package TO::D2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use Agent::D2;
use strict;

sub leaf { 1 }
sub portLabel {
  my($class, $port) = @_;
  return "esm-$port";
}

sub getPortCIMId {
  my($node , $port) = @_;    #  0 / 1
  my $pi = $node->portInfo();
  return $pi->[$port]{PortWWN};
}


sub new {
  my($class, $to, $host, $dev) = @_;

  my $storages  =  $to->[2];
  my $syns      =  $to->[4];
  my $key       = $dev->{key};

  my $obj = {};
  $obj->{info}{type}    = 'd2';
  $obj->{info}{class}   = 'storage.d2';
  $obj->{info}{name}    = "d2:$key";
  $obj->{info}{BoxName} = $dev->{name};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "ib";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{LGroup}  = "StorEdge-D2";
  $obj->{info}{PortWWN} = $dev->{wwn};
  $obj->{info}{NodeWWN} = $dev->{wwn};
  $obj->{port}          = [];
  my $h = $to->nodeByName("host:$host");
  if ($h) {
     my $hp = $h->port();
     my $hpi = $h->portInfo();
     my $cnt = 0;
     foreach my $w ($dev->{wwn}, $dev->{wwn2}) {
        next if (!$w);
        my $hpc      = $#$hpi + 1;
        $hp->[$hpc]  = "d2:$key:$cnt";
        $hpi->[$hpc] = { PortWWN    => "scsi-$key", 
                         LGroup     => 'scsi', 
                         DriverName => 'scsi',
                         RegisterName => 'scsi', 
                         path       => $w };
        $obj->{portInfo}[$cnt] = {PortWWN  => $w, LogicalPath => $w, 
                                  portType => 'scsi' };
        $obj->{port}[$cnt]     = "host:$host:$hpc";
        $syns->{$w}            = "d2:$key:$cnt";
        $cnt++;
     }
  }

  my $report = {};
  Agent::D2->read_device_slot_status($report, $dev);

  $obj->{info}{disk_per_row} = $report->{'slot.0.total'} || $report->{'slot.1.total'};

  my $x;
  foreach my $esm (0,1) { 
    for ($x=0; $x <= 11; $x++) {
        next if (!exists($report->{"slot.$esm.$x.dev"})) ;
        my $dev = $report->{"slot.$esm.$x.dev"};
        my $vendor = $report->{"slot.$esm.$x.vendor"};
        my $model  = $report->{"slot.$esm.$x.model"};
        $obj->{diskInfo}{"esm$esm-$x"} = { 
                   devID => "$esm-$x", 
                   VendorID => $vendor . ":" . $model,
                   LogicalPath => "/dev/rdsk/$dev",
                   RegisterName => "$dev-$esm-$x" 
                        };
    }
  }
      
  
  bless($obj, 'TO::D2');
  $syns->{$key} = "d2:$key";
  $storages->{"d2:$key"} = $obj;
  return $obj;
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne "d2");
     next if (!$dev->isMineToMonitor());

     my $k = $dev->{type} . ":" . $dev->key();
     next if ($topo->nodeByName($k));
     $dev->{host} = $renv->{hostname} if (!$dev->{host});

     $class->new($topo, $renv->{hostname}, $dev);
  }
}

sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp    = $State->components();
  my $i       = $Comp->value("$name:e");
  my $iIB     = $Comp->value("$name:ib");

  my $enc     = TO->val($i->[0], $iIB->[0]);
  my $encInfo = TO->val2(1,$i, $iIB);

  my $port =  $Comp->value("$name:esm.0",0) . "," .
              $Comp->value("$name:esm.1",0);

  my $portInfo = $Comp->value("$name:esm.0",1) . "," .
                 $Comp->value("$name:esm.1",1);

  my($disk, $diskInfo, $otherInfo, $other, $u, $d);
  my($l1, $l2, $p1, $p2, $m1, $v1, $v2, $v3, $v4);

  foreach my $el (0,1) {
    for ($d=0; $d < ($node->info('disk_per_row')||12) ; $d++) {
      $disk     .= $Comp->value("$name:slot.$el.$d",0) . ",";
      $diskInfo .= $Comp->value("$name:slot.$el.$d",1) . ",";
    }
  }
#   LMPV

     $l1 = $Comp->value("$name:fan.0");
     $l2 = $Comp->value("$name:fan.1");

     $p1 = $Comp->value("$name:power.0");
     $p2 = $Comp->value("$name:power.1");

     $m1 = $Comp->value("$name:midplane");


     $other = TO->val($l1->[0], $l2->[0])  . "," .
              TO->val($p1->[0], $p2->[0]) . "," . $m1->[0];

     $otherInfo = TO->val2(1,$l1, $l2)  . "," .
                  TO->val2(1,$p1, $p2)  . "," .  $m1->[1];

     return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);
    
}




sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);

  $cat = "a,D2,2/01,6,0/1,FPM,Fan/Power/Midplane,D0D0F0/d2.gif";
  $label2 = "D2";

  $ses = 1;

  return ($cat, $label2, $ses);
}


1;
