package TO::A5K;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
use State;
sub leaf { 1 }

sub portLabel {
   my($class, $port) = @_;

   if ($port == 0) {
      return "ses-A0";
   } elsif ($port == 1) {
      return "ses-B0";
   } elsif ($port == 2) {
      return "ses-A1";
   } elsif ($port == 3) {
      return "ses-B1";
   }
}
  
      

#
# used to look in the State db
#
sub getPortId {
  my($class, $port) = @_;    # 0 / 1
  if ($port == 0) {
     return 'interface_board.A';
  } else {
     return 'interface_board.B';
  }
}

sub getDiskList {
  my($node) = @_;
  my (@L, $x, $y);
  foreach my $x ('disk_front','disk_rear') {
     for ($y=0; $y <= 10; $y++) {
       push(@L, "$x.$y");
     }
  }
  return \@L;
}


sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;
  my($type);
  my $Comp = $State->components();

  my $i = $Comp->value("$name:ib");
  my $enc = $i->[0];
  my $encInfo = $i->[1];

  ($type, $name) = split(/:/, $name);
  $name = "a5k:$name";

  my($port, $portInfo, $p1, $p2);
  my ($map, @MAP);
  if ($node->{info}{gbic_map}) {
     $map =1;
     @MAP = split(/,/, $node->{info}{gbic_map});
  }
  my $cnt = 0;
  foreach my $e ('A.gbic0','B.gbic0','A.gbic1','B.gbic1') {
     my $ab = substr($e,0,1);
     if ($map && ($MAP[$cnt] == -1)) {
        $port .= "-1,";
        $portInfo .= ",";
     } elsif ($e =~ /0/) {
         $p1        = $Comp->value("$name:interface_board.$ab",0) ;
         $p2        = $Comp->value("$name:interface_board.$e",0);
         $port     .= TO->val($p1, $p2) . ",";
         $portInfo .= ($Comp->value("$name:interface_board.$ab",1) ||
                       $Comp->value("$name:interface_board.$e",1)) . ",";
     } else {
         $port     .= $Comp->value("$name:interface_board.$e",0) . ",";
         $portInfo .= $Comp->value("$name:interface_board.$e",1) . ",";
     }
     $cnt++;
  }

  my $l1 = $Comp->value("$name:power.0");
  my $l2 = $Comp->value("$name:power.1");
  my $l3 = $Comp->value("$name:power.2");

  $p1 = $Comp->value("$name:fan.0");
  $p2 = $Comp->value("$name:fan.1");

  my $other = TO->val($p1->[0], $p2->[0]) . ",," .
              TO->val($l1->[0], $l2->[0], $l3->[0]);

  my $otherInfo =  TO->val2(1,$p1, $p2) . ",," .
                   TO->val2(1,$l1, $l2, $l3);

  my($disk, $diskInfo);
  $map = 0;
  if ($node->{info}{disk_map}) {
     $map =1;
     @MAP = split(/,/, $node->{info}{disk_map});
  }
  my $o1 = 0;
  foreach my $u ('disk_front','disk_rear') {
     my($d);
     for ($d=0; $d <= 10; $d++) {
         if ($map && ($MAP[$d+$o1] == -1)) {
           $disk .= "-1,";
         } else {
           $disk .= $Comp->value("$name:${u}.$d",0) . ",";
         }
         $diskInfo .= $Comp->value("$name:${u}.$d",1) . ",";
     }
     $o1 = 11;
  }

 return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}


sub iconLayout {
  my($class) = @_;

  return("a,A5K,4/AB,11,f/r,FBP,Fan/BackPlane/Power,E0F0F0/a5k.gif", "A5K", 2);
}

sub getLogicalPaths{
  my($self) = @_; 
  my @paths;
  my $diskInfo = $self->diskInfo();
  foreach my $disk (keys %$diskInfo) {
    my $Disk = $diskInfo->{$disk};
    push(@paths, $Disk->{LogicalPath});
  }
  return @paths;
}


1;


