package TO::A3500FC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
sub leaf { 1 }

use strict;

sub statusFunc {
  my($class, $name, $State) = @_;

   my $Comp = $State->components();
   my $i = $Comp->value("$name:ib");
   my $enc     = $i->[0];
   my $encInfo = $i->[1];
   my $port =  $Comp->value("$name:controller.a",0) . "," .
               $Comp->value("$name:controller.b",0);

   my $portInfo = $Comp->value("$name:controller.a",1) . "," .
                  $Comp->value("$name:controller.b",1);

   my $other     =  "," . $Comp->value("$name:device_info.battery",0);
   my $otherInfo =  "," . $Comp->value("$name:device_info.battery",1);

   my($disk, $diskInfo, $d);

   for ($d=0; $d <= 9; $d++) {
      $disk     .= $Comp->value("$name:disk.$d",0) . ",";
      $diskInfo .= $Comp->value("$name:disk.$d",1) . ",";
   }
   return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}


sub iconLayout {
  my($class) = @_;

  return("a,A35,2,10,,LB,Luns/Battery,E0F0E0/a3500fc.gif", "A35", 2);
}

sub getLogicalPaths{
  my($self) = @_;
  my @paths;
  my $diskInfo = $self->portInfo();
  foreach my $disk (@{$diskInfo}) {
    push(@paths, split(/\|/, $disk->{LogicalPath}));
  }
  return @paths;
}

1;
