package Revision::MCDATA;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use Agent::MCDATA;
#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"McData Switch Firmware "}
sub class {"oob.mcdata"}
sub type {"mcdata"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;

  my $rc2 = $class->check_MCDATA_Firmware($Matrix, $InstalledPatches);

  return [@$rc2];
}

sub check_MCDATA_Firmware {
    my($class, $Matrix, $InstalledP) = @_;
    my $switch_fw = $Matrix->{MCDATA};
    my $category = "McDATA Switch";
    my $key = "switch";
    my @L;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $d;
    my $req_fw;
    my $found=0;
    my $desc = "Please contact your SUN representative to install the expected level firmware";
    foreach my $dev (@$devs){
          if ( $dev->{class} =~ /mcdata/) {

             my $ip_num = $dev->{ipno};
             $found =1;             

             my $curr_fw = Agent::MCDATA->getVersion($ip_num);
	     $d = $switch_fw->{$key};
             $req_fw = $d->[0];

             my $comp = $class->compare_MCDATA_FwLevels($curr_fw, $req_fw);
             if ( $comp==0) {
                   push(@L, [$category, $ip_num,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp>0) {
                   push(@L, [$category, $ip_num,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp<0){
                   push(@L, [$category, $ip_num,'DOWNREV',$curr_fw, $req_fw, undef,undef,$desc]);
             }

          }
    }
    if ($found ==0)
    {
            push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No McDATA device are present, please check system"]);
    }
 
    return \@L;
}




sub compare_MCDATA_FwLevels{
    my ($class, $drive, $matrix) = @_;
    my (@matrix, @drive, $indx);

    @matrix = split(//, $matrix); # separate characters
    @drive = split(//, $drive); # separate characters
    if (scalar(@matrix) > scalar(@drive)) {
       $indx = 0;
       my ($m, $d);
       foreach my $char (@matrix) {
          if ($char ne ".") {
            $m .= $char;
            $d .= $drive[$indx];
          }
          if ( $d gt $m) {
              return 1;
          } elsif ( $d lt $m ) {
              return -1;
          }
          $indx++;
       }
       return 0;
   } else {
       $indx = 0;
       my ($m, $d);
       foreach my $char (@drive) {
          if ($char ne ".") {
            $m .= $matrix[$indx]; 
            $d .= $char;
          }
          if ( $d gt $m) {
              return 1;
          } elsif ( $d lt $m ) {
              return -1;
          }
          $indx++;
       }
       return 0;
   }

}


1;


