package Revision::A5K;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Sun StorEdge A5000 array Patches and Disk Firmware"}
sub class {"host.driver"}
sub type {"a5k"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;

  # first create a a5k box list
  my $di = run_A5K_inquiry(0); 
  my @a5k_box_list;
  my @rec_list;
  my $box_wwn;

  foreach my $line (@$di) {
     next if ($line !~ /SENA\s+Name/);
     print $line;
     my $l = Util->ltrim($line);
     if ($l =~ / Name:(.+)\s+Node WWN:([^\s]+)\s+Log(.+)/) {
         $box_wwn  = Util->trim($2);
     } elsif ($l =~ / Name:(.+)\s+Node WWN:([^\s]+)/) {
         $box_wwn  = Util->trim($2);
     }
     push(@a5k_box_list, $box_wwn);
  }  
  my ($l, @Li);
  my %box_ib =();
  foreach my $box (@a5k_box_list){
       my $file = "luxadm display $box"; 
       my $done = 0;
       my $line_num =0;
       if (open(tem, "$file 2>&1|")) {
           while (($l = <tem>) && (!$done)){
              $line_num++;
              next if  (($line_num<=4)|| ($line_num >20) || ($l =~ /Not/));
              chop($l);
              my ($first,$rest)= split(/\s+/,$l);
              if ($first =~ /\d/){
                   my ($index,$status,$front_wwn,$status_2,$rear_wwn) = split(/\s{3,}/,$l);
                   my $outline;
                   my $file2 ="luxadm dis $front_wwn";
                   if (open(tem2,"$file2 2>&1|")){
                       while ($outline= <tem2>){
                            next if ($outline !~  /\/dev\/rdsk/);
                            my $where1 = index($outline,"c");
                            my $where2 = index($outline,"t");
                            my $num= substr($outline,$where1, $where2-$where1);
                            push (@Li, $num);
                            # print $num;
                            
                       }    
                       $done =1;
                       close (tem2);
                   }             
              } 
          }
          close(tem);
       }
       else{
         print "err\n";
      } 
  }

   my $Liptr = \@Li;
   my $box_ptr = \@a5k_box_list;
   my $rc1 = $class->checkA5kIB($Matrix, $InstalledPatches, $box_ptr);
   my $rc2 = $class->checkDiskFirmware($Matrix,   $InstalledPatches,$Liptr );
   
   return [@$rc1, @$rc2];
}



my $DI;
sub run_A5K_inquiry() {
   my ($var) = @_;
   my($l, @L);
   my $F = "luxadm probe";
   open(O, "$F 2>&1|");
   while ($l = <O>) {
    push(@L, $l);
  }
  close(O);
  $DI = \@L; 
  sleep(2);
  return $DI;

}

sub checkA5kIB {
   my($class, $Matrix, $InstalledP, $yu_box_list) = @_;
   my @L;
   my $category="IB_FIRMWARE";
   my $key;
   foreach my $box (@$yu_box_list){
       my $file = "luxadm display $box";
       my $line_num =0;
       if (open(OT, "$file 2>&1|")) {
           my $l;
           while ($l = <OT>){
              $line_num++;
              next if  (($line_num<=4)|| ($line_num >20) || ($l =~ /Not{2}/));
              chop($l);
              my ($first,$rest)= split(/\s+/,$l);
              if ($first =~ /FW/ ) {
                  my ($var1, $var2, $var3, $var4, $var5) = split(/\s+/, $l);
                  #  var2 has contents like:  Revision:1.09
                  my ($rn, $curr_fw) = split(/:/,$var2);

                  if ( $curr_fw =~ /\d/){
                       if ($line_num > 16) {
                         $key = 5200;
                       }
                       if ($line_num < 16) {
                         $key = 5000;
                       }
                       my $ib_fw = $Matrix->{IB_FIRMWARE};
                       if ($ib_fw->{$key}){
                             my $d =$ib_fw->{$key};
                             my $req_fw = $d->[0];
                             my $comp = $class->compareFwLevels($curr_fw, $req_fw);
                            if ( $comp==0) {
                              push(@L, [$category, $box,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                            }
                            elsif ($comp>0) {
                               push(@L, [$category, $box,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                            }
                            elsif ($comp<0){
                               push(@L, [$category, $box,'DOWNREV',$curr_fw, $req_fw, undef,undef,undef]);
                            }
                      }else{
                            push(@L, [$category, $box, 'ERR', undef, undef,undef,undef, "No Key in Matrix/A5K"]);
                      }

               }
           }
        }
        close(OT);
      }
   }
   return \@L;
}

1;


