package Provider::NetConnect;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: NetConnect.pm,v 1.12 2002/09/11 23:30:30 ccadieux Exp $

use PDM;
use PDM::ConfigFile;
use Carp;
use Message;
use Util;
use System;
use Util::Http;

use base 'Provider';
sub revision {'$Revision: 1.12 $'}

sub description {'Net Connect'}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::NetConnect');
  return $p;
}

# http://shadow:8080/servlet/InsertService

sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $info);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('netconnect');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    $renv->{'pro.netconnect.active'} = $q->{active}? "Y":"N";
    $renv->{'pro.netconnect.maxsize'}  = $q->{max};

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);

    $err = Html->info($L->{err_1});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  if ($renv->{'pro.netconnect.active'} eq "Y") {
    $active = "checked" ;
  } else {
    $info = "<font color=red><b>$G->{inactive}</b>";
  }
  $max    = $renv->{'pro.netconnect.maxsize'} || "2000";

 $o =<<EOF;
$err
<form  method=get>
 <input type=hidden name=GO value=GUI::Providers::display>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{label}</td>

<tr><td bgcolor=$main'LIGHT width=20% align=right>$G->{active} :</td>
      <td><input type=checkbox name=active $active> $info

<tr><td bgcolor=$main'LIGHT align=right>$L->{max}:</td>
      <td><input type=text name=max value=\"$max\" size=20>
</table>
</table>
<b>
EOF
  if (!$deny) {
     $o .= "<input type=submit name=ACTION_update value=$G->{submit_update}>";
  }
  $o .= " </form>";

  return $o;

}


sub RUN {
  my($pro, $pdm) = @_;
  my($f, $l, $transmit);
  $DB::single = 1;
  my $NET_RUN;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  return if ($renv->{'pro.netconnect.active'} ne "Y");
  return if ($pdm->getEventCount() == 0);

  my $package_base = System->getPackageInfo("", "SUNWnc01", "BASEDIR");
  if ($package_base) {
     $NET_RUN = "$package_base/SUNWnc/bin/ncsend";
  }

  my($netfile) = "/opt/SUNWstade/DATA/SHUTTLE" ;  # prefix
                  #$renv->{'pro.shuttle.ifile'};

  my($netfile1) = $netfile . "1";   # high priority
  my($netfile3) = $netfile . "3";   # low priority

  my($max)      = ($renv->{'pro.netconnect.maxsize'} + 0) * 1000;
  $max = 2000000 if (!$max);

  rename $netfile1, "$netfile1.work";
  rename $netfile3, "$netfile3.work";

  if (!open(W1, ">>$netfile1.work")) {
       Debug->err(NETCONNECT => "Cannot open $netfile1: $!");
       return;
  }
  if (!open(W3, ">>$netfile3.work")) {
       Debug->err(NETCONNECT => "Cannot open $netfile3: $!");
       return;
  }
  my($size1) = (stat("$netfile1.work"))[7];
  my($size3) = (stat("$netfile3.work"))[7];

  foreach $ed (@{ $pdm->getMessages}) {
     if ($ed->type eq "A") { # alert
       if ($size1 > $max) {
         close(W1);
         Debug->err(NETCONNECT => "File $netfile1 is full, cannot write anymore");
         last;
       }
       $post = $ed->toC;
       Debug->print2("NetConnect ($url): " . $ed->className . " " . $ed->description );
       print W1 $post;
       $size1 += length($post);

     } else {
       if ($size3 > $max) {
         close(W3);
         Debug->err(NETCONNECT => "File $netfile3 is full, cannot write anymore");
         last;
       }
       $post = $ed->toC;
       Debug->print2("NetConnect ($url): " . $ed->className . " " . $ed->description );
       print W3 $post;
       $size3 += length($post);
     }
  }
  close(W1);
  close(W3);
  if ($NET_RUN && -x $NET_RUN) {
     my $F1 = "$netfile1";  # use pid names since ncsend queue work
     my $F3 = "$netfile3";
     rename "$netfile1.work" , $F1;
     rename "$netfile3.work" , $F3;
     chmod 0666, $F1;
     chmod 0666, $F3;
     if (!(-z $F1) ) {
        system("$NET_RUN -n nws $F1");
     }
     if (!(-z $F3) ) {
        system("$NET_RUN -n nws $F3");
     }
  } else {
     rename "$netfile1.work" , $netfile1;
     rename "$netfile3.work" , $netfile3;
     chmod 0666, $netfile1;
     chmod 0666, $netfile3;
  }

  Debug->print2("NetConnect done.");

}


  
1;
