package Grouping;
use System;
use Util;
use Data::Dumper;

# 'info' => {
#      'description' => 'Systems',
#      'group' => 'systems'
#    },
#    'map' => {
#      'systems.san-01-rack1' => [
#        '',
#        'standard',
#        'F0C0F0'
#      ],


@COLORS = ('F0F0F0=gray', 'F0F0D0=yellow', 'F0F0E0=lyellow','F0C0F0=lpurple', 
           'C0C0F0=purple','C0F0C0=green', 'C0F0F0=blue', 'F0C0C0=brown',
           'DDDDFF=SunPale', '666699=Sun');
$GROUPING = undef;

sub _load {
  my($class) = @_;

  if (!$GROUPING) {
     open(O, System->get_home() . "/DATA/Grouping");
     my @l = <O>; close(O);
     eval "@l";
     $GROUPING = $VAR1;
  }
}

sub groupList {
  my($class, $host) = @_;
  
  $class->_load();

  my(@L);
  foreach my $el (sort keys %$GROUPING) {
     my($h ,$gr) = split(/\:/, $el);
     next if ($host && $host ne $h);
     push(@L,  $GROUPING->{$el}{info});
  }
  return \@L;
}

sub deleteCategory {
  my($class, $code) = @_;
  $class->_load();
  delete($GROUPING->{$code});
}


sub updateId { 
  my($class, $code, $k, $desc, $style, $color) = @_;
  $class->_load();
  $GROUPING->{$code}{map}{$k} = [$desc, $style, $color];
}

sub deleteId {
  my($class, $code, $k) = @_;
  $class->_load();
  delete ($GROUPING->{$code}{map}{$k});
}

sub addCategory {
  my($class, $host, $code, $desc, $noerase) = @_;

  my $code0 = "$host:$code";
  $class->_load();
  $GROUPING->{$code0}{info}{host} = $host;
  $GROUPING->{$code0}{info}{group} = $code;
  $GROUPING->{$code0}{info}{description} = $desc;
  if (!$noerase) {
    $GROUPING->{$code0}{members} = {};
  }
  return undef;
}

# key = e10k.central.sun.com:lab1.rack1
# return ('e10k.central.sun.com', 'lab1','rack1...')
#
sub keyParts {
  my($class, $key) = @_;

  my($host, $rest) = split(/\:/, $key, 2);
  my($cat, $rest2) = split(/\./, $rest,2);
  return ($host, $cat, $rest2);
}

#  {
#    systems => {
#        'switch:wwn1' => 'sys1',
#        't3:wwn1'     => 'sys2',
#
sub read {
  my($class, $group) = @_;

  $class->_load();
  my $gr = $GROUPING->{$group};
  return undef if (!$gr);
  bless($gr, "GR_element");
  return $gr;
}

#  $map = getMap("host:Labs")
#  $style = getMap("host:Labs", "lab1")
#
sub getMap {
  my($class, $group, $key) = @_;
  $class->_load();
  if (exists($GROUPING->{$group}{map})) {
    if ($key) {
      return $GROUPING->{$group}{map}{"$group.$key"};
    } else {
      return $GROUPING->{$group}{map};
    }
  } 
  return [];
}
  

sub setGroup {
  my($class, $group, $key, $groupID, $color, $style, $desc) = @_;

  $class->_load();
  if (substr($key,0,6) eq "group:") {
    $key = substr($key,6);
    my $M = $GROUPING->{$group}{members};
    my $MP = $GROUPING->{$group}{map};
    my(@T) = $class->keyParts($key);
    foreach my $el (keys %$M) {
      if ($M->{$el} eq $key) {
         my $new = "$T[0]:$T[1].$groupID";  # host:grouping.id
         $M->{$el} = $new;
         $MP->{$new} = [$desc, $style, $color || "F0C0F0"];
      } elsif (substr($M->{$el} , 0, length($key) + 1) eq "$key.") { # child
         my $new = "$T[0]:$T[1].$groupID" . substr($M->{$el},length($key));
         $M->{$el} = $new;
         $MP->{$new} = $MP->{$M->{$el}};
      }
    }
  } else {
    if (!$groupID) {
      delete( $GROUPING->{$group}{members}{$key} );
    } else {
      $GROUPING->{$group}{members}{$key} = "$group.$groupID";
      $GROUPING->{$group}{map}{"$group.$groupID"} = [$desc, $style, $color || "F0C0F0"];
    }
  }
}

sub refreshMap {
  my($class, $group) = @_;

  return if (!$group);
  $class->_load();
  my $l = $GROUPING->{$group}{members};
  my %MAP;
  foreach my $x (keys %$l) {
    $MAP{$l->{$x}} = 1;
  }
  my $m = $GROUPING->{$group}{map};

  foreach my $k (%$m) {
    if (!$MAP{$k}) {
      delete( $GROUPING->{$group}{map}{$k} );
    }
  }

  foreach my $k (keys %MAP) {
     if (!$m->{$k})  {
        $GROUPING->{$group}{map}{$k} = ["", "", "F0C0F0"];
     }
  }

  $class->save();    
}
  

sub save {

  if ($GROUPING) {
     open(O,  ">" . System->get_home() . "/DATA/Grouping");
     $Data::Dumper::Indent = 1;
     print O Dumper($GROUPING);
     close(O);
  }

}

package GR_element ;

sub members {
  my($class) = @_;

  return $class->{members};
}

sub info {
  my ($class) = @_;
  
  return $class->{info};
}

sub map {
  my ($class) = @_;
  
  return $class->{map};
}

1;
