package GUIAdmin::SWITCH;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SWITCH.pm,v 1.42 2002/09/19 15:44:03 ccadieux Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';
use Logic::SWITCH;
use Labels;

sub description {

   my $G = Labels->read();

   if ($_[1] =~ /Dis_Screen/) {
      return $G->{switch_from_list};
   } else {
     return 'Sun Switch';
   }
   
}
sub isDevice {1}

sub ipRequired {1}


sub discover {
  my($q) = @_;
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my ($err, $nodes, $info, $all_info);
  my $L = Labels->read("GUIAdmin::A1000");

  if ($q->{select_host} eq "local")
  {
     # User wants information from local host
     print "$L->{finding}\n<br>";
     ($err, $nodes, $info) = Logic::SWITCH->addFromFile( $q );
  }
  elsif (!$q->{select_host})
  {
     # User wants all hosts
     print "$L->{new_dev}\n<br>";

     $q->{select_host} = "local";
     ($err, $nodes, $info) = Logic::SWITCH->addFromFile( $q );

     print "$L->{new_slave}\n<br>";

     foreach my $h (@$host) {
       
       print $L->expand(getting => $h->{hostname}) . "<br>";
       $q->{select_host} = $h->{hostname};
       ($err, $nodes, $info) = Logic::SWITCH->addFromFile( $q );
       $all_info .= $info;
     }
  }
  else
  {
     # user wants a specific host
     print $L->expand(getting => $q->{select_host}) . "<br>";

     ($err, $nodes, $all_info) = Logic::SWITCH->addFromFile( $q );
  }
  if ($err) {
     print $err->toHtml();
  }

  print "<pre>$all_info</pre>";
  return "DONE";

}


sub getDevices {
  my($q) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn);

  my($HOME) = System->get_home();
  if (open(RUN, "/etc/fcswitch.conf")) {
     while ($l = <RUN>) {
         chop($l);
         next if ($l !~ /^\d+/);
         my(@a) = split(/\s+/, $l);
         $f .= "$a[0]|$a[1]\n";
     }
     close(RUN);
     return "OK $f\n";
  } else {
     return "ERR $!";
  }
}

sub addDevice {
  my($class, $q) = @_;

  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);
  print Html->body();
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::A1000")->section("add");

  my $deny = Roles->verifyRole($q, "admin");
  require "GUI/Devices.pm";
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my ($err, $nodes) = Logic::SWITCH->addToConfig($q);
    if ($err) {
       $info = $err->toHtml();
    } elsif ($#$nodes >= 0) {
       print Html->info($G->expand('x_devices_added', ($#$nodes + 1)));
       GUI::Devices::list($q);
       return;
    }
  }
out:
  print GUI::Devices::add0($q);

  my($h) = Html->header("Add " . $class->description(),"","",
              "Maintenance.General#adddevice", undef, {nohelp => 1});

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\" $sel>Local</option>";

  foreach $x (@$host) {
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::SWITCH->addDevice">
<center>
$h
$info
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{enter}</td>

<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{dev_name}:</td>
    <td><input type=text name=name size=15 maxlength=15 value="$q->{name}">

<tr><td bgcolor=$main'LIGHT align=right>$L->{primary}:</td>
    <td>$phost</td>

<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{telnet}:</td>
    <td><input type=password name=password size=20 maxlength=30 value="$q->{password}">

<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{ip}:</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">


</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=\"$L->{submit_add} \">";
  }
  print "<input type=submit name=ACTION_back value=\"$L->{submit_back}\"></form>";

}


sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
   my $deny = Roles->verifyRole($q, "admin");
  print "\n";
  require "GUI/Devices.pm";
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::A1000")->section("update");

  if ($q->{ACTION_back}) {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION_upd})  {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{telnet}   = Util->encodeAll($q->{password});

    $dev->[$x]{key}  = $dev->[$x]{wwn};
    #$dev->[$x]{class} = "switch.switch";
    $dev->[$x]{hba}  = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->info($G->expand('device_updated', $name));

  } elsif ($q->{ACTION_del}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->header("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

 $h1 = Html->header2("admin.gen_maint.maint_device", 
           undef, $class->description()," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my($primary);
  $primary = "<br><b>[ Monitored thru $h->{primary} port:$h->{port} on fc:$h->{fc} ]"
              if ($h->{primary});
  my $telnet = Util->decode($h->{telnet});
  my $type = $h->{userLabel} || $h->{type};
  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form method=get>
 <input type=hidden name=GO value="GUIAdmin::SWITCH->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;$L->{titme}</td>

<tr><td bgcolor=$main'LIGHT align=right>$L->{type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$type</td>
        <td bgcolor=$main'LIGHT align=right>$L->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$main'LIGHT width=30% align=right>$L->{name}:</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">$primary

<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{ip}:</td>
    <td>&nbsp;$ip</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{ipno}:</td>
    <td>&nbsp;$ipno</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>$L->{telnet}:</td>
    <td><input type=password name=password size=20 maxlength=30 value="$telnet">

<tr><td bgcolor=$main'LIGHT align=right>$L->{wwn}:</td>
    <td><b>$h->{wwn}</td>
<tr><td bgcolor=$main'LIGHT align=right>$L->{primary}:</td>
    <td><b>$ho</td>

</table>
</table>
<b>

EOF
  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION_upd value=\"$L->{submit_update}\">
             <input type=submit name=ACTION_del value=\"$L->{submit_delete}\">";
  }
  print " <input type=submit name=ACTION_back value=\"$L->{submit_back}\">
  </form>";
}

1;

