package GUI::Rsh;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use Util::Http;
use strict;

sub list {
  my($q) = @_;
  print Html->body(undef, { color => "#F0F0F0"});
  print Html->header2('admin.system.run_script');
  my $L = Labels->read("GUI::Rsh");

  my $C = &readCommands();
  print "<table border=0 cellspacing=1 cellpadding=1 width=90% bgcolor=white>";
  my $cat;
  foreach my $comm (sort keys %$C) {
    my($cat0, $com) = split(/\./, $comm, 2);
    if ($cat ne $cat0) {
       print "<tr><td></td>";
       print "<tr><td></td>";
       print "<tr bgcolor=#CCCCFF><td colspan=3><b>&nbsp;$cat0</td>";
       $cat = $cat0;
    }
    my $c = $C->{$comm};
    my $name = $L->{"$comm.name"};
    my $desc = $L->{"$comm.desc"};
    print "<tr><td nowrap><a href=$Http::WEBPROC?GO=GUI::Rsh::run&command=$comm >$name</a></td><td>$desc&nbsp;</td>\n";
  }
  print "</table>";
}

sub readCommands {
  my($class) = @_;
  my (%A, $l);
  my $D = System->get_home() . "/System/Commands.txt";
  my $comm;
  if (open(O, $D)) {
    while ($l = <O>) {
       chop($l);
       if (substr($l,0,1) eq "[") {
          $comm = substr($l,1,-1);
       } else {
          my($name, $val) = split(/\s*\=\s*/, $l, 2);
          $A{$comm}{$name} = $val;
       }
    }
    close(O);
  }
  return \%A; 
}

sub run {
  my($q) = @_;
  my $command = $q->{command};
  my $renv = System->get_renv();
  if ($q->{ACTION} =~ /List/) {
     &list($q);
     return;
  }
  my $L = Labels->read("GUI::Rsh");

  print Html->body(undef, { color => "#F0F0F0"});
  print Html->header2('admin.system.run_script');


  my $C = PDM::ConfigFile->read();
  my $l = $C->hostsList( {include_ip => 1} );

  my $hosts = "<select name=host>";
  foreach my $h (@$l) {
     my $val =  ($h->[0] eq $renv->{hostname})? "Local" : $h->[1];
     my $ck = ($q->{host} eq $val) ? "selected": "";
     $hosts .= "<option value=$val $ck>$h->[0]";
  }
  $hosts .= "</select>";

  my $C = &readCommands();

  my ($args, $desc2);
  my $command0 = $q->{command};
  my $c = $C->{$q->{command}};
  if ($q->{ACTION}) {
     $args = $q->{args} || $c->{default};
  } else {
     $args = $c->{default};
  }

  my ($line, $a);

  if ($c->{syntax}) {
     $q = {} if (!$q->{ACTION_run});
     ($line, $args) = &gen_html($c, $q,$command0);
  } else {
     if ($c->{options}) {
       $a = $c->{options};
       $a =~ s/</&lt;/g;
       $a = "&nbsp;$a<br>";
     }
     $line = "<input type=text name=args size=70 value=\"$args\">";
  }

  my $name = $L->{"$command.name"};
  my $desc = $L->{"$command.desc"};

  print "
   <table border=0 width=90% cellspacing=0 cellpadding=4>
    <tr><td><b>$name</td>
    <tr><td bgcolor=white>$desc&nbsp;</table>
   <table border=0><tr><td></table>
   <table border=1 cellpadding=2 cellspacing=0 width=90% bgcolor=white>
   <tr bgcolor=#666699>
      <td colspan=2><form>
        <input type=hidden name=GO value=GUI::Rsh::run>
        <input type=hidden name=command value=\"$command\">
      <font color=white><b>$command: $c->{path}</td>
   <tr>
       <td width=25% align=right bgcolor=#CCCCFF>$L->{select_host}:&nbsp;</td>
       <td>$hosts
   <tr><td width=25% align=right bgcolor=#CCCCFF>$L->{args}:&nbsp;</td>
       <td>$a $line

   </table>
      <b><input type=submit name=ACTION_run value=\"$L->{run}\">
      <input type=submit name=ACTION_list value=\" $L->{list} \">
      </b>
   </form>";

   return if (!$q->{ACTION_run}) ;
   print "</center></b><pre>";

   if (!$q->{command}) {
      print "$L->{no_command}<br>";
      return;
   }
   my $c = $C->{$q->{command}};
   my $bin = $c->{path};
 
   my $args0 = $args;
   $args0 = "" if ($c->{hide_args});
  
   print "<b>running = '$bin $args0' on $q->{host}</b>\n\n";

   if ($q->{host} eq "Local") {
      my $c = System->get_home() . "/$bin";
      if (!-x $c) {
         print "$L->{cannot_ex} '$c'<br>";
         return;
      }
      open(R, "$c $args|");
      while ($l = <R>) {
          print $l;
      }
      close(R);
   } else {
      my($err, $rc) = Util::Http->runit($q->{host}, "/$bin+$args", $c->{timeout} );
      $rc =~ s/</&lt;/g;
      print $rc;
   }

}


# syntax=-m#s3910|3960|6910|6960  -p#t20 -i#t20  -h#c=0      
#  -m#s3910:Sun 3910|3960|6910|6960=6910 : select , default is 6910
#  -p#t20 : -p text field
#  -p#p20 : -p password field
#  -p#T20 : send -p even if text is blank
#  -h#c=0 : checkbox , send -h if checked , default is un-checked (0)

# syntax_name=Model VE_Password Subnet_Prefix Help

sub gen_html {
  my($c , $q, $command) = @_;
  my $syn = $c->{syntax};

  my $L = Labels->read("GUI::Rsh");

  my @names = split(/\s+/, $L->{"$command.syntax_name"});
  my $cl;
  my $line = "<table border=0 cellspacing=1>";
  my $cnt = 1;
  my(@v) = split(/\s+/, $syn);
  my $lb_cnt = 0;
  foreach my $el (@v) {
    my ($name, $opt);
    if (substr($el,0,1) eq "-") {
      my $ix = index($el, "#");
      if ($ix > 0) {
         $opt = substr($el, 0, $ix) . " ";
         $el = substr($el, $ix);
      }
    }
    if (substr($el,0,1) eq "#") {
      $name = $names[$lb_cnt]; $lb_cnt++;
      my $type = substr($el,1,1);
      my ($rest,$default) = split(/\=/, substr($el,2));
      my $field;
      $line .= "<tr>";
      $line .= "<td bgcolor=#E8E8E8>&nbsp;$opt&nbsp;</td>" if ($opt);

      if (lc($type) eq "t" || lc($type) eq "p") { # text
        my $it = (lc($type) eq "t") ? "text":"password";
        my $v = exists($q->{"arg_$cnt"}) ? $q->{"arg_$cnt"} : $default;
        $cl .= "$opt\"$v\" " if ($v || $type eq "T");

        $field = "<input type=$it name=arg_$cnt size=$rest value=\"$v\">";
        $line .= "<td bgcolor=#E8E8E8 align=right>&nbsp;<b>$name:</td><td>$field &nbsp;</td>";

      } elsif ($type eq "c") {# select
        my $ck;
        if ($q->{ACTION} =~ /Run/) {
           $ck = defined($q->{"arg_$cnt"}) ? "checked" : "";
        } else {
           $ck = $default ? "checked" : "";
        }
        if ($opt && $ck) {
           $cl .= "$opt";
        } elsif ($ck) {
           $cl .= "1 ";
        }
        $field = "<input type=checkbox name=arg_$cnt $ck>";
        $line .= "<td bgcolor=#E8E8E8 align=right>&nbsp;<b>$name:</td><td>$field</td>";

      } elsif ($type eq "s") {# select
        my(@vals) = split(/\|/, $rest);
        $field = "<select name=arg_$cnt>";
        $default = $q->{"arg_$cnt"} if ( $q->{"arg_$cnt"} );
        $cl .= "$opt\"$default\" ";
        foreach my $e0 (@vals) {
           $e0 =~ s/\+/ /g;
           my($e, $val) = split(/\:/, $e0, 2);
           my $ck = ($e eq $default) ? "selected":"";
           $val = $e if (!$val);
           $field .= "<option $ck value=\"$e\">$val</option>";
        }
        $field .= "</select>";
        $line .= "<td bgcolor=#E8E8E8 align=right>&nbsp;<b>$name:</td><td>$field &nbsp;</td>";
      }
      $line .= "\n";
    } else {
      $line .= "<tr><td><b>$el</b>&nbsp;</td>";
      $cl .= "$el ";
    }
    $cnt++;
  }
  $line .= "</table>";
  chop($cl) if (substr($cl,-1) eq " ");
  return ($line, $cl);
}


1;
