package GUI::Review;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use System;
use Util;

#  $Id: Review.pm,v 1.83 2002/09/19 15:43:57 ccadieux Exp $


sub run {
  my($q, $post) = @_;

  my $G = Labels->read();
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  print Html->header2("admin.gen_maint.review");

  print "<form><input type=hidden name=GO value=GUI::Review::_run>
       <b><input type=submit name=ACTION_run value=\" $G->{submit_run} \"></form>";
}

sub _run {
  my($q) = @_;

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
  my($acronym) = $renv->{GSV_ACRONYM};
  my $G = Labels->read();

  print Html->body();
  print Html->header2('admin.gen_maint.review');
  $info = "";

  print "<table border=1 cellspacing=0 cellpadding=3 width=90% bgcolor=white><tr bgcolor=$main'LIGHT>
   <th>$G->{number}</td><td><b>$G->{details0}</td>
  ";

  my $L = &run_($q);
  my $cnt=1;
  foreach my $el (@$L) {
    print "<tr><td>$cnt</td><td>$el</td>";
    $cnt++;
  }
  if ($#$L < 0) {
    print "<tr><td><b>No error(s) found!</td>";
  }
  print "</table>";
}

sub run_ {
  my($q) = @_;

  my $SUPPORTED_PERL_VERSION = 5.005;
  my $G = Labels->read();
  my $L = Labels->read('GUI::Review')->section('review');

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
  my($acronym) = $renv->{GSV_ACRONYM};
  my @L;
  $cnt= 0;
  if (!$renv->{customer} || ($renv->{customer} =~ /Enter /) ||
      !$renv->{site_name} || !$renv->{site_city} || !$renv->{site_zip} ||
      !$renv->{site_country} ) {
     push(@L, $L->expand('err_1', "<a href=$Http::WEBPROC?GO=GUI::Config::upd>"));
  }

  if (!$renv->{categories} || $renv->{categories} eq "message") {
     push(@L, $L->expand('err_2', "<a href=$Http::WEBPROC?GO=GUI::Config::upd>"));
  }

  $local_active = (-f System->get_home() . "/DATA/start")? "Y":"N";

  if ($local_active eq "N") {
     push(@L, "Warning: Master Agent is not active, activate in  <a href=$Http::WEBPROC?GO=GUI::Start::Agents>[Start/Stop Agents]</a>");
  }


  #Check Patch levels on master and slaves
  my %R;
  #get Local patches
  require Agent::HOST;
  $R{"local"} =  Agent::HOST->get_patches();

  # get all SUNWstade patches on slaves 
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my @HD ;

  foreach my $host0 (@$hosts) 
  {
     # Get info from remote host 
     my $rc = Util::Http->runit($host0->{ipno} || $host0->{hostname}, "/sbin/installed_patches ");

     my @A = split(/\n/, $rc);
     for (my $x=0; $x <= $#A; $x++) {
        my(@a) = split(/\./, $A[$x]);
	push(@HD, "$a[1]");
     }

     $R{"$host0->{hostname}"} = join("\n", @HD);
  }
  # have all the patch data, now compare
  my ($match, $x, $y);
  my ($key1, $key2, $name1, $name2);
  foreach $key1 (keys %R) {
     my @A = split(/\n/, %R->{$key1});
     #index through all the patches from this host index key
     for ($x=0; $x <= $#A; $x++) {
	#Compare this patch with patches from other hosts
        foreach $key2 (keys %R) {
	   if("$key1" eq "$key2"){
	      #No need to compare with self
	      next;
	   }
           my @B = split(/\n/, %R->{$key2});
	   $match = 0;
	   
           for ($y=0; $y <= $#B; $y++) {
	      if($B[$y] eq $A[$x]){
	         # We found the match
		 $match = 1;
		 last;
	      }
           }
	   if(!$match){
	      if("$key1" eq "local"){
                 $name1 = "Master";
              }else{
                 $name1 = $key1;
              }
	      if("$key2" eq "local"){
                 $name2 = "Master";
              }else{
                 $name2 = $key2;
              }
	      push(@L, $L->expand('err_10',  $A[$x], $name1, $name2));
	   }

        }
     }
  }


#
# CHECK IF SLAVES CONFIG WERE PUSHED
#
  $CAT{H} = $renv->{categories} . "|se|";
  $CAT{H. $renv->{hostname}} = $renv->{categories} . "|se|";

  for ($x0 = 0; $x0 <= $#$hosts; $x0++) {
    $h = $hosts->[$x0];
    $CAT{"H" . $h->{hostname}} = $h->{categories} . "|se|";

    if (!$h->{categories} || ($h->{categories} eq "message") ) {
      push(@L, "Error : No storage categories selected on slave $h->{hostname}. Execute <a href=$Http::WEBPROC?GO=GUI::Hosts::upd&no=$x0>Update Slave</a> to fix.");
    }
    if (!$h->{last_push}) {
      push(@L, "Error : The configuration of slave $h->{hostname} needs to be updated, Execute <a href=$Http::WEBPROC?GO=GUI::Hosts::pushSlaves>Push Slaves</a> to update Slaves.");
    }
    if ($h->{active} eq "N") {
      push(@L, $L->expand('slave_1', $h->{hostname}, "<a href=$Http::WEBPROC?GO=GUI::Start::Agents>") );
    }

    $rc = Util::Http->getCommand($h->{ipno} || $h->{hostname}, "Util::checkRasCrons",  20);
    if ($rc =~ /ERROR/) {
      $rc =~ s/\<font color=green\>.*\<\/font\>//;
      push(@L, "$h->{hostname}:</b> $rc");
    }
 
  }

  my ($version, $last_v, $version_err);
  $last_v = $renv->{version};
  my %HOSTS;
  $HOSTS{'LOCAL'} = 1;
  for ($x0 = 0; $x0 <= $#$hosts; $x0++) {
    $h = $hosts->[$x0];
    $HOSTS{$h->{hostname}} = 1;
    $rc = Util::Http->getCommand($h->{ipno} || $h->{hostname}, "INFO1",  10);
    my($hostid, $v, $master1, $perl_version) = split(/\s*\|\s*/, $rc);
    $v = Util->trim(substr($v,8)) if (length($v) > 8);
    $version .= "<tr><td>$h->{hostname}</td><td>$v</td>";
    if ($perl_version && $perl_version < $SUPPORTED_PERL_VERSION) {
         push(@L, $L->expand('perl',$h->{hostname}, $perl_version));
    }
    if ($last_v) {
       if ($last_v ne $v) {
         push(@L, $L->expand('diff',$h->{hostname}, $v, $last_v));
       }
    } else {
      $last_v = $v;
    }
  }

  $active = 0; $found = 0;
  my %NOCHECK;
  for ($x0 = 0; $x0 <= $#$dev; $x0++) {
     $h = $dev->[$x0];
     next if (!$HOSTS{$h->{host} || 'LOCAL' });

     if (!$h->{host} && !defined($CAT{"H" . $h->{host}})) {
        push(@L, $L->expand('err_3',  $h->{host}, 
          "<a href=$Http::WEBPROC?GO=GUIAdmin::A5K::updDevice&no=$x0>" , $h->{name}));
     }
     next if ($h->{type} eq "se");
     if (index($CAT{"H" . $h->{host}}, $h->{type}) < 0) {
        $hh = $h->{host} || System->hostname();
        $NOCHECK{$hh} .= "$h->{type}:$h->{name}, ";
     }
         
     $found++;
     if ($h->{active} eq "Y") {
        $active++;
     }
  }
  foreach $x0 (keys %NOCHECK) {
     push(@L, $L->expand('err_4', $x0,  $NOCHECK{$x0}, "<a href=$Http::WEBPROC?GO=GUI::Hosts::list>" )); 
  }
     
  if (!$active) {
     push(@L, $L->expand('err_5', "<a href=$Http::WEBPROC?GO=GUI::Start::Devices>" ));
  }

  if ($found != $active) {
     push(@L, $L->expand('err_6', "<a href=$Http::WEBPROC?GO=GUI::Start::Devices>")); 
  }
 
  $active = 0;
  opendir(O, System->get_home() . "/lib/Provider");
  @list = readdir(O); closedir(O);

  foreach $x (@list) {
    next if ($x !~ /.pm$/);
    $name = substr(lc($x), 0, -3);
    $active = 1 if ($renv->{"pro.$name.active"} eq "Y");
  }

  if (!$active) {
     push(@L, $L->expand('err_7', "<a href=$Http::WEBPROC?GO=GUI::Providers::display>" ));
  }

  if ($#$notifs < 0) {
     push(@L, $L->expand('err_8', "<a href=$Http::WEBPROC?GO=GUI::Notifs::list>"));
  }


  # check for MPxIO failed over paths
  # Read in Topology
  require TO;
  my($To) = TO->readExistingTopo("MERGE-MASTER") || TO->readExistingTopo();
  if($To) {
     my($storage) = $To->storageList();
     $co = 0;
     foreach my $st ( @$storage) {
        my($port_infos) = $st->portInfo();

	my($p);
	for ($p=0; $p <= $#$port_infos; $p++) {

           if($port_infos->[$p]->{ProductID} ) {
	      if($port_infos->[$p]->{ProductID} =~ /T300/) { 
		if($port_infos->[$p]->{PortMode} =~ /Primary/) {
		   if($port_infos->[$p]->{"Path State"} !~ /ONLINE/)
		   {
		      push(@L, "Warning: On host $port_infos->[$p]->{dataHost} found \
		      $port_infos->[$p]->{LogicalPath} as a primary path but was not \
		      online when the snapshot topology was performed. To check to see if\
		      the path is in the correct state issue the following command on host\
		      $port_infos->[$p]->{dataHost}: \
		      <br>luxadm display $port_infos->[$p]->{LogicalPath}<br> You should see\
		      the primary path as online. If it isn't,\
		      issue the following command on host $port_infos->[$p]->{dataHost}:\n\
		      <br>luxadm failover primary $port_infos->[$p]->{LogicalPath}<br> Then perform \
		      another Topology Snapshot.<br> If the path is in the correct state, just perform \
		      another Topology Snapshot.");

		   }
		}
	      }
	   }
	}
     }
  }
  #end find mpxio path errors
  


  $out = Util->checkRasCrons();

  if ($out =~ /ERROR:/) {
     $out =~ s/\<font color=green\>.*\<\/font\>//;
     push(@L, "On Master: $out \n");
  }

  my $netc = `/usr/bin/pkginfo -q SUNWncon`;
  $netc = $?;
  # With -q option, if package is installed, return value will 0
  # If the package isn't stalled, a value greater than 0 will be returned.
  if ((!$netc)  && $renv->{'pro.netconnect.active'} ne "Y") {
     push(@L, $L->expand('err_9', "<a href=$Http::WEBPROC?GO=GUI::Providers::display>"));
  }

  
  return \@L;
}

sub frame {
  my($q) = @_;

  my $frame = $q->{frame} || "maintF";
  my $page = $q->{page};

  open(O, System->get_home() . "/htdocs/${frame}.html");
  my $out;
  while ($l = <O>) {
     if ($l =~ /src=.*Welcome/) {
        $out .= "src=$Http::WEBPROC?GO=$page\n";
     } else {
        $out .= $l;
     }
  }
  close(O);
  print $out;
}

sub logout {
  my $renv = System->get_renv();

  print "Http/1.0 401 Authorization Required\n";
  print "WWW-Authenticate: Basic realm=\"User\"\n\n";

  print "<body bgcolor=white><meta http-equiv=Refresh content=\"0;URL=/\">";
}


sub welcome {
  my($q) = @_;
  my $out;
  print Html->body();
  my $G = Labels->read();
  my $L = Labels->read('GUI::Review')->section('welcome');

  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  if (!$renv) {
     print "&nbsp;<p><center>$L->{err_1}";
     return;
  }
  my $master = Util->findMaster();
  my $port   = System->get_rasport();
  if ($master) {
     print "&nbsp;<p>&nbsp;<br>
      <table border=0 cellpadding=4 cellspacing=0 bgcolor=white width=60%>
       <tr><td><center><big><a href=http://$master:$port target=_top>
        <font color=red>$L->{err_2}
      </table>";
     return;
  }
  my($acronym) = $renv->{GSV_ACRONYM};

  print Html->header2('ROOT.welcome');

  #my $welcome = Util->readHtdocs("welcome");
  my $copyright = Util->readHtdocs("copyright");
  $copyright =~ s/<body /<Xody /;
  $copyright =~ s/<p>//;

  my ($extra, $config_summary) = &config_summary($renv, $devs, $hosts, $notifs, $G, $L);

  $state_summary  = &state_summary($extra, $G, $L);

  print "<table border=0 cellspacing=0 cellpadding=0 width=90%><tr>
        <td valign=top width=50%>$config_summary</td><td valign=top>$state_summary</td></table>
  <table border=0><tr><td></table>";

  
  my $steps = &steps($L);

  print "
    <script>
    function win1() {
      var O = window.open('$Http::WEBPROC?GO=GUI::Review::steps_win', 'install',
                'menubar=no,resizable=yes,scrollbars=no,width=720,height=180');
      O.focus();
    }
    </script>
    <table border=0 cellspacing=2 cellpadding=1 width=90%><tr><td bgcolor=black>
    <table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=#F0F0F0>
      <tr><td bgcolor=$main'LIGHT>
       <table border=0 cellspacing=0 cellpadding=0 width=100%>
          <tr><td><b>$L->{steps}</td>
              <td align=right>[ <a href=javascript:win1()>$L->{steps2}</a> ]
       </table>
      <tr><td> $steps </td>
   </table></table>";

  print " </table> ";
  print $copyright;
}

use vars qw (@A @B);

@A = ('site','hosts','devices','email','notif','topo','config','start');
@B = ('GUI::Config::site',      'GUI::Hosts::list',
           'GUI::Discover::run',     'GUI::Notifs::list',
           'GUI::Providers::display','GUI::SAN::snapshot', 
           'GUI::Review::run',       'GUI::Start::Agents'
           );

sub steps {
  my ($L) = @_;
  my $out;

  $out = "<table border=0 cellspacing=0 cellpadding=0><tr><td>";

  for ($x=0; $x <= $#A; $x++) {
     my $l = "step_" . $A[$x];
     $out .= "<td>
    <table border=1 cellspacing=0 cellpadding=4 bgcolor=white width=100%>
      <tr><td><b><center>
        <a href=$Http::WEBPROC?GO=$B[$x]>$L->{$l}</a></td>
      </table>
    </td>";
     $out .= "<td> <img src=/gif/arrow.gif></td>" if ($x < $#A);
  }
  $out .= "</table>";

  return $out;
}

sub steps_win {

  my $L = Labels->read('GUI::Review')->section('welcome');
  my $js = &js2();
  my ($out, $layers);

  $out =<<EOF;
<head>$js</head><body bgcolor=#666699>
<table border=0 cellspacing=2 cellpadding=1 width=70%><tr><td bgcolor=black>
    <table border=0 cellpadding=2 cellspacing=1 width=100% bgcolor=#F0F0F0>
      <tr><td bgcolor=#CCCCFF>
          <b>$L->{steps}</td>
      <tr><td>
<table border=0 cellspacing=0 cellpadding=0><tr>
EOF
  my $cnt = 11;
  for ($x=0; $x <= $#A; $x++) {
     my $l = "step_" . $A[$x];
     my $info  = "info_" . $A[$x];
     $out .=<<EOF;
 <td> <center>
     <table border=1 cellspacing=0 cellpadding=4 bgcolor=white width=100%>
      <tr><td><b><center>
       <a href=$Http::WEBPROC?GO=$B[$x]  target=bottom
        onclick="set('$A[$x]',2,$cnt)" onmouseover="set('$A[$x]',1,$cnt)"
        onmouseout="set('$A[$x]',0,$cnt)">$L->{$l}</a></td>
     </table>
     <img name=b$cnt src=gif/lineout.gif width=65 height=5 vspace=2>
     </td>
EOF

     $out .= "<td> <img src=/gif/arrow.gif></td>" if ($x < $#A);
     $cnt++;
     $layers .=<<EOF;
<layer id=$A[$x] left=14 visibility=hide>
  <table border=0 cellspacing=0 cellpadding=4 width=98% bgcolor=#FFFFDD>
   <tr><td>$L->{$info}
  </table>
</layer>
EOF

  }
  $out .= "</table> </td></table></table> <table border=0><tr><td></table>";
   
  print $out . $layers;

  
}



  


sub js2 {
  return <<EOF;
<script>
var browser = select_browser();
var click = new Array(10);

 function pic(id,gif) {
    if (navigator.appName == "Netscape") {
      document.images["b" + id].src = "/gif/" + gif + ".gif";
    } else {
      document.all["b" + id].src = "/gif/" + gif + ".gif";
    }
 }

function select_browser() {
  var browser="None";

  if (navigator.appName.indexOf("Netscape")>=0 && parseFloat(navigator.appVersion) >=4){
    browser="NS4";
    version=4;
  }

  if(document.getElementById){
    browser="NS6";
    version=6;
  }

  if(document.all){
    if(document.getElementById){
      version=5;
    } else {
      version=4;
    }
    browser="IE";
  }
  return browser;
}
function set_visible(element,show) {
  if(browser=="NS4"){
    if(document.layers[element] != undefined){
      if (show >= 1){
        document.layers[element].visibility="show";
      } else {
        document.layers[element].visibility="hide";
      }
    }
  } else if (browser == "IE"){
    if(document.all[element]!=null){
      if(show >= 1){
        document.all[element].style.visibility="visible";
      } else {
        document.all[element].style.visibility="hidden";
      }
    }
  }
}
var save = "X";
var erase = "X";
function set(element, show, id) {
  if (show == 2) {
    click[id] = 1;
    pic(id,'linein');

  } else if (show == 1) {
    if (click[id] != 1) pic(id,'lineover');
    if (erase != "X") {
      set_visible(erase, 0);
      erase = "X";
    }

    if (save != element) {
      set_visible(save, 0);
      set_visible(element, show);
      save = "X";
    }
  } else if (show == 0) {
    if (click[id] != 1) pic(id,'lineout');
    erase = element;
  }
}
</script>
EOF
}





sub state_summary {
  my($extra, $G, $LB) = @_;

  require GUI::AlertReport;
  my $L = GUI::AlertReport->state_();
  my $cnt=0;
  my $out = "
  <table border=0 cellspacing=2 cellpadding=1 width=100%><tr><td bgcolor=black>
  <table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
   <tr  bgcolor=#CCCCFF> <td>
    <table border=0 cellspacing=0 cellpadding=0 width=100%>
        <tr><td><b>&nbsp;$LB->{alert_summ}</b></td>
        <td align=right>[ <a href=$Http::WEBPROC?GO=GUI::AlertReport::state>$LB->{details}</a> ]&nbsp;</table>
   <tr><td >
    <table border=0 cellspacing=1 cellpadding=2 width=100%>
        <tr bgcolor=#E0E0E0><td><b>$LB->{cat}</th>
           <th><img src=/gif/al_alert.gif vspace=0 alt=$LB->{warn}></th>
           <th><img src=/gif/al_crit.gif vspace=0 alt=$LB->{err}></th>
           <th><img src=/gif/al_down.gif vspace=0 alt=$LB->{down}></th>
            ";
  foreach my $l (@$L) {
     my $bg = $cnt % 2 == 1 ? "bgcolor=#F0F0F0":"";
     $out .= "<tr $bg><td>$l->[1]</td><td><b><center>$l->[2]&nbsp;</td><td><b><center>$l->[3]&nbsp;</td><td><b><center>$l->[4]&nbsp;</td>";
     $cnt++;
  }

  for ($x = $cnt ; $x <= 3 + $extra; $x++) {
     my $bg = $cnt % 2 == 1 ? "bgcolor=#F0F0F0": "";
     $out .= "<tr $bg><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>";
     $cnt++;
  }
  $out .= "</table></table></table>";
  return $out;
}


sub config_summary {
  my($renv,  $devs, $hosts, $notifs, $G, $L) = @_;


  my $hcnt = $#$hosts + 2;
  my $dcnt = $#$devs + 1;
  my $hcnt_s = "s" if ($hcnt > 1);
  my $dcnt_s = "s" if ($dcnt > 1);
  my $not;
  $not .= "Http, " if ($renv->{'pro.http.active'} eq "Y");
  $not .= "NetConnect, " if ($renv->{'pro.netconnect.active'} eq "Y");
  $not .= "SRS, " if ($renv->{'pro.srs.active'} eq "Y");
  $not .= "RSS, " if ($renv->{'pro.uucp.active'} eq "Y");
  my $not_title;
  if ($not) {
    chop($not);chop($not);
    $not_title = $L->{notifs} ;
  } else {
    $not = "None";
    $not_title = $L->{notif};
  }
  my $em = $#$notifs + 1;
  $em .= " ($notifs->[0]{email})" if ($em == 1);
  my $info = $renv->{customer} . " " . $renv->{site_city} . " " . $renv->{site_state};
  if (!$renv->{site_country}) {
     $info .= "&nbsp;<b><a href=$Http::WEBPROC?GO=GUI::Config::site>".
               "<font color=red>$L->{site_err}</font></a>";
  }
  my $last = Util->get_file_created(System->get_home() . "/DATA/Events.log");
  $last = "[No events]" if (!$last);

  my $laste = Util->get_file_created(System->get_home() . "/DATA/Alerts.log");
  $laste = "[No alerts]" if (!$laste);
  my %C;
  foreach my $d (@$devs) {
    $C{$d->{type}}++;
  }
  my(%SP);
  $SP{$renv->{solution_model}}++ if ($renv->{solution_model});
  foreach my $h (@$hosts) {
     if ($h->{solution_model}) {
       $SP{$h->{solution_model}}++;
     }
  }
  my ($sol, $sol2, $extra);
  foreach my $s (sort keys %SP) {
     $sol .= ", " if ($sol);
     $sol .= "$SP{$s} $s";
  }
  my $next = "";
  if ($sol) {
    $sol2 = "<tr><td align=right width=25%>3900/6900:</td><td>$sol</td>";
    $next = "bgcolor=#F0F0F0";
    $extra = 1;
  }
  
  return ($extra, "
  <table border=0 cellspacing=2 cellpadding=1 width=100%><tr><td bgcolor=black>
  <table border=0 cellpadding=2 cellspacing=0 width=100% bgcolor=white>
   <tr><td colspan=2 bgcolor=$main'LIGHT><b>&nbsp;$L->{conf_summ}</td>
   <tr><td colspan=2>
    <table border=0 cellspacing=1 cellpadding=2 width=100%>
     <tr  bgcolor=#E0E0E0>
       <td align=right>$L->{site}:</td><td><b>$info</td>
     <tr>
       <td align=right>$L->{ins}:</td><td>$hcnt host$hcnt_s, $dcnt device$dcnt_s</td>
     <tr  bgcolor=#F0F0F0>
       <td align=right>$not_title:</td><td>$not</td>
     <tr>
       <td align=right width=25%>$L->{email}:</td><td>$em</td>
     <tr bgcolor=#F0F0F0>
       <td align=right width=25%>$L->{event}:</td><td>$last</td>
     $sol2
     </table>
  </table></table>");
}

1;
 
