package GUI::RUNAgent;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Util;
use Agent;
use Html;

sub run {
  my($q) = @_;
  print Html->body();

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $G = Labels->read();
  my $L = Labels->read('GUI::RUNAgent');

  my($acronym) = $renv->{GSV_ACRONYM};

  print Html->header2('admin.system.run_agent');

  my $l = "Local=$G->{local}|";
  foreach my $h (@$hosts) {
     $l .= "$h->{ipno}=$h->{hostname}|";
  }
  my $select = Util->makeSelect("host", $l, $q->{host});


  my($err, $but2);
  if (($st_found= Agent->stor_conflicts()) ) {
    $err = "<br><font color=red>" . $L->expand('err_1', $renv->{frequency});
    $but2 = " <input type=submit name=ACTION_force value=\"$L->{submit2}\">";
  }

  print "&nbsp;<p>
  $err
  <form><input type=hidden name=GO value=GUI::RUNAgent::run2><b>

 <table border=1 cellpadding=4 cellspacing=0 bgcolor=white width=90%><tr>
   <td align=right bgcolor=#CCCCFF><b>$L->{l1}:</td>
   <td><b>$select </td>
   <tr><td align=right bgcolor=#CCCCFF><b>$L->{l2}:</td>
   <td><b><input type=checkbox name=audit></table>
  <input type=submit name=ACTION_run value=\"$L->{submit1}\">
  &nbsp;$but2
  </form>
  ";
}


sub meta {
  my($to, $q) = @_;
  return "<meta http-equiv=Refresh content=\"$to;URL=$Http::WEBPROC?GO=GUI::RUNAgent::run2&TO=$to&host=$q->{host}\">";
}


sub run2 {
 my($q) = @_;
 my($force);
 my($renv) = System->get_renv();
 my($acronym) = $renv->{GSV_ACRONYM};
 print "\n";
 #$q->{host} = "ccadieux";
 my $L = Labels->read('GUI::RUNAgent');

 if ($q->{TO} && $q->{host}) {
   my $display = &display($q);
   print "<body bgcolor=#E0E0E0 onload=window.scroll(0,100000)><center>";
   print &meta(3, $q) if ($display !~ /Done/);
   print Html->header2('admin.system.run_agent');
   print "</center><b>$L->{reading} $q->{host}:</b><br>\n";
   print $display;
   return;
 } else {
   print Html->body();
   print &meta(3, $q);
   print Html->header2('admin.system.run_agent');
 }

   
 $PIDfile = System->get_home() . "/DATA/pid";
 $force = "-f" if ($q->{ACTION_force});
 my $audit = "-A" if ($q->{audit});

 my $T = System->get_home() . "/DATA/tmp/run_agent.out";

 if ($q->{host} eq "Local") {
   print "<b>" . $L->expand(running => $renv->{hostname}) . "</b>";
   print "<pre>";
   $h = System->get_home() . "/bin/rasagent -d2 $force $audit >$T 2>&1 &";
   system($h);

 } elsif ($q->{host}) {
   if (!Util->ping($q->{host}, 5)) {
      print "&nbsp;<p><center><font color=red><h2>$L->{cannotping}";
      return;
   }
   print "<b>" . $L->expand(running => $q->{host}) . "</b>";
   Util::Http->deleteFile($q->{host}, "/tmp/run_agent.out");

   my($err, $rc) = Util::Http->runshell($q->{host}, "/bin/rasagent -d2 $force $audit>$T 2>&1");
   print "<br>";
   print "Error: $err<br>" if ($err);
   print $rc;
 }
 #sleep(2);
 #&display($q);

}

sub display {
  my($q) = @_;
  my ($err, $rc);
  my $out;
  my $L = Labels->read('GUI::RUNAgent');
  my $T = System->get_home() . "/DATA/tmp/run_agent.out";

  if ($q->{host}  eq "Local") {
    open(O, $T);
    my @lines = <O>; 
    close(O);
    $rc = "@lines";
  } else {
    ($err, $rc) = Util::Http->readFile($q->{host}, "/tmp/run_agent.out");
  }
  my $done;
  if ($err) {
    $out .= "Error on $q->{host}: $err<br>";

  } if ($rc !~ /Remove pid/) {
    $out .= $meta;

  } else {
    $done = "<b>$L->{done}</b>";
  }
  $out .= $head;
  $out .= "<pre>";
  $out .= $rc;
  $out .= $done;
  $out .= "<br>&nbsp;<p>&nbsp;";
  return $out;
}


1;
