package GUI::Navigation;
use Html;
use System;
use Navigation;
use strict;
use GUI::Review;


sub index {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  print Http->text_header("Set-Cookie: RAS_LANG=" . $ruser->{language}. "; path=/;");
  my $window = $ruser->{window} || $renv->{window};

  if ($window eq "N") { # no top frame
     if ($q->{MENU}) {
       if (substr($q->{MENU},0,1) eq ">") {
          $q->{MENU} = substr($q->{MENU},1);
          #Navigation::nf_top($q);
          &welcome($q);
       } else {
          eval {
            Http->runFunction($q->{MENU}, $q);
          };
          if ($@) {
             print "Execution error: $@<br>\n";
          }
       }
     } else {
       #Navigation::nf_top($q);
       GUI::Review::welcome($q);  # welcome is default
     }
     return;
  } elsif ($ENV{HTTPS} || $Http::httpua !~ /la\/4.7/ ) {  # no javascript on top frame
     if ($q->{MENU}) {
       if (substr($q->{MENU},0,1) eq ">") {
          $q->{MENU} = substr($q->{MENU},1);
       }
       $q->{FRAME} = 1;
       Navigation::nf_top($q);
     } else {
       print <<EOF;
       <header><title>Storage Automated Diagnostic Environment</title></header>
       <frameset rows=80,* border=0>
         <frame src=$Http::WEBPROC?GO=GUI::Navigation::index&MENU=X name=top scrolling=no>
         <frame src=$Http::WEBPROC?GO=GUI::Review::welcome name=bottom scrolling=auto>
       </frameset>
EOF
     }
     return;

  }
# javascript on top frame

  my $nav = Navigation->read();
  my $nav1 = $nav->{ROOT};
  my @O = split(/,/, $nav1->{order});
  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $out, $sub);

  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    next if ($item->{skip} && index($item->{skip}, "t") >= 0);
    my $act = Navigation::active($item, $ruser, $renv);
    next if ($act == 0);
    $tab_list .= "\"" . ($act == 1?"-":"") . $nav->{$el}{info}{title} . "\","; # deactivate tab
    my @order = split(/,/, $nav->{$el}{order});
    $sub_tab .= "subTab[$cnt] = new Array(";
    foreach my $e (@order) {
       my $el1 = $nav->{$el}{items}{$e};
       my $url = &clean_url($el1->{url});
       my $act = Navigation::active($el1, $ruser, $renv);
       if ($act == 2) {
          my $tt = $el1->{title}; $tt =~ s/'/\\'/g;
          $sub_tab .= "'$url', '$tt',";
       } elsif ($act == 1) {
          my $tt = $el1->{title}; $tt =~ s/'/\\'/g;
          $sub_tab .= "'X', '$tt',";
       }
    }
    chop($sub_tab);
    $sub_tab .= ");\n";
    $cnt++;
  }

  chop($tab_list);
  my $out =<<EOF;
<head>
<title>Storage Automated Diagnostic Environment</title>
<script>
 var currentTab = -2;
 var currentLink = -2;
 var CNT;
 var subTab   = new Array();
 var TARGET = "bottom";
 var col1   = "white";
 var menuItem = new Array($tab_list);
 $sub_tab

EOF
  my $desc = $nav1->{info}{desc};
  $out .= &top_js($nav1->{info});

  $out .=<<EOF;
<title>$desc</title>
</head>
<frameset rows=80,* border=0>
     <frame src=/tab_topPage.html name=top scrolling=no>
     <frame src=$Http::WEBPROC?GO=GUI::Review::welcome name=bottom scrolling=auto>
</frameset>
EOF
  print $out;

}

sub top {
  my($q) = @_;
  print "\n";
  Navigation::nf_top($q);

}

sub clean_url {
  my($url) = @_;
  my $new;
  if (substr($url,0,1) eq "/") {
     $new = $url;
  } elsif (substr($url,0,1) eq ">") {
     $new = "$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=" . substr($url,1);
  } else {
     $new = "$Http::WEBPROC?GO=$url";
  }
  return $new;
}

# Navigation::file&FILE=/help.html&MENU=help

sub file {
  my($q) = @_;

  my $file = $q->{FILE};

  print Html->body();
  print Html->header2("$q->{MENU}");

  print Html->readHtdocs($file);
}




# LEFT/RIGHT FRAME if needed

sub frame {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  print "\n\n";
  
  if ($window ne "N") { # window eq B/S/N
     print <<EOF;
<frameset cols=132,* border=0>
    <frame src=$Http::WEBPROC?GO=GUI::Navigation::left_menu&MENU=$q->{MENU} name=main scrolling=auto>
    <frame src=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$q->{MENU} name=detail scrolling=auto>
</frameset>
EOF
  } else {
    GUI::Navigation::welcome($q);
  }
}

# LEFT MENU 

sub left_menu {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $nav = Navigation->read();
  my $style = $nav->{ROOT}{info}{style};
  my $js;
  my $cnt = 1;
  print "\n\n$style";

  if (exists $nav->{$q->{MENU}}) {
    my $nav1 = $nav->{$q->{MENU}};
    my $head = &menu_head( $nav1->{info}{title});
    my $out = "<table border=0 cellpadding=0 cellspacing=1 width=100%>";
    my @O = split(/,/, $nav1->{order});
    foreach my $el (@O) {
        my $item = $nav1->{items}{$el};
        next if ($item->{skip} && index($item->{skip}, "m") >= 0);

        my($url, $out0) = &read_url($item);
        $out .= $out0;
        my $target = $item->{target} || "detail";
        my $t = $out0 ? "" : "target=$target";

        my $act = Navigation::active($item, $ruser, $renv);
        my $title = $item->{short} || $item->{title};
        if ($act == 2) {
           $out .= "<tr><td valign=top><img name=b$cnt src=gif/bout.gif width=9 height=9>" .
          "</td><td><a href=$url $t onmouseover=bover($cnt) " . 
          "onmouseout=bout($cnt) onclick=bclick($cnt)>$title</a></td>\n";
        } elsif ($act == 1) {
           $out .= "<tr><td valign=top><font color=silver>&nbsp;-</td><td><font color=silver>$title</td>\n";
        }
        $out .= "<tr><td></td>";
        $out .= "<tr><td></td>";
        $cnt++;
    }
    print $head;
    print $out;
    print "</table>";
  } else {
    print "Cannot access $q->{MENU} in navigation file!";
  }
}


sub read_url {
  my($item) = @_;
  my ($url, $out);
  if (substr($item->{url},0,7) eq "WINDOW ") {
     $url = &clean_url(substr($item->{url},7));
     $out .= "<script>\nfunction win2(a) {\n" .
           "  var b = '$url'; \n"   .
           "  var O = window.open(b,'procW','$item->{window}');\n" .
           "  O.focus(); \n}</script>\n";
     $url = "javascript:win2()";
   } else {
     $url = &clean_url($item->{url});
   }
   return ($url, $out);
}


# RIGHT MENU

sub welcome {
  my($q, $TOPDONE) = @_;

  my $renv   = System->get_renv();
  my $ruser  = System->get_ruser();
  my $window = $ruser->{window} || $renv->{window};
  my $nav    = Navigation->read();
  my $style = $nav->{ROOT}{info}{style};
  my $ix     = index($q->{MENU}, ".");
  my $tab    = substr($q->{MENU}, 0, $ix);
  my $crumb;
  if (!$TOPDONE && $window eq 'N') {
     Navigation::nf_top($q);
  }

  if (exists $nav->{$tab}) {
    if ($window eq 'N') {
      $crumb = "<a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$tab>$nav->{$tab}{info}{title}</a> >";
    #} else {
    #  $crumb = "$nav->{$tab}{info}{title}.";
    }
  }
  if ($q->{MENU} ne 'ROOT') {
   if ($window eq 'N') {
     $crumb = "<a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=ROOT>$nav->{ROOT}{info}{title}</a> > $crumb";
   } else {
     #$crumb = "$nav->{ROOT}{info}{title} > $crumb";
   }
  }

  if (exists $nav->{$q->{MENU}}) {
    my $nav1 = $nav->{$q->{MENU}};
    my ($help, $u) = Html->help($nav1->{info}{help});

    my $out =<<EOF;
     \n$style<body bgcolor="#E0E0E0"><center>
      <table border=0><tr><td></table>
      <table border=0 width=90% cellpadding=2>
      <tr><td><font color=navy>$crumb <b>$nav1->{info}{title}</td>
          <td align=right>[ $help ]</table>
      <table border=0 width=90% cellpadding=5 bgcolor=white><tr><td>
       $nav1->{info}{desc}
      </table>
      <table border=1 width=90% cellspacing=0 bgcolor=#F0F0F0><tr><td>
      <table border=0 width=100% cellspacing=2 cellpadding=4>
EOF
    my @O = split(/,/, $nav1->{order});
    foreach my $el (@O) {
        my $item = $nav1->{items}{$el};
        next if ($item->{skip} && index($item->{skip}, "w") >= 0);
        my $act = Navigation::active($item, $ruser, $renv);
        my($url, $out0) = &read_url($item);
        $out .= $out0;
        
        if ($act == 2) {
           $out .= "<tr><td bgcolor=$main::LIGHT width=25% align=right><b>[ <a href=$url>$item->{title}</a> ]</td>
          <td bgcolor=white>$item->{desc}</td>";
        } elsif ($act == 1) {
           $out .= "<tr><td bgcolor=$main::LIGHT width=25% align=right><b><font color=gray>[ $item->{title} ]</td>
          <td bgcolor=white>$item->{desc}</td>";
        }
    }
    $out .= "</table></table>";
    print $out;
  } else {
    print "Cannot access $q->{MENU} in navigation file!";
  }

}

# AUTOMATIC SITE MAP

sub site {
  my($q) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $role = $ruser->{role};
  my $window = $ruser->{window} || $renv->{window};
  my $nav = Navigation->read();
  print Html->body();
  print Html->header2('help_sys.site_map', "95%");

  my ($tab_list, $sub_tab);
  my $cnt = 0;
  my ($i, $out, $sub);
  print "<table border=0 cellspacing=1 width=95% bgcolor=white cellpadding=2>";

  print &site_($ruser, $renv, $nav, 'ROOT', 0);
  print "</table>";
}

sub site_ {
  my($ruser, $renv, $nav, $node, $level) = @_;
  my $out;
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});
  my ($last, $i);
  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    my $sp = "&nbsp;&nbsp;&nbsp;" x ($level -1) if ($level > 0);
    next if ($item->{skip} && index($item->{skip}, "s") >= 0);
    my $act = Navigation::active($item, $ruser, $renv);
#   print "$item->{url}, $item->{role}, $item->{rack}, $act<br>";
    next if ($act == 0);
    $out .= "</td><td valign=top>" if ($level == 0);

    if (substr($item->{url},0,1) eq ">") {
      if ($level == 0) {
        $out .= "<table border=0 cellspacing=0 cellpadding=2 bgcolor=$main::LIGHT width=100%><tr><td>" . 
                 "$sp<b>$item->{title}</b></table>\n";
      } else {
        $out .= "$sp<b>$item->{title}</b><br>\n";
      }
      $out .=  &site_($ruser, $renv, $nav, substr($item->{url},1), $level+1);
    } elsif (substr($item->{url}, 0, 1) eq "/")  {
      if ($act == 2) {
        $out .= "$sp-<a href=$item->{url}>$item->{title}</a><br>\n";
      } elsif ($act == 1) {
        $out .= "$sp-<font color=gray>$item->{title}</font><br>\n";
      }
    } else {
      if ($act == 2) {
        $out .= "$sp-<a href=$Http::WEBPROC?GO=$item->{url}>$item->{title}</a><br>\n";
      } elsif ($act == 1) {
        $out .= "$sp-<font color=gray>$item->{title}</font><br>\n";
      }
    }
    $last = $item;
  }
  return $out;
}


  

sub menu_head {
  my($name) = @_;
  return <<EOF;
<head>
 <script> var click = 0;  function pic(id,gif) {     if (navigator.appName == "Netscape") {       document.images["b" + id].src = "/gif/" + gif + ".gif";     } else {       document.all["b" + id].src = "/gif/" + gif + ".gif";     }  }  function bover(id) {     pic(id,'bover');   }  function bout(id) {     if (click) {        pic(click, 'bclick');     }     if (id == click) {        return;     }     pic(id,'bout');   }  function bclick(id) {     if (click) {       pic(click,'bout');     }     click = id;     pic(id,'bclick');   } 
</script>
</head>
<body bgcolor=#666699  link=white vlink=white alink=red leftmargin=1 marginwidth=1 marginheight=0 topmargin=0>
 <table border=0  cellspacing=0 cellpadding=1 bgcolor=$main::LIGHT width=110%>
    <tr><td>
      <center><b>$name
    </table>
    <table border=0><tr><td></table>

EOF
}

sub top_js {
  my($info) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  return <<EOF;
 var high =  "#6666A2";
 function go(page) {
    setTimeout("parent.frames[1].location='"+ page + "'", 0);
    return;
 }
 function go0(page) {
    setTimeout("parent.location='"+ page + "'", 0);
    return;
 }

 function draw_menu(thismenu) {
     if (thismenu == -2) {   // reset
       currentTab = -2;
     } else if (thismenu >= 0) {
       currentTab = thismenu;
     }
     var style = '<style type="text/css">a:link       {text-decoration:none; }</style>';
     var out = style + 
        '<body alink=red vlink=white link=white bgcolor="#666699" ' + 
        'leftmargin=0 topmargin=0 marginwidth=0 marginheight=0 ' + 
        'background=/gif/tab_bg0.gif>' + 
        '<table border=0 cellspacing=0 cellpadding=0 width=100%>' +
        '<tr><td width=1% rowspan=2>' + 
        '<a href=javascript:parent.draw_menu(-2)><img src=/gif/tab_logo.gif name=logo border=0 width=125 height=48 alt=Sun></a></td>' + 
        '<td><img src=/gif/dot_clear.gif width=1 height=24></td><td nowrap>$info->{label1}</td>' + 
        '<td align=right nowrap>' +
        "<a href=javascript:parent.go('$Http::WEBPROC?GO=GUI::Review::welcome')><font color=white><u>$info->{label2}</u></font></a>&nbsp;" + 
        "<font color=red>|</font>&nbsp;" + 
        "<a href=javascript:parent.go('$Http::WEBPROC?GO=GUI::Navigation::frame&MENU=help_sys')><font color=white><u>$info->{label3}</u></font></a>&nbsp;" + 
        "<font color=red>|</font>&nbsp;" + 
        "<a href=javascript:parent.go0('$Http::WEBPROC?RESETLOGIN=1')><font color=white><u>$info->{label4}</a>&nbsp;" +
        "&nbsp;</td>" +
        '<tr><td></td><td>';
    CNT = 2;
    var builder,  bold;

    builder = "<table border=0 cellspacing=1 cellpadding=0><tr>";

    bold = "";

    for (var i=0; i < menuItem.length; i++) {
        CNT++;
        if (i == currentTab ) {
           builder += "<td bgcolor=" + high + "><img src=/gif/sep2.gif width=5 height=17 xalign=top>" +
           "&nbsp;<a href='javascript:parent.tab_click("+ i+ 
           ")'><font color=white><b>&nbsp;" + menuItem[i] + 
           "&nbsp;</b></font></a>&nbsp;<img src=/gif/sep1.gif width=5 height=17 xalign=top></td>";
        } else {
           var im1 , im2;
           im1 = (i == currentTab+1)? "&nbsp;": "<img src=/gif/sep2.gif width=5 height=17 xalign=top>";
           im2 = (i == currentTab-1)? "&nbsp;": "<img src=/gif/sep1.gif width=5 height=17 xalign=top>";
           if (menuItem[i].substr(0,1) == '-') {
             builder += "<td bgcolor=#C0C0C0>" + im1 +
              "&nbsp;<font color=#606060>" + menuItem[i].substr(1) + "</font>&nbsp;" + 
              im2 + "</td>";
           } else {
             builder += "<td bgcolor=#C0C0C0>" + im1 +
              "&nbsp;<a href='javascript:parent.tab_click(" + i + 
              ")'><font color=navy>" + menuItem[i] + "</font></a>&nbsp;" + 
              im2 + "</td>";
           }
        }
    }
    builder += "</table>";
    out += builder;

    out += '</td><td align=right>' + 
      '<font color=white>$ruser->{userid} | $renv->{version}&nbsp;&nbsp;' + 
      '<host></host>&nbsp;</td>';
    out += '<tr>';

    if (currentTab >= 0) {
        out += "<tr><td></td><td colspan=2 valign=top bgcolor=" + high +
                "><table border=0 cellpadding=2>" +
                "<tr><td nowrap>" + makeSubTab(currentTab) +
                "&nbsp;<br>&nbsp;</td></table></td>";
    } else {
        out += '<td colspan=2></td>';
    }
    out += '</table>';

    return out;
 }

 function makeSubTab(menu) {
   var arr = subTab[menu];
   var out, sel, not_sel, sel0 ;
   sel = "";  sel0 = ""; out = "";

   for (var i=0; i < arr.length; i+=2){
       var el;
       if (i == currentLink) {
         go(arr[i]);
         out +=  "<td bgcolor=#DDDDFF><a href=javascript:parent.link_click(" + 
              menu + "," + i + ",'" + arr[i] + "')>" +
             "<font color=black><b>&nbsp;" + arr[i+1] + "&nbsp;</font></b>" + "</a></td>";

       } else {
         var a1 = arr[i];
         if (a1 == 'X') {
           out += "<td><font color=white>" + arr[i+1] + "</font></td>";
         } else {
           out += "<td><a href=javascript:parent.link_click(" + 
                 menu + "," + i + ",'" + a1 +"')>" + "<u>" + arr[i+1] + "</u></a></td>";
         }
       }
       if (i < arr.length-2) 
         out += "<td>&nbsp;<font color=white>|&nbsp;</td>";
       
   }
   return "<table border=0 cellspacing=0 cellpadding=0><tr>" + 
           sel + out + "</table>";
 }

 function link_click(num, link, page) {
    currentLink = link;
    return draw_menu(-1);
 }

 function tab_click(num) {
    currentLink = -2;
    return draw_menu(num);
 }
</script>
EOF
}




1;
