package GUI::Grouping;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;
use TO;
use Util;
use Grouping;
use Html;
use Html::Tabs;
use Html::List;
use strict;


sub index {
  my($q) = @_;

  my($h) = Html->header2("admin.topo.grouping",  "95%");
  print "\n<body bgcolor=$main'BGCOLOR><center> $h";
  my $LB = Labels->read("GUI::Grouping");


  if ($q->{ACTION_addcat}) {
      if ($q->{code} && $q->{desc}) {
         $q->{code} =~ s/\./_/g;
         Grouping->addCategory($q->{host}, $q->{code}, $q->{desc});
         Grouping->save();
      } else {
         print "<font color=red><b>$LB->{enter_code}";
      }
  }
  if ($q->{ACTION_delete}) {
     foreach my $el (keys %$q) {
        if (substr($el,0,4) eq "del_") {
           Grouping->deleteCategory(substr($el,4));
        }
     }
     Grouping->save();
  }
  my $list = Grouping->groupList();
  my @M;
  my @L = ("1=$LB->{list}");
  my $cnt=2;
  foreach my $el (@$list) {
    my $v1 = Util->shortHostname($el->{host});
    
    push(@L, "$cnt=$v1:$el->{group}");
    $M[$cnt] = "$el->{host}:$el->{group}";
    $cnt++;
  }
  $q->{option} = 1 if (!$q->{option});
  my $tab = Html::Tabs->create(list  =>  \@L,
                     url  => "$Http::WEBPROC?GO=GUI::Grouping::index",
                       width  => "95%",
               selectedColor  => "white",
           selectedTextColor  => "blue",
             backgroundColor  => $main'LIGHT,
          backgroundTextColor => 'black',
                    selection => $q->{option}
                 );
 if($#L > 0){
    print $tab;
 }

  if ($q->{option} == 1) {
    &group_maintain($q);
  } else {
    $q->{code} = $M[$q->{option}];
    &group_build($q);
  }

}

sub group_build {
  my($q) = @_;
  my $group = $q->{code};
  my($group_host, $group_id) = split(/\:/, $group);
  my $deny = Roles->verifyRole($q, "admin");
  my $LB = Labels->read("GUI::Grouping");

  my @GROUP_TYPE = ("standard=$LB->{g_default}","rack=$LB->{g_rack}", 
                    "room=$LB->{g_room}", 
                    "building=$LB->{g_building}",
                    "cloud=$LB->{g_cloud}" );

  if ($q->{ACTION_update}) {
     foreach my $v (keys %$q) {
        if (substr($v,0,4) eq "sel_") { 
           my $k = substr($v,4);
           $q->{groupID} =~ s/[^\w\.\-]/_/g;
           Grouping->setGroup($group, $k, $q->{groupID});
        }
     }
     Grouping->save();
  }

  if ($q->{ACTION_updid}) {
     foreach my $v (keys %$q) {
        if (substr($v,0,5) eq "desc_") { 
           my $k = substr($v,5);
           my $desc = $q->{$v};
           my $style = $q->{"style_$k"};
           my $color = $q->{"color_$k"};
           if ($desc || $style || $color) {
             Grouping->updateId($group, $k, $desc, $style, $color);
           }
        }
     }
     Grouping->save();
  }

  Grouping->refreshMap($group);
  my $gr      = Grouping->read($group);
  my $members = $gr->members();
  my $map     = $gr->map();
  my $info    = $gr->info();

  if ($q->{SUMM}) {
      print "
   <table border=0><tr><td></table>
   <table border=1 cellspacing=0 width=95% bgcolor=white>
     <tr bgcolor=#666699><td colspan=5>
       <form method=post><input type=hidden name=GO value=\"GUI::Grouping::index\">
       <input type=hidden name=option value=\"$q->{option}\">
       <input type=hidden name=SORT value=\"$q->{SORT}\">
       <input type=hidden name=SUMM value=1>
       <table border=0 cellspacing=0 cellpadding=0 width=100%>
        <tr><td><b><font color=white>$LB->{title1} '$group'</td>
        <td align=right><font color=white>[ 
           <a href=\"$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&HOST=$q->{HOST}&TYPE=$q->{TYPE}\"><font color=white>$LB->{details}</font></a> | 
           <a href=\"$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&SUMM=1&HOST=$q->{HOST}&TYPE=$q->{TYPE}\"><font color=white>$LB->{summary}</font></a> ]
       </table>
     <tr bgcolor=#CCCCFF>
        <td>&nbsp;$LB->{catid}
        <td>#Membe
        <td>&nbsp;$LB->{desc}
        <td>&nbsp;$LB->{style}
        <td>&nbsp;$LB->{color}";
     my(%X);
     foreach my $el (keys %$members) {
         my $v0 = $members->{$el};
         next if (!$v0 || $v0 eq $group);
         my $v = $X{$v0};
         if ($v) {
           $X{$v0} = [$v->[0]+1,undef];
         } else {
           $X{$v0} = [1, undef];
         }
         my ($f1, $f2) = split(/\./, $v0);
         if ($f2) {
            $v = $X{$f1};
            if ($v) {
              $X{$f1} = [$v->[0]+1,undef];
            } else {
              $X{$f1} = [1, undef];
            }
         }
     }
     foreach my $el (keys %$map) {
         if ($X{$el}) {
            $X{$el}[1] = $map->{$el};
         } else {
            $X{$el} = [0, $map->{$el}];
         }
     }
     my $cnt;
     foreach my $el (sort keys %X) {
        next if ($el eq $group);
        if (!$X{$el}[0]) {
           Grouping->deleteId($group, $el);
           next;
        }
        my $v = $X{$el};
        my $styl = "<select name=\"style_$el\">";
        foreach my $st0 (@GROUP_TYPE) {
           my $sel = ($v->[1][1] eq $st0)? "selected":"";
           $styl .= "<option $sel>$st0</option>";
        }
        $styl .= "</select>";

        my $color = "<select name=\"color_$el\">";
        foreach my $st0 (@Grouping::COLORS) {
           my($f1, $f2) = split(/\=/, $st0);
           my $sel = ($v->[1][2] eq $f1)? "selected":"";
           $color .= "<option $sel value=\"$f1\">$f2</option>";
        }
        $color .= "</select>";
        my $ix0 = CORE::index($el,":");
        my$ el0 = substr($el,$ix0+1);
        print "<tr><td>&nbsp;$el0<td>&nbsp;$v->[0]
         <td>&nbsp;<input type=text size=25 name=\"desc_$el\" value=\"$v->[1][0]\">
         <td>$styl<td>$color</td>\n";
     }
     print "</table>";
     if (!$deny) {
       print "<input type=submit name=ACTION_updid value=\"$LB->{submit_updid}\">";
     }
     print "</form>\n";
     return;
  } 
#
# DETAILS
#
  my %L;
  #foreach my $el (keys %$members) {
  #   $L{$el} = [ $members->{$el} ];
  #}
  my($hosts) = Util->shortHostname($info->{host});
  my($types) = "<select name=TYPE><option value=\"\">$LB->{all}</option>";
  my(%TY);
  my $short =  Util->shortHostname($info->{host});

  my $to = TO->readTopo($info->{host});
  my $sw_list = $to->switchList();
  my $st_list = $to->storageList();
  my $ho_list = $to->hostList();
  foreach my $el (@$sw_list, @$st_list, @$ho_list) {
         my $k = $el->name();
         $TY{$el->type()} = 1;
         my $name = $el->boxName();
         $L{$k}[1] = $el->boxName();
         $L{$k}[0] = $members->{$k};
         #if ($L{$k}) {
         #  $L{$k}[1] = $name;
         #} else {
         #  $L{$k} = [undef, $name];
         #}
  }
  foreach my $ty (sort keys %TY) {
    my $sel = ($q->{TYPE} eq $ty) ? "selected":"";
    $types .= "<option $sel>$ty</option>";
  }
  $types .= "</select>";
  my (@L2);
  foreach my $x (keys %L) {
     my($type, $wwn) = split(/\:/, $x);
     next if ($q->{TYPE} && $type ne $q->{TYPE});

     push(@L2, [$type, $wwn, $L{$x}[1], 
                substr($L{$x}[0],length($group)+1),
                "<input type=checkbox name=\"sel_$x\">" ]);
  }
 
  $q->{SORT} = 1 if (!$q->{SORT});
  my($pageInfo, $list) = Html::List->makeList($q,
                        \@L2,
                    [$LB->{type}, $LB->{id},   $LB->{name}, "$group_id-$LB->{id}", $LB->{select}],
                    [  'l',  'l',     'l',     'l' ,   'c'  ],
                    [ '+sn',  '+',    '+',     '+sn'  ],
                       {pageSize => 200});

  print "<table border=0><tr><td></table>";
  
  my $gsel;
  if (!$deny) {
    $gsel = "
      <table border=1 cellspacing=0 cellpadding=1 bgcolor=#CCCCFF>
        <tr><td>&nbsp;<b>$group_id-Id: <input type=text name=groupID size=20>
           <input type=submit name=ACTION_update value=$LB->{submit_upd}> &nbsp;
      </table>";
  }
       
  print "<table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#666699>
   <td colspan=5>
     <table border=0 cellspacing=0 cellpadding=0 width=100%>
     <tr><td>
       <b><font color=white>Category '$group'</td>
       <form><input type=hidden name=GO value=GUI::Grouping::index>
       <input type=hidden name=option value=$q->{option}>
       <input type=hidden name=SORT value=$q->{SORT}>
       </td>
     <td><font color=white><b>Type:$types&nbsp<small> <input type=submit name=ACTION value=GO></td>
     <td align=right>
      <font color=white>[ <a href=$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&TYPE=$q->{TYPE}&HOST=$q->{HOST}><font color=white>Details</font></a> | 
    <a href=$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&SUMM=1&TYPE=$q->{TYPE}&HOST=$q->{HOST}><font color=white>Summary</font></a> ]</td></table>

   $list
   </table>
  <table border=0 width=95%> <tr><td> $pageInfo <td align=right>$gsel </td>
  </table>
  </form>
  ";
}

sub group_maintain {
  my($q) = @_;

  my $l = Grouping->groupList();
  my $select_host = TO->topoListSelect("host");
  my $LB = Labels->read("GUI::Grouping");

  if (length($select_host) < 30) {
     print Html->info($LB->{no_topo});
     return;
  }

  print "
   <table border=0><tr><td></table>
   <table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#666699>
    <td colspan=4>
     <form><input type=hidden name=GO value=GUI::Grouping::index>
           <input type=hidden name=option value=1>
     <b><font color=white>$LB->{grouping_list}
    <tr bgcolor=#CCCCFF>
       <td><b>$LB->{host}</td>
       <td><b>$LB->{group_code}</td>
       <td><b>$LB->{desc}</td>
       <td><b><center>$LB->{delete}</td>
       ";
  my $cnt;
  foreach my $el (@$l) {
     $cnt++;
     my $d = "$el->{host}:$el->{group}";
     print "<tr>
                <td>$el->{host}
                <td>$el->{group}
                <td>$el->{description}
            <td><center><input type=checkbox name=del_$d>
           ";
  }
  my($info, $del);
  if (!$cnt) {
    print "<tr><td colspan=3><b><font color=red>$LB->{no_grouping}";
  }
  print "</table>";
  my $deny = Roles->verifyRole($q, "admin");
  if ($cnt && !$deny) {
    $del = "<input type=submit name=ACTION_delete value=\"$LB->{submit_delete}\">";
    print "<table border=0 width=95%><tr><td align=right>$del</table>";
  }
 
  print "
    <table border=0><tr><td></table>
    <table border=1 cellspacing=0 cellpadding=4 width=95% bgcolor=#CCCCFF>
    <tr  bgcolor=#666699>
      <td colspan=2><b><font color=white>$LB->{new_grouping}
    <tr><td>
       <center>&nbsp;
       <b>$LB->{host}: $select_host &nbsp;
          $LB->{code}:<input type=text size=10 name=code>
          $LB->{desc}:<input type=text size=30 name=desc> 
     ";
   if (!$deny) {
       print "<input type=submit name=ACTION_addcat value=\"$LB->{submit_addcat}\">";
   }
   print "</table></form>";
  

}
1;
