#! /bin/sh
#
#  trace_rotate.sh tracefile
#
#  trace_rotate.sh is intended to be executed by sam-fsd when a tracefile
#  has aged or grown to the limits specified by the trace controls.
#  trace_rotate.sh moves the current tracefile to tracefile.0 and rotates
#  former tracefiles accordingly.  If tracefile.7 exists it is lost.
#
#    ex:  trace_rotate.sh /var/opt/SUNWsamfs/trace/sam-archiverd
#
#  If desired, you can disable the sam-fsd action, and perform the rotations
#  by using cron.  In a crontab you could do the following:
#
# 10 3 * * 0  /opt/SUNWsamfs/sbin/trace_rotate.sh /var/opt/SUNWsamfs/trace/sam-archiverd
#
TRACE=$1
#
if test -s $TRACE
then
   	test -f $TRACE.6 && mv $TRACE.6 $TRACE.7
   	test -f $TRACE.5 && mv $TRACE.5 $TRACE.6
   	test -f $TRACE.4 && mv $TRACE.4 $TRACE.5
   	test -f $TRACE.3 && mv $TRACE.3 $TRACE.4
   	test -f $TRACE.2 && mv $TRACE.2 $TRACE.3
   	test -f $TRACE.1 && mv $TRACE.1 $TRACE.2
   	test -f $TRACE.0 && mv $TRACE.0 $TRACE.1
   	mv $TRACE $TRACE.0
fi
