#!/bin/csh -f
# save_core.sh - template shell for processing exceptional events.
# $Id: save_core.sh,v 1.1.2.1 2002/04/24 01:13:45 grm Exp $
#
# args:
#	1) calling program name (Not the notify wrapper!).
#	2) calling program pid (again, not the notify wrapper!).
#	3) keyword identifying the 'syslog' level of the event.
# 		The keywords are:
# 		emerg, alert, crit, err, warning, notice, info, debug
#	4) message number from the message catalog.
#	5) the actual message.
#
#

#  Save the core in /var/opt/SUNWsamfs/cores/core.<program>-<eq>.<date>

set SAMFSDIR=/etc/opt/SUNWsamfs
set SAMCOREDIR=/var/opt/SUNWsamfs/cores

if ( ! -d ${SAMCOREDIR} ) then
    mkdir -p ${SAMCOREDIR}
endif

set msg=($5)
set program=$msg[1]
set eq=$msg[2]
set date=`date +%m%d%y-%H:%M`

mv ${SAMFSDIR}/core ${SAMCOREDIR}/core.${program}-${eq}.${date}

