/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.plugins.sunos.pkg;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class SunOSBaseDataExtension
implements BaseDataDetector {
    final String[] parameter = new String[]{"PKGINST", "NAME", "ARCH", "VERSION"};
    private PatchProProperties properties;
    private PatchProLog log;
    private Vector listeners = new Vector();
    private Locale locale;
    private LocalizedMessages catalog;
    private Host targetHost;
    private int progress;
    private int fivePercent;
    private int totalPkgCount;
    private int loadedPkgCount;
    private boolean bestGuessProgress = true;

    public SunOSBaseDataExtension() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.catalog = new LocalizedMessages(Locale.ENGLISH);
        this.initializeProgress();
    }

    public SunOSBaseDataExtension(Host host, Locale locale) {
        this();
        this.setHost(host);
        this.setLocale(locale);
        this.initializeProgress();
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.catalog = new LocalizedMessages(locale);
        }
    }

    public String getMessage() {
        return this.catalog.getMessage("SunOSBaseDataExtension", "Looking for SVR4 packages ...");
    }

    public void run() {
        Runtime runtime = Runtime.getRuntime();
        try {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.properties.getProperty("SunOS.command.get.pkg.data", "/bin/pkginfo -l"));
                InputStream inputStream = null;
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = stringTokenizer.nextToken();
                    ++n;
                }
                Process process = runtime.exec(stringArray);
                inputStream = process.getErrorStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
                if (this.bestGuessProgress) {
                    this.progress = 15;
                    this.incrementProgress(true);
                }
                this.buildDatabase((InputStream)bufferedInputStream);
                bufferedInputStream.close();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.dispatchErrorEvent(new DetectorEvent((BaseDataDetector)this, "SunOSBaseDataExtension: Could not find utility."));
            }
        }
        catch (Exception exception) {
            this.log.println((Object)this, 2, "SunOSBaseDataExtension: Threw " + exception.getMessage() + " while verifying privilege.");
            this.dispatchErrorEvent(new DetectorEvent((BaseDataDetector)this, "SunOSBaseDataExtension: Threw " + exception.getMessage() + " while verifying privilege."));
        }
        this.progress = 100;
        this.incrementProgress(true);
        this.dispatchDoneEvent(new DetectorEvent((BaseDataDetector)this));
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void initializeProgress() {
        try {
            File file = new File("/var/sadm/pkg");
            this.progress = 0;
            this.fivePercent = file.list().length / 20;
            this.bestGuessProgress = false;
        }
        catch (Exception exception) {
            this.progress = 20;
            this.fivePercent = 1;
        }
        this.totalPkgCount = 0;
    }

    private void incrementProgress(boolean bl) {
        ++this.loadedPkgCount;
        if (this.loadedPkgCount % this.fivePercent == 0 || bl) {
            this.progress += 5;
            if (this.progress > 100) {
                this.progress = 100;
            }
            this.dispatchProgressEvent(new DetectorEvent((BaseDataDetector)this));
        }
    }

    private void buildDatabase(InputStream inputStream) {
        boolean bl = false;
        SoftwarePackage softwarePackage = new SoftwarePackage();
        char[] cArray = new char[200];
        int n = 0;
        try {
            int n2 = 200;
            int n3 = 500;
            int n4 = 30;
            int n5 = 500;
            int n6 = 0;
            while (inputStream.available() == 0) {
                Thread.sleep(n3);
                if (n6 > n2) {
                    return;
                }
                ++n6;
            }
            while (true) {
                int n7 = 0;
                while (inputStream.available() == 0) {
                    Thread.sleep(n5);
                    if (n7 > n4) {
                        return;
                    }
                    ++n7;
                }
                int n8 = inputStream.read();
                if (n8 == 10) {
                    if (bl) {
                        try {
                            this.targetHost.addSoftwarePackage(softwarePackage);
                            if (!this.bestGuessProgress) {
                                this.incrementProgress(false);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        softwarePackage = new SoftwarePackage();
                        continue;
                    }
                    bl = true;
                    this.augmentSoftwarePackage(cArray, softwarePackage);
                    n = 0;
                    cArray = new char[200];
                    continue;
                }
                bl = false;
                if (n >= 200) continue;
                cArray[n++] = (char)n8;
            }
        }
        catch (Exception exception) {
            this.log.println((Object)this, 4, "SunOSBaseDataExtension.buildDatabase: " + exception + " thrown trying to build database.");
            return;
        }
    }

    private void augmentSoftwarePackage(char[] cArray, SoftwarePackage softwarePackage) {
        boolean bl = false;
        int n = this.parameter.length;
        String string = new String(cArray);
        String string2 = new String();
        while (--n >= 0) {
            int n2;
            int n3 = string.indexOf(this.parameter[n]);
            if (n3 > -1 && (n2 = string.indexOf(58, n3)) > -1) {
                string2 = string.substring(n2 + 1, string.length()).trim();
                switch (n) {
                    case 0: {
                        softwarePackage.setName(string2);
                        bl = true;
                        break;
                    }
                    case 1: {
                        softwarePackage.setDescription(string2);
                        bl = true;
                        break;
                    }
                    case 2: {
                        softwarePackage.setProcessorArch(string2);
                        bl = true;
                        break;
                    }
                    case 3: {
                        softwarePackage.setVersion(string2);
                        bl = true;
                    }
                }
            }
            if (bl) break;
        }
    }

    private void dispatchProgressEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorProgress(detectorEvent);
        }
    }

    private void dispatchDoneEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorDone(detectorEvent);
        }
    }

    private void dispatchErrorEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorFailed(detectorEvent);
        }
    }
}

