/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.plugins.sunos.iostat;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LineParser;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class SunOSBaseDataExtension
implements BaseDataDetector {
    private final String VENDORPREFIX = "Vendor:";
    private final String PRODUCTPREFIX = "Product:";
    private final String REVISIONPREFIX = "Revision:";
    private final String SERIALNOPREFIX = "Serial No:";
    private PatchProProperties properties;
    private PatchProLog log;
    private Vector listeners = new Vector();
    private Locale locale;
    private LocalizedMessages catalog;
    private Host targetHost;
    private int progress;
    private int fivePercent;
    private boolean bestGuessProgress = true;
    private boolean deviceFound = false;

    public SunOSBaseDataExtension() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.catalog = new LocalizedMessages(Locale.ENGLISH);
        this.initializeProgress();
    }

    public SunOSBaseDataExtension(Host host, Locale locale) {
        this();
        this.setHost(host);
        this.setLocale(locale);
        this.initializeProgress();
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.catalog = new LocalizedMessages(locale);
        }
    }

    public String getMessage() {
        return this.catalog.getMessage("SunOSBaseDataExtension", "Looking for disk data ...");
    }

    public void run() {
        Runtime runtime = Runtime.getRuntime();
        try {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.properties.getProperty("SunOS.command.get.disk.data", "/usr/bin/iostat -E"));
                String[] stringArray = new String[stringTokenizer.countTokens()];
                InputStream inputStream = null;
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = stringTokenizer.nextToken();
                    ++n;
                }
                Process process = runtime.exec(stringArray);
                inputStream = process.getErrorStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                this.interpretStream(bufferedReader);
                bufferedReader.close();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.dispatchErrorEvent(new DetectorEvent((BaseDataDetector)this, "SunOSBaseDataExtension: Could not find utility."));
            }
        }
        catch (Exception exception) {
            this.log.println((Object)this, 2, "SunOSBaseDataExtension: Threw " + exception.getMessage() + " while verifying privilege.");
            this.dispatchErrorEvent(new DetectorEvent((BaseDataDetector)this, "SunOSBaseDataExtension: Threw " + exception.getMessage() + " while verifying privilege."));
        }
        this.finishProgress();
        this.dispatchDoneEvent(new DetectorEvent((BaseDataDetector)this));
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void initializeProgress() {
        this.progress = 0;
        this.dispatchProgressEvent(new DetectorEvent((BaseDataDetector)this));
    }

    private void finishProgress() {
        this.progress = 100;
        this.dispatchProgressEvent(new DetectorEvent((BaseDataDetector)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void interpretStream(BufferedReader bufferedReader) {
        try {
            try {
                String string;
                LineParser lineParser = new LineParser();
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                HardwareComponent hardwareComponent = null;
                while ((string = bufferedReader.readLine()) != null) {
                    lineParser.setLine(string);
                    try {
                        string2 = new String(lineParser.getTokenSuffix("Vendor:"));
                        string3 = new String(lineParser.getTokenBetween("Product:", "Revision:"));
                        string4 = new String(lineParser.getTokenSuffix("Revision:"));
                        string5 = new String(lineParser.getTokenSuffix("Serial No:"));
                        hardwareComponent = new HardwareComponent(string2, string3, string4, string5);
                        this.targetHost.addHardwareComponent(hardwareComponent);
                        this.deviceFound = true;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                this.log.println((Object)this, 4, "SunOSBaseDataExtension.interpretStream: " + exception + " thrown trying to interpret output.");
                Object var11_12 = null;
                if (this.deviceFound) return;
                this.log.println((Object)this, 4, "SunOSBaseDataExtension.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No module was found.");
                return;
            }
            Object var11_11 = null;
            if (this.deviceFound) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (this.deviceFound) throw throwable;
            this.log.println((Object)this, 4, "SunOSBaseDataExtension.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No module was found.");
            throw throwable;
        }
        this.log.println((Object)this, 4, "SunOSBaseDataExtension.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No module was found.");
    }

    private void dispatchProgressEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorProgress(detectorEvent);
        }
    }

    private void dispatchDoneEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorDone(detectorEvent);
        }
    }

    private void dispatchErrorEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorFailed(detectorEvent);
        }
    }
}

