/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.plugins.sunos.host;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class SunOSBaseDataExtension
implements BaseDataDetector {
    Host host;
    PatchProLog log;
    LocalizedMessages catalog;
    Locale locale;
    Vector listeners = new Vector();
    PatchProProperties properties = PatchProProperties.getInstance();
    LocalizedMessages msgcat = new LocalizedMessages(this.properties.getLocale());

    public SunOSBaseDataExtension() {
        this(null, null);
    }

    public SunOSBaseDataExtension(Host host, Locale locale) {
        this.log = PatchProLog.getInstance();
        this.catalog = new LocalizedMessages(Locale.ENGLISH);
        this.initializeProgress();
        this.setHost(host);
        this.setLocale(locale);
        this.initializeProgress();
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.catalog = new LocalizedMessages(locale);
        }
    }

    public void run() {
        this.dispatchProgressEvent(new DetectorEvent((BaseDataDetector)this));
        this.dispatchDoneEvent(new DetectorEvent((BaseDataDetector)this));
    }

    public String getMessage() {
        return this.catalog.getMessage("SunOSBaseDataExtension", "Looking for associated hosts.");
    }

    public Percentage percentComplete() {
        return new Percentage(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(detectorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void initializeProgress() {
    }

    private void dispatchProgressEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorProgress(detectorEvent);
        }
    }

    private void dispatchDoneEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorDone(detectorEvent);
        }
    }

    private void dispatchErrorEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorFailed(detectorEvent);
        }
    }
}

