package TO::BROCADE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use TO::SWITCH;
use base 'TO::SWITCH';
use Agent::BROCADE;
use strict;
use TO;


sub newFromDev {
  my($class, $Topo, $host, $dev) = @_;
  my($x);
  my $TYPE = "brocade";
  my $name = "$TYPE:$dev->{wwn}";
  my $new = 0;

  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];

  if (!defined($switches->{$name})) {
     $new= 1;
     my($obj) = {};
     $obj->{info}{name}   = $name;
     $obj->{info}{type}   = "brocade";
     $obj->{info}{class}  = "switch.brocade";
     $obj->{info}{sw_WWN} = $dev->{wwn};
     $obj->{info}{sw_ipAddr} = $dev->{ipno};
     if ($dev->{primary}) {
       $obj->{info}{sw_ipAddr_remote} = $dev->{primary};
       $obj->{info}{sw_remote_fcaddr} = "0x". $dev->{fc};
     }
     $obj->{port} = [];
     my ($err, $V) = Agent::BROCADE->getDevStatus($dev);
     if ($err) {
         $Topo->[6]{brocade} = {error => $err};
     }

     my $port_cnt = $V->{'port.count'};
     $obj->{info}{ProductID} = "Brocade-$port_cnt";

     for ($x=0; $x < $port_cnt; $x++) {
        $obj->{portInfo}[$x] = { 
                sw_PortType   => $V->{"port.$x.type"},
                sw_PortNum    => $x,
                sw_PortState  => lc($V->{"port.$x.status"}),
                sw_ipAddr_remote => $dev->{ipno},
                PortWWN       => $V->{"port.$x.link_wwn"},
                PortFC        => $V->{"port.$x.link_fc"},
                 };
        if ($V->{"port.$x.link_port"}) {
           $obj->{portInfo}[$x]{PortTargetPort} = $V->{"port.$x.link_port"};
           $obj->{port}[$x] = "$TYPE:" . $V->{"port.$x.link_wwn"} . ":" . 
                              $V->{"port.$x.link_port"}
        }
     }
     $obj->{info}{host} = $host;
     $obj->{info}{host_type} = "oob";
     
     $obj->{info}{portCount} = $port_cnt;
     bless($obj, 'TO::BROCADE');

     my $ip = $dev->{ipno};
     my $ZO = {};

     $syns->{$dev->{wwn}} = $name;
     $switches->{$name}  = $obj;
  }
  return ($new ,$switches->{$name});
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne "brocade");
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     next if ($topo->nodeByName($k));
     $dev->{host} = $renv->{hostname} if (!$dev->{host});

     $class->newFromDev($topo, $renv->{hostname}, $dev);
  }
}

sub statusFunc {
  my($class, $name, $State) = @_;

  my $Comp = $State->components();
  my $i = $Comp->value("$name:e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo, @t1, @f1, @p1, $x);

  for ($x=1; $x <= 5; $x++) {
    push(@t1, $Comp->value("$name:sensor.temperature.$x"));
  }
  for ($x=1; $x <= 6; $x++) {
    push(@f1, $Comp->value("$name:sensor.fan.$x"));
  }
  for ($x=1; $x <= 2; $x++) {
    push(@p1, $Comp->value("$name:sensor.power-supply.$x"));
  }
  my ($other, $otherInfo) = TO->valArray(\@f1, \@p1, \@t1);

  my($port, $portInfo);

  for ($x=0; $x <= 16; $x++) {
       $port     .= $Comp->value("$name:port.$x",0) . ",";
       $portInfo .= $Comp->value("$name:port.$x",1) . ",";
  }

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}



sub type { "brocade"};

sub isCascaded {
  my($obj) = @_;
  return 0;
}

sub ip {
  my($sw) = @_;
  my $i = $sw->{info};
  return $i->{sw_ipAddr};
}


1;
