#
#
#  Copyright (c) 2001 Sun Microsystems, Inc, All Rights Reserved.
# SCCS Info:      pragma ident   "@(#)WebUtil.pm 1.3     02/05/15 09:22:08 SMI"
#
#  Perl Module for UI Utilities.
#
package SE::WebUtil;

use lib qw ( /opt/SUNWstade/lib );
use strict;
use CGI qw/:standard *table/;

# Note: This could use the HCI style sheet.
# For reference this is what a breadcrumb should look like:
#
#<table border="0" cellpadding="0" cellspacing="0" 
#       class="breadcrumb-table" width="100%">
#    <tr>
#    <td>
#        <div class="breadcrumb-text">&nbsp;<a class="breadcrumb-link-text" 
#			 href="/dm?ID=array.sun.t3.t3_0" title="the title">
#                        <b>array.sun.t3.t3_0</b>
#          </a>&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;<b>Configuration</b>&nbsp;
#        </div>
#    </td>
#    </tr>
#</table>

my $PkgName = 'SE::WebUtil';

#This helps speed up "checkForIndy"
my $cachedModel;

sub createCrumb ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $listref, $label ) = @_ if @_;

    my @list = @{$listref};

    my $theCrumb = "\n\t<table border=0 cellpadding=0 cellspacing=0 "
	         . " class=breadcrumb-table width=100%>\n"
	         . "\n\t\t<tr><td>"
                 . "<div class=breadcrumb-text>&nbsp;";

    foreach my $subarray ( @list )
    {
	my @seclist = @{$subarray};

	$theCrumb .= "<a class=breadcrumb-link-text "
	          .  "href=\""
	          .  $seclist[1]
	          .  "\"><b>" . $seclist[0] . "</b>"
	          .  "</a>&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;";
    }

    $theCrumb .= "<b>$label</b>&nbsp;</div>"
              .  "\n\t\t</td></tr>"
              .  "\n\t</table>";

    return $theCrumb;
}


sub createStorAdeHeader ( )
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $action ) = @_ if @_;
    my $mach = Util->select_hosts( $action );
    my $hostname = System->hostname();
    #my $h  = Html->header("SE Config (on $hostname)", "90%", $mach);
    my $h  = Html->header("Sun StorEdge Series Config </small> (on $hostname)", "90%");

    return "<table border=0><tr><td></table>$h";
}


sub createForm ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $title, $action, $buttonsRef, $fieldsRef, $optRef ) = @_ if @_;

    my @buttons = @$buttonsRef;
    my @fields  = @$fieldsRef;

    my $theForm;
    my $method = "post"; 

    if ( %$optRef->{"method"} )
    {
	$method = %$optRef->{"method"};
    }

    if ( %$optRef->{"longlived"} )
    {
        #$theForm .= "\n<form action=/rashttp  method=post>";
        #$theForm .= "\n<form action=/rashttp.2  method=post>";
        #$theForm .= "\n<form action=/rascgi method=post>";
        $theForm .= "\n<form method=post>";

        my @f2;

	if ( %$optRef->{"longlived"} eq "1" )
	{
	    @f2 = ( [ "static", 
	             "Note: This operation may take a few minutes." ] );
	}
	elsif ( %$optRef->{"longlived"} eq "2" )
	{
	    @f2 = ( [ "static", 
	             "Note: Because this operation is time consuming,"
		   . " it will be run in the background." ] );
        }

	push ( @fields, @f2 );
    }
    else
    {
	$theForm .= "\n<form method=$method>";
    }

    $theForm .= "\n<table border=2 cellspacing=2 width=90% "
             .              " bgcolor=white><tr><td>"
             .  "\n<table border=0 cellspacing=2 width=100%>"
             .  "\n<tr><td colspan=2 bgcolor=#666699><b><font"
             .              " color=white>&nbsp; "
             .  $title
             .  "</td>";

    #$theForm .= start_form
             #.  start_table ( { -border=>2, -cellspacing=>2,
                                #-width=>"90%", -bgcolor=>white } )
	     #.  Tr
	     #.  td
             #.  start_table ( { -border=>0, -cellspacing=>2,
                                #-width=>"100%" } )
	     #.  Tr
             #.  td ( { -colspan=>2, -bgcolor=>"#666699" } )
             #.  b
             #.  font ( { -color=>white }, "&nbsp;$title " );


    # action must be of the form "SE::VE::selectPool";
    $theForm .= "<input type=hidden name=\"GO\" value=$action>";

    foreach my $elem (@fields)
    {
	my @sec = @$elem;
	# Text elements should be part of an array with the folloing:
	# "text"(0), "label"(1), "name"(2), "value"(3), "size"(4), "length"(5)
	if ( @sec[0] eq "text" )
	{
	    $theForm .= "\n<!--text-->"
	             .  "\n<tr><td bgcolor=$main'LIGHT width=30% align=right>"
	             .  "$sec[1]</td>"
	             .  "<td><input type=text "
	             .  "name=@sec[2] size=$sec[4] maxlength=$sec[5] "
	             .  "value=@sec[3]>";
	}
	if ( @sec[0] eq "password" )
	{
	    $theForm .= "\n<!--password-->"
	             .  "\n<tr><td bgcolor=$main'LIGHT width=30% align=right>"
	             .  "$sec[1]</td>"
	             .  "<td><input type=password "
	             .  "name=@sec[2] size=$sec[4] maxlength=$sec[5] "
	             .  "value=@sec[3]>";
	}
	# static
	if ( @sec[0] eq "static" )
	{
	    $theForm .= "\n<!--password-->"
	             .  "\n<tr><td bgcolor=$main'LIGHT width=30% align=right>"
	             .  "$sec[1]</td>"
	             .  "<td>@sec[2]</td>";
	}
	# hidden elements should be part of an array with the folloing:
	# "hidden"(0), "name"(1), "value"(2)
	if ( @sec[0] eq "hidden" )
	{
	    $theForm .= "\n<!--hidden-->"
	             .  "<input type=hidden name=$sec[1] value=$sec[2] >";
	}
	# Radio elements 
	# [ "radio", "Virt. Engine:", "ve", ("v1","v2"), 2 ],
	# [ "type",  "label",         "name", "radiolabel", "default" ],
	if ( @sec[0] eq "radio" )
	{
	    $theForm .= "\n<!--raido-->"
	             .  "<tr><td bgcolor=$main'LIGHT width=30% align=right>"
	             .  "$sec[1]</td>"
	             .  "<td>";
	    
	    my $i = 0;
	    foreach my $val ( @{$sec[3]} )
	    {
		if ( $sec[4] == $i )
		{
		    $theForm .= "\n<input type=radio checked=true ";
		}
		else
		{
		    $theForm .= "\n<input type=radio ";
		}
		$theForm .= "name=@sec[2] value=$val size=5 maxlength=5 "
			 .  " @sec[4] " #4 is javascript
		         .  ">&nbsp;&nbsp;$val&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
		$i ++;
	    }
	}
	# Check elements 
	# [ "checkbox", "My Label:", "somename", \@list, "onClick='alert();'" ],
	# [ "type",  "label", "param name", array, javascript ],
	if ( @sec[0] eq "checkbox" )
	{
	    $theForm .= "\n<!--checkbox-->"
	             .  "<tr><td bgcolor=$main'LIGHT width=30% align=right>"
	             .  "$sec[1]</td>"
	             .  "<td>";
	    
	    my $i=0;

	    #foreach $val ( @{$sec[3]} )
	    #{
		#$i ++;
		#$theForm .= "\n<input type=checkbox "
		         #.  "name=@sec[2] value=$val size=5 maxlength=5 "
			 #.  " @sec[4] " #4 is javascript
		         #.  ">&nbsp;&nbsp;$val&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
	    #}

	    while ( my ($key, $value) = each %{$sec[3]} )
	    {
		$i ++;
		$theForm .= "\n<input type=checkbox "
		         .  "name=$value value=$value size=5 maxlength=5 "
			 .  " @sec[4] " #4 is javascript
		         .  ">&nbsp;&nbsp;$key&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
	    }
	}
    }

    $theForm .= "\n</table>"
             .  "\n</table>";

    foreach my $elem (@buttons)
    {
	my @sec = @$elem;

	if ( @sec[2] )
	{
	    $theForm 
	      .=  "\n<input type=button name=@sec[0] value=@sec[1] "
	      .   " onClick=\"if ( confirm ('@sec[2]')) "
	      .   " {"
	      .   "    this.form.submit();"
	      .   " }\" >";
        }
	else
	{
	    $theForm 
	      .=  "\n<input type=submit name=@sec[0] value=@sec[1] >";
        }

    }

    $theForm .= "\n</form>";

    return $theForm;
}


sub createHead ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $headContent ) = @_ if @_; 

    my $theHead;
    $theHead .= "<html>";
    $theHead .= "\n<head>";


    $theHead .= "\n    <style>"
             .  "\n    .breadcrumb-table {background-color: #CCCCCC; }"
             .  "\n    .breadcrumb-text { color: #000000; font-weight: bold; "
             .         " margin: 5px 0px 5px 0px; }"
             .  "\n    a.breadcrumb-link-text:visited, "
             .  "\n    a.breadcrumb-link-text:link,"
             .  "\n    a.breadcrumb-link-text:active "
             .  "\n         { color: #000000; font-weight: bold; "
             .              " text-decoration: underline; }"
             .  "\n    </style>"
             .  "\n<meta http-equiv=expires content=0>"
	     .  "\n"
	     .  $headContent
	     .  "\n"
             .  "\n</head>"
             .  "\n<body bgcolor=#e0e0e0>\n";

    return $theHead;
}


sub createTail ()
{
    my $theTail;
    $theTail .= "\n</body>"
             .  "\n</html>";

    return $theTail;
}


sub createSideMenu ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $title, $listref ) = @_ if @_;

    my @list = @{$listref};
    my $theMenu;

    $theMenu .= "\n<head>"
             .  "\n<script language=javascript src=/buttons.js></script>"
             .  "\n</head>"
             .  "\n<body bgcolor=#666699 link=white vlink=white alink=red>"
             .  "\n<table border=0 cellpadding=0><tr><td></td></table>"
             .  "\n<table border=0 bgcolor=#CCCCFF width=110%><tr><td>"
             .  "\n<center><b>$title"
             .  "\n</table>"
             .  "\n<table border=0><tr><td></table>"
             .  "\n"
             .  "\n<table border=0 cellpadding=2 cellspacing=0>";
	      
    my $j = 0;
    foreach my $subarray ( @list )
    {
	my @seclist = @{$subarray};
	$j = $j + 1;

	my $target = @seclist[2];
	if ( !$target )
	{
	    $target = "detail";
	}

	$theMenu .= "\n<tr><td>"
                 .  "\n<img name=b" . $j . " src=gif/bout.gif>"
                 .  "\n<a href=@seclist[1] "
		 .  " target=$target"
                 .  "\nonmouseover=bover($j) onmouseout=bout($j)"
                 .  " onclick=bclick($j)"
                 .  ">@seclist[0]</a><br>"
                 .  "\n</td></tr>";
    }

    $theMenu .= "\n</table>";

    return $theMenu;
}


sub topMenu ()
{
    my ( $request ) = @_ if @_;

    if ( $request->{se} eq "yes" )
    {
	print 
	"<meta http-equiv=Refresh content=\"0;URL=/seTopPage.html\">";
    }
    elsif ( $request->{se} eq "no" )
    {
	print "<meta http-equiv=Refresh content=\"0;URL=/topPage.html\">";
    }
    else
    {
	print SE::WebUtil->createHead ();
	print "<br>";
	print "<a href=/?GO=SE::WebUtil::topMenu&se=yes >se ";
	print "</a>";
	print "<br>";
	print "<a href=/?GO=SE::WebUtil::topMenu&se=no >Not se ";
	print "</a>";
	print SE::WebUtil->createTail ();
    }
}


sub printHostSelect ()
{
    my $class = shift if ( $_[0] eq $PkgName );

    my ( $request ) = @_ if @_;

    my($select_host, $filter, $selected) = GUI->topoPage($request);

    my $theSelect;

    #<b>&nbsp;Host:$select_host 

    $theSelect = 
	"<form>
	    <table>
		<tr>
		    <td>

		<b>&nbsp;Host:
		<select name=topo>
		  <option selected value=msp0.central.sun.com>msp0
		  <option value=v4u-60n.central.sun.com>v4u-60n
		</select>

		<input type=hidden name=GO value=SE::WebUtil::redirect2>
		<input type=submit name=NOTUSED value=\"Change Host\" >
		</b>
		    <td align=right></td>
		<tr><td></td>
	    </table>
	</form>";

    return $theSelect;
}


sub isValidRole ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $request ) = @_ if @_;

    if ( my $deny = Roles->verifyRole($request, "xxxscript")) 
    {
	print $deny;
	return 0;
    }
    return 1;
}


sub getHostIndyModelViaStorAde ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $host ) = @_ if @_;
    my $model;
    # debug print "<br>host=$host";

    if ( ! $host  || $host =~ /Local/i )
    {
	$host = "Local";
	my $renv = System->get_renv();
	$model = $renv->{solution_model};
        $ENV{BOXTYPE} = $model;

	if ( !$model )
	{
	    my $execPath = "/opt/SUNWsecfg/bin/getcabinet";
	    $model = `$execPath`;
	}
    }
    else
    {
	my $config = PDM::ConfigFile->read();
	my $hostData = $config->hostByKey($host);
        $model = $hostData->{solution_model};
    }

    # debug print "<br>model=$model";

    return $model;
}

##
## This method is significantly different from "checkForIndy"
## This method uses the StorAde configuration file
## 
sub checkHostForIndyViaStorAde ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $host, $printFlag, $modelsQuery ) = @_ if @_;
    my $retVal = 0;
    my $model = &getHostIndyModelViaStorAde ( $host );

    # debug print "<br>$host";
    # debug print "<br>$printFlag";
    # debug print "<br>$modelsQuery";
    # debug print "<br>$model";

    if ( isIndyModel ( $model, $modelsQuery ) )
    {
	$retVal = 1;
    }

    if ( ! $retVal && $printFlag )
    {
	#print "<h2>This system does not support this"
	#    . " StorEdge 3900/6900 function.</h2>";
	print "";
    }

    return $retVal;
}


##
## model arg is optional string of "|" separated model
##       ex: "3960|69" would match a 3960 or any 69XX
## This method uses "getcabinet"
##
sub checkForIndy ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $printFlag, $modelsQuery ) = @_ if @_;
    
    if ( isIndyModel ( $cachedModel, $modelsQuery ))
    {
	return 1;
    }

    my $retVal = 0;
    my $cabinet;
    my $renv = System->get_renv();

    #first check the config file per Christian's recommendation
    # the indy team has recommended we go based on "getcabinet"
    # so I'll have to comment this out.

    # ras conf file
    if ( isIndyModel ( $renv->{solution_model}, $modelsQuery ) )
    #if ( 0 ) 
    {
	#save incase we are called again.
	$cachedModel = $renv->{solution_model};
        $ENV{BOXTYPE} = $cachedModel;
	$retVal = 1;
    }
    #if ( 1 ) # getcabinet
    else
    {
	my $execPath = "/opt/SUNWsecfg/bin/getcabinet";

	if ( -x $execPath ) 
	{
	    $cabinet = `$execPath`;

	    if ( isIndyModel ( $cabinet, $modelsQuery ) )
	    {
		#save incase we are called again.
		$cachedModel = $cabinet;
		$retVal = 1;
	    }
	}
    }

    if ( ! $retVal && $printFlag )
    {
	#print "<h2>This system does not support this"
	#    . " StorEdge 3900/6900 function.</h2>";
	print "";
    }

    return $retVal;
}


sub isIndyModel ( )
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $golden, $modelsQuery ) = @_ if @_;
    my $retVal = 0;

    my @list = split '\|', $modelsQuery;

    foreach my $tmp ( @list )
    {
        if ( $golden =~ /$tmp/ )
        {
	    $retVal = 1;
        }
    }
    return $retVal;
}


sub redirect2 ()
{
    my $class = shift if ( $_[0] eq $PkgName );
    my ( $request ) = @_ if @_;

    #if ( $request->{se} eq "yes" )
    my $port = System->get_rasport();

    print 
    "<meta http-equiv=Refresh content=\"0;URL=http://v4u-60n.central:$port/\">";
}

1;
