#
# SCCS Info:      pragma ident   "@(#)VEUI.pm 1.25     02/05/20 14:07:35 SMI"
#  Copyright (c) 2001 Sun Microsystems, Inc, All Rights Reserved.
#
#  Perl Module for SE Virtualization Engine UI
#
package SE::VEUI;

use lib qw ( /opt/SUNWstade/lib );
use strict;
use IO::File;  # VERY VERY IMPORTANT for sysopen to work; DO NOT REMOVE!!!!!
use SE::T3UI;
use SE::Util;
use SE::VE;
use SE::WebUtil;
use Data::Dumper;

my $webproc = "rashttp.2";

my $STADE_BIN = "/opt/SUNWstade/bin";
my $createMultiVlunFile;
my $VLUNFileParam = "vfile";
my $createMultiZoneFile;
my $ZoneFileParam = "zfile";

my $homeStr = "Sun StorEdge Series Config";
my $homeURL = "/$webproc?GO=GUI::SE::index";

my $manageVLUNsStr    = "Manage VLUNs";
my $manageVLUNsAction = "SE::VEUI::manageVLUNs";
my $manageVLUNsURL    = "/$webproc?GO=" . $manageVLUNsAction;

my $manageSlicdStr    = "Manage slicd Daemon";
my $manageSlicdAction = "SE::VEUI::manageSlicd";
my $manageSlicdURL    = "/$webproc?GO=" . $manageSlicdAction;

my $createVLUNStr    = "Create VLUN(s)";
my $createVLUNAction = "SE::VEUI::createVLUN";
my $createVLUNURL    = "/$webproc?GO=" . $createVLUNAction;

my $createMultiVLUNStr    = "Create Multiple VLUN(s)";
my $createMultiVLUNAction = "SE::VEUI::createMultiVLUN";
my $createMultiVLUNURL    = "/$webproc?GO=" . $createMultiVLUNAction;

my $checkSlicdStr    = "Check the slicd Daemon";
my $checkSlicdAction = "SE::VEUI::checkSlicd";
my $checkSlicdURL    = "/$webproc?GO=" . $checkSlicdAction;

my $startSlicdStr    = "Start the slicd Daemon";
my $startSlicdAction = "SE::VEUI::startSlicd";
my $startSlicdURL    = "/$webproc?GO=" . $startSlicdAction;

my $clearMapStr    = "Clear Virtualization Engine Map";
my $clearMapAction = "SE::VEUI::clearMap";
my $clearMapURL    = "/$webproc?GO=" . $clearMapAction;

my $viewMapStr    = "View Virtualization Engine Map";
my $viewMapAction = "SE::VEUI::viewMap";
my $viewMapURL    = "/$webproc?GO=" . $viewMapAction;

my $restoreMapStr    = "Restore Virtualization Engine Map";
my $restoreMapAction = "SE::VEUI::restoreMap";
my $restoreMapURL    = "/$webproc?GO=" . $restoreMapAction;

my $resetVEStr    = "Reset Virtualization Engine";
my $resetVEAction = "SE::VEUI::resetVE";
my $resetVEURL    = "/$webproc?GO=" . $resetVEAction;

my $saveMapStr    = "Save Virtualization Engine Map";
my $saveMapAction = "SE::VEUI::saveMap";
my $saveMapURL    = "/$webproc?GO=" . $saveMapAction;

my $verifyMapStr    = "Verify Virtualization Engine Map";
my $verifyMapAction = "SE::VEUI::verifyMap";
my $verifyMapURL    = "/$webproc?GO=" . $verifyMapAction;

my $removeVLUNStr    = "Remove VLUN(s)";
my $removeVLUNAction = "SE::VEUI::removeVLUN";
my $removeVLUNURL    = "/$webproc?GO=" . $removeVLUNAction;

my $viewVE1ResultsStr    = "View the last results of Creating VLUN(s) on v1";
my $viewVE1ResultsAction = "SE::VEUI::viewVE1Results";
my $viewVE1ResultsURL    = "/$webproc?GO=" . $viewVE1ResultsAction;

my $viewVE2ResultsStr    = "View the last results of Creating VLUN(s) on v2";
my $viewVE2ResultsAction = "SE::VEUI::viewVE2Results";
my $viewVE2ResultsURL    = "/$webproc?GO=" . $viewVE2ResultsAction;

my $viewVE1ZoneResultsStr    = "View the last results of Creating Zone(s) on v1";
my $viewVE1ZoneResultsAction = "SE::VEUI::viewVE1ZoneResults";
my $viewVE1ZoneResultsURL    = "/$webproc?GO=" . $viewVE1ZoneResultsAction;

my $viewVE2ZoneResultsStr    = "View the last results of Creating Zone(s) on v2";
my $viewVE2ZoneResultsAction = "SE::VEUI::viewVE2ZoneResults";
my $viewVE2ZoneResultsURL    = "/$webproc?GO=" . $viewVE2ZoneResultsAction;

my $zoneStr    = "Manage Zones";
my $zoneAction = "SE::VEUI::manageZones";
my $zoneURL    = "/$webproc?GO=" . $zoneAction;

my $createZoneStr    = "Create Virtualization Engine Zone";
my $createZoneAction = "SE::VEUI::createZone";
my $createZoneURL    = "/$webproc?GO=" . $createZoneAction;

my $createMultiZoneStr    = "Create Multiple Virtualization Engine Zones";
my $createMultiZoneAction = "SE::VEUI::createMultiZone";
my $createMultiZoneURL    = "/$webproc?GO=" . $createMultiZoneAction;

my $addToZoneStr    = "Add Components to Virtualization Engine Zone";
my $addToZoneAction = "SE::VEUI::addToZone";
my $addToZoneURL    = "/$webproc?GO=" . $addToZoneAction;

my $addToZoneByRangeStr    = "Add Components to Virtualization Engine Zone";
my $addToZoneByRangeAction = "SE::VEUI::addToZoneByRange";
my $addToZoneByRangeURL    = "/$webproc?GO=" . $addToZoneByRangeAction;

my $delFromZoneStr    = "Delete Components from Virtualization Engine Zone";
my $delFromZoneAction = "SE::VEUI::delFromZone";
my $delFromZoneURL    = "/$webproc?GO=" . $delFromZoneAction;

my $delFromZoneByRangeStr = "Delete Components from Virtualization Engine Zone";
my $delFromZoneByRangeAction = "SE::VEUI::delFromZoneByRange";
my $delFromZoneByRangeURL    = "/$webproc?GO=" . $delFromZoneByRangeAction;

my $removeZoneStr    = "Remove Virtualization Engine Zone";
my $removeZoneAction = "SE::VEUI::removeZone";
my $removeZoneURL    = "/$webproc?GO=" . $removeZoneAction;

my $manageFilesStr    = "Manage Config Files";
my $manageFilesAction = "SE::VEUI::manageFiles";
my $manageFilesURL    = "/$webproc?GO=" . $manageFilesAction;

my $manageHostsStr    = "Manage Virtualization Engine Hosts";
my $manageHostsAction = "SE::VEUI::manageHosts";
my $manageHostsURL    = "/$webproc?GO=" . $manageHostsAction;

my $verifyHostsStr    = "Verify Virtualization Engine Hosts";
my $verifyHostsAction = "SE::VEUI::verifyHosts";
my $verifyHostsURL    = "/$webproc?GO=" . $verifyHostsAction;

my $setupHostsStr     = "Setup Virtualization Engine Hosts";
my $setupHostsAction  = "SE::VEUI::setupHosts";
my $setupHostsURL     = "/$webproc?GO=" . $setupHostsAction;

my $validateStr = "Store/Clear Virtualization Engine Password ";
my $validateAction = "SE::VEUI::validate";
my $validateURL = "/$webproc?GO=" . $validateAction;

my $pswdParam      = "pswd";
my $passFileName = "/opt/SUNWstade/DATA/SE_VE.dat";

my $veParam = "ve";
my $initParam = "init";
my $poolParam = "pool";
my $countParam = "vluncount";
my $sizeParam = "vlunsize";
my $vlunNameParam = "vlunname";
my $singleZoneNameParam = "zonename";
my $singleAliasNameParam = "aliasname";
my $targetParam = "target";
my $wwnParam = "wwn";
my $zone1Param = "zone1";
my $zone2Param = "zone2";
my $AllZoneParam = "all";
my $zoneList;
my $zoneOptParam = "zoneopt";
my $oneOrTwoParam = "oneortwo";
my $rangeParam = "range";
my $multiVlunParam = "multi";
my $multiZoneParam = "multi";
my $vlunsOrHbaParam = "vlunsorhba";
my $startRangeParam = "startrange";
my $endRangeParam = "endrange";
my $liveParam = "live";
my $mapOnlyParam = "maponly";
my $multiParam = "multi";

my $multiSizeParam = "msp";
my $multiCountParam = "mcp";
my $multiDiskPoolParam = "mdp";

my $batchType;

my %dpNameSize = ();
my $DPNAMESIZE = "SUNWsecfg_dpNameSize";
my $ALLZONELIST= "SUNWsecfg_AllZoneList";

my %AllZoneList = ();

my @veList;

my $AllZonesNote = "Adding a vlun to more than 2 zones is useful only for multinode shared file system support.";

my $stepParam = "step";

my $freeOnInit = "F_R_E_E_ZONE_ON_";

my $warning = "All data on these VLUNs will be lost."
	    . "  Do you wish to continue?";

my $warningReset = "If you select both (DB & Files) the map will be lost.\\n"
		 . "If you select (DB Only) the (Restore Map) menu option\\n"
		 . "can be used to restore the map.\\n"
		 . "Do you wish to continue?";

my $aliasNote = "Alias name is the user-defined HBA alias for the associated WWN channel, if not specified the zonename will be used. Unique names should be used when multiple HBAs are in a single zone, as in clusters.";

my $aliasNote2 = "There is a max length of 15 chars for the alias name";

my $selectVEStr = "Select Virtualization Engine"; 
my $selectInitStr = "Select Initiator";
my $selectZoneStr = "Select Zone";

my $selectStartRangeStr = "Select start of range for VLUNs to add:";
my $selectEndRangeStr = "Select end of range for VLUNs to add:";

my $selectStartRangeRemoveStr = "Select start of range for VLUNs to remove:";
my $selectEndRangeRemoveStr = "Select end of range for VLUNs to remove:";

my $operationResultStr =  
    "Operation may take several minutes before it is updated and reflected in"
  . " Virtualization Engine Map.<br><br>";
  
my $mayTimeoutStr = "The browser may time out but"
		  . " the operation will complete.";

my $veSelectedStr = "Virtualization Engine selected: ";
my $veAvailStr    = "Virtualization Engine(s) available: ";
my $veInUseStr    = "Virtualization Engine(s) in use: ";

my $indy6900OnlyStr = "<h2>This command can only be run on a"
	            . " Sun StorEdge 6910 or 6960 system.</h2>";

my $noVEsAvailStr = "There are no available Virtualization Engine(s).";
my $noLunsForVEStr = "There are no available LUNS for Virtualization Engine: ";
my $noZonesForInitiatorStr = "There are no Zones for Initiator: ";
my $noPoolsForVEStr = "There are no Disk Pools for Virtualization Engine: ";
my $noInitiatorsForVEStr = "There are no Initiators for"
			 . " Virtualization Engine: ";


my $vlunNameNoteStr   = "Note: there is a 10 character limit on the name" 
		      . " including a unique id prefix which will be added"
		      . " automatically.  Additionally the VLUN Name field"
		      . " is optional, if left empty a name will automatically"
		      . " be assigned.";

my $viewVErefresh = "Refresh";

my $initOne = "I00001";
my $initTwo = "I00002";

$VEUI::secfgBinDir = "/opt/SUNWsecfg/bin";


sub manageVLUNs()
{
    my ( $request ) = @_ if @_;

    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $manageVLUNsAction );
    print SE::WebUtil->createCrumb ( \@crumb, $manageVLUNsStr );

    # IF DEEMED NECESSARY (not right now because top level link checks)
    #if ( ! SE::WebUtil->isValidRole ( $request ) )
    #{
	#return;
    #}

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    print "<br>";
    print "<a href=$viewMapURL >$viewMapStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$createVLUNURL >$createVLUNStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$removeVLUNURL >$removeVLUNStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$viewVE1ResultsURL >$viewVE1ResultsStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$viewVE2ResultsURL >$viewVE2ResultsStr";
    print "</a>";
    print "<br>";
    print SE::WebUtil->createTail ();
}


sub manageFiles()
{
    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $manageFilesAction );
    print SE::WebUtil->createCrumb( \@crumb, $manageFilesStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    #print "<br>";
    #print "<a href=$viewMapURL >$viewMapStr";
    #print "</a>";
    print "<br>";
    print "<a href=$saveMapURL >$saveMapStr";
    print "</a>";
    print "<br>";
    print "<a href=$verifyMapURL >$verifyMapStr";
    print "</a>";
    print "<br>";
    print "<a href=$restoreMapURL >$restoreMapStr";
    print "</a>";
#my $clearMapStr    = "Clear Virtualization Engine SAN Map";
    print "<br>";
    print "<a href=$clearMapURL >$clearMapStr";
    print "</a>";

    print SE::WebUtil->createTail ();
}


sub manageHosts()
{
    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $manageHostsAction );
    print SE::WebUtil->createCrumb( \@crumb, $manageHostsStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    print "<br>";
    print "<a href=$verifyHostsURL >$verifyHostsStr";
    print "</a>";
    print "<br>";
    print "<a href=$setupHostsURL >$setupHostsStr";
    print "</a>";
    print "<br>";
    print "<a href=$resetVEURL >$resetVEStr";
    print "</a>";
  #["Reset",           "Reset the Virtualization Engine",     "$GO=SE::VEUI::resetVE" , 0 ],

    print SE::WebUtil->createTail ();
}


sub manageSlicd()
{
    my ( $request ) = @_ if @_;

    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $manageSlicdAction );
    print SE::WebUtil->createCrumb ( \@crumb, $manageSlicdStr );

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    print "\n<br>";
    print "<a href=$checkSlicdURL >$checkSlicdStr";
    print "</a>";
    print "\n<br>";
    print "<a href=$startSlicdURL >$startSlicdStr";
    print "</a>";

    print SE::WebUtil->createTail ();
}


sub verifyHosts()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( 0 == SE::VEUI->validate ( $request, $verifyHostsAction,
					     $verifyHostsStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $verifyHostsAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $verifyHostsStr, $verifyHostsURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

        #usage: checkve -n ve_hostname -v | [-h]
        #here: 
        #    -v                - verbose mode
        #    -n <ve_hostname>  - is a virtualization engine hostname
        #                        from the /etc/hosts file
        #    -h                - print usage

	my $command;

	if ( $request->{$veParam} eq "ALL" )
        {
	    my ( $velist, $busyStr, $errMsg ) = &getVEs("hosts");

	    if ( scalar(@$velist) == 0 )
	    {
	    	print "<h2>$noVEsAvailStr</h2>";
	    	print "<br>$veInUseStr $busyStr";
	    	print "<br><pre>$errMsg</pre>";
	    	return;
	    }

            for my $tmp ( @$velist )
            {
                $command = "$VEUI::secfgBinDir/checkve"
                    . " -n $tmp -v";

		my $passwd = &getSavedVEPassword ();
		my $prePasswd = $ENV{VEPASSWD};
		$ENV{VEPASSWD} = $passwd ;

                if ( $tmp ne "ALL" )
                {
                    SE::Util->execCmd ( $command, 1 );
                }

		$ENV{VEPASSWD} = $prePasswd;
            }
        }
        else
        {

	$command = "$VEUI::secfgBinDir/checkve"
		    # this command does not accept -m
		    . " -n $request->{$veParam}"
                    . " -v ";

	my $passwd = &getSavedVEPassword ();
	my $prePasswd = $ENV{VEPASSWD};
	$ENV{VEPASSWD} = $passwd ;

	SE::Util->execCmd ( $command, 1 );
	$ENV{VEPASSWD} = $prePasswd;

	}

    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $verifyHostsStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs("hosts","ALL");

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Verify" ] );

	print SE::WebUtil->createForm ( $verifyHostsStr,
				    $verifyHostsAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub setupHosts()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( 0 == SE::VEUI->validate ( $request, $setupHostsAction,
					     $setupHostsStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $setupHostsAction );

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $setupHostsStr, $setupHostsURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

	# FIRST CHECK
        #usage: checkve -n ve_hostname -v | [-h]
        #where: 
        #    -v                - verbose mode
        #    -n <ve_hostname>  - is a virtualization engine hostname
        #                        from the /etc/hosts file
        #    -h                - print usage

	# SECOND SETUP if step one returned 0
        #usage: setupve -n ve_hostname -v | [-h]
        #where: 
        #    -v                - verbose mode 
        #    -n <ve_hostname>  - is a virtualization engine hostname
        #                        from /etc/hosts file
        #    -h                - print usage

	print "<h2>This command will first run:<pre>checkve</pre>"
	    . " Only if its exit value is 1; will it then call:"
	    . " <pre>setupve</pre></h2>";

	my $command1 = "$VEUI::secfgBinDir/checkve"
		    # this command does not accept -m
		    . " -n $request->{$veParam}"
                    . " -v ";

	my $command2 = "$VEUI::secfgBinDir/setupve"
		    # this command does not accept -m
		    . " -n $request->{$veParam}"
                    . " -v ";


	my $passwd = &getSavedVEPassword ();
	my $prePasswd = $ENV{VEPASSWD};
	$ENV{VEPASSWD} = $passwd ;

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command1, 1 );

	if ( $retVal == 1 )
	{
	    SE::Util->execCmd ( $command2, 1 );
	}
	# else 
	# {
	    # print "<h2>Unable to properly configure"
		# . " virtualization engine host.</h2>";
	# }

	$ENV{VEPASSWD} = $prePasswd;
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $setupHostsStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs("hosts");

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Setup" ] );

	print SE::WebUtil->createForm ( $setupHostsStr,
				    $setupHostsAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub manageZones()
{
    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $zoneAction );
    print SE::WebUtil->createCrumb( \@crumb, $zoneStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    print "<br>";
    print "<a href=$viewMapURL >$viewMapStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$createZoneURL >$createZoneStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$addToZoneURL >$addToZoneStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$delFromZoneURL >$delFromZoneStr";
    print "</a>";
    print "<br>";
    print "<br>";
    print "<a href=$removeZoneURL >$removeZoneStr";
    print "</a>";
    print "<br>";

    print SE::WebUtil->createTail ();
}


sub saveMap ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $saveMapAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $saveMapStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Save" ] );

	print SE::WebUtil->createForm ( $selectVEStr,
				    $saveMapAction,
				    \@buttons,
				    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $saveMapStr, $saveMapURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, 
		  "Saving Virtualization Engine Map..." );

	#USAGE 

        #usage : savevemap -n <vepair_name> [ -V ]
        #where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2
        #        -V - verbose option

	my $command = "$VEUI::secfgBinDir/savevemap"
		    # this command does not accept -m
		    . " -n $request->{$veParam}";

	print "<h2>";
	print "Map saved.";
	print "</h2>";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}


sub removeZone ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $removeZoneAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $removeZoneStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $removeZoneStr,
				    $removeZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $removeZoneStr, $removeZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select Initiator" );

	# DAVID_NEEDS_LIB_INIT
	my @initiators = &getInitiators ( $request->{$veParam} );

	if ( scalar(@initiators) == 0 )
	{
	    print "<h2>$noInitiatorsForVEStr $request->{$veParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	    [ "radio", "Available Initiators:", $initParam , \@initiators ],
	    [ "hidden", $stepParam, "3" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $removeZoneStr,
				    $removeZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "3" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $removeZoneStr, $removeZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select Zone" );

	# DAVID_NEEDS_LIB_ZONES
	&getAllZones ( $request->{$veParam}, $request->{$initParam} );

        if ( scalar(%AllZoneList) == 0 )
	{
	    print "<h2>$noZonesForInitiatorStr $request->{$initParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "static", "Initiator:", $request->{$initParam} ],
	    [ "hidden", $initParam, $request->{$initParam} ],

	    [ "checkbox", "Zones:", $singleZoneNameParam , \%AllZoneList ],
	    [ "hidden", $stepParam, "4rmzone" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $removeZoneStr,
				    $removeZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "4rmzone" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $removeZoneStr, $removeZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Zone Removed" );

	my $AllZoneList_p = Util->deserialize($ALLZONELIST);

	$zoneList = "";
        my $key;
        my $value;
        while(($key,$value)=each %$AllZoneList_p){
         if ( $request->{$key} )
          {
           $zoneList = $zoneList . $value . ",";
          }
         }

	#USAGE 
        #usage : rmvezone -n <vepair_name> -c <initiator> -z <zonename> [ -V ]
        #where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2
        #           initiator - is the SLIC initiator, (i.e. I00001 or I00002)
        #           zonename - is the name of the zone to delete
        #           -V - verbose output

	my $command = "$VEUI::secfgBinDir/rmvezone"
		    . " -m" #this means don't re-validate
		    . " -n $request->{$veParam}"
		    . " -c $request->{$initParam} "
		    . " -z $zoneList"
		    . " -V";

	print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
	print "</h3>";

	#my $fh = new FileHandle;
	#my $buf = '';

	#open ( $fh, "echo y | $command | ");
	#while ( <$fh> ) 
	#{
	    #$buf .= $_;
	#}
	#$fh->close;
	
	my ( $retVal, $stdout, $stderr ) = 
	    SE::Util->execCmd ( "echo y | $command", 1 );

	#SE::
	#print "command returned value $? ";
    }

    print SE::WebUtil->createTail ();
}


sub createZone ()
{
   #Supports cluster (multiple HBAs)

    my ( $request ) = @_ if @_;
    #If the user selects create multiple zones option then createMultiZone
    #subroutine is called directly.

    if ( $request->{$multiZoneParam} eq "Multiple" )
    {
	my $tmp = `ps -aef|grep createGuiMultiZones|grep -v grep >/dev/null 2>&1`;
	if ( $? )
	{
		$tmp = `rm -f /tmp/createGuiMultiZones*`;
	}

	$createMultiZoneFile = $request->{$ZoneFileParam};
        open(MULTIZONE, ">$createMultiZoneFile")|| die "Can't open newfile: $!\n";
	print MULTIZONE "#!/bin/ksh\n#include the ve lib\n. /opt/SUNWsecfg/flib/ve_kshlib\n\ncat $createMultiZoneFile\n\n#Commands Executed\n\n";
	close MULTIZONE;
        #&loadWWNs;
        &createMultiZone;
        return;
    }

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $createZoneAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $createZoneStr );
	my @singleOrMulti = ( "Single", "Multiple" );

	$createMultiZoneFile = "/tmp/createGuiMultiZones_$$";

	my @fields = ( 
	    [ "radio", "Do you want to create single or multiple zones", $multiZoneParam , \@singleOrMulti ],
	    [ "hidden", $ZoneFileParam, $createMultiZoneFile ],
	    [ "hidden", $stepParam, "1" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $createZoneStr,
				    $createZoneAction,
				    \@buttons,
				    \@fields  );

    }
    elsif ( $request->{$stepParam} eq "1" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $createZoneStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $createZoneStr,
				    $createZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $createZoneStr, $createZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $selectInitStr );

	# DAVID_NEEDS_LIB_INIT
	my @initiators = &getInitiators ( $request->{$veParam} );

	if ( scalar(@initiators) == 0 )
	{
	    print "<h2>$noInitiatorsForVEStr $request->{$veParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	    [ "radio", "Available Initiators:", $initParam , \@initiators ],
	    [ "hidden", $stepParam, "3" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $createZoneStr,
				    $createZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "3" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $createZoneStr, $createZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select WWN" );

	# DAVID_NEEDS_LIB_WWN
	my @wwns = &getWWNs ( $request->{$veParam}, $request->{$initParam} );

	if ( scalar(@wwns) == 0 ) 
	{
	    print "<h2>There are no available HBAs"
		. " on $request->{$initParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	    [ "static", "Initiator:", $request->{$initParam} ],
	    [ "hidden", $initParam, $request->{$initParam} ],
	    [ "radio", "Available WWN(s):", $wwnParam , \@wwns ],
	    [ "text", "Zone Name:", $singleZoneNameParam ,"","16", "15" ],
	    [ "text", "Alias Name:", $singleAliasNameParam ,"","16", "15" ],
	    [ "static", "NOTE:", $aliasNote ],
	    [ "hidden", $stepParam, "4newzone" ]
	    );

	my @buttons = ( [ "NOTUSED", "\"Create Zone\"" ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $createZoneStr,
				    $createZoneAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "4newzone" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $createZoneStr, $createZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Creating Zone" );

	#remove leading spaces for comparison
	$request->{$singleZoneNameParam} =~ s/^ *//g;

	if ( ! $request->{$singleZoneNameParam} 
	    || $request->{$singleZoneNameParam} eq "0" )
	{
	    print "<h2>";
	    print "Invalid zone name : $request->{$singleZoneNameParam}";
	    print "</h2>";

	    print "\n<form>";

	    print "\n<input type=submit"
		. " value=\"Back to Create Zone\" name=back >";

	    print "<input type=hidden name=GO"
		. " value=$createZoneAction >";

	    print "\n</form>";
	    return;
	}

	my $aliasOption; 

	if ( ! $request->{$singleAliasNameParam} 
	    || $request->{$singleAliasNameParam} eq "0" )
	{
		$aliasOption = ""; 
	} else {
		$aliasOption = " -a $request->{$singleAliasNameParam}";
	}

	#USAGE 
        #usage : createvezone -n <vepair_name> -c <initiator> -w <WWN> 
        #                     -z <zonename> [ -V ]
        #where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2
        #        initiator - is the SLIC initiator, (i.e. I00001 or I00002)
        #        WWN - is the world wide number for the associated HBA channel
        #        zonename - is the name of the zone to create, 
        #                   the recommended format
        #                   is: remoteHostName_channelId (ex labsys_c1)
        #        -V - verbose output

	my $command = "$VEUI::secfgBinDir/createvezone"
		    . " -m" #this means don't re-validate
		    . " -n $request->{$veParam}"
		    . " -c $request->{$initParam} "
		    . " -w $request->{$wwnParam} "
		    . " -z $request->{$singleZoneNameParam}"
		    . " -V"
		    . $aliasOption;

	print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
	print "</h3>";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}


sub createMultiZone () {

    my ( $request ) = @_ if @_;
    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $createMultiZoneAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "1" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $createZoneStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = (
            [ "static", $veInUseStr, $busyStr ],
            [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "hidden", $ZoneFileParam, $request->{$ZoneFileParam} ],
            [ "hidden", $stepParam, "2" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $createMultiZoneStr,
                                    $createMultiZoneAction,
                                    \@buttons,
                                    \@fields  );
	}
	elsif ( $request->{$stepParam} eq "2" )
	{
	my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ],
                      [ $createZoneStr, $createZoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $selectInitStr );

	# DAVID_NEEDS_LIB_INIT
	my @initiators = &getInitiators ( $request->{$veParam} );

	if ( scalar(@initiators) == 0 )
	{
	    print "<h2>$noInitiatorsForVEStr $request->{$veParam}.</h2>";
	    return;
	}

	my @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],
            [ "radio", "Available Initiators:", $initParam , \@initiators ],
	    [ "hidden", $ZoneFileParam, $request->{$ZoneFileParam} ],
            [ "hidden", $stepParam, "3" ]
            );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $createMultiZoneStr,
				    $createMultiZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "3" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $createZoneStr, $createZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select WWN" );

	# DAVID_NEEDS_LIB_WWN
	my @wwns = &getWWNs ( $request->{$veParam}, $request->{$initParam} );


	if ( scalar(@wwns) == 0 ) 
	{
	    print "<h2>There are no available HBAs"
		. " on $request->{$initParam}.</h2>";
	    return;
	}

	my @effWWN;

	#Exclude the wwn from the list that has already been selected
	for my $wwn ( @wwns )
    	{
		my $tmp = `grep "$wwn" $createMultiZoneFile >/dev/null 2>&1`;
        	if ( $? ) #if wwn not found
        	{
        	    push @effWWN, $wwn;
        	}
    	}

	if ( scalar(@effWWN) == 0 ) 
	{
	    print "<h2>There are no more available HBAs"
		. " on $request->{$initParam}.</h2>";
	    return;
	}

	my @multiparam = ( "Yes", "No" );

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	    [ "static", "Initiator:", $request->{$initParam} ],
	    [ "hidden", $initParam, $request->{$initParam} ],
	    [ "radio", "Available WWN(s):", $wwnParam , \@effWWN ],
	    [ "text", "Zone Name:", $singleZoneNameParam ,"", "16", "15" ],
	    [ "text", "Alias Name:", $singleAliasNameParam ,"", "16", "15" ],
	    [ "static", "NOTE:", $aliasNote ],
	    [ "radio", "Do you want to create more zones on $request->{$veParam}:", $multiParam , \@multiparam ],
	    [ "hidden", $ZoneFileParam, $request->{$ZoneFileParam} ],
	    [ "hidden", $stepParam, "4" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $createMultiZoneStr,
				    $createMultiZoneAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }

    elsif ( $request->{$stepParam} eq "4" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $createZoneStr, $createZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Creating Zone" );

	#remove leading spaces for comparison
	$request->{$singleZoneNameParam} =~ s/^ *//g;

	if ( ! $request->{$singleZoneNameParam} 
	    || $request->{$singleZoneNameParam} eq "0" )
	{
	    print "<h2>";
	    print "Invalid zone name : $request->{$singleZoneNameParam}";
	    print "</h2>";

	    print "\n<form>";

	    print "\n<input type=submit"
		. " value=\"Back to Create Zone\" name=back >";

	    print "<input type=hidden name=GO"
		. " value=$createZoneAction >";

	    print "\n</form>";
	    return;
	}

	my $stepNum;
	my $dispString;

	if ( $request->{$multiParam} eq "Yes" )
	{
		$stepNum = "2";
		$dispString = "Add to the List";
	}
	else
	{
		$stepNum = "4newzone";
		$dispString = "Create Multiple Zones";
	
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	    [ "static", "Initiator:", $request->{$initParam} ],
	    [ "hidden", $initParam, $request->{$initParam} ],
	    [ "static", "WWN:", $request->{$wwnParam} ],
	    [ "hidden", $wwnParam, $request->{$wwnParam} ],
	    [ "static", "Zone Name:", $request->{$singleZoneNameParam} ],
	    [ "hidden",$singleZoneNameParam , $request->{$singleZoneNameParam} ],
	    [ "static", "Alias Name:", $request->{$singleAliasNameParam} ],
	    [ "hidden",$singleAliasNameParam , $request->{$singleAliasNameParam} ],
	    [ "hidden", $ZoneFileParam, $request->{$ZoneFileParam} ],
	    [ "hidden", $stepParam, $stepNum ]
	    );

	my @buttons = ( [ "NOTUSED", "\"$dispString\"" ] );
	my %opts = ( "longlived" => "1" );

	my $aliasOption; 

	if ( ! $request->{$singleAliasNameParam} 
	    || $request->{$singleAliasNameParam} eq "0" )
	{
		$aliasOption = ""; 
	} else {
		$aliasOption = " -a $request->{$singleAliasNameParam}";
	}

	#Write the batch commands to the file

	$createMultiZoneFile = $request->{$ZoneFileParam};
        open(MULTIZONE, ">> $createMultiZoneFile")|| die print "Can't open file: $!
\n";
        print MULTIZONE "/opt/SUNWsecfg/bin/createvezone -V -m -x -n $request->{$veParam} -c $request->{$initParam} -w $request->{$wwnParam} -z $request->{$singleZoneNameParam} $aliasOption\n";
	close MULTIZONE;


	print SE::WebUtil->createForm ( $createMultiZoneStr,
				    $createMultiZoneAction,
				    \@buttons,
				    \@fields,
				    \%opts );


    }
    elsif ( $request->{$stepParam} eq "4newzone" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ],
		      [ $createZoneStr, $createZoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Creating Multiple Zones" );

	$createMultiZoneFile = $request->{$ZoneFileParam};
        open(MULTIZONE, ">> $createMultiZoneFile")|| die print "Can't open file: $!";
	print MULTIZONE "/opt/SUNWsecfg/bin/savevemap -n $request->{$veParam} -V \n";
	close MULTIZONE;

	my $tmp = `chmod +x $createMultiZoneFile`;
        my $command = "/usr/bin/ksh $createMultiZoneFile";

	my $link;

        if ( $request->{$veParam} eq "v1" )
        {
            $link = $viewVE1ZoneResultsURL;
        }
        else
        {
            $link = $viewVE2ZoneResultsURL;
        }

	$tmp = `rm -f /tmp/se6900_$request->{$veParam}_z`;
        #$tmp = `rm -f /tmp/se6900_v2z`;

        SE::Util->execCmdBGOutputToFile ( $command, 1, $link, "$request->{$veParam}_z" );


    }

    print SE::WebUtil->createTail ();



} #end of createMultiZone


sub addToZone ()
{
	#Supports cluster (multiple HBAs)

    my ( $request ) = @_ if @_;

    if ( $request->{$rangeParam} eq "Range" )
    {
	&addToZoneByRange ( $request );
	return;
    }

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $addToZoneAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ($request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $addToZoneStr );

        # DAVID_NEEDS_LIB_VE
        my ( $velist, $busyStr, $errMsg ) = &getVEs();

        if ( scalar(@$velist) == 0 )
        {
            print "<h2>$noVEsAvailStr</h2>";
            print "<br>$veInUseStr $busyStr";
            print "<br><pre>$errMsg</pre>";
            return;
        }
        my @vlunsOrHba = ( "VLUNs", "HBAs" );

        my @fields = (
            [ "static", $veInUseStr, $busyStr ],
            [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "radio", "Do you want to add to VLUNs or HBAs:", 
				 $vlunsOrHbaParam , \@vlunsOrHba ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $selectVEStr,
                                    $addToZoneAction,
                                    \@buttons,
                                    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "1"
	    && ( $request->{$vlunsOrHbaParam} eq "VLUNs" ) )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $addToZoneStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	my @oneOrTwo = ( "1", "2" );
	my @singleOrRange = ( "Single", "Range" );

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	    [ "radio", "Do you want to add a single VLUN or a range:", 
				 $rangeParam , \@singleOrRange ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $selectVEStr,
				    $addToZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "1"
	    && ( $request->{$vlunsOrHbaParam} eq "HBAs" ) )
    {
#Display Available Initiators, Zones & WWn numbers for that init and alias name
	my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ] 
                    );

        print SE::WebUtil->createCrumb( \@crumb, $addToZoneStr );

        # DAVID_NEEDS_LIB_INIT
        my @initiators = &getInitiators ( $request->{$veParam} );

        if ( scalar(@initiators) == 0 )
        {
            print "<h2>$noInitiatorsForVEStr $request->{$veParam}.</h2>";
            return;
        }

        my @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],
	    [ "radio", "Available Initiators:", $initParam , \@initiators ],
	    [ "hidden", $stepParam, "hba2" ]
	    );
	my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $selectInitStr,
                                    $addToZoneAction,
                                    \@buttons,
                                    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "hba2") 
    {
	my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $addToZoneStr );

	# NEED_LIB_ZONES
	my @zones = &getZones ( $request->{$veParam}, $request->{$initParam} );

        if ( scalar(@zones) == 0 )
        {
            print "<h2>$noZonesForInitiatorStr $request->{$initParam}.</h2>";
            return;
        }
	# NEED_LIB_WWN
        my @wwns = &getWWNs ( $request->{$veParam}, $request->{$initParam} );

        if ( scalar(@wwns) == 0 )
        {
            print "<h2>There are no available HBAs"
                . " on $request->{$initParam}.</h2>";
            return;
        }
	my @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],
            [ "static", "Initiator:", $request->{$initParam} ],
            [ "hidden", $initParam, $request->{$initParam} ],
	    [ "radio", "Zones:", $singleZoneNameParam , \@zones ],
            [ "radio", "Available WWN(s):", $wwnParam , \@wwns ],
            [ "text", "Alias Name:", $singleAliasNameParam ,"", "16", "15" ],
            [ "static", "NOTE:", $aliasNote2 ],
            [ "hidden", $stepParam, "hba3" ]
            );

        my @buttons = ( [ "NOTUSED", "\"Add HBAs to Zone\"" ] );
        my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $selectZoneStr,
                                    $addToZoneAction,
                                    \@buttons,
                                    \@fields,
                                    \%opts );

    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $addToZoneStr );

	# DAVID_NEEDS_LIB_ZONES
	# Get the zones on both the initiators

          &getAllZones ( $request->{$veParam} );

	if ( scalar(%AllZoneList) == 0 )
	{
	    print "<h2>$noZonesForInitiatorStr $initOne, $initTwo.</h2>";
	    return;
	}

	# DAVID_NEEDS_LIB_LUNS

	my @luns = &getLUNs ( $request->{$veParam} );

	if ( scalar(@luns) == 0 )
	{
	    print "<h2>$noLunsForVEStr $request->{$veParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "checkbox", "Zones for $initOne, $initTwo:", $AllZoneParam , \%AllZoneList ],
	    [ "static", "NOTE:",$AllZonesNote ],

	    [ "radio", "Select VLUN to Add:", $targetParam , \@luns ],

	    [ "hidden", $stepParam, "4addtozone" ]

	    );

	my @buttons = ( [ "NOTUSED", "\"Add VLUNs to Zone\"" ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $selectZoneStr,
				    $addToZoneAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "hba3" )
    {
	my ( $request ) = @_ if @_;

        my @crumb = ( [$homeStr   , $homeURL],
                      [$zoneStr , $zoneURL],
                      [$addToZoneStr , $addToZoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Adding HBA(s) to Zone" );

	#remove leading spaces for comparison
	$request->{$singleAliasNameParam} =~ s/^ *//g;

        if ( ! $request->{$singleAliasNameParam} 
            || $request->{$singleAliasNameParam} eq "0" )
        {
            print "<h2>";
            print "Invalid alias name : $request->{$singleAliasNameParam}";
            print "</h2>";

            print "\n<form>";

            print "\n<input type=submit"
                . " value=\"Back to Add Components to Zone\" name=back >";

            print "<input type=hidden name=GO"
                . " value=$addToZoneAction >";

            print "\n</form>";
            return;
        }

	my $command;
	$command = "$VEUI::secfgBinDir/addtovezone"
                    . " -m" #this means don't re-validate
                    . " -n $request->{$veParam}"
                    . " -z $request->{$singleZoneNameParam}"
                    . " -w $request->{$wwnParam}"
                    . " -a $request->{$singleAliasNameParam}"
                    . " -V ";

        print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
        print "</h3>";

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }
    elsif ( $request->{$stepParam} eq "4addtozone" )
    {
        my ( $request ) = @_ if @_;
    
        my @crumb = ( [$homeStr   , $homeURL],
		      [$zoneStr , $zoneURL],
		      [$addToZoneStr , $addToZoneURL ]
		    );
    
        print SE::WebUtil->createCrumb( \@crumb, "Adding VLUN(s) to Zone" );
    
        #USAGE 
        #usage : addtovezone -n <vepair_name> -v <vlun> -z <zonename> 
        #            [ -s <secondary_zone> ] [ -e <end_vlun> ] [ -V ]
        #where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2
        #        vlun -  is the VLUN target ID assigned by the virtualization
        #                engine (either a single ID or if used with the 
        #                -e option its used as the starting ID in the range)
        #        zonename - is the name of the zone to which to add the VLUN
        #        secondary_zone - is the name of the alternate path zone 
        #                         in which to also add the VLUN
        #        end_vlun - indicates a range of VLUNs are to be added and works
        #                    with the -v option
        #        -V - verbose output

	my $theTarget = $request->{$targetParam};
	#$theTarget =~ s/\(.*?\)//g; #for historical ref; this was not ideal
	$theTarget =~ s/\(.*//g;

	my $AllZoneList_p = Util->deserialize($ALLZONELIST);

	$zoneList = "";
        my $key;
        my $value;
        while(($key,$value)=each %$AllZoneList_p){
         if ( $request->{$key} )
          {
           $value =~ s/\(.*//g;
           $zoneList = $zoneList . $value . ",";
          }
         }

        my $command;
	
	    $command = "$VEUI::secfgBinDir/addtovezone"
		    . " -m" #this means don't re-validate
                    . " -n $request->{$veParam}"
                    . " -v $theTarget "
                    . " -z $zoneList "
		    . " -V ";
    
        print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
        print "</h3>";
    
	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}


sub delFromZone ()
{
	##Supports cluster (multiple HBAs)

    my ( $request ) = @_ if @_;

    if ( $request->{$rangeParam} eq "Range" )
    {
	&delFromZoneByRange ( $request );
	return;
    }

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $delFromZoneAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

	if ( $request->{$stepParam} eq "" )
		{
			my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

        # DAVID_NEEDS_LIB_VE
        my ( $velist, $busyStr, $errMsg ) = &getVEs();

        if ( scalar(@$velist) == 0 )
        {
            print "<h2>$noVEsAvailStr</h2>";
            print "<br>$veInUseStr $busyStr";
            print "<br><pre>$errMsg</pre>";
            return;
        }
        my @vlunsOrHba = ( "VLUNs", "HBAs" );

        my @fields = (
            [ "static", $veInUseStr, $busyStr ],
            [ "radio", $veAvailStr, $veParam , \@$velist ],
            [ "radio", "Do you want to delete VLUNs or HBAs:",
                                 $vlunsOrHbaParam , \@vlunsOrHba ],
            [ "hidden", $stepParam, "1" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $selectVEStr,
                                    $delFromZoneAction,
                                    \@buttons,
                                    \@fields  );
		}
		
  elsif ( $request->{$stepParam} eq "1"
					&& ( $request->{$vlunsOrHbaParam} eq "HBAs" ) )
	{
		#Display Available Initiators
        my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

        # DAVID_NEEDS_LIB_INIT
        my @initiators = &getInitiators ( $request->{$veParam} );

        if ( scalar(@initiators) == 0 )
        {
            print "<h2>$noInitiatorsForVEStr $request->{$veParam}.</h2>";
            return;
        }

        my @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],
            [ "radio", "Available Initiators:", $initParam , \@initiators ],
            [ "hidden", $stepParam, "hba2" ]
            );
        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( $selectInitStr,
                                    $delFromZoneAction,
                                    \@buttons,
                                    \@fields  );
	}
	elsif ( $request->{$stepParam} eq "hba2")
    {
        my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

        # NEED_LIB_ZONES
        my @zones = &getZones ( $request->{$veParam}, $request->{$initParam} );

        if ( scalar(@zones) == 0 )
        {
            print "<h2>$noZonesForInitiatorStr $request->{$initParam}.</h2>";
            return;
        }
        my @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],
            [ "static", "Initiator:", $request->{$initParam} ],
            [ "hidden", $initParam, $request->{$initParam} ],
            [ "radio", "Zones:", $singleZoneNameParam , \@zones ],
            [ "hidden", $stepParam, "hba3" ]
            );
				my @buttons = ( [ "NOTUSED", "NEXT" ] );
        my %opts = ( "longlived" => "1" );

        print SE::WebUtil->createForm ( $selectZoneStr,
                                    $delFromZoneAction,
                                    \@buttons,
                                    \@fields,
                                    \%opts );
	}
  elsif ( $request->{$stepParam} eq "hba3")
  {
	 my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

        # NEED_LIB_ALIAS
        #my @aliases = &getAliases ( $request->{$veParam}, $request->{$initParam} );
        my @aliases = &getAliasesByZone ( $request->{$veParam}, $request->{$initParam},$request->{$singleZoneNameParam} );

        if ( scalar(@aliases) == 0 )
        {
            print "<h2>There are no available aliases"
                . " for zone $request->{$singleZoneNameParam}.</h2>";
            return;
        }
        my @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],
            [ "static", "Initiator:", $request->{$initParam} ],
            [ "hidden", $initParam, $request->{$initParam} ],
            [ "static", "Zones:", $singleZoneNameParam , $request->{$singleZoneNameParam} ],
            [ "hidden", $singleZoneNameParam, $request->{$singleZoneNameParam} ],
            [ "radio", "Available Alias(s) for $request->{$singleZoneNameParam}:", $singleAliasNameParam , \@aliases ],
            [ "hidden", $stepParam, "hba4" ]
            );
				my @buttons = ( [ "NOTUSED", "\"Delete HBAs from Zone\"" ] );
        my %opts = ( "longlived" => "1" );

        print SE::WebUtil->createForm ( $selectZoneStr,
                                    $delFromZoneAction,
                                    \@buttons,
                                    \@fields,
                                    \%opts );	

  }
  elsif ( $request->{$stepParam} eq "1"
					&& ( $request->{$vlunsOrHbaParam} eq "VLUNs" ) )
  {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}
	my @oneOrTwo = ( "1", "2" );
	my @singleOrRange = ( "Single", "Range" );

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
			[ "hidden", $veParam, $request->{$veParam} ],
	    [ "radio", "Do you want to delete a single VLUN or a range:", 
				 $rangeParam , \@singleOrRange ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $selectVEStr,
				    $delFromZoneAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "2")
    {
        my @crumb = ( [ $homeStr , $homeURL ],
                      [ $zoneStr, $zoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

        # DAVID_NEEDS_LIB_ZONES
	# Get the zones on both the initiators

          &getAllZones ( $request->{$veParam} );


        if ( scalar(%AllZoneList) == 0 )
        {
            print "<h2>$noZonesForInitiatorStr $initOne, $initTwo.</h2>";
            return;
        }

	# DAVID_NEEDS_LIB_LUNS

        my @luns = &getLUNs ( $request->{$veParam} );

        if ( scalar(@luns) == 0 )
        {
            print "<h2>$noLunsForVEStr $request->{$veParam}.</h2>";
            return;
        }

        my @fields = ( 
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],

            [ "checkbox", "Zones for $initOne, $initTwo:", $AllZoneParam , \%AllZoneList ],
	    [ "static", "NOTE:",$AllZonesNote ],

	    [ "radio", "Select VLUN to delete:", $targetParam , \@luns ],


            [ "hidden", $stepParam, "5delfrom" ]
            );

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( "\"Delete VLUN from Zone\"",
                                    $delFromZoneAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "hba4" )
	{
		my ( $request ) = @_ if @_;

        my @crumb = ( [$homeStr   , $homeURL],
                      [$zoneStr , $zoneURL],
                      [$delFromZoneStr , $delFromZoneURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb,
                                            "Deleting VLUN from Zone" );
		my $command;
		$command = "$VEUI::secfgBinDir/delfromvezone"
                     . " -m" #this means don't re-validate
                     . " -n $request->{$veParam}"
                     . " -z $request->{$singleZoneNameParam} "
                     . " -a $request->{$singleAliasNameParam} "
                     . " -V ";
	print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
        print "</h3>";

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );

	}
    elsif ( $request->{$stepParam} eq "5delfrom" )
    {
        my ( $request ) = @_ if @_;

        my @crumb = ( [$homeStr   , $homeURL],
		      [$zoneStr , $zoneURL],
		      [$delFromZoneStr , $delFromZoneURL ]
		    );
    
        print SE::WebUtil->createCrumb( \@crumb, 
					    "Deleting VLUN from Zone" );
    
        #USAGE 
        #usage : delfromvezone -n <vepair_name> -v <vlun> -z <zonename> 
        #        [ -s <secondary_zone> ] [ -e <end_vlun> ] [ -V ]
        #   where:
        #   vepair_name - is a virtualization engine pair name, v1 or v2
        #   vlun -  is the VLUN target ID assigned by the virtualization
        #           engine (either a single ID or if used with the -e option 
        #           its used as the starting ID in the range)   
        #   zonename - is the name of the zone from which to remove the VLUN
        #   secondary_zone - is the name of the alternate path zone from which
        #                     to also remove the VLUN
        #   end_vlun - indicates a range of VLUNs are to be removed and works
        #               with the -v option
        #   -V - verbose output

	my $theTarget = $request->{$targetParam};
	$theTarget =~ s/\(.*//g;

	my $AllZoneList_p = Util->deserialize($ALLZONELIST);

	$zoneList = "";
        my $key;
        my $value;

        while(($key,$value)=each %$AllZoneList_p){
         if ( $request->{$key} )
          {
           $value =~ s/\(.*//g;
           $zoneList = $zoneList . $value . ",";
          }
         }

        my $command;
	
	    $command = "$VEUI::secfgBinDir/delfromvezone"
		     . " -m" #this means don't re-validate
                     . " -n $request->{$veParam}"
                     . " -v $theTarget "
                     . " -z $zoneList "
		     . " -V ";
    
        print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
        print "</h3>";
    
	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}


sub addToZoneByRange ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $addToZoneByRangeAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $addToZoneStr );

	# DAVID_NEEDS_LIB_ZONES
	# Get the zones on both the initiators

          &getAllZones ( $request->{$veParam} );


	if ( scalar(%AllZoneList) == 0 )
	{
	    print "<h2>$noZonesForInitiatorStr $initOne, $initTwo.</h2>";
	    return;
	}

	# DAVID_NEEDS_LIB_LUNS
	my @luns = &getLUNs ( $request->{$veParam} );

	if ( scalar(@luns) == 0 )
	{
	    print "<h2>$noLunsForVEStr $request->{$veParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "checkbox", "Zones for $initOne, $initTwo:", $AllZoneParam , \%AllZoneList ],
	    [ "static", "NOTE:",$AllZonesNote ],

	    [ "radio", "Select start range:", $startRangeParam , \@luns ],

	    [ "hidden", $stepParam, "4dualz_endrange" ]

	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $selectZoneStr,
				    $addToZoneByRangeAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "4dualz_endrange" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $addToZoneStr );

	# DAVID_NEEDS_LIB_LUNS
	my @luns = &getLUNs ( $request->{$veParam} );

	if ( scalar(@luns) == 0 )
	{
	    print "<h2>$noLunsForVEStr $request->{$veParam} $initOne, $initTwo.</h2>";
	    return;
	}

	my @endRange = &getEndRange ( \@luns, $request->{$startRangeParam} );

	my $AllZoneList_p = Util->deserialize($ALLZONELIST);

	$zoneList = "";
        my $key;
        my $value;
        while(($key,$value)=each %$AllZoneList_p){
         if ( $request->{$key} )
          {
           $value =~ s/\(.*//g;
           $zoneList = $zoneList . $value . ",";
          }
         }

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "static", "Zones for $initOne, $initTwo:", $zoneList ],
	    [ "hidden", $AllZoneParam, $zoneList ],

	    [ "static", "VLUN Start Range:", $request->{$startRangeParam} ],
	    [ "hidden", $startRangeParam, $request->{$startRangeParam} ],

	    [ "radio", "Select VLUN End Range:", $endRangeParam , \@endRange ],

	    [ "hidden", $stepParam, "4addrange" ]

	    );

	my @buttons = ( [ "NOTUSED", "\"Add to Zone\"" ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $selectZoneStr,
				    $addToZoneByRangeAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "4addrange" )
    {
        my ( $request ) = @_ if @_;
    
        my @crumb = ( [$homeStr   , $homeURL],
		      [$zoneStr , $zoneURL],
		      [$addToZoneStr , $addToZoneURL ]
		    );
    
        print SE::WebUtil->createCrumb( \@crumb, "Adding VLUN(s) to Zone" );
    
        #USAGE 
        #usage : addtovezone -n <vepair_name> -v <vlun> -z <zonename> 
        #            [ -s <secondary_zone> ] [ -e <end_vlun> ] [ -V ]
        #where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2
        #        vlun -  is the VLUN target ID assigned by the virtualization
        #                engine (either a single ID or if used with the 
        #                -e option its used as the starting ID in the range)
        #        zone_list - is a single zone if adding an HBA or a comma-separated
        #               list of zones if specifying vlun(s) (i.e. zone1,zone2)
        #        end_vlun - indicates a range of VLUNs are to be added and works
        #                    with the -v option
        #        -V - verbose output

	my $startRange = $request->{$startRangeParam};
	$startRange =~ s/\(.*?\)//g;

	my $endRange = $request->{$endRangeParam};
	$endRange =~ s/\(.*?\)//g;

        my $command;
	
	    $command = "$VEUI::secfgBinDir/addtovezone"
		    . " -m" #this means don't re-validate
                    . " -n $request->{$veParam}"
                    . " -v $startRange"
                    . " -z $request->{$AllZoneParam}"
		    . " -e $endRange"
		    . " -V ";
    
        print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
        print "</h3>";
    
	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}


sub delFromZoneByRange ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $delFromZoneByRangeAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

	# DAVID_NEEDS_LIB_ZONES
	# Get the zones on both the initiators

          &getAllZones ( $request->{$veParam} );


	if ( scalar(%AllZoneList) == 0 )
	{
	    print "<h2>$noZonesForInitiatorStr $initOne, $initTwo.</h2>";
	    return;
	}

	# DAVID_NEEDS_LIB_LUNS
        my @luns = &getLUNs ( $request->{$veParam} );

        if ( scalar(@luns) == 0 )
        {
            print "<h2>$noLunsForVEStr $request->{$veParam}.</h2>";
            return;
        }


	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "checkbox", "Zones for $initOne, $initTwo:", $AllZoneParam , \%AllZoneList ],
	    [ "static", "NOTE:",$AllZonesNote ],

	    [ "radio", "Select start range:", $startRangeParam , \@luns ],

	    [ "hidden", $stepParam, "4dualz_endrange" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( "Select VLUN Targets",
				    $delFromZoneByRangeAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "4dualz_endrange" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr, $zoneURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $delFromZoneStr );

	# DAVID_NEEDS_LIB_LUNS
	my @luns = &getLUNs ( $request->{$veParam} );

	if ( scalar(@luns) == 0 )
	{
	    print "<h2>$noLunsForVEStr $request->{$veParam}";
	    return;
	}

	my @endRange = &getEndRange ( \@luns, $request->{$startRangeParam} );
	
	my $AllZoneList_p = Util->deserialize($ALLZONELIST);

	$zoneList = "";
        my $key;
        my $value;
        while(($key,$value)=each %$AllZoneList_p){
         if ( $request->{$key} )
          {
           $value =~ s/\(.*//g;
           $zoneList = $zoneList . $value . ",";
          }
         }

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "static", "Zones for $initOne, $initTwo:", $zoneList ],
            [ "hidden", $AllZoneParam, $zoneList ],

	    [ "static", "VLUN Start Range:", $request->{$startRangeParam} ],
	    [ "hidden", $startRangeParam, $request->{$startRangeParam} ],

	    [ "radio", "Select VLUN End Range:", $endRangeParam , \@endRange ],

	    [ "hidden", $stepParam, "4delrange" ]

	    );

	my @buttons = ( [ "NOTUSED", "\"Delete VLUNs from Zone\"" ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $selectZoneStr,
				    $delFromZoneByRangeAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "4delrange" )
    {
        my ( $request ) = @_ if @_;
    
        my @crumb = ( [$homeStr   , $homeURL],
		      [$zoneStr , $zoneURL],
		      [$delFromZoneStr , $delFromZoneURL ]
		    );
    
        print SE::WebUtil->createCrumb( \@crumb, "Deleting VLUN(s) from Zone" );
    
        #USAGE 
        #usage : delfromvezone -n <vepair_name> -v <vlun> -z <zonename> 
        #        [ -s <secondary_zone> ] [ -e <end_vlun> ] [ -V ]
        #   where:
        #   vepair_name - is a virtualization engine pair name, v1 or v2
        #   vlun -  is the VLUN target ID assigned by the virtualization
        #           engine (either a single ID or if used with the -e option 
        #           its used as the starting ID in the range)   
        #   zonename - is the name of the zone from which to remove the VLUN
        #   secondary_zone - is the name of the alternate path zone from which
        #                     to also remove the VLUN
        #   end_vlun - indicates a range of VLUNs are to be removed and works
        #               with the -v option
        #   -V - verbose output

	my $startRange = $request->{$startRangeParam};
	$startRange =~ s/\(.*?\)//g;

	my $endRange = $request->{$endRangeParam};
	$endRange =~ s/\(.*?\)//g;

        my $command;
	
	    $command = "$VEUI::secfgBinDir/delfromvezone"
		    . " -m" #this means don't re-validate
                    . " -n $request->{$veParam}"
                    . " -v $startRange"
                    . " -z $request->{$AllZoneParam}"
		    . " -e $endRange"
		    . " -V ";
    
        print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
        print "</h3>";
    
	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}


sub createVLUN ()
{
    my ( $request ) = @_ if @_;

#If the user selects create multiple vluns option then createMultiVLUN 
#subroutine is called directly.

	if ( $request->{$multiVlunParam} eq "Multiple" )
    {

	my $tmp = `ps -aef|grep createGuiMultiVluns|grep -v grep >/dev/null 2>&1`;
	if ( $? )
	{
		$tmp = `rm -f /tmp/createGuiMultiVluns*`;
	}

	$createMultiVlunFile = $request->{$VLUNFileParam};
	open(MULTIVLUN, ">$createMultiVlunFile")|| die "Can't open newfile: $!\n";
	print MULTIVLUN "#!/bin/ksh\n#include the ve lib\n. /opt/SUNWsecfg/flib/ve_kshlib\n\ncat $createMultiVlunFile\n\n#Commands Executed\n\n";
	close MULTIVLUN;
	&loadDPsize($request->{$veParam});	
        &createMultiVLUN ( $request );
        return;
    }

    # start password check #THIS IS CORRECT VALIDATE AGAINST T3 NOT VE
    if ( 0 == SE::T3UI->validate ( $request, $createVLUNAction,
					     $createVLUNStr ) )
    {
		return;
    }
    # end password check


    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $createVLUNAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
		return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $manageVLUNsStr => $manageVLUNsURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $createVLUNStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}
	my @zones = ( "Yes", "No" );
	my @singleOrMulti = ( "Single", "Multiple" );

	$createMultiVlunFile = "/tmp/createGuiMultiVluns_$$";

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "radio", "Specify Zones:", $zoneOptParam , \@zones ],
	    [ "radio", "Do you want to create VLUNs in a single diskpool or multiple:", $multiVlunParam , \@singleOrMulti ],
	    [ "hidden", $VLUNFileParam, $createMultiVlunFile ],

	    [ "hidden", $stepParam, "2" ]
	);

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $selectVEStr,
				    $createVLUNAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $manageVLUNsStr => $manageVLUNsURL ],
		      [ $createVLUNStr => $createVLUNURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "VLUN Properties" );

	# DAVID_NEEDS_LIB_POOLS
	my @pools = &getDiskPools ( $request->{$veParam} );

	if ( scalar(@pools) == 0 )
	{
	    print "<h2>$noPoolsForVEStr $request->{$veParam}.</h2>";
	    return;
	}


	my @fields;

	if ( $request->{$zoneOptParam} eq "Yes" )
	{
	  # DAVID_NEEDS_LIB_ZONES
	  # Get the zones on both the initiators

	  &getAllZones ( $request->{$veParam} );
	    if ( scalar(%AllZoneList) == 0 )
	    {
		print "<h2>$noZonesForInitiatorStr $initOne, $initTwo.</h2>";
		return;
	    }


	    @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "radio", "Disk Pool:", $poolParam, \@pools ],
	    [ "static", "NOTE:","The diskpool space displayed above is the largest contiguous block available." ],

	    [ "text", "Number of VLUNs to create:", $countParam, 
		      "0", "4", "3" ],

	    [ "text", "VLUN Size (in 1 GB increments):", 
		      $sizeParam,   "0", "5", "5" ],
	    [ "text", "VLUN Name(s):", $vlunNameParam, 
		      "", "10", "9" ], #blank default name

	    [ "static", $vlunNameNoteStr, "" ],

	    [ "checkbox", "Zones for $initOne, $initTwo:", $AllZoneParam , \%AllZoneList ],
	    [ "static", "NOTE:",$AllZonesNote ],

	    [ "hidden", $zoneOptParam, "Yes" ],
	    [ "hidden", $stepParam, "3" ]
	    );
	}
	else
	{
	    @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "radio", "Disk Pool:", $poolParam, \@pools ],
	    [ "static", "NOTE:","The diskpool space displayed above is the largest contiguous block available." ],

	    [ "text", "Number of VLUNs to create:", $countParam, 
		      "0", "4", "3" ],

	    [ "text", "VLUN Size (in 1 GB increments):", 
		      $sizeParam,   "0", "5", "5" ],
	    [ "text", "VLUN Name(s):", $vlunNameParam, 
		      "", "10", "9" ], #blank default name
	    [ "static", $vlunNameNoteStr, "" ],
	    [ "hidden", $stepParam, "3" ]
	    );
	}

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( "VLUN Properties", 
				    $createVLUNAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "3" )
    {
        my @crumb = ( [$homeStr   , $homeURL],
    		  [$manageVLUNsStr , $manageVLUNsURL],
    		  [$createVLUNStr , $createVLUNURL]
    		);
    
        print SE::WebUtil->createCrumb( \@crumb, "Verify Create VLUN(s)" );
    
        # DAVID_NEEDS_LIB_VALIDATE
        ### NEED TO VALIDATE ENTRIES !!!!!!!
        # %someHash = 
        # verifyCreateOK ( $request->{$veParam}, 
        #                  $request->{$poolPara}, 
        #                  $request->{$countParam},
        #                  $request->{$sizeParam}, 
        #                  $request->{$vlunNameParam} );

	#remove leading spaces for comparison
	$request->{$sizeParam} =~ s/^ *//g;
	$request->{$countParam} =~ s/^ *//g;

	my $goBack = 0;
	if ( ! $request->{$countParam} || $request->{$countParam} eq "0" )
	{
	    print "<h2>";
	    print "Invalid count parameter: $request->{$countParam}";
	    print "</h2>";
	    $goBack = 1;
	}
	if ( ! $request->{$sizeParam} || $request->{$sizeParam} eq "0" )
	{
	    print "<h2>";
	    print "Invalid size parameter: $request->{$sizeParam}";
	    print "</h2>";
	    $goBack = 1;
	}

	if ( $goBack )
	{
	    print "\n<form>";

	    print "\n<input type=submit"
		. " value=\"Back to Create VLUNs\" name=back >";

	    print "<input type=hidden name=GO"
		. " value=$createVLUNAction >";

	    # this wont quite do unless we also add the spec_zone->yes/no
	    #print "<input type=hidden name=$stepParam"
		#. " value=3 >";

	    print "\n</form>";
	    return;
	}

	my $name;

	if ( ! $request->{$vlunNameParam} )
	{
	    $name = "(System assigned)";
	}
	else
	{
	    $name = $request->{$vlunNameParam};
	}
    
        my @fields;

	my $thePool = $request->{$poolParam};
	$thePool =~ s/\(.*//g;

	if ( $request->{$zoneOptParam} eq "Yes" )
	{

	    my $AllZoneList_p = Util->deserialize($ALLZONELIST);

	    $zoneList = "";
	    my $key;
	    my $value;
	    while(($key,$value)=each %$AllZoneList_p){
		if ( $request->{$key} )
		{
			$value =~ s/\(.*//g;
			$zoneList = $zoneList . $value . ",";
		}
	    }
            @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	
	    [ "static", "Disk Pool:", $thePool ],
	    [ "hidden", $poolParam, $thePool ],
	
	    [ "static", "Number of VLUN(s) to create:", 
			 $request->{$countParam} ],
	    [ "hidden", $countParam, $request->{$countParam} ],
	
	    [ "static", "VLUN Size(s):", $request->{$sizeParam} ],
	    [ "hidden", $sizeParam, $request->{$sizeParam} ],
	
	    [ "static", "VLUN Name(s):", $name ],
	    [ "hidden", $vlunNameParam, $request->{$vlunNameParam} ],

	    [ "static", "Zones for $initOne, $initTwo:", $zoneList ],
	    [ "hidden", $AllZoneParam, $zoneList ],

	    [ "hidden", $zoneOptParam, "Yes" ],
	    [ "hidden", $stepParam, "4newvlun" ]
	    );
	}
	else
	{

            @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	
	    [ "static", "Disk Pool:", $thePool ],
	    [ "hidden", $poolParam, $thePool ],
	
	    [ "static", "Number of VLUN(s) to create:", 
			 $request->{$countParam} ],
	    [ "hidden", $countParam, $request->{$countParam} ],
	
	    [ "static", "VLUN Size(s):", $request->{$sizeParam} ],
	    [ "hidden", $sizeParam, $request->{$sizeParam} ],
	
	    [ "static", "VLUN Name(s):", $request->{$vlunNameParam} ],
	    [ "hidden", $vlunNameParam, $request->{$vlunNameParam} ],

	    [ "hidden", $stepParam, "4newvlun" ]
	    );
	}
    
        my @buttons = ( [ "NOTUSED", "Create" ] );
    
        print SE::WebUtil->createForm ( 
    				"The following VLUN(s) will be created.", 
    				$createVLUNAction,
    				\@buttons,
				\@fields );
    }
    elsif ( $request->{$stepParam} eq "4newvlun" )
    {
        my ( $request ) = @_ if @_;
    
        my @crumb = ( [$homeStr   , $homeURL],
		      [$manageVLUNsStr , $manageVLUNsURL],
		      [$createVLUNStr , $createVLUNURL]
		    );
    
        print SE::WebUtil->createCrumb( \@crumb, "Creating VLUN(s)" );

        #USAGE 
        #usage : createvlun -n <vepair_name> -d <diskpoolname> 
	#                   -l <size> -c <number>
	#                   [ -v <vlun_name> ]  
	#                   [ -z <zone_list>] [ -V ]
        #where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2
        #        diskpoolname - corresponds to the t3 LUN from which the 
        #                       VLUNs are carved
        #        size - is the size in GB for each VLUN (0.5 GB increments)
        #        number - is the number of VLUNs to create
        #        vlun_name - is a user-defined descriptive suffix for 
        #                    the vlun, the lun count number will be 
        #                    prepended, 10 char limit total
        #        zone_list - is a comma-separated list of zones in which to add the 
        #               VLUN (i.e. zone1,zone2)
        #        -V - verbose output
        #       NOTE: You may only specify either no zones or both zones.

        my $command;
	my $zoneArgs;

	#One of both zones might not be set

	if ( $request->{$zoneOptParam} eq "Yes" && $request->{$AllZoneParam} )
	{
	    $zoneList = $request->{$AllZoneParam};
	    $zoneArgs = " -z $zoneList";
	}

	my $nameArgs;
	if ( $request->{$vlunNameParam} )
	{
	    $nameArgs = " -v $request->{$vlunNameParam}";
	}

	$command = "$VEUI::secfgBinDir/createvlun"
		 . " -m" #this means don't re-validate
		 . " -n $request->{$veParam}"
		 . " -d $request->{$poolParam} "
		 . " -l $request->{$sizeParam} "
		 . " -c $request->{$countParam}"
		 #. " -v $request->{$vlunNameParam}"
		 . $nameArgs
		 . $zoneArgs
		 . " -V "; #for kelly
    
	my $passwd = SE::T3UI->getSavedT3Password ();
	my $prePasswd = $ENV{PASSWD};
	$ENV{PASSWD} = $passwd ;

        my $link;
	$batchType = "vluns";
        if ( $request->{$veParam} eq "v1" )
        {
            $link = $viewVE1ResultsURL;
        }
        else 
        {
            $link = $viewVE2ResultsURL;
        }

	SE::Util->execCmdBGOutputToFile ( $command, 1, $link,
		$request->{$veParam} );

	$ENV{PASSWD} = $prePasswd;
    }

    print SE::WebUtil->createTail ();
} #end of createVLUN


#This subroutine enables the user to create multiple vluns for a particular router 
#without having to go through all the menu options. 
#It keeps track of all user requests, writes them to a file and executes at the end 
#doing batch processing.

sub createMultiVLUN ()
{

my ( $request ) = @_ if @_;
	
	# start password check #THIS IS CORRECT VALIDATE AGAINST T3 NOT VE
    if ( 0 == SE::T3UI->validate ( $request, $createVLUNAction,
                                             $createVLUNStr ) )
    {
        return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $createMultiVLUNAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
        return;
    }

    if ( $request->{$stepParam} eq "2")
	{
		my @crumb = ( [ $homeStr , $homeURL ],
                      [ $manageVLUNsStr => $manageVLUNsURL ],
                      [ $createVLUNStr => $createVLUNURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "VLUN Properties" );

        # DAVID_NEEDS_LIB_POOLS
	my @pools;
        if ($request->{$sizeParam})
        {
        	my $tSize = ( $request->{$sizeParam} * $request->{$countParam} );
        	@pools = &getMultiDiskPools ( $request->{$veParam},$request->{$poolParam},$tSize);
        }
        else
        {
        	@pools = &getMultiDiskPools ( $request->{$veParam} );
        }

        if ( scalar(@pools) == 0 )
        {
            print "<h2>$noPoolsForVEStr $request->{$veParam}.</h2>";
            return;
        }

        # DAVID_NEEDS_LIB_ZONES
	# Get the zones on both the initiators

          &getAllZones ( $request->{$veParam} );

        my @fields;

        if ( $request->{$zoneOptParam} eq "Yes" )
        {
            if ( scalar(%AllZoneList) == 0 )
            {
                print "<h2>$noZonesForInitiatorStr $initOne, $initTwo.</h2>";
                return;
            }


			my @multiparam = ( "Yes", "No" );

            @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],

            [ "radio", "Disk Pool:", $poolParam, \@pools ],
	    [ "static", "NOTE:","The diskpool space displayed above is the largest contiguous block available." ],

            [ "text", "Number of VLUNs to create:", $countParam,
                      "0", "4", "3" ],
			[ "text", "VLUN Size (in 1 GB increments):",
                      $sizeParam,   "0", "5", "5" ],
            [ "text", "VLUN Name(s):", $vlunNameParam,
                      "", "10", "9" ], #blank default name

            [ "static", $vlunNameNoteStr, "" ],

            [ "checkbox", "Zones for $initOne, $initTwo :", $AllZoneParam , \%AllZoneList ],
	    [ "static", "NOTE:",$AllZonesNote ],

            [ "radio", "Do you want to create more VLUNs on $request->{$veParam} :", $multiParam , \@multiparam ],
	    [ "hidden", $zoneOptParam, "Yes" ],
	    
            [ "hidden", $VLUNFileParam, $request->{$VLUNFileParam} ],

            [ "hidden", $stepParam, "3" ]
            );
        }
        else
        {
			my @multiparam = ( "Yes", "No" );

            @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],

            [ "radio", "Disk Pool:", $poolParam, \@pools ],
	    [ "static", "NOTE:","The diskpool space displayed above is the largest contiguous block available." ],

            [ "text", "Number of VLUNs to create:", $countParam,
                      "0", "4", "3" ],

            [ "text", "VLUN Size (in 1 GB increments):",
                      $sizeParam,   "0", "5", "5" ],
            [ "text", "VLUN Name(s):", $vlunNameParam,
                      "", "10", "9" ], #blank default name
            [ "static", $vlunNameNoteStr, "" ],
            [ "radio", "Do you want to create more VLUNs on $request->{$veParam} :", $multiParam , \@multiparam ],
            [ "hidden", $VLUNFileParam, $request->{$VLUNFileParam} ],

            [ "hidden", $stepParam, "3" ]
            );
        }

        my @buttons = ( [ "NOTUSED", "Next" ] );

        print SE::WebUtil->createForm ( "VLUN Properties",
                                    $createMultiVLUNAction,
                                    \@buttons,
                                    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "3" )
	{
		my @crumb = ( [$homeStr   , $homeURL],
                  [$manageVLUNsStr , $manageVLUNsURL],
                  [$createVLUNStr , $createVLUNURL]
                );

        print SE::WebUtil->createCrumb( \@crumb, "Verify Create VLUN(s)" );

        # DAVID_NEEDS_LIB_VALIDATE
        ### NEED TO VALIDATE ENTRIES !!!!!!!
        # %someHash =
        # verifyCreateOK ( $request->{$veParam},
        #                  $request->{$poolPara},
        #                  $request->{$countParam},
        #                  $request->{$sizeParam},
        #                  $request->{$vlunNameParam} );

        #remove leading spaces for comparison
        $request->{$sizeParam} =~ s/^ *//g;
        $request->{$countParam} =~ s/^ *//g;

        my $goBack = 0;
        if ( ! $request->{$countParam} || $request->{$countParam} eq "0" )
        {
            print "<h2>";
            print "Invalid count parameter: $request->{$countParam}";
            print "</h2>";
            $goBack = 1;
        }
        if ( ! $request->{$sizeParam} || $request->{$sizeParam} eq "0" )
        {
            print "<h2>";
            print "Invalid size parameter: $request->{$sizeParam}";
            print "</h2>";
            $goBack = 1;
        }

	#Add check for disk pool size
	my $totalSize = $request->{$poolParam};
	$totalSize =~ s/t.*\(//g;
	$totalSize =~ s/G.*\)//g;
	$totalSize =~ s/^ *//g;

	my $effSize = ($request->{$countParam} * $request->{$sizeParam});

	if ( $effSize >  $totalSize )
	{
	    print "<h2>";
            print "Not enough space to create $request->{$countParam} VLUNs of size $request->{$sizeParam} GB.";
            print "</h2>";
            $goBack = 1;
	}


		if ( $goBack )
        {
            print "\n<form>";

            print "\n<input type=submit"
                . " value=\"Back to Create VLUNs\" name=back >";

            print "<input type=hidden name=GO"
                . " value=$createVLUNAction >";

            # this wont quite do unless we also add the spec_zone->yes/no
            #print "<input type=hidden name=$stepParam"
                #. " value=3 >";

            print "\n</form>";
            return;
        }

        my $name;

        if ( ! $request->{$vlunNameParam} )
        {
            $name = "(System assigned)";
        }
        else
        {
            $name = $request->{$vlunNameParam};
        }

        my @fields;
		my $stepNum;
		my $dispString;

		if ( $request->{$multiParam} eq "Yes" )
		{
			$stepNum = "2";
			$dispString = "Add to the List";
		}
		else
		{
			$stepNum = "4";
			$dispString = "Create Multiple Vluns";

		}

        my $thePool = $request->{$poolParam};
        $thePool =~ s/\(.*//g;

        if ( $request->{$zoneOptParam} eq "Yes" )
        {

	    my $AllZoneList_p = Util->deserialize($ALLZONELIST);

	    $zoneList = "";
            my $key;
            my $value;
            while(($key,$value)=each %$AllZoneList_p){
                if ( $request->{$key} )
                {
                        $value =~ s/\(.*//g;
                        $zoneList = $zoneList . $value . ",";
                }
            }

            @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],

            [ "static", "Disk Pool:", $thePool ],
            [ "hidden", $poolParam, $thePool ],

            [ "static", "Number of VLUN(s) to create:",
                         $request->{$countParam} ],
            [ "hidden", $countParam, $request->{$countParam} ],
			
			[ "static", "VLUN Size(s):", $request->{$sizeParam} ],
            [ "hidden", $sizeParam, $request->{$sizeParam} ],

            [ "static", "VLUN Name(s):", $name ],
            [ "hidden", $vlunNameParam, $request->{$vlunNameParam} ],

	    [ "static", "Zones for $initOne, $initTwo:", $zoneList ],
            [ "hidden", $AllZoneParam, $zoneList ],

	    [ "hidden", $zoneOptParam, "Yes" ],

            [ "hidden", $VLUNFileParam, $request->{$VLUNFileParam} ],

            [ "hidden", $stepParam, $stepNum ]
            );
	
	    $multiSizeParam = $request->{$sizeParam};
	    $multiCountParam = $request->{$countParam};
	    $multiDiskPoolParam = $thePool;
        }
        else
        {

            @fields = (
            [ "static", $veSelectedStr, $request->{$veParam} ],
            [ "hidden", $veParam, $request->{$veParam} ],

            [ "static", "Disk Pool:", $thePool ],
            [ "hidden", $poolParam, $thePool ],

            [ "static", "Number of VLUN(s) to create:",
                         $request->{$countParam} ],
            [ "hidden", $countParam, $request->{$countParam} ],

            [ "static", "VLUN Size(s):", $request->{$sizeParam} ],
            [ "hidden", $sizeParam, $request->{$sizeParam} ],

            [ "static", "VLUN Name(s):", $request->{$vlunNameParam} ],
            [ "hidden", $vlunNameParam, $request->{$vlunNameParam} ],

            [ "hidden", $VLUNFileParam, $request->{$VLUNFileParam} ],

            [ "hidden", $stepParam, $stepNum ]
            );

	    $multiSizeParam = $request->{$sizeParam};
	    $multiCountParam = $request->{$countParam};
	    $multiDiskPoolParam = $thePool;
        }

        my @buttons = ( [ "NOTUSED", "\"$dispString\"" ] );

		my $zoneArgs;

        #One of both zones might not be set

        if ( $request->{$zoneOptParam} eq "Yes" && $request->{$AllZoneParam} )
        {
	    $zoneList = $request->{$AllZoneParam};
            $zoneArgs = " -z $zoneList";
        }

        my $nameArgs;
        if ( $request->{$vlunNameParam} )
        {
            $nameArgs = " -v $request->{$vlunNameParam}";
        }

	my $thePool = $request->{$poolParam};
        $thePool =~ s/\(.*//g;

#Write the batch commands to the file
		$createMultiVlunFile = $request->{$VLUNFileParam};
		open(MULTIVLUN, ">> $createMultiVlunFile")|| die print "Can't open file: $!\n"; 
		print MULTIVLUN "/opt/SUNWsecfg/bin/createvlun -V -m -x -n $request->{$veParam} -d $thePool -l $request->{$sizeParam} -c $request->{$countParam} $nameArgs $zoneArgs\n";
		close MULTIVLUN;

		print SE::WebUtil->createForm (
                                "The following VLUN(s) will be created.",
                                $createMultiVLUNAction,
                                \@buttons,
                                \@fields );
    }
    elsif ( $request->{$stepParam} eq "4" )
    {
        my ( $request ) = @_ if @_;

        my @crumb = ( [$homeStr   , $homeURL],
                      [$manageVLUNsStr , $manageVLUNsURL],
                      [$createVLUNStr , $createVLUNURL]
                    );

        print SE::WebUtil->createCrumb( \@crumb, "Creating VLUN(s)" );

	#Add savevemap in bg to the batch file
	$createMultiVlunFile = $request->{$VLUNFileParam};
	open(MULTIVLUN, ">> $createMultiVlunFile")|| die print "Can't open file: $!\n"; 
	print MULTIVLUN "/opt/SUNWsecfg/bin/savevemap -n $request->{$veParam} -V  \n";
	close MULTIVLUN;
		
		my $command;

		my $tmp = `chmod +x $createMultiVlunFile`;
		$command = "/usr/bin/ksh $createMultiVlunFile";

        my $passwd = SE::T3UI->getSavedT3Password ();
        my $prePasswd = $ENV{PASSWD};
        $ENV{PASSWD} = $passwd ;

	my $link;
	$batchType = "vluns";

        if ( $request->{$veParam} eq "v1" )
        {
            $link = $viewVE1ResultsURL;
        }
        else
        {
            $link = $viewVE2ResultsURL;
        }

	$tmp = `rm -f /tmp/se6900_v1`;
        $tmp = `rm -f /tmp/se6900_v2`;

        SE::Util->execCmdBGOutputToFile ( $command, 1, $link,
                $request->{$veParam} );

        $ENV{PASSWD} = $prePasswd;


	} #if ( $request->{$stepParam} eq "2"

	print SE::WebUtil->createTail ();

} #end of createMultiVLUN


sub resetVE ()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( 0 == SE::VEUI->validate ( $request, $resetVEAction,
					     $resetVEStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $resetVEAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageHostsStr, $manageHostsURL ],
		      [ $resetVEStr, $resetVEURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

        #usage: resetve -n ve_hostname | [-h]
        #    where: 
        #    -h                - print usage
        #    -n <ve_hostname>  - is a virtualization engine hostname
	#                        from the /etc/hosts file

	my $passwd = &getSavedVEPassword ();

	my $prePasswd = $ENV{VEPASSWD};
	$ENV{VEPASSWD} = $passwd ;

	my $command = "$VEUI::secfgBinDir/resetve"
		    # this command does not accept -m
		    . " -n $request->{$veParam}";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );

	$ENV{VEPASSWD} = $prePasswd;
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageHostsStr, $manageHostsURL ]
		    ); 

	print SE::WebUtil->createCrumb( \@crumb, $resetVEStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs("hosts");

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ]
	    );

	my @buttons = ( [ "NOTUSED", "Reset" ] );

	print SE::WebUtil->createForm ( $resetVEStr,
				    $resetVEAction,
				    \@buttons,
				    \@fields  );
    }

    print SE::WebUtil->createTail ();
}


sub checkSlicd ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $checkSlicdAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageSlicdStr, $manageSlicdURL ],
		      [ $checkSlicdStr, $checkSlicdURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

        #usage : checkslicd -n <vepair_name> [ -c <initiator> ]
        #where :
        #   vepair_name - is a virtualization engine pair name, v1 or v2
        #   initiator - is the SLIC initiator number

	my $command = "$VEUI::secfgBinDir/checkslicd"
		    # this command does not accept -m
		    . " -n $request->{$veParam}";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );

	if ( !$retVal )
	{
	    print "<h2>The process is running properly.</h2>";
	}
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageSlicdStr, $manageSlicdURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $checkSlicdStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],

	    );

	my @buttons = ( [ "NOTUSED", "Check" ] );

	print SE::WebUtil->createForm ( $checkSlicdStr,
				    $checkSlicdAction,
				    \@buttons,
				    \@fields  );
    }

    print SE::WebUtil->createTail ();
}


sub startSlicd ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $startSlicdAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageSlicdStr, $manageSlicdURL ],
		      [ $startSlicdStr, $startSlicdURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

        #usage : startslicd -n <vepair_name> [ -c <initiator> ]
        #where :
        #   vepair_name - is a virtualization engine pair name, v1 or v2

	my $command = "$VEUI::secfgBinDir/startslicd"
		    # this command does not accept -m
		    . " -n $request->{$veParam}";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );

	if ( !$retVal )
	{
	    print "<h2>The process is running properly.</h2>";
	}
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageSlicdStr, $manageSlicdURL ],
		    );
	print SE::WebUtil->createCrumb( \@crumb, $startSlicdStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],

	    );

	my @buttons = ( [ "NOTUSED", "Start" ] );

	print SE::WebUtil->createForm ( $startSlicdStr,
				    $startSlicdAction,
				    \@buttons,
				    \@fields  );
    }

    print SE::WebUtil->createTail ();
}


sub clearMap ()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( 0 == SE::VEUI->validate ( $request, $clearMapAction,
					     $clearMapStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $clearMapAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $clearMapStr, $clearMapURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

        #usage: resetsandb -n vepair -m | [-h]
        #    where: 
        #    -h           - print usage
        #    -n <vepair>  - vepair, either v1 or v2 
        #    -m           - clear san & map files 

	my $command = "$VEUI::secfgBinDir/resetsandb"
		    # CAUTION :
		    # this command not -m for performance
		    # it uses it to delete the map 
		    . " -n $request->{$veParam}";

	if ( $request->{$mapOnlyParam} =~ "Files" )
	{
            $command .= " -m";
	}

	my $passwd = &getSavedVEPassword ();
	my $prePasswd = $ENV{VEPASSWD};
	$ENV{VEPASSWD} = $passwd ;

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );

	$ENV{VEPASSWD} = $prePasswd;
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $clearMapStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	# use &nbsp; when we need to check value
	my @maponly = ( "SAN DB Only", 
		      "SAN&nbsp;DB&nbsp;and&nbsp;Map&nbsp;Files" );

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "radio", "Clear DB Only or DB and Files:", $mapOnlyParam , \@maponly ],

	    );

	my @buttons = ( [ "NOTUSED", "Reset", $warningReset ] );

	print SE::WebUtil->createForm ( $clearMapStr,
				    $clearMapAction,
				    \@buttons,
				    \@fields  );
    }

    print SE::WebUtil->createTail ();
}


sub viewMap ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewMapAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $viewMapStr, $viewMapURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

	my $live = 0;
	my $liveFlag = "-f";

	if ( $request->{$liveParam} eq "Live" )
	{
	    $live = 1;
	    $liveFlag = "-l";
	}

	#print SE::VE->getHTMLOutput ( 
		   #"Virtualization Engine Map for $request->{$veParam}", 
		   #$request->{$veParam},
		   #"", 
		   #"",
		   #$live );

        #usage : showvemap -n <vepair_name> -f|-l
        #  where:
        #   vepair_name - is a virtualization engine pair name, v1 or v2
        #   -f - read data from file
        #   -l - read data from live configuration

	my $command = "$VEUI::secfgBinDir/showvemap"
		    # this command does not accept -m
		    . " -n $request->{$veParam}"
		    . " $liveFlag ";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $viewMapStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my $cabtype = `/opt/SUNWsecfg/bin/getcabinet`;
        if ( $cabtype == 6910 )
        {
          @veList = ("v1");
        }
        elsif ( $cabtype == 6960 )
        {
          @veList = ("v1", "v2");

        }

	my @fields;

	if ($busyStr =~ /[v]/)
	{
		my @live = ( "File" );
		

	 	@fields = ( 
	    [ "radio", $veAvailStr, $veParam , \@veList ],

	    [ "radio",  "From File or Live System:", $liveParam , \@live ],

	    [ "static", "Note: Live System Map option is"
                      . " not available due to busy ve pair(s)." ]

	    );

	}
	else
	{
		my @live = ( "File", "Live" );

        	@fields = (
            [ "static", $veInUseStr, $busyStr ],
            [ "radio", $veAvailStr, $veParam , \@veList ],

            [ "radio",  "From File or Live System:", $liveParam , \@live ],

            [ "static", "Note: Accessing Live System Map is"
                      . " time consuming." ]

            );

	}

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $viewMapStr,
				    $viewMapAction,
				    \@buttons,
				    \@fields  );
    }

    print SE::WebUtil->createTail ();
}


sub verifyMap ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $verifyMapAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $verifyMapStr, $verifyMapURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

	#USAGE 
        #usage : checkvemap -n <vepair_name>
        #where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2

	my $command = "$VEUI::secfgBinDir/checkvemap"
		    # this command does not accept -m
		    . " -n $request->{$veParam}";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $verifyMapStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    );

	my @buttons = ( [ "NOTUSED", "Verify" ] );

	print SE::WebUtil->createForm ( $verifyMapStr,
				    $verifyMapAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub restoreMap ()
{
    my ( $request ) = @_ if @_;

    # start password check
    if ( 0 == SE::VEUI->validate ( $request, $restoreMapAction,
					     $restoreMapStr ) )
    {
	return;
    }
    # end password check

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $restoreMapAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }
    
    if ( $request->{$veParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageFilesStr, $manageFilesURL ],
		      [ $restoreMapStr, $restoreMapURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$veParam} );

	#from 1.1.6
	#usage: restorevemap -n <vepair_name> 
        #       [-z -c <old_initiator> -d <new_initiator>] | [-h]
        #where: 
        #    -h                 - print usage
        #    -n <vepair_name>   - vepair, either v1 or v2 

        #    Use all of the following options to import the zone 
        #                   data from a failed
        #    initiator to a new initiator:
        #    -z                 - import zone data only 
        #    -c <old_initiator> - initiator number for the replaced component
        #    -d <new_initiator> - initiator number for the new component

	my $command = "$VEUI::secfgBinDir/restorevemap"
		    # this command does not accept -m
		    . " -n $request->{$veParam}";

	my $passwd = &getSavedVEPassword ();
	my $prePasswd = $ENV{VEPASSWD};
	$ENV{VEPASSWD} = $passwd ;

	SE::Util->execCmd ( $command, 1 );

	$ENV{VEPASSWD} = $prePasswd;
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $manageFilesStr, $manageFilesURL ],
		    );

	print SE::WebUtil->createCrumb( \@crumb, $restoreMapStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    );

	my @buttons = ( [ "NOTUSED", "Restore" ] );

	print SE::WebUtil->createForm ( $restoreMapStr,
				    $restoreMapAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub removeVLUN ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $removeVLUNAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $manageVLUNsStr, $manageVLUNsURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $removeVLUNStr );

	# DAVID_NEEDS_LIB_VE
	my ( $velist, $busyStr, $errMsg ) = &getVEs();

	if ( scalar(@$velist) == 0 )
	{
	    print "<h2>$noVEsAvailStr</h2>";
	    print "<br>$veInUseStr $busyStr";
	    print "<br><pre>$errMsg</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veInUseStr, $busyStr ],
	    [ "radio", $veAvailStr, $veParam , \@$velist ],
	    [ "hidden", $stepParam, "1a" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $removeVLUNStr,
				    $removeVLUNAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "1a" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $manageVLUNsStr, $manageVLUNsURL ]  
		    );

	print SE::WebUtil->createCrumb( \@crumb, $removeVLUNStr );

	# DAVID_NEEDS_LIB_POOLS
	my @pools = &getDiskPools ( $request->{$veParam} );

	if ( scalar(@pools) == 0 )
	{
	    print "<h2>$noPoolsForVEStr $request->{$veParam}.</h2>";
	    return;
	}

	# DAVID_NEEDS_LIB_VE
	my @singleOrRange = ( "Single", "Range" );

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],
	    [ "radio", "Disk Pool:", $poolParam, \@pools ],
	    [ "radio", "Do you want to remove a single VLUN or a range:", 
				 $rangeParam , \@singleOrRange ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $removeVLUNStr,
				    $removeVLUNAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "2" 
	    && $request->{$rangeParam} eq "Single" )
    {
	my @crumb = ( [$homeStr   , $homeURL],
		      [$manageVLUNsStr, $manageVLUNsURL ],
		      [$removeVLUNStr , $removeVLUNURL]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select VLUNs" );

	# DAVID_NEEDS_LIB_LUNS 
	my @luns = &getLUNs ( $request->{$veParam}, $request->{$poolParam} );

	if ( scalar(@luns) == 0 )
	{
	    print "<h2>$noLunsForVEStr $request->{$veParam}"
		. " on pool $request->{$poolParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "static", "Disk Pool:", $request->{$poolParam} ],
	    [ "hidden", $poolParam, $request->{$poolParam} ],

	    [ "radio", "Select VLUN to Remove:", $targetParam , \@luns ],
	    [ "hidden", $stepParam, "4rmvlun" ]
	    );

	my @buttons = ( [ "NOTUSED", "\"Remove VLUNs\"", $warning ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $removeVLUNStr,
				    $removeVLUNAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "2" 
	    && $request->{$rangeParam} eq "Range" )
    {
	my @crumb = ( [$homeStr   , $homeURL],
		      [$manageVLUNsStr, $manageVLUNsURL ],
		      [$removeVLUNStr , $removeVLUNURL]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select VLUNs" );

	# DAVID_NEEDS_LIB_LUNS 
	my @luns = &getLUNs ( $request->{$veParam}, $request->{$poolParam} );

	if ( scalar(@luns) == 0 )
	{
	    print "<h2>$noLunsForVEStr $request->{$veParam}"
		. " on pool $request->{$poolParam}.</h2>";
	    return;
	}

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "static", "Disk Pool:", $request->{$poolParam} ],
	    [ "hidden", $poolParam, $request->{$poolParam} ],

	    [ "radio", $selectStartRangeRemoveStr, $startRangeParam , \@luns ],
	    [ "hidden", $stepParam, "3endrange" ]
	    );

	my @buttons = ( [ "NOTUSED", "Next" ] );

	print SE::WebUtil->createForm ( $removeVLUNStr,
				    $removeVLUNAction,
				    \@buttons,
				    \@fields  );
    }
    elsif ( $request->{$stepParam} eq "3endrange" )
    {
	my @crumb = ( [$homeStr   , $homeURL],
		      [$manageVLUNsStr, $manageVLUNsURL ],
		      [$removeVLUNStr , $removeVLUNURL]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "Select VLUNs" );

	# DAVID_NEEDS_LIB_LUNS 
	my @luns = &getLUNs ( $request->{$veParam}, $request->{$poolParam} );

	if ( scalar(@luns) == 0 )
	{
	    print "<h2>$noLunsForVEStr $request->{$veParam}"
		. " on pool $request->{$poolParam}.</h2>";
	    return;
	}

	my @endRange = &getEndRange ( \@luns, $request->{$startRangeParam} );

	my @fields = ( 
	    [ "static", $veSelectedStr, $request->{$veParam} ],
	    [ "hidden", $veParam, $request->{$veParam} ],

	    [ "static", "Disk Pool:", $request->{$poolParam} ],
	    [ "hidden", $poolParam, $request->{$poolParam} ],

	    [ "static", $selectStartRangeRemoveStr, 
					  $request->{$startRangeParam} ],
	    [ "hidden", $startRangeParam, $request->{$startRangeParam} ],

	    [ "radio", $selectEndRangeRemoveStr, $endRangeParam , \@endRange ],

	    [ "hidden", $stepParam, "4rmvlun" ]
	    );

	my @buttons = ( [ "NOTUSED", "\"Remove VLUNs\"", $warning ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $removeVLUNStr,
				    $removeVLUNAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "4rmvlun" )
    {
	my @crumb = ( [$homeStr   , $homeURL],
		      [$manageVLUNsStr, $manageVLUNsURL ],
		      [$removeVLUNStr , $removeVLUNURL]
		    );

	print SE::WebUtil->createCrumb( \@crumb, "VLUN(s) Removed" );

	#USAGE 
	#usage : rmvlun -n <vepair_name> -v <vlun> 
        #                  [ -e <end_vlun> ] [ -V ]
	#where :
        #        vepair_name - is a virtualization engine pair name, v1 or v2
        #        vlun - is the VLUN target ID assigned by the virtualization 
        #               engine
        #               (either a single ID or if used with the -e option
        #               its used as the starting ID in the range)
        #        end_vlun - indicates a range of VLUNs are to be removed 
        #                and works with the -v option
        #         -V - verbose output

	my $command;
	my $thePool = $request->{$poolParam};
	$thePool =~ s/\(.*//g;

	if ( $request->{$targetParam} ) #single vlun
	{
	    my $theTarget = $request->{$targetParam};
	    $theTarget =~ s/\(.*//g;

	    $command = "$VEUI::secfgBinDir/rmvlun "
			. " -m" #this means don't re-validate
			. " -n $request->{$veParam}"
			. " -d $thePool"
			. " -v $theTarget"
			. " -V "; #for kelly
	}
	else #range of vluns
	{
	    my $start = $request->{$startRangeParam};
	    my $end = $request->{$endRangeParam};
	    $start =~ s/\(.*?\)//g;
	    $end =~ s/\(.*?\)//g;

	    $command = "$VEUI::secfgBinDir/rmvlun "
			. " -m" #this means don't re-validate
			. " -n $request->{$veParam}"
			. " -d $thePool"
			. " -v $start"
			. " -e $end"
			. " -V "; 
	}

	print "<h3>";
	print "Executing command : $command <br><br>";
	print "Please wait as it may take few minutes for the command to complete.<br><br>";
        print $operationResultStr;
        print $mayTimeoutStr;
	print "</h3>";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();
}


sub viewVE1Results ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewVE1ResultsAction );

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $manageVLUNsStr => $manageVLUNsURL ]
		    );
	print SE::WebUtil->createCrumb( \@crumb, $viewVE1ResultsStr );

	&viewVLUNCreateResults(1, $viewVE1ResultsURL);


    }
}


sub viewVE1ZoneResults ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewVE1ZoneResultsAction );

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {

	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr => $zoneURL ]
		    );
	print SE::WebUtil->createCrumb( \@crumb, "View the last results of Creating Zone(s) " );

	&viewZoneCreateResults(1, $viewVE1ZoneResultsURL);


    }
}


sub viewVE2Results ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewVE2ResultsAction );

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $manageVLUNsStr => $manageVLUNsURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $viewVE2ResultsStr );

	&viewVLUNCreateResults(2, $viewVE2ResultsURL);
    }
}


sub viewVE2ZoneResults ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewVE2ZoneResultsAction );

    if ( ! SE::WebUtil->checkForIndy ( 1, "69" ) )
    {
        print  $indy6900OnlyStr;
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr , $homeURL ],
		      [ $zoneStr => $zoneURL ]
		    );
	print SE::WebUtil->createCrumb( \@crumb, "View the last results of Creating Zone(s) " );

	&viewZoneCreateResults(2, $viewVE2ZoneResultsURL);
    }
}


sub viewZoneCreateResults ()
{

    my ( $venum, $refreshURL ) = @_ if @_;

    my ( $velist, $busyStr ) = &getVEs();

    my $router1;
    my $router2;

    if ($venum eq "1")
    {
        $router1 = "v1";
        $router2 = "v2";
    }
    elsif ($venum eq "2")
    {
        $router1 = "v2";
        $router2 = "v1";

    } #end of if ($venum eq "1")

    my $command = "/usr/bin/cat /tmp/se6900_$router1"."_z";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 0 );
    if ( $retVal == 0)
    {
	print $stdout;
    }
    else
    {
        print "<br>";
    }

   # my $command = "/usr/bin/cat /tmp/se6900_$router2";
   # my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 0 );
   # if ( $retVal == 0)
   # {
   #     print $stdout;
   # }
   # else
   # {
   #     print "<br>";
   # }

    print "<br></pre>";
    print "<a href=$refreshURL>$viewVErefresh</a>";

} #end of viewZoneCreateResults


sub viewVLUNCreateResults ()
{
    my ( $venum, $refreshURL ) = @_ if @_;

    my ( $velist, $busyStr ) = &getVEs();

    my $command = "/usr/bin/cat /tmp/se6900_v$venum";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 0 );
    if ( $retVal == 0)
    {
	print $stdout;
    }
    else
    {
        print "<br>No VLUN creations results were found for v$venum.<br>";
    }

    print "<br></pre>";
    print "<a href=$refreshURL>$viewVErefresh</a>";
}


sub getAllZones ()
{
    my ( $theVE,, $theInit ) = @_ if @_;


    my @zones = ();
    my @recs = ();
  
    if ( $theInit )
    {
        @recs = split ' ',
        `/opt/SUNWsecfg/bin/listvemap -z -n $theVE -c $theInit`;
    }
    else
    {
    	@recs = split ' ',
        `/opt/SUNWsecfg/bin/listvemap -z -n $theVE`;
    }


    if ( $? ) #listvemap error
    {
	splice ( @recs );
    }

    for my $z ( @recs ) 
    {
	##TODO ignore case on "undefined"
	if ( $z ne "Undefined" )
	{
	    push @zones, $z;
	}
    }

    #return @zones;
    for my $zone ( @zones )
    {
        $AllZoneList{$zone}=$zone;
    }
    Util->serialize($ALLZONELIST, \%AllZoneList);

}




sub getZones ()
{
    my ( $theVE, $theInititator ) = @_ if @_;

    #debug print "<br>DBL111:$theVE";
    #debug print "<br>DBL222:$theInititator";

    my @zones = ();

    my @recs = split ' ', 
	`/opt/SUNWsecfg/bin/listvemap -z -n $theVE -c $theInititator`;

    if ( $? ) #listvemap error
    {
	splice ( @recs );
    }

    for my $z ( @recs ) 
    {
	##TODO ignore case on "undefined"
	if ( $z ne "Undefined" )
	{
	    push @zones, $z;
	}
    }

    return @zones;
}


sub getInitiators ()
{
    my ( $theVE ) = @_ if @_;

    my @initiators = split ' ', `/opt/SUNWsecfg/bin/listvemap -i -n $theVE`;

    if ( $? ) #listvemap error
    {
	splice ( @initiators );
    }
    
    $initOne = $initiators[0];
    $initTwo = $initiators[1];

    return @initiators;
}


sub getWWNs
{
    my ( $theVE, $theInitiator ) = @_ if @_;

    my @wwns = split ' ', 
	       `/opt/SUNWsecfg/bin/listvemap -w -n $theVE -c $theInitiator`;

    if ( $? ) #listvemap error
    {
	splice ( @wwns );
    }

    return @wwns;

    #my @fakewwns = ( "29000060220041F1", "29000060220041F7" );
    #return @fakewwns;
}

sub getAliases
{
	my ( $theVE, $theInitiator ) = @_ if @_;

    my @aliases = split ' ', 
	       `/opt/SUNWsecfg/bin/listvemap -a -n $theVE -c $theInitiator`;

    if ( $? ) #listvemap error
    {
	splice ( @aliases );
    }

    return @aliases;

}

sub getAliasesByZone
{

   my ( $theVE, $theInitiator, $theZone ) = @_ if @_;

    my @aliases = split ' ', 
	       `/opt/SUNWsecfg/bin/listvemap -a -n $theVE -c $theInitiator -l $theZone`;

    if ( $? ) #listvemap error
    {
	splice ( @aliases );
    }

    return @aliases;


} #end of sub getAliasesByZone


sub getDiskPools ()
{
    my ( $theVE ) = @_ if @_;

    #debug print "<br>theve--$theVE--";

    my @pools;
    my @recs = split ' ', `/opt/SUNWsecfg/bin/listvemap -d -n $theVE`;

    if ( $? ) #listvemap error
    {
	splice ( @recs );
    }

    for my $rec ( @recs ) 
    {
	my $tmp = `/opt/SUNWsecfg/bin/getdpspace -d $rec`;

        $tmp =~ s/\n//g;

	#debug print "<br>1--$rec--";
	#debug print "<br>3--$tmp--";

	$rec =~ s/ /&nbsp;/g;
	push @pools, $rec . "(" . $tmp . "&nbsp;GB&nbsp;free)";
    }

    return @pools;
}


sub loadDPsize ()
{

  my ( $theVE ) = @_ if @_;

    #debug print "<br>theve--$theVE--";

    #my @dpsizeArr;
    my @dpools = split ' ', `/opt/SUNWsecfg/bin/listvemap -d -n $theVE`;

    if ( $? ) #listvemap error
    {
        splice ( @dpools );
    }

    for my $dpool ( @dpools )
    {
        my $tmp = `/opt/SUNWsecfg/bin/getdpspace -d $dpool`;

        $tmp =~ s/\n//g;

        $dpool =~ s/ /&nbsp;/g;
        $dpNameSize{$dpool}=$tmp;
    }
    Util->serialize($DPNAMESIZE, \%dpNameSize);

    #return %dpNameSize; 


}


sub getMultiDiskPools ()
{
    my ( $theVE, $mdp, $tot ) = @_ if @_;

    #debug print "<br>theve--$theVE--";

    my @pools;
    my $key;
    my $value;
    my $tmp;
    my $totalsize;
    my $dps = `/opt/SUNWsecfg/bin/listvemap -d -n $theVE`;
    my @recs = split ' ', `/opt/SUNWsecfg/bin/listvemap -d -n $theVE`;

    if ( $? ) #listvemap error
    {
        splice ( @recs );
    }

    if ( $mdp)
    {
	$multiDiskPoolParam = $mdp;
	$totalsize = $tot;
    }
    else
    {
	$totalsize = ($multiSizeParam * $multiCountParam);
    }


#If the dpNameSize hash table loses it's data due to the web server timeout, then
#the implementation needs to be different where the name value pairs in the hash 
#should be written to the disk (file)

    my $dpNameSize_p = Util->deserialize($DPNAMESIZE);

    for my $rec ( @recs )
    {
	if ($multiDiskPoolParam eq $rec)
	{
		$tmp = $dpNameSize_p->{$rec};
		$dpNameSize_p->{$rec} = ($tmp - $totalsize);	
        }

       # $tmp =~ s/\n//g;

    }
    Util->serialize($DPNAMESIZE, $dpNameSize_p);
   
   while(($key,$value)=each %$dpNameSize_p){
	push @pools, $key . "(" . $value . "&nbsp;GB&nbsp;free)";
   }
    return @pools;
}


sub getLUNs ()
{
    my ( $theVE, $diskPool ) = @_ if @_;

    my @luns = ();
    $diskPool =~ s/\(.*//g;

    my @recs;

    if ( $diskPool )
    {
	@recs = split ' ', 
		`/opt/SUNWsecfg/bin/listvemap -v -t $diskPool`;
    }
    else
    {
	@recs = split ' ', 
		`/opt/SUNWsecfg/bin/listvemap -v -n $theVE`;
    }

    if ( $? ) #listvemap error
    {
	splice (@recs);
    }

    for my $rec ( @recs ) 
    {
	push @luns, "$rec(" . &getLunName ($theVE, $rec) . ")";
    }
    return sort @luns;
}


sub getLunName ()
{
    my ( $theVE, $vlun ) = @_ if @_;

    #TODO:
    #This could ALL be done in PERL

    my $cmd = "/usr/bin/cat /opt/SUNWsecfg/etc/$theVE.map"
	    . " | /usr/bin/grep $vlun"
	    . " | /usr/bin/awk '{print \$5}'";

    my $name = `$cmd`;

    $name =~ s/\n//;

    return $name
}


#
# 1st arg VE required
# 2nd arg DispkPool optional
#
sub getLUNs_ORIG ()
{
    my ( $theVE, $diskPool ) = @_ if @_;

    my @luns = ();
    $diskPool =~ s/\(.*//g;

    my $data = SE::VE->getSystemData ( $theVE );

    my @recs = SE::VE->enumerate ( 
		       $SE::VE::VLUN,
		       $theVE,
		       $data );

    for my $rec ( @recs ) 
    {
	my @crecs = SE::VE->get_entry ( $SE::VE::VLUN,
					    $theVE,
					    'aname',
					    $rec,
					    $data );

	for my $r ( @crecs ) 
	{
	    #DEBUG_ARIEH print "<br>t--$r->{bdisk_pool}--t";
	    #print "<br>t--$r->{aname}--t";
	    #print "<br>pool1--$r--";
	    #print "<br>pool--" . scalar ( @crecs ) . "--";

	    if ( $diskPool )
	    {
		if ( $r->{aname} eq $diskPool )
		{
		    push @luns, "$$r{dvlun_target}($$r{evlun_name})";
		}
	    }
	    else
	    {
		push @luns, "$$r{dvlun_target}($$r{evlun_name})";
	    }
	}
    }
    return @luns;
}


##
## Special values of $zone1 = FREE_ON_(initiator)
##                            FREE_ON_$request->{$initParam}
## indicate luns with no zone for that initiaotr
##
sub getLUNsByZone ()
{
    my ( $theVE, $zone1, $zone2 ) = @_ if @_;

    my @luns = ();

    my $data = SE::VE->getSystemData ( $theVE );

    my @recs = SE::VE->enumerate ( 
		       $SE::VE::VLUN,
		       $theVE,
		       $data );

    #debug print "<br>cc = @recs";
    #debug print "<br>cc = " . scalar(@recs);

    for my $rec ( @recs ) 
    {
	my @crecs = SE::VE->get_entry ( $SE::VE::VLUN,
					    $theVE,
					    'aname',
					    $rec,
					    $data );


	for my $r ( @crecs ) 
	{
	    #debug print "<br>dblz1 = $r->{gslic_zones}";

	    if ( $zone1 =~ $freeOnInit )
	    { 
		    #debug print "<br>first : $r->{gslic_zones}";
		if ( $r->{gslic_zones} !~ "," 
		     || $r->{gslic_zones} eq "-"  )
		{
		    push @luns, "$$r{dvlun_target}($$r{evlun_name})";
		}
	    }
	    elsif ( ! $zone2 )
	    {
		    #debug print "<br>second : $r->{gslic_zones}";
		if ( $r->{gslic_zones} =~ $zone1 )
		{
		    push @luns, "$$r{dvlun_target}($$r{evlun_name})";
		}
	    }
	    else
	    {
		    #debug print "<br>third : $r->{gslic_zones}";
		if ( $r->{gslic_zones} =~ $zone1
		     && $r->{gslic_zones} =~ $zone2 )
		{
		    push @luns, "$$r{dvlun_target}($$r{evlun_name})";
		}
	    }
	}
    }

    return sort @luns;
}


#
# if arg is true it will return hosts (ie. v1a, v1b, v2a, v2b)
# otherwise (default) it will return pairs (ie. v1, v2 )
#
sub getVEs ()
{
    my ( $hostsFlag, $opt ) = @_ if @_;
    my @velist;
    my $cmdOut;
    my $errMsg;
    my @tmplist;
    my $busyStr;

    if ( $hostsFlag )
    {
	$cmdOut = `/opt/SUNWsecfg/bin/listvemap -h`;

	#if ( $cmdOut eq " " ) # must be busy
	#{
	    #$cmdOut = `/opt/SUNWsecfg/bin/listvemap -h`;
	#}

	@tmplist = split ' ', $cmdOut;
    }
    else
    {
	$cmdOut = `/opt/SUNWsecfg/bin/listvemap -r`;
	@tmplist = split ' ', $cmdOut;
    }

    if ( $? ) #listvemap error
    {
	splice ( @tmplist );
	$errMsg = $cmdOut . "\nCheck power and ethernet connectivity.";
    }

    #check locks
    for my $item ( @tmplist ) 
    {
	#for some reason the item(s) seem to have a new-line
	$item =~ s/\n//;

	#because the "item" may be "v1a" or "v1b" remove the "a|b"
	#before checking for lockfile
	my $pairItem = $item;

	$pairItem =~ s/a//;
	$pairItem =~ s/b//;

	#debug print "Item = $pairItem";

	if ( -f "/opt/SUNWsecfg/etc/.$pairItem.lock" )
	{
	    $busyStr .= " $item ";
	}
	else
	{
	    push @velist, $item;
	}
    }

    if ( $opt )
    {
	    push @velist, "ALL";
    }

    return ( \@velist, $busyStr, $errMsg );
}


# truncates list and returns from "value" on
sub getEndRange ()
{
    my ( $listRef, $value ) = @_ if @_;

    my @list = @$listRef;

    #print "list ";
    #print @list;
    #print " val ";
    #print $value;

    my $add = 0;
    my @endRange;

    for my $item ( @list ) 
    {
	#print $item;
	if ( $item eq $value )
	{
	    $add = 1;
	}
	push @endRange, $item if $add;
    }

    return @endRange;
}


sub getSavedVEPassword ()
{
    my $fh = new FileHandle;
    my $buf = '';
    open ( $fh, $passFileName );
    while ( <$fh> )
    {
	$buf .= $_;
    }
    $fh->close;

    #print " getsaved: $buf ";
    ## Special treatment of blank password
    if ( $buf eq "\"\"" )
    {
	return "";
    }

    return $buf;
}


sub saveVEPassword ()
{
    my ( $passwd ) = @_ if @_;

    unlink ( $passFileName );

    sysopen ( FH, $passFileName, O_WRONLY|O_CREAT, 0600 )
	      or die "Could not save password";

    print FH $passwd;
    close FH;
}


# return 1 if valid
#IMPORTANT IT MUST BE CALLED with "SE::VEUI->validate"
sub validate ( )
{
    my ( $self )  = @_ if @_;

    my $printIndyMsg = 1;
    my $isPasswordValid = 0;
    my $vePassword;

    if ( "SE::VEUI" eq $self )
    {
	$self = shift;
        $printIndyMsg = 0;

    }
    my ( $request, $action, $msg ) = @_ if @_; #MUST BE AFTER SHIFT;

    #TRICKY CODE, apparently Http.pm must have changed to pass 2
    #params and action gets an invalid value so I need to clear it out
    if ( $action =~ /^GO/ )
    {
	$action = $validateAction;
    }

    my @crumb = ( [ $homeStr , $homeURL ] );

    if ( !SE::WebUtil->checkForIndy ( 0, "39|69" ) )
    {
	if ( $printIndyMsg )
	{
	    print SE::WebUtil->createHead ();
	    print SE::WebUtil->createStorAdeHeader ( $validateAction );
	    print SE::WebUtil->createCrumb( \@crumb, $validateStr );
            SE::WebUtil->checkForIndy ( 1, "39|69" ); #call again to print
	}
	return 1;#ok to return true because fucntionality is not present
    }

    if ( $request->{clear} eq "true" )
    {
	unlink ( $passFileName );
    }

    if ( 0 == $isPasswordValid ) #cache for performance
    {
	## Special treatment of blank password
	if ( ! $request->{$pswdParam} && ( $request->{clear} ne "true" ) )
	{
	    $request->{$pswdParam} = "\"\"";
	}

	#DOES NOT WORK $ENV{VEPASSWD} = $request->{$pswdParam};
	my $command = "$VEUI::secfgBinDir/checkvepw $request->{$pswdParam}";

	my $retString = `$command`;

	if ( $? == 0 ) 
	{
	    $vePassword = $request->{$pswdParam};
	    $isPasswordValid = 1;

	    &saveVEPassword ( $request->{$pswdParam} );
	}
	else # check file
	{
	    my $buf = &getSavedVEPassword ();

	    if ( $buf ) 
	    {
		#DOES NOT WORK $ENV{VEPASSWD} = $buf;
		my $cmd3 = "$VEUI::secfgBinDir/checkvepw $buf";
		my $retString = `$cmd3`;

		#TODO possible bug return is 256 on success
		#NEWINFO This used to be a proeblem
		#    for some reason we are not getting 256
		#    anymore so I will ingnore it.
		if ( $? == 0 ) # || $? == 256 ) 
		{
		    $vePassword      = $buf;
		    $isPasswordValid = 1;
		}
	    }
	}
    }

    # if invalid display the page for the user to enter the password
    if ( 0 == $isPasswordValid )
    {
	my $cmdOut = `/opt/SUNWsecfg/bin/listvemap -h`;

	if ( $? ) #listvemap error
	{
	    #if no ve's return true; no need to validate
	    return 1;
	}
	elsif ( -f "/opt/SUNWsecfg/etc/.v1.lock"  )
	{
	    return 1;
	}


	print SE::WebUtil->createHead ();
	print SE::WebUtil->createStorAdeHeader ( $validateAction );
	print SE::WebUtil->createCrumb( \@crumb, $validateStr );

	if ( $action eq "" )
	{
	    $action = $validateAction;
	}

	if ( $msg && ( $action ne $validateAction ) )
	{
	    print "<br>You must enter the Virtualization Engine Password in "
		. " order to invoke: <b>$msg</b><br>";
	}

	if ( $request->{anothertry} )
	{
	    print "<br><b>Incorrect password, please try again.</b>";
	    print "  If this problem persists check network connectivity"
		. " to the device.";
	}

	my @fields = ( 
	    [ "password", "Virtualization Engine password:", 
	      $pswdParam, "", "10", "10" ],
	    [ "static", "<b>NOTE :</b> ", "Setting the password will not actually update the password on the<br>Virtualization Engine itself but is only to be used by the commands<br>executed during the GUI session." ],
	    [ "hidden", "anothertry", "true" ]
	    );

	my @buttons = ( [ "Continue", "\"Save Continue\"" ] );
	my %opts = ( "method" => "get" );

	####IMPORTANT THIS FORM MUST USE "get" METHOD
	print SE::WebUtil->createForm ( $validateStr, 
				    $action,
				    \@buttons,
				    \@fields,
				    \%opts );

	print SE::WebUtil->createTail ();
    }
    elsif ( $action eq "" )
    {
	print SE::WebUtil->createHead ();
	print SE::WebUtil->createStorAdeHeader ( $validateAction );
	print SE::WebUtil->createCrumb( \@crumb, $validateStr );

	print "<h2>The password you entered is valid.</h2>";

	#print "<a href=$validateURL&clear=true>Clear Password</a>";

	print "\n<form>";

	#print "\n<input type=submit"
	#    . " value=\"Clear Password\" name=delit >";

	## Use "button" because on private netowrk
	## master/slaves the submit does not work on the slave.
	print "\n<input type=button"
	    . " value=\"Clear Password\""
	    . " onClick='document.location=\"$validateURL&clear=true\"' >";

	print "<input type=hidden name=clear"
	    . " value=true >";

	print "<input type=hidden name=GO"
	    . " value=$validateAction >";

	print "\n</form>";

	print SE::WebUtil->createTail ();
    }

    return $isPasswordValid;
}

sub sideMenu ()
{

    my @menu = (  [ "SE Home" , "/seTop.html", "bottom" ],
		  [ $manageVLUNsStr , $manageVLUNsURL, "detail" ],
		  [ $zoneStr , $zoneURL, "detail" ],
		  [ $manageFilesStr , $manageFilesURL, "detail" ],
		  [ $manageHostsStr , $manageHostsURL, "detail" ],
		  [ $viewMapStr , $viewMapURL, "detail" ]
		);

    print SE::WebUtil->createSideMenu ( "StorEdge 3900/6900 VE Section",
					     \@menu );
}


#listvemap usage:
#
#    listvemap -r ---- lists the virtualization engine pairs (Ex:- v1,v2)
#    listvemap -h --- lists all the router hosts (Ex:- v1a,v1b,v2a,v2b)
#    listvemap -i -n <ve_pair_name> ---- lists the initiator names
#    listvemap -d -n <ve_pair_name> ---- lists the diskpools per 
#                                        virtualization engine pair
#    listvemap -d -t <t3name> ---- lists the diskpools per t3
#    listvemap -z -n <ve_pair_name> -c <initiator_name> --- lists zones 
#    listvemap -z -n <ve_pair_name> -l <vlun_targetID> --- lists all the 
#                                       zones per ve pair to which this 
#                                       vlun belongs to 
#    listvemap -v -n <ve_pair_name> -c <initiator_name> -l <zone_name> 
#                                    -- lists vluns per zone
#    listvemap -v -t <diskpool_name> -- lists vluns per diskpool
#    listvemap -v -n <ve_pair_name>  -- lists all the vluns 
#    listvemap -v -o -n <ve_pair_name> -- lists all the vluns 
#                                       that belong to one zone or no zone 
#    listvemap -w -n <ve_pair_name> -c <initiator_name> 
#                                    -- lists the unaliased hosts WWN numbers




1;

