#
# SCCS Info:      pragma ident   "@(#)Util.pm 1.2     02/03/22 10:45:27 SMI"
#
#  Copyright (c) 2001 Sun Microsystems, Inc, All Rights Reserved.
#
#  Perl Module for Virtualization Engine
#
#  This module serves as the main library utility for functions that
#  operate on the Virtualization Engine for the Indy.
#
#  The module also supports functions that can parse the VE output.
#
package SE::Util;

use Exporter;
use strict;

@Util::ISA	= qw(Exporter);
@Util::EXPORT	= qw( execCmd );
$Util::VERSION	= 1.00;

#use FileHandle;
use IPC::Open3;
use IO::Select;
use CGI::Carp;

my $Name = 'SE::Util';

sub execCmd2 {
    my ($class, $cmd, $printFlag ) = @_;

    my($l, $out, $err, $rc);

    if ( ! defined $cmd ) {
        return ( 255, 'missing command', '' );
    }
    my $errfile = "/tmp/execCmd2.$$";

    open(O, "$cmd 2>$errfile|");
    while ($l = <O>) {
       $out .= $l;
    }
    close(O);
    my $rc = $? >> 8;

    if (open(ERR, $errfile)) {
       while ($l = <ERR>) {
            $err .= $l;
       }
       close(ERR);
       unlink $errfile;
    }
    if ( $printFlag ) {
        printCmdAll ( $cmd, $rc, $out, $err);
    }
    return ( $rc, $out, $err);
}


#
#  Input Arguments:	$cmd	the command to execute
#
#  Return Value:	a list with 3 elements:
#			    1. the completion status of the command
#			    2. the output generated on stdout
#			    3. the output generated on stderr
#
#
sub execCmd {

    my $class = shift if ( $_[0] eq $Name );

    my ( $cmd, $printFlag ) = @_ if @_;

    if ( ! defined $cmd ) {
	return ( 255, 'missing command', '' );
    }

    my @args = split /\s/, $cmd;
    
    my $execPath = $args[0];

    #if ( -x $execPath) {

        #kludge: An invalid command "stty" is added to the command
        #        to force the flush of the buffers.  This is an interaction
        #        problem between bash and ksh.
	$cmd = "/usr/bin/stty;" . $cmd;
	my $childpid = open3 ( *IN, *OUT, *ERR, $cmd )
		or croak "${Name}::exeCmd: Unable to execute $cmd $!\n";
	my $s = IO::Select->new();

	$s->add ( *OUT, *ERR );

	my $outgen = '';
	my $errgen = '';

	my $exitstat = 0;

	# No benefit
	#autoflush IN;
	#autoflush OUT;
	#autoflush ERR;

	$SIG{CHLD} = sub {
	    $exitstat = ($? >> 8) if waitpid ( $childpid, 0 ) > 0;
	};

	#THIS IS NECESSARY DON'T KNOW HOW IT COULD WORK W/O it.
	#In particular "showvemap" seems to need it.!!!!

	# waitpid ( $childpid, 0 );
	# kludge
	sleep ( 5 );

	while ( my @ready = $s->can_read ) {

	    foreach my $fh ( @ready ) {

		if ( fileno ( $fh ) == fileno ( OUT ) ) {
		    $outgen .= scalar ( <OUT> );
		}

		elsif ( fileno ( $fh ) == fileno ( ERR ) ) {
		    $errgen .= scalar ( <ERR> );
		}

		$s->remove ( $fh ) if eof ( $fh );
	    }
	}
	# Last line flush
	$outgen .= scalar ( <OUT> );
	$errgen .= scalar ( <ERR> );

	close ( IN );
	close ( OUT );
	close ( ERR );

	if ( $printFlag )
	{
	    printCmdAll ( $cmd, $exitstat, $outgen, $errgen );
	}

	return ( $exitstat, $outgen, $errgen );
    #}

}

sub printCmdAll ()
{
    my $class = shift if ( $_[0] eq $Name );

    my ( $cmd, $exitstat, $outgen, $errgen ) = @_ if @_;

    $cmd =~ s/\/usr\/bin\/stty\;//;
    print "<br><h3>Command executed:</h3><br>";
    print "<pre>";
    print "$cmd";
    print "</pre>";
    print "<br><h3>Command returned (stdout):</h3><br>";
    print "<pre>";
    print "$outgen";
    print "</pre>";
    print "<br><h3>Command returned (stderr):</h3><br>";
    print "<pre>";
    # filter out the invalid command
    $errgen =~ s/stty: : Invalid argument//;
    print "$errgen";
    print "</pre>";
    print "<br><h3>Command returned exit value: $exitstat</h3><br>";
}


sub execCmdBG ()
{
    my $class = shift if ( $_[0] eq $Name );

    my ( $cmd, $printFlag, $secondMsg ) = @_ if @_;

    my $pid;

    if ( $pid = fork )
    {
	## PARENT
	#print "parenthere$pid";

	if ( $printFlag )
	{
	    print "<h2>This command has been started"
		. " in the background.</h2>";
		#NO EASY WAY OF GETTING REAL PID  
		#. " in the background PID:$pid</h2>";
	    print "<br>";
	    print "<br><h3>Command executed:</h3><br>";
	    print "<pre>";
	    print "$cmd";
	    print "</pre>";
	    print "<h2>";
	    print $secondMsg;
	    print "</h2>";
	}

	close(STDIN); close(STDOUT); close(STDERR);
	#exit;
    }
    else
    {
	## CHILD
	# KEY STEP if we don't close stdout the parent waits for child
	close(STDIN); close(STDOUT); close(STDERR);

	#setgpid ( 1 );
	my $retStr = `$cmd`;
	#exit;
    }
}

sub execCmdBGOutputToFile ()
{
    my $class = shift if ( $_[0] eq $Name );

    my ( $cmd, $printFlag, $link, $outFileHead ) = @_ if @_;

    my $pid;
    #my $parentpid = getppid();
    #my $outfilename = "se6900_$outFileHead.$parentpid";
    my $outfilename = "se6900_$outFileHead";

    # clear file and save command:
    my $startCmd = "/usr/bin/echo \"<br><h3>Command executed:</h3><br>"
		 . "<pre>$cmd</pre>"
		 . "<b>This command was started on: `/usr/bin/date`</b>"
		 . "<h3>Output:</h3>\" > /tmp/$outfilename";

    `$startCmd`;

    if ( $pid = fork )
    {
	## PARENT
	#print "parenthere$pid";

	if ( $printFlag )
	{
	    print "<h2>This command has been started"
		. " in the background.</h2>";
		#NO EASY WAY OF GETTING REAL PID  
		#. " in the background PID:$pid</h2>";
	    print "<br>";
	    print "<br><h3>Command executed:</h3><br>";
	    print "<pre>";
	    print "$cmd";
	    print "</pre>";
	    print "<br>";
	    print "<a href=$link> View the Results";
	    print "</a>";
	}

	close(STDIN); close(STDOUT); close(STDERR);
	#exit;
    }
    else
    {
	## CHILD
	# KEY STEP if we don't close stdout the parent waits for child
	close(STDIN); close(STDOUT); close(STDERR);

	#setgpid ( 1 );

	`/usr/bin/echo "<pre>" >> /tmp/$outfilename`;
	my $retStr = `$cmd >> /tmp/$outfilename 2>&1`;

	`/usr/bin/echo "</pre>" >> /tmp/$outfilename`;

	my $date = `/usr/bin/date`;
	
	my $finishCmd = "/usr/bin/echo \"<b>This command"
	     . " completed on: $date</b>\" >> /tmp/$outfilename";

	`$finishCmd`;

	#exit;
    }
}

1;
__END__

=head1 NAME

SE::Util - Perl Module with Utilities for SExx00 Management

=head1 SYNOPSIS

Utility Functions for the Configuration of the Indy Platform.

=head1 DESCRIPTION

The C<Util> module supplies subroutines to be used by the storage management
perl modules.

=head1 OVERVIEW OF SUBROUTINES

The subroutines exposed address the generality of executing management
commands.

=head2 B<execCmd ()>

Syntax:

	( $ret, $stdout, $stderr ) = execCmd ( $cmd );

The subroutine will invoke the B<cmd> passed as an argument and capture
the results of the execution.

=head1 AUTHOR

Arieh Markel

=cut

