#
# SCCS Info:      pragma ident   "@(#)SWUI.pm 1.22     02/05/16 14:54:14 SMI"
#
#  Copyright (c) 2001 Sun Microsystems, Inc, All Rights Reserved.
#
#  Perl Module for SE Switch UI
#
package SE::SWUI;

use lib qw ( /opt/SUNWstade/lib );
use strict;
#use SE::SW;
use SE::T3UI;
use SE::Util;
use SE::WebUtil;

my $webproc = "rashttp.2";

my $boxtype = "bt";

my $SEConfigStr = "SE Config Home";
#my $homeStr = "Switch Config";
#my $homeURL = "/seSWWelcome.html";
my $homeStr = "Sun StorEdge Series Config";
my $homeURL = "/$webproc?GO=GUI::SE::index";

my $dispStr    = "Display Switch Config";
my $dispAction = "SE::SWUI::dispConfig";
my $dispURL    = "/$webproc?GO=" . $dispAction;

my $saveStr = "Save Switch Config";
my $saveAction  = "SE::SWUI::saveConfig";
my $saveURL  = "/$webproc?GO=" . $saveAction;

my $restoreStr = "Restore Switch Config";
my $restoreAction  = "SE::SWUI::restoreConfig";
my $restoreURL  = "/$webproc?GO=" . $restoreAction;

my $verifyStr = "Verify Switch Config";
my $verifyAction  = "SE::SWUI::verifyConfig";
my $verifyURL  = "/$webproc?GO=" . $verifyAction;

my $configStr = "Set Switch Config";
my $swSetConfigStr = "\"Set Config\"";
my $swConfiguringSW = "Configuring Switch ";
my $configAction = "SE::SWUI::setConfig";
my $configURL = "/$webproc?GO=" . $configAction;

my $downloadStr = "Download Switch Flash";
my $swDefaultFFStr = "Use default flash file?";
my $swDownloadFlashStr = "\"Download Flash\"";
my $swDownloadingStr = "Downloading Switch Firmware ";
my $downloadAction = "SE::SWUI::downloadFirmware";
my $downloadURL = "/$webproc?GO=" . $downloadAction;

my $true=1;
my $false=0;

my $swParam = "sw";
my $swFlashFileParam = "flash_file";
my $swDefaultFlashFileParam = "default_ff";
my @yesno = ( "yes", "no" );
my $stepParam = "step";
my $realSystem = $true;

my $viewSWFlashResultsStr    = "View the last results of Set Switch Flash";
my $viewSWFlashResultsAction = "SE::SWUI::viewSWFlashResults";
my $viewSWFlashResultsURL    = "/$webproc?GO=" . $viewSWFlashResultsAction;

my $swSwitchSelection = "StorEdge 3900/6900 Switch Section";
my $swSelectedStr = "Switch selected:";
my $swAvailStr = "Switch(es) available:";
my $swInUseStr = "Switch(es) in use:";
my $swDefaultStr = "Default";

my $portTLModeStr = "Set Switch Port TL Mode";
my $tLModeStr = "Port TL Mode: ";
my @tlOnOff = ( "on", "off" );
my $setPortTLModeStr = "\"Set Port TL Mode\"";
my $portTLModeAction = "SE::SWUI::portTLMode";
my $portTLModeURL = "/$webproc?GO=" . $portTLModeAction;
my $tlModeParam = "tlmode";

my $portFModeStr = "Set Switch Port F Mode";
my $fModeStr = "Port F Mode: ";
my @fOnOff = ( "on", "off" );
my $setPortFModeStr = "\"Set Port F Mode\"";
my $portFModeAction = "SE::SWUI::setSwitchF";
my $portFModeURL = "/$webproc?GO=" . $portFModeAction;
my $fModeParam = "fmode";
my $fPortNum = "portnum";

my $modSwitchStr = "Modify Switch Zones: ";
my $modSwitchAction = "SE::SWUI::modifySwitchZones";
my $modSwitchURL = "/$webproc?GO=" . $modSwitchAction;

my $TLPortNum = "portnum";
my $TLPortNote = "Please enter a comma seperated list of port numbers that are connected to hosts<br> (i.e. even port numbers such as 2,6,8 or the string 'all')  ";

my $boxtypeParam = "btp";
my $chassisIDParam = "chassis";
my $hardZoneIDParam = "hardzone";

my $chassisIDStr = "Chassis ID ranging between 1 - 63:";
my $chassisIDNoteStr = "Note: The default Chassis IDs are sw1a:1 sw1b:2 sw2a:3 sw2b:4 .";
my $chassisIDAllNoteStr = " The Chassis ID number you enter will be assiged "
			. " to the first switch and each"
			. " additional switch will get an incremented value.";
my $hardZoneIDStr = "Hard Zone number ranging between ";
my $hardZoneIDNoteStr = "Note: The default Hard Zone is: 1";

my $warning = "Modifying the switch configuration may disrupt traffic."
	    . "  Do you want to continue?";

my $multiParam = "multi";
my $zoneParam = "zp";
my $portParam = "pp";

my $modSwitchZoneFile;

$SWUI::secfgBinDir = "/opt/SUNWsecfg/bin";

my $allStr = "All";
my %portList;
my %ZONES = (1,'',2,'',3,'',4,'',5,'',6,'',7,'',8,'',9,'',10,'',11,'',12,'',13,'',14,'',15,'',16,'');
my $key = "test";
my $swfile = "tt";
my $SWI1 = "1";
my $SWI2 = "2";
my $SWI3 = "3";
my $SWI4 = "4";
my $SWI5 = "5";
my $SWI6 = "6";
my $SWI7 = "7";
my $SWI8 = "8";
my $SWI9 = "9";
my $SWI10 = "10";
my $SWI11 = "11";
my $SWI12 = "12";
my $SWI13 = "13";
my $SWI14 = "14";
my $SWI15 = "15";
my $SWI16 = "16";

my $indy3900OnlyStr = "<h2>This command can only be run on a"
                    . " Sun StorEdge 3910 or 3960 system.</h2>";



sub viewSWFlashResults ()
{

    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $viewSWFlashResultsAction );



    my @crumb = ( [ $homeStr , $homeURL ],
		  [ $downloadStr => $downloadURL ]
                );
    print SE::WebUtil->createCrumb( \@crumb, $viewSWFlashResultsStr );

    &viewFlashResults(1, $viewSWFlashResultsURL);

} #end of viewSWFlashResults


sub viewFlashResults ()
{

my ( $num, $refreshURL ) = @_ if @_;


    my $command = "/usr/bin/cat /tmp/se6900_AllSWFlash";
    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 0 );
    if ( $retVal == 0)
    {
        print $stdout;
    }
    else
    {
        print "<br>No flash info was found for All Switches <br>";
    }

    print "<br></pre>";
    print "<a href=$refreshURL>Refresh</a>";

} #end of viewFlashResults


sub dispConfig
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $dispAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }
    
    if ( $request->{$swParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $dispStr, $dispURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$swParam} );

	#print "html table will go here for $request->{$swParam}";

	#print SE::SW->getHTMLOutput ( 
			   #" for $request->{$swParam}", 
			   #$request->{$swParam} );

	my $command;
	
	if ( $request->{$swParam} eq $allStr )
	{
	    #my ( $switches, $busyStr ) = &getSwitches ();
	    my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

	    if ( $errStr )
	    {
		print "<pre>$errStr</pre>";
		return;
	    }

	    for my $tmp ( @$switches )
	    {
		$command = "$SWUI::secfgBinDir/showswitch"
		    . " -s $tmp";

		if ( $tmp ne $allStr )
		{
		    SE::Util->execCmd ( $command, 1 );
		}
	    }
	}
	else
	{
	    $command = "$SWUI::secfgBinDir/showswitch"
		    . " -s $request->{$swParam}";
		    
	    SE::Util->execCmd ( $command, 1 );
	}

    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $dispStr );

	#my ( $switches, $busyStr ) = &getSwitches ();
	my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

	if ( $errStr )
	{
	    print "<pre>$errStr</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $swInUseStr, $busyStr ],
	    [ "radio",  $swAvailStr, $swParam, \@$switches ],
	    );

	my @buttons = ( [ $dispStr, $dispStr ] );

	print SE::WebUtil->createForm ( $dispStr,
				    $dispAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub saveConfig
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $saveAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
        return;
    }
  
    if ( $request->{$swParam} )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $saveStr, $saveURL ]
                    );
        print SE::WebUtil->createCrumb( \@crumb, $request->{$swParam} );

        #print "html table will go here for $request->{$swParam}";

        #print SE::SW->getHTMLOutput (
                           #" for $request->{$swParam}",
                           #$request->{$swParam} );

        my $command;

        if ( $request->{$swParam} eq $allStr )
        {
            #my ( $switches, $busyStr ) = &getSwitches ();
            my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

            if ( $errStr )
            {
                print "<pre>$errStr</pre>";
		return;
            }
            for my $tmp ( @$switches )
            {
                $command = "$SWUI::secfgBinDir/saveswitch -v -m"
                                    . " -s $tmp";

                if ( $tmp ne $allStr )
                {
                    SE::Util->execCmd ( $command, 1 );
                }
            }
        }
        else
        {
            $command = "$SWUI::secfgBinDir/saveswitch -v -m"
                    . " -s $request->{$swParam}";

            SE::Util->execCmd ( $command, 1 );
        }

    }
    else
    {
        my @crumb = ( [ $homeStr, $homeURL ] );
        print SE::WebUtil->createCrumb( \@crumb, $saveStr );

        #my ( $switches, $busyStr ) = &getSwitches ();
        my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

        if ( $errStr )
        {
            print "<pre>$errStr</pre>";
	    return;
        }

        my @fields = (
            [ "static", $swInUseStr, $busyStr ],
            [ "radio",  $swAvailStr, $swParam, \@$switches ],
            );

        my @buttons = ( [ $saveStr, $saveStr ] );

        print SE::WebUtil->createForm ( $saveStr,
                                    $saveAction,
                                    \@buttons,
                                    \@fields );
    }

    print SE::WebUtil->createTail ();

} #end of subroutine saveConfig


sub restoreConfig
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $restoreAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
        return;
    }
  
    if ( $request->{$swParam} )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $restoreStr, $restoreURL ]
                    );
        print SE::WebUtil->createCrumb( \@crumb, $request->{$swParam} );

        #print "html table will go here for $request->{$swParam}";

        my $command;

        if ( $request->{$swParam} eq $allStr )
        {
            my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

            if ( $errStr )
            {
                print "<pre>$errStr</pre>";
		return;
            }
            for my $tmp ( @$switches )
            {
                $command = "$SWUI::secfgBinDir/restoreswitch -v -m"
                                    . " -s $tmp";

                if ( $tmp ne $allStr )
                {
                    SE::Util->execCmd ( $command, 1 );
                }
            }
        }
        else
        {
            $command = "$SWUI::secfgBinDir/restoreswitch -v -m"
                    . " -s $request->{$swParam}";

            SE::Util->execCmd ( $command, 1 );
        }

    }
    else
    {
        my @crumb = ( [ $homeStr, $homeURL ] );
        print SE::WebUtil->createCrumb( \@crumb, $restoreStr );

        my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

        if ( $errStr )
        {
            print "<pre>$errStr</pre>";
	    return;
        }

        my @fields = (
            [ "static", $swInUseStr, $busyStr ],
            [ "radio",  $swAvailStr, $swParam, \@$switches ],
            );

        my @buttons = ( [ $restoreStr, $restoreStr ] );

        print SE::WebUtil->createForm ( $restoreStr,
                                    $restoreAction,
                                    \@buttons,
                                    \@fields );
    }

    print SE::WebUtil->createTail ();

} #end of subroutine restoreConfig


sub verifyConfig ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $verifyAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$swParam} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $verifyStr, $verifyURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $request->{$swParam} );

	# USAGE
        #usage : checkswitch -s <switch_name> 
        #        [-c <sys_config_type> [ -f ] ] [ -v ]
        #where :
        #   switch_name - as defined in /etc/hosts file.
        #   sys_config_type - Sun StorEdge system type, which can be one of:
        #                     3910, 3960, 6910, 6960
        #   -f - force config, don't validate sys_config_type specified.
        #   -v - verbose option, messages go to stdout as well as log file.

	my $boxtype = SE::WebUtil->getHostIndyModelViaStorAde ();
	$boxtype =~ s/\n//;

	my $command;
	my $pArg;
	
	if ( $request->{$multiParam} eq "Yes" )
	{
		$pArg = "-p";
	}	
	else
	{
		$pArg = "";
	}

	if ( $request->{$swParam} eq $allStr )
	{
	    #my ( $switches, $busyStr ) = &getSwitches ();
	    my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

	    if ( $errStr )
	    {
		print "<pre>$errStr</pre>";
		return;
	    }

	    for my $tmp ( @$switches )
	    {
		$command = "$SWUI::secfgBinDir/checkswitch"
		    . " -s $tmp"
		    . " -c $boxtype"
		    . " -v -f $pArg";

		if ( $tmp ne $allStr )
		{
		    SE::Util->execCmd ( $command, 1 );
		}
	    }
	}
	else
	{
	    $command = "$SWUI::secfgBinDir/checkswitch"
		    . " -s $request->{$swParam}"
		    . " -c $boxtype"
		    . " -v -f $pArg";
		    
	    my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
	}
    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $verifyStr );

	#my ( $switches, $busyStr ) = &getSwitches ();
	my ( $switches, $busyStr, $errStr ) = &getSwitches ();

	if ( $errStr )
	{
	    print "<pre>$errStr</pre>";
	    return;
	}

        my @multiparam = ( "Yes", "No , Compare against factory defaults" );

	my @fields = ( 
	    [ "static", $swInUseStr, $busyStr ],
	    [ "radio",  $swAvailStr, $swParam, \@$switches ],
	    [ "radio",  "Compare current config to saved map file:", $multiParam, \@multiparam ],
	    );

	my @buttons = ( [ $verifyStr, $verifyStr ] );

	print SE::WebUtil->createForm ( $verifyStr,
				    $verifyAction,
				    \@buttons,
				    \@fields );
    }

    print SE::WebUtil->createTail ();
}


sub setConfig ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $configAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $configStr );

	#my ( $switches, $busyStr ) = &getSwitches ();
	my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

	if ( $errStr )
	{
	    print "<pre>$errStr</pre>";
	    return;
	}

	my $boxtype = SE::WebUtil->getHostIndyModelViaStorAde ();
	$boxtype =~ s/\n//;

	my @fields;
	my @buttons;

	if ( ! SE::WebUtil->checkForIndy ( 0, "69" ) )
	{
	    @fields = ( 
	    [ "static", $swInUseStr, $busyStr ],
	    [ "radio",  $swAvailStr, $swParam, \@$switches ],
	    [ "hidden", $boxtypeParam, $boxtype ],
	    [ "hidden", $stepParam, "3setupswitch" ] #do it on a 3900
	    );
	    @buttons = ( [ $swDefaultStr, $swSetConfigStr, $warning ] );
	}
	else
	{
	    @fields = ( 
	    [ "static", $swInUseStr, $busyStr ],
	    [ "radio",  $swAvailStr, $swParam, \@$switches ],
	    [ "hidden", $boxtypeParam, $boxtype ],
	    [ "hidden", $stepParam, "2setupswitch" ] #go to extra info page
	    );
	    @buttons = ( [ $swDefaultStr, "Next" ] );
	}

	print SE::WebUtil->createForm ( $configStr,
				    $configAction,
				    \@buttons,
				    \@fields );
    }
    elsif ( $request->{$stepParam} eq "2setupswitch" )
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $configStr );

	my ( $chassis, $zoneRangeStr );

	if ( "sw1a" eq $request->{$swParam} || $allStr eq $request->{$swParam} )
	{
	    $chassis = "1";
	}
	elsif ( "sw1b" eq $request->{$swParam} )
	{
	    $chassis = "2";
	}
	elsif ( "sw2a" eq $request->{$swParam} )
	{
	    $chassis = "3";
	}
	elsif ( "sw2b" eq $request->{$swParam} )
	{
	    $chassis = "4";
	}

	my $zoneRangeStr = " 1-8:";

	if ( $request->{$boxtypeParam} eq "6960" )
	{
	    $zoneRangeStr = " 1-16:";
	}

	my $theChassisStr;

	if ( $request->{$swParam} eq $allStr )
	{
	    $theChassisStr = $chassisIDAllNoteStr;
	}

	my @fields = ( 
	    [ "static", $swSelectedStr, $request->{$swParam} ],
	    [ "hidden", $swParam, $request->{$swParam} ],
	    [ "text",   $chassisIDStr, $chassisIDParam, $chassis, "3", "3" ],
	    [ "static", $chassisIDNoteStr, $theChassisStr ],
	    [ "text",   $hardZoneIDStr . $zoneRangeStr, 
		        $hardZoneIDParam, "1", "3", "3" ],
	    [ "static", $hardZoneIDNoteStr ],
	    [ "hidden", $boxtypeParam, $request->{$boxtypeParam} ],
	    [ "hidden", $stepParam, "3setupswitch" ]
	    );

	my @buttons = ( [ $swDefaultStr, $swSetConfigStr, $warning ] );

	print SE::WebUtil->createForm ( $configStr,
				    $configAction,
				    \@buttons,
				    \@fields );
    }
    elsif ( $request->{$stepParam} eq "3setupswitch" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $configStr, $configURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb, $swConfiguringSW
					  . $request->{$swParam} );

	#USAGE 
#usage : setupswitch -s <switch_name> [-i <chassis_id> ] [-z <zone_id>]
#             [-c <sys_config_type> [ -f ] ] [ -v ] 
#          where:
#           switch_name - as defined in /etc/hosts file.
#           chassis_id - Override the default chassis id setting on the switch, 
#                        useful for SAN environments with multiple Sun StorEdge 
#                        6900 series systems in same SAN.  Range is 1-63.  
#                        Defaults are sw1a (1), sw1b (2), sw2a (3), sw2b (4).
#                        Valid on Sun StorEdge 6900 series only.
#           zone_id - Override the default hard zone number on the front-end
#                     switch, useful for SAN environments with cascaded
#                     switches and existing  zones.  The Sun StorEdge 6910
#                     range is 1-8, the Sun StorEdge 6960 range is 1-16.
#                     Default hard zone number for both is 1.  Valid on  
#                     Sun StorEdge 6900 series switch sw1a and sw1b only.
#           sys_config_type - Sun StorEdge system type, which can be one of:
#                             3910, 3960, 6910, 6960
#            -f - force config, don't validate sys_config_type specified.
#            -v - verbose option, messages go to stdout as well as log file.

	my $command;
	my $hardZoneAndChassis;


	#$command = "$SWUI::secfgBinDir/setupswitch "
		 #. " -s $request->{$swParam}" 
		 #. " -c $request->{$boxtypeParam} "
		 #. $hardZoneAndChassis 
		 #. " -f -v ";

	if ( $request->{$swParam} eq $allStr )
	{
	    #my ( $switches, $busyStr ) = &getSwitches ();
	    my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

	    if ( $errStr )
	    {
		print "<pre>$errStr</pre>";
		return;
	    }

	    for my $tmp ( @$switches )
	    {
		if ( $request->{$hardZoneIDParam} )
		{
		    $hardZoneAndChassis = 
		      " -i $request->{$chassisIDParam} "
		    . " -z $request->{$hardZoneIDParam} ";
		}

		$command = "$SWUI::secfgBinDir/setupswitch "
			 . " -s $tmp"  #key diff from other cmd
			 . " -c $request->{$boxtypeParam} "
			 . $hardZoneAndChassis 
			 . " -f -v ";

		if ( $tmp ne $allStr )
		{
		    SE::Util->execCmd ( $command, 1 );
		}
		$request->{$chassisIDParam} = $request->{$chassisIDParam} + 1;
	    }
	}
	else
	{
	    if ( $request->{$hardZoneIDParam} )
	    {
		$hardZoneAndChassis = 
		      " -i $request->{$chassisIDParam} "
		    . " -z $request->{$hardZoneIDParam} ";
	    }

	    $command = "$SWUI::secfgBinDir/setupswitch "
		     . " -s $request->{$swParam}" 
		     . " -c $request->{$boxtypeParam} "
		     . $hardZoneAndChassis 
		     . " -f -v ";
		    
	    SE::Util->execCmd ( $command, 1 );
	}
    }

    print SE::WebUtil->createTail ();
}


sub portTLMode()
{

    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $portTLModeAction );

    if ( $request->{$stepParam} eq "" )
    {
        my @crumb = ( [ $homeStr, $homeURL ] );

        print SE::WebUtil->createCrumb( \@crumb, $portTLModeStr );
        if ( ! SE::WebUtil->checkForIndy ( 0, "39" ) )
        {
            print  $indy3900OnlyStr;
            return;
        }


        my ( $switches, $busyStr, $errStr  ) = &getSwitches ();
	if ( $errStr )
        {
            print "<pre>$errStr</pre>";
	    return;
        }

	my @fields = (
            [ "static", $swInUseStr, $busyStr ],
            [ "radio",  $swAvailStr, $swParam, \@$switches ],
            [ "radio",  $tLModeStr, $tlModeParam, \@tlOnOff ],
            [ "static",
              "Note: on is (Set Reverse TL Mode)<br>off is "
              . "(Clear Reverse TL Mode)" ],
	    ["text", "Port Numbers:", $TLPortNum , "12", "12"],
	    [ "static", "NOTE:", $TLPortNote ],
            [ "hidden", $stepParam, "2" ]
            );

        my @buttons = ( [ "Default",  $setPortTLModeStr ] );
        my %opts = ( "longlived" => "1" );

        print SE::WebUtil->createForm ( $portTLModeStr,
                                    $portTLModeAction,
                                    \@buttons,
                                    \@fields,
                                    \%opts );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $portTLModeStr, $portTLModeURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb,
                      "Setting Port TL Mode for "
                                          . $request->{$swParam} );

        #USAGE
	#usage : setswitchtl { -n <switch_name> | -d } -s [on | off] 
        #          -p <port_list> [-c <sys_config_type> [ -f ] ] [ -v ] 
        #where:
        # switch_name - as defined in /etc/hosts file, implies a single path
        #               for the host(s) associated with port_list (sw1a or sw1b).
        # -d - set same ports on both switches, implies dual paths to host(s)
        #      associated with port_list (sw1a and sw1b).
        # -s - on implies set reverse TL mode, off implies clear reverse TL mode.
        # port_list - a comma separated list of port numbers that are connected
        #             to hosts (i.e. even port numbers such as 2,6,8)
        # sys_config_type - Sun StorEdge system type, which can be one of:
        #                   3910, 3960
        # -f - force config, don't validate sys_config_type specified.
        # -v - verbose option, messages go to stdout as well as log file.
        #SAMPLE setswitchtl -n $sw -s $opt -p $portlist -c $BOXTYPE -v -f

        #my $boxtype = `$T3UI::secfgBinDir/getcabinet`;
        my $boxtype = SE::WebUtil->getHostIndyModelViaStorAde ();

        $boxtype =~ s/\n//;
	my $command;

	if ( $request->{$swParam} eq $allStr )
	{

        $command =
              "$SWUI::secfgBinDir/setswitchtl "
            . " -d"
            . " -s $request->{$tlModeParam}"
            . " -c $boxtype"
	    . " -p $request->{$TLPortNum}"
            . " -v -f";
	} 
	else
	{

	$command =
              "$SWUI::secfgBinDir/setswitchtl "
            . " -n $request->{$swParam}"
            . " -s $request->{$tlModeParam}"
            . " -c $boxtype"
	    . " -p $request->{$TLPortNum}"
            . " -v -f";
	} #end of if ( $request->{$swParam} eq $allStr )

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();

} #end of portTLMode 



sub setSwitchF()
{

    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $portFModeAction );

    if ( $request->{$stepParam} eq "" )
    {
        my @crumb = ( [ $homeStr, $homeURL ] );

        print SE::WebUtil->createCrumb( \@crumb, $portFModeStr );
        if ( ! SE::WebUtil->checkForIndy ( 0, "39" ) )
        {
            print  $indy3900OnlyStr;
            return;
        }


        my ( $switches, $busyStr, $errStr  ) = &getSwitches ();
	if ( $errStr )
        {
            print "<pre>$errStr</pre>";
	    return;
        }

	my @fields = (
            [ "static", $swInUseStr, $busyStr ],
            [ "radio",  $swAvailStr, $swParam, \@$switches ],
            [ "radio",  $fModeStr, $fModeParam, \@fOnOff ],
	    ["text", "Port Numbers:", $fPortNum , "12", "12"],
	    [ "static", "NOTE:", $TLPortNote ],
            [ "hidden", $stepParam, "2" ]
            );

        my @buttons = ( [ "Default",  $setPortFModeStr ] );
        my %opts = ( "longlived" => "1" );

        print SE::WebUtil->createForm ( $portFModeStr,
                                    $portFModeAction,
                                    \@buttons,
                                    \@fields,
                                    \%opts );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
        my @crumb = ( [ $homeStr, $homeURL ],
                      [ $portFModeStr, $portFModeURL ]
                    );

        print SE::WebUtil->createCrumb( \@crumb,
                      "Setting Port F Mode for "
                                          . $request->{$swParam} );

        #USAGE
	#usage : setswitchf { -n <switch_name> | -d } -s [on | off] 
        #          -p <port_list> [-c <sys_config_type> [ -f ] ] [ -v ] 
        #where:
        # switch_name - as defined in /etc/hosts file, implies a single path
        #               for the host(s) associated with port_list (sw1a or sw1b).
        # -d - set same ports on both switches, implies dual paths to host(s)
        #      associated with port_list (sw1a and sw1b).
        # -s - on implies set reverse TL mode, off implies clear reverse TL mode.
        # port_list - a comma separated list of port numbers that are connected
        #             to hosts (i.e. even port numbers such as 2,6,8)
        # sys_config_type - Sun StorEdge system type, which can be one of:
        #                   3910, 3960
        # -f - force config, don't validate sys_config_type specified.
        # -v - verbose option, messages go to stdout as well as log file.
        #SAMPLE setswitchtl -n $sw -s $opt -p $portlist -c $BOXTYPE -v -f

        #my $boxtype = `$T3UI::secfgBinDir/getcabinet`;
        my $boxtype = SE::WebUtil->getHostIndyModelViaStorAde ();

        $boxtype =~ s/\n//;
	my $command;

	if ( $request->{$swParam} eq $allStr )
	{

        $command =
              "$SWUI::secfgBinDir/setswitchf "
            . " -d"
            . " -s $request->{$fModeParam}"
            . " -c $boxtype"
	    . " -p $request->{$fPortNum}"
            . " -v -f";
	} 
	else
	{

	$command =
              "$SWUI::secfgBinDir/setswitchf "
            . " -n $request->{$swParam}"
            . " -s $request->{$fModeParam}"
            . " -c $boxtype"
	    . " -p $request->{$fPortNum}"
            . " -v -f";
	} #end of if ( $request->{$swParam} eq $allStr )

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );
    }

    print SE::WebUtil->createTail ();

} #end of setSwitchF



sub modifySwitchZones ()
{

my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $modSwitchAction );

    if ( $request->{$stepParam} eq "" )
    {
        my @crumb = ( [ $homeStr, $homeURL ] );

        print SE::WebUtil->createCrumb( \@crumb, $modSwitchStr );

	if ( ! SE::WebUtil->checkForIndy ( 0, "39" ) )
        {
            print  $indy3900OnlyStr;
            return;
        }

	my $tmp = `ps -aef|grep swModSwitchGui|grep -v grep >/dev/null 2>&1`;
        if ( $? )
        {
                $tmp = `rm -f /tmp/swModSwitchGui*`;
        }

        $modSwitchZoneFile = "/tmp/swModSwitchGui_$$";


        my ( $switches, $busyStr, $errStr  ) = &getSwitches("noall");

        if ( $errStr )
        {
            print "<pre>$errStr</pre>";
            return;
        }
        $boxtype = SE::WebUtil->getHostIndyModelViaStorAde ();
        $boxtype =~ s/\n//;

        my @fields;
        my @buttons;

	@fields = (
            [ "static", $swInUseStr, $busyStr ],
            [ "radio",  $swAvailStr, $swParam, \@$switches ],
            [ "hidden", $boxtypeParam, $boxtype ],
            [ "hidden", $swfile, $modSwitchZoneFile ],
            [ "hidden", $stepParam, "mod2" ] #go to extra info page
            );
            @buttons = ( [ $swDefaultStr, "Next" ] );

	print SE::WebUtil->createForm ( $modSwitchStr,
                                    $modSwitchAction,
                                    \@buttons,
                                    \@fields );
    }
    elsif ( $request->{$stepParam} eq "mod2" )
    {

	my @crumb = ( [ $homeStr, $homeURL ] );

        my $result;

        print SE::WebUtil->createCrumb( \@crumb, $modSwitchStr );

	my @fields;
        my @buttons;
	my @multiparam = ( "Yes", "No" );
        my @hardzones; 
        my @zports; 
        my ($zoneid,$ports,$zone,$temp);
        my $count = 0;

        if (!-e "/opt/SUNWsecfg/etc/$request->{$swParam}.map") { 

             while (-e "/opt/SUNWsecfg/etc/.switch.lock") {
                   sleep 5;
                   $count++;
                   if($count > 20 ) { 
                            $result =  `/opt/SUNWsecfg/bin/removelocks -s `;
                            last;
                   }
             } 
                   $result =  `/opt/SUNWsecfg/bin/saveswitch -s $request->{$swParam} 2>&1`;
                   if ($? != 0 ) { 
                       print "<pre> $result </pre>";
                       return;
                   } 
        } else {
                  $result =  `/opt/SUNWsecfg/bin/checkswitch -s $request->{$swParam} -p 2>&1`;
                  if ($? != 0 ) {
                       print "<pre>$result </pre>";
                       print "<pre>Updating $request->{$swParam} map file with current configuration </pre>";
                       $result =  `/opt/SUNWsecfg/bin/saveswitch -s $request->{$swParam} 2>&1`;
                       if ($? != 0 ) {
                           print "<pre> $result </pre>";
                           return;
                       }
                  }
        }
           
 
        @hardzones = `grep HARDZONE /opt/SUNWsecfg/etc/$request->{$swParam}.map`; 	

        undef(%ZONES);

        foreach $zone (@hardzones) {
          undef(@zports);
          ($temp,$zoneid,@zports) = split(' ',$zone);
          $ports = join(' ',@zports);
          $ports =~ s/\s+/,/g;
          $ZONES{$zoneid} = "$ports";
        }


	if ( $request->{$boxtypeParam} eq "3910" )
	{
            print "<br>SWITCH Configuration :-<br>";
            print "<table BORDER cols=20 NOSAVE>";
            print "<tr><td>Port </td><td>1</td><td>2</td><td>3</td><td>4</td><td>5</td><td>6</td><td>7</td><td>8</td></tr>"; 
            print "<tr><td>SW1a</td><td>t3b0(Pri)</td><td>Host</td><td>t3b1(Pri)</td><td>Host</td><td>t3b2(Pri)</td><td>Host</td><td>t3b3(Pri)</td><td>Host</td></tr>"; 
            print "<tr><td>SW1b</td><td>t3b0(Alt)</td><td>Host</td><td>t3b1(Alt)</td><td>Host</td><td>t3b2(Alt)</td><td>Host</td><td>t3b3(Alt)</td><td>Host</td></tr></table>"; 

	}
	elsif (  $request->{$boxtypeParam} eq "3960" )
	{
            print "<br>SWITCH Configuration :-<br>";
            print "<table BORDER cols=20 WIDTH=100% NOSAVE>";
            print "<tr><td>Port </td><td>1</td><td>2</td><td>3</td><td>4</td><td>5</td><td>6</td><td>7</td><td>8</td><td>9</td>"; 
            print "<td>10</td><td>11</td><td>12</td><td>13</td><td>14</td><td>15</td><td>16</td></tr>"; 
            print "<tr><td>SW1a</td><td>t3b0(Pri)</td><td>Host</td><td>t3b1(Pri)</td><td>Host</td><td>t3b2(Pri)</td><td>Host</td><td>t3b3(Pri)</td><td>Host</td>"; 
            print "<td>t3be0(Pri)</td><td>Host</td><td>t3be1(Pri)</td><td>Host</td><td>t3be3(Pri)</td><td>Host</td><td>t3be2(Pri)</td><td>t3be4(Pri)</td></tr>"; 
            print "<tr><td>SW1b</td><td>t3b0(Alt)</td><td>Host</td><td>t3b1(Alt)</td><td>Host</td><td>t3b2(Alt)</td><td>Host</td><td>t3b3(Alt)</td><td>Host</td>"; 
            print "<td>t3be0(Alt)</td><td>Host</td><td>t3be1(Alt)</td><td>Host</td><td>t3be3(Alt)</td><td>Host</td><td>t3be2(Alt)</td><td>t3be4(Alt)</td></tr></table>"; 

	}

        @fields = (
            [ "static",  "To modify Switch zone configuration enter comma separated list" ,],
            [ "static",  $swSelectedStr, $request->{$swParam} ],
            [ "hidden",  $swParam, $request->{$swParam} ],
            [ "hidden", $swfile, $request->{$swfile} ],
            [ "text", "ZONE ID 1", $SWI1 , "$ZONES{1}", "60", "256" ],
            [ "text", "ZONE ID 2", $SWI2 , "$ZONES{2}", "60", "256" ],
            [ "text", "ZONE ID 3", $SWI3 , "$ZONES{3}", "60", "256" ],
            [ "text", "ZONE ID 4", $SWI4 , "$ZONES{4}", "60", "256" ],
            [ "text", "ZONE ID 5", $SWI5 , "$ZONES{5}", "60", "256" ],
            [ "text", "ZONE ID 6", $SWI6 , "$ZONES{6}", "60", "256" ],
            [ "text", "ZONE ID 7", $SWI7 , "$ZONES{7}", "60", "256" ],
            [ "text", "ZONE ID 8", $SWI8 , "$ZONES{8}", "60", "256" ],
            [ "text", "ZONE ID 9", $SWI9 , "$ZONES{9}", "60", "256" ],
            [ "text", "ZONE ID 10",$SWI10 , "$ZONES{10}", "60", "256" ],
            [ "text", "ZONE ID 11",$SWI11 , "$ZONES{11}", "60", "256" ],
            [ "text", "ZONE ID 12",$SWI12 , "$ZONES{12}", "60", "256" ],
            [ "text", "ZONE ID 13",$SWI13 , "$ZONES{13}", "60", "256" ],
            [ "text", "ZONE ID 14",$SWI14 , "$ZONES{14}", "60", "256" ],
            [ "text", "ZONE ID 15",$SWI15 , "$ZONES{15}", "60", "256" ],
            [ "text", "ZONE ID 16",$SWI16 , "$ZONES{16}", "60", "256" ],
            [ "hidden", $boxtypeParam, $boxtype ],
            [ "hidden", $stepParam, "mod4" ] #go to extra info page
            );

            @buttons = ( [ $swDefaultStr, "Next" ] );
	print SE::WebUtil->createForm ( $modSwitchStr,
                                    $modSwitchAction,
                                    \@buttons,
                                    \@fields );
	
    }
    elsif ( $request->{$stepParam} eq "mod4" )
    {
	my ( $request ) = @_ if @_;
        my ( $key);
   
        my @crumb = ( [$homeStr   , $homeURL],
                      [$modSwitchStr , $modSwitchURL ]
                    );
   
        print SE::WebUtil->createCrumb( \@crumb, "Modifying switch zones" );
        open(MSWITCH, ">$request->{$swfile}")|| die "Can't open file: $!\n";

            if($request->{$SWI1}){
               # print "SWI1 :  $request->{$SWI1}";
                $request->{$SWI1} =~ s/,/ /g;
                print MSWITCH "ZONE 1 $request->{$SWI1} \n";
            } 

     
            if($request->{$SWI2}){
               # print"SWI2 :  $request->{$SWI2}";
                $request->{$SWI2} =~ s/,/ /g;
                print MSWITCH "ZONE 2 $request->{$SWI2} \n";
            }

            if($request->{$SWI3}){
               #print"SWI3 :  $request->{$SWI3}";
               $request->{$SWI3} =~ s/,/ /g;
               print MSWITCH "ZONE 3 $request->{$SWI3} \n";
            } 

            if($request->{$SWI4}){
               #print"SWI4 :  $request->{$SWI4}";
               $request->{$SWI4} =~ s/,/ /g;
               print MSWITCH "ZONE 4 $request->{$SWI4} \n";
            }

            if($request->{$SWI5}){
               #print"SWI5 :  $request->{$SWI5}";
               $request->{$SWI5} =~ s/,/ /g;
               print MSWITCH "ZONE 5 $request->{$SWI5} \n";
            }

            if($request->{$SWI6}){
               #print"SWI6 :  $request->{$SWI6}";
               $request->{$SWI6} =~ s/,/ /g;
               print MSWITCH "ZONE 6 $request->{$SWI6} \n";
            }

            if($request->{$SWI7}){
               #print"SWI7 :  $request->{$SWI7}";
               $request->{$SWI7} =~ s/,/ /g;
               print MSWITCH "ZONE 7 $request->{$SWI7} \n";
            }

            if($request->{$SWI8}){
               #print"SWI8 :  $request->{$SWI8}";
               $request->{$SWI8} =~ s/,/ /g;
               print MSWITCH "ZONE 8 $request->{$SWI8} \n";
             }

            if($request->{$SWI9}){
               #print"SWI9 :  $request->{$SWI9}";
               $request->{$SWI9} =~ s/,/ /g;
               print MSWITCH "ZONE 9 $request->{$SWI9} \n";
            }

            if($request->{$SWI10}){
               #print"SWI10 :  $request->{$SWI10}";
               $request->{$SWI10} =~ s/,/ /g;
               print MSWITCH "ZONE 10 $request->{$SWI10} \n";
            }

            if($request->{$SWI11}){
               #print"SWI11 :  $request->{$SWI11}";
               $request->{$SWI11} =~ s/,/ /g;
               print MSWITCH "ZONE 11 $request->{$SWI11} \n";
            }

            if($request->{$SWI12}){
               #print"SWI12 :  $request->{$SWI12}";
               $request->{$SWI12} =~ s/,/ /g;
               print MSWITCH "ZONE 12 $request->{$SWI12} \n";
            } 

            if($request->{$SWI13}){
               #print"SWI13 :  $request->{$SWI13}";
               $request->{$SWI13} =~ s/,/ /g;
               print MSWITCH "ZONE 13 $request->{$SWI13} \n";
            }

            if($request->{$SWI14}){
               #print"SWI14 :  $request->{$SWI14}";
               $request->{$SWI14} =~ s/,/ /g;
               print MSWITCH "ZONE 14 $request->{$SWI14} \n";
             }

            if($request->{$SWI15}){
               #print"SWI15 :  $request->{$SWI15}";
               $request->{$SWI15} =~ s/,/ /g;
               print MSWITCH "ZONE 15 $request->{$SWI15} \n";
            }

            if($request->{$SWI16}){
               #print"SWI16 :  $request->{$SWI16}";
               $request->{$SWI16} =~ s/,/ /g;
               print MSWITCH "ZONE 16 $request->{$SWI16} \n";
            }

        close MSWITCH;

	my $command;

            $command = "$SWUI::secfgBinDir/modifyswitch"
                    . " -s $request->{$swParam}"
                    . " -z $request->{$swfile}"
                    . " -c $boxtype"
                    . " -f -v ";

        #print "<h2>";
        #print $operationResultStr;
        #print "</h2>";
        #print $mayTimeoutStr;

        my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );

    }

	print SE::WebUtil->createTail ();

} #end of modifySwitchZones



sub downloadFirmware ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $downloadAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    if ( $request->{$stepParam} eq "" )
    {
	my @crumb = ( [ $homeStr, $homeURL ] );

	print SE::WebUtil->createCrumb( \@crumb, $downloadStr );

	#my ( $switches, $busyStr ) = &getSwitches ();
	my ( $switches, $busyStr, $errStr  ) = &getSwitches ();

	if ( $errStr )
	{
	    print "<pre>$errStr</pre>";
	    return;
	}

	my @fields = ( 
	    [ "static", $swInUseStr, $busyStr ],
	    [ "radio",  $swAvailStr, $swParam, \@$switches],
	    [ "radio",  $swDefaultFFStr, $swDefaultFlashFileParam, \@yesno, 0 ],
	    [ "text", "Flash File:", $swFlashFileParam , 
		      "", "60", "256" ],
	    [ "hidden", $stepParam, "2" ]
	    );

	my @buttons = ( [ $swDefaultStr, $swDownloadFlashStr ] );
	my %opts = ( "longlived" => "1" );

	print SE::WebUtil->createForm ( $downloadStr,
				    $downloadAction,
				    \@buttons,
				    \@fields,
				    \%opts );
    }
    elsif ( $request->{$stepParam} eq "2" )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $downloadStr, $downloadURL ]
		    );

	print SE::WebUtil->createCrumb( \@crumb,
                      $swDownloadingStr
					  . $request->{$swParam} );

	#USAGE 
        #usage : setswitchflash -s <switch_name> [ -f flashfile ]
        #
        #where:
        #        switch_name - as defined in /etc/hosts file.
        #        flash_file - full pathname to alternate flash_file.
        #                     Default is /usr/opt/SUNWsmgr/flash/m16030462.fls
        #                     or m08030462.fls based on number of ports.

	my $command;
	
	if ( $request->{$swParam} eq $allStr )
	{

		$command = "$SWUI::secfgBinDir/setswitchflash "
			 . " -s ALL"; 

		if ( $request->{$swDefaultFlashFileParam} eq $yesno[1] 
		     &&  $request->{$swFlashFileParam} ne "" ) 
		{
			$command .= " -f $request->{$swFlashFileParam}";
		}

		    #SE::Util->execCmd ( $command, 1 );
		SE::Util->execCmdBGOutputToFile ( $command, 1, $viewSWFlashResultsURL, "AllSWFlash" );
	}
	else
	{
	    $command = "$SWUI::secfgBinDir/setswitchflash "
                     . " -s $request->{$swParam}"; 

	    if ( $request->{$swDefaultFlashFileParam} eq $yesno[1] 
		 &&  $request->{$swFlashFileParam} ne "" ) 
	    {
		    $command .= " -f $request->{$swFlashFileParam}";
	    }

	    SE::Util->execCmd ( $command, 1 );
	}
    }

    print SE::WebUtil->createTail ();
}


sub getSwitches ()
{
    my($option) = @_; 
    my @list;
    my @busylist;
    my $busyStr;
    my $errStr;
    
    # listavailable returns only NON-locked units
    @list = split ' ', `/opt/SUNWsecfg/bin/listavailable -s`;

    if ( $? )
    {
	$errStr = "<h2>ERROR: No switches available, either"
		. " not found or configuration lock set.</h2>";
        $busyStr = "No Switch available for use, may be all are busy";
        return ( \@list, $busyStr, $errStr );
    }

    if ( scalar(@list) > 0 )
    {
	push(@list, $allStr) if($option !~/noall/i);
    }

    return ( \@list, $busyStr, $errStr );
}


sub sideMenu ()
{

    my @menu = (  [ $SEConfigStr , "/seTop.html", "bottom" ],
                  [ $dispStr , $dispURL, "detail" ],
		  [ $verifyStr , $verifyURL, "detail" ],
		  [ $configStr , $configURL, "detail" ],
		  [ $downloadStr , $downloadURL, "detail" ]
		);

    print SE::WebUtil->createSideMenu ( $swSwitchSelection,	\@menu );
}


1;


