#
# SCCS Info:      pragma ident   "@(#)LogUI.pm 1.4     02/05/19 19:03:23 SMI"
#
#  Copyright (c) 2001 Sun Microsystems, Inc, All Rights Reserved.
#
#  Perl Module for SE Log/Error UI
#
package SE::LogUI;

use lib qw ( /opt/SUNWstade/lib );
use strict;
use SE::T3UI;
use SE::Util;
use SE::VEUI;
use SE::WebUtil;

my $webproc = "rashttp.2";

#my $homeStr = "Logs/Errors";
#my $homeURL = "/seLogErrWelcome.html";
my $homeStr = "Sun StorEdge Series Config";
my $homeURL = "/$webproc?GO=GUI::SE::index";

my $logStr = "View Logs";
my $logAction = "SE::LogUI::logs";
my $logURL = "/$webproc?GO=" . $logAction;

my $errStr = "View Errors";
my $errAction = "SE::LogUI::errors";
my $errURL = "/$webproc?GO=" . $errAction;

my $removeLockStr = "Remove Locks";
my $removeLockAction = "SE::LogUI::removeLock";
my $removeLockURL = "/$webproc?GO=" . $removeLockAction;

my $lockParam = "lock";

sub logs 
{
    my ( $request ) = @_ if @_;

    #DAVID_NEEDS_LIB returns list I can make it into table
    my @list=`$T3UI::secfgBinDir/showlogs -v`;

    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $logAction );
    print SE::WebUtil->createCrumb( \@crumb, $logStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    print "<h2>\n";
    if ( ! SE::WebUtil->checkForIndy ( 1, "39" ) )
    {
        print "Sun StorEdge 6900 Series Logs\n";
    }
    else
    {
        print "Sun StorEdge 3900 Series Logs\n";
    }
    print "</h2>\n";
    print "<table border=0 width=90% cellspacing=2"
	 . " bgcolor=white cellpadding=8 >\n";

    foreach my $tmp (@list)
    {
	print "<tr><td>\n";
	print $tmp;
	print "\n</td></tr>\n";
    }
    print "</table>\n";
    
    print SE::WebUtil->createTail ();
}


sub errors 
{
    my ( $request ) = @_ if @_;

    #DAVID_NEEDS_LIB returns list I can make it into table
    my @list=`$T3UI::secfgBinDir/showerrors -a`;

    my @crumb = ( [ $homeStr, $homeURL ] );

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $errAction );
    print SE::WebUtil->createCrumb( \@crumb, $errStr );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }

    print "<h2>\n";
    if ( ! SE::WebUtil->checkForIndy ( 1, "39" ) )
    {
        print "Sun StorEdge 6900 Series Logs\n";
    }
    else
    {
        print "Sun StorEdge 3900 Series Logs\n";
    }
    print "</h2>\n";
    print "<table border=0 width=90% cellspacing=2"
	 . " bgcolor=white cellpadding=8 >\n";

    foreach my $tmp (@list)
    {
	print "<tr><td>\n";
	print $tmp;
	print "\n</td></tr>\n";
    }
    print "</table>\n";
    
    print SE::WebUtil->createTail ();
}


sub removeLock ()
{
    my ( $request ) = @_ if @_;

    print SE::WebUtil->createHead ();
    print SE::WebUtil->createStorAdeHeader ( $removeLockAction );
    if ( ! SE::WebUtil->checkForIndy ( 1, "39|69" ) )
    {
	return;
    }
    
    if ( $request->{t3} || $request->{sw} || $request->{ve} )
    {
	my @crumb = ( [ $homeStr, $homeURL ],
		      [ $removeLockStr, $removeLockURL ] 
		    );
	print SE::WebUtil->createCrumb( \@crumb, $request->{$lockParam} );

	my $lockFlag;

	if ( $request->{t3} )
	{
	    $lockFlag .= " -t";
	}
	if ( $request->{sw} )
	{
	    $lockFlag .= " -s";
	}
	if ( $request->{ve} )
	{
	    $lockFlag .= " -v";
	}

        #usage: removelocks [-t|-s|-v]
        #where: 
	#	-t - remove all T3+ related lock files.
	#	-s - remove all switch related lock files.
	#	-v - remove all virtualization engine related lock files.

	my $command = "$T3UI::secfgBinDir/removelocks"
                    . " $lockFlag ";

	my ( $retVal, $stdout, $stderr ) = SE::Util->execCmd ( $command, 1 );

    }
    else
    {
	my @crumb = ( [ $homeStr, $homeURL ] );
	print SE::WebUtil->createCrumb( \@crumb, $removeLockStr );

	my %lock = ( "Sun StorEdge T3+ Array"=>"t3", 
		     "Switch" =>"sw",
		     "Virtualization Engine" => "ve" );

	my @fields = ( 
	  # [ "radio",  "Type of locks to remove:", $lockParam , \@lock ],
	    [ "checkbox", "Type of locks to remove:", $lockParam, \%lock ]
	    );

	my @buttons = ( [ "NOTUSED", "\"Remove Locks\"" ] );

	print SE::WebUtil->createForm ( $removeLockStr,
				    $removeLockAction,
				    \@buttons,
				    \@fields  );
    }

    print SE::WebUtil->createTail ();
}


sub sideMenu ()
{
    my @menu = (  [ "SE Config Home" , "/seTop.html", "bottom" ],
                  [ $logStr , $logURL, "detail" ],
		  [ $errStr , $errURL, "detail" ]
		);

    print SE::WebUtil->createSideMenu ( "StorEdge 6900 Log Section", \@menu );
}

1;
