package GUIAdmin::Subnet;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Subnet.pm,v 1.22 2002/04/08 20:47:32 buildst Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUIAdmin;
use base 'GUIAdmin';
use Agent::T3;

sub description {'Subnet'}
sub isDevice {0}

sub ipRequired {0}

sub discover {
  my( $q, $post, $util) = @_;
  my($o, $err);
  print "\n";

  if ($q->{ACTION} =~ /Back/) {
       &main'discover0($q);
       return;

  } elsif ($q->{ACTION} =~ /Confirm/) {
     $q->{prefix} =~ s/\./_/g;
     $q->{prefix2} =~ s/\./_/g;
     if ($q->{SUB} !~ /\d+\.\d+\.\d+/) {
       $err= "<big><b><font color=red>Error: Invalid subnet, must be xxx.xxx.xxx</font>";
     } else {
       my($data, %F, $adding, $found);
       my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
       my $new_dev = $#$dev ;
       my $monitor_on = $q->{monitor_on};
       my $datahost   = $q->{datahost};
       print "<pre>1 - Find Devices already registered ...\n";
       my $cnt=1;
       foreach my $d (@$dev) {
          if ($d->{class} =~ /switch/ || $d->{class} =~ /storage.t3/) {
             $F{$d->{key}} = $cnt;
          }
          $cnt++;
       }
       if (!$q->{subhost}) {
           $data = &get_snmpdata($q, $post, $util);
       } else {
          print "2 - Getting devices from $q->{subhost}..\n";
          my $url = Util->makeUrl($q->{subhost}, 
                         "?GET=GUIAdmin::Subnet::snmpdata&REM=1&SUB=$q->{SUB}");
          my $rc = Util::Http->get($url, 200);
          if (substr($rc,0,2) ne "OK") {
              print "<font color=red><b>Snmp Error: $rc";
              return;
          } else {
              my @A = split(/\n/, substr($rc,2));
              $data = \@A;
          }
       }
       my $short = Util->shortHostname($q->{subhost} || $renv->{hostname});

       foreach my $line (@$data) {
          my($class, $type, $ip, $wwn, $key, $wwn2, $ctrl) = split(/\|/, $line);
          if ($class eq "ERR") {
             print " --> ERR: $type <br>";
             next;
          } 
print "$class, $type, $ip, $wwn, $key, $wwn2 <br>";
          if (!$F{$key}) {
             $F{$key} = 1;
             $adding = 1;
             $found++;
             $new_dev++;
             my($ip1,$ip2,$ip3, $ip4) = split(/\./, $ip);
             $dev->[$new_dev]{_name}    = "device" . $new_dev;
             $dev->[$new_dev]{type}     = $type;
             $dev->[$new_dev]{class}    = $class;
             if ($q->{prefixT}) {
               $dev->[$new_dev]{name}     = $short ."-" . sprintf("%3.3d", $ip4);
             } elsif ($q->{prefix}) {
               $dev->[$new_dev]{name}     = $q->{prefix} . "-$ip3" . "_$ip4";
             } else {
               $dev->[$new_dev]{name}     = ($type eq "switch"? "sw-":"t3-") .
                                              "$ip3-$ip4";
             }
             $dev->[$new_dev]{ctrl_model}= $ctrl if ($ctrl);
             $dev->[$new_dev]{ip}       = $ip;
             $dev->[$new_dev]{ipno}     = $ip;
             $dev->[$new_dev]{wwn}      = $wwn;
             $dev->[$new_dev]{wwn2}     = $wwn2;
             $dev->[$new_dev]{key}      = $key;
             $dev->[$new_dev]{host}     = $q->{subhost};
             $dev->[$new_dev]{active}   = ($monitor_on ? "Y":"N");
             #$dev->[$new_dev]{datahost} = $datahost;
             print " $type:$ip added. \n";
         } else {
           my $ix = $F{$wwn};
           if ($ix) {
             #$dev->[$ix]{wwn}      = $wwn;
             $dev->[$ix]{active}   = ($monitor_on ? "Y":"N");
             #$dev->[$ix]{datahost} = $datahost;
           }
           $adding = 1;
           print " $type:$ip already exist.\n";
         }
      }
      if ($adding) {
         foreach my $h (@$host) {
             $h->{last_push} = undef;
         }
         PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
      } else {
         print "  *** No new devices found***\n";
      }
    }
  }
  print "</pre>";

  my($h) = Html->header("Discover Subnet", "85%");
  my($ip)    = Util->name2ip(System->hostname() );
  my($ix) = rindex($ip, ".");
  $ip = substr($ip, 0, $ix);
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  my $hosts = "<select name=subhost><option value=\"\">Local</option>";
  foreach my $d (@$host) {
     $hosts .= "<option>$d->{hostname}</option>";
  }
  $hosts .= "</select>";
   my $dphost = "<select name=datahost><option value=\"\">Same Host</option>
            <option value=\"*None\">None</option>";

  $dphost .= "<option>" . $renv->{hostname} . "</option>";
  foreach my $h (@$host) {
      $dphost .= "<option>$h->{hostname}</option>";
  }
  $dphost .= "</select>";



  $o =<<EOF;
 <body bgcolor=$main'BGCOLOR><center>
 $h  $err
<table border=0 cellpadding=4 width=85% bgcolor=white><tr><td>
  <b>This program will discover all Switches and T3 using the following IP prefixes . This operation will take approx. 1 minute per prefix.<p>
</table>
  <form method=get>
  <input type=hidden name=GO value=discover>
  <input type=hidden name=PKG value=GUIAdmin::Subnet::discover>
  <tr><td bgcolor=white><center>
    <table border=0 cellspacing=1 cellpadding=0 bgcolor=white width=85%>
    <tr><td bgcolor=gray colspan=2><table border=0 cellpadding=1 cellspacing=0><tr><td></table></td>
    <tr><td align=right bgcolor=#CCCCFF><b>Run on Host: </td>
        <td><b>&nbsp;$hosts</td>
    <tr><td align=right bgcolor=#CCCCFF><b> Subnet to Search: </td>
        <td>&nbsp;<input type=text name=SUB value="$ip"> (xxx.xxx.xxx)</td>
    <tr><td align=right  bgcolor=#CCCCFF><b> Use Host Name as Prefix: </td>
        <td><b>&nbsp;<input type=checkbox name=prefixT></td>
    <tr><td align=right  bgcolor=#CCCCFF><b> Use Custom Prefix: </td>
        <td>&nbsp;<input type=text name=prefix value="$q->{prefix}"</td>

    <tr><td bgcolor=gray colspan=2><table border=0 cellpadding=1 cellspacing=0><tr><td></table></td>

    <tr><td align=right bgcolor=#F0F0C0><b>Turn Monitoring On: </td>
        <td><input type=checkbox name=monitor_on></td>
    <tr><td bgcolor=gray colspan=2><table border=0 cellpadding=1 cellspacing=0><tr><td></table></td>
    </table>
    <b><center>&nbsp;<br>
    <input type=submit name=ACTION value="Confirm Subnet Discovery">&nbsp;
    <input type=submit name=ACTION value="Back"><br>&nbsp;
 </form>
EOF

#    <tr><td align=right bgcolor=#F0F0C0><b>Data Path Host: </td> <td><b>$dphost &nbsp; (T3 only)
  print $o;
  return 0;

}


sub get_snmpdata {
  my($q, $post, $util) = @_;
  my(%T, @a, $loc, $ip, $out);
  my(%F, $d, $adding, $found, $l );
  my(@NEW);
  my($xx, $sub, $remote);

  $remote   = $q->{REM};
  $sub      = $q->{SUB};

  my(@L);
#  foreach my $x (160) {
  foreach my $x (0,20,40,60,80,100,120,140,160,180,200,220,240) {
      print "Looking at ports $sub.$x  .. " . ($x+19) . " \n" if (!$remote);
      $out = snmpget($sub, $x,  "public 1.1.0");
      foreach my $node (@$out) {
         my($class, $type, $ip, $wwn, $key, $wwn2, $ctrl) = split(/\|/, $node);
         push(@L, "$class|$type|$ip|$wwn|$key|$wwn2|$ctrl");
      }
  }
  if ($remote) {
     print "OK" . join("\n", @L);
  } else {
     return \@L;
  }
}
  

sub snmpget {
  my($ip,$no, $f) = @_;
  my($err, @out, $l, $x, $ipno, $comm, $cnt, $ret);
  my($GROUP) = 20;
  if (!-d "/tmp") {
     mkdir "/tmp" , 0777;
  }
  my($prog) = System->get_home() . "/bin/snmpget";
  for ($x = 1; $x <= $GROUP; $x++) {
     unlink("/tmp/ras_snmp_$x");
  }
  for ($x = 1; $x <= $GROUP; $x++) {
     last if ($no +$x > 255);
     $ipno = "$ip." . ($no+$x);
     $comm = "$prog -t 5 -r 0 $ipno $f > /tmp/snmp_$x 2>/dev/null";
     system("$comm&");
  }
  sleep(6);
  $cnt= 0;
  for ($x = 1; $x <= $GROUP; $x++) {
     last if ($no +$x > 255);
     open(O, "/tmp/snmp_$x");
     $ret = <O>; close(O);
     chop($ret);
     $ipno = "$ip." . ($no+$x);

     if ($ret !~ /No Response/) {
        my(@b) = split(/\s*=\s*/, $ret);
        if (lc($b[1]) =~ /brocade/) {
           my $wwn = Util->snmpWWN($ipno);
           push(@out, "switch.brocade|brocade|$ipno|$wwn|$wwn|$wwn");

        } elsif (lc($b[1]) =~ /switch/)  {
           my($er, $s2) = Util->run_command(System->get_home() . 
                              "/bin/sanbox version $ipno", "sanbox", 20);
           my $wwn = Util->snmpWWN($ipno);
           if ("@$s2" =~ /No response/) {
             push(@out, "switch.brocade|brocade|$ipno|$wwn|$wwn|$wwn");
           } else {
             push(@out, "switch.switch|switch|$ipno|$wwn|$wwn|$wwn");
           }

        } elsif (lc($b[1]) =~ /t3/) {
           my $class = "storage.t3";
           my $type  = "t3";
           my($key, $wwn ,$wwn2, $ctrl) =  Agent::T3->getWWN($ipno);
           if (!$key) {
              push(@out, "ERR|Invalid Key for T3 $ipno, cannot add !");
           } else {
              push(@out, "$class|$type|$ipno|$wwn|$key|$wwn2|$ctrl");
           }
        }
     }
  }
  return \@out;
}


1;
