package GUIAdmin::BROCADE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: BROCADE.pm,v 1.13 2002/04/08 20:47:32 buildst Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUIAdmin;
use base 'GUIAdmin';
use Agent::BROCADE;
sub description {'Silkworm Switch'};

sub isDevice {1}

sub ipRequired {1}

sub getDevices {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn);

  my($HOME) = System->get_home();
  if (open(RUN, "/etc/fcswitch.conf")) {
     while ($l = <RUN>) {
         chop($l);
         next if (substr($l,0,1) eq "#" || $l =~ /^\s*$/);
         my(@a) = split(/\s+/, $l);
         $f .= "$a[0]|$a[1]\n";
     }
     close(RUN);
     return "OK $f\n";
  } else {
     return "ERR $!";
  }
}

sub addDevice {
  my( $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);

  my $deny = Roles->verifyRole($q, "admin");
  print "\n";
  require "GUI/Devices.pm";
  if ($q->{ACTION} eq "Back") {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION} eq " Add ") {
    my($active) = "Y";
    while (1) {
     if ($q->{name} eq "") {
        $err = Html->header("Device name is mandatory <br>Record not added!");
        last;
     } elsif (!$q->{ip}) {
        $err = Html->header("You must enter an IP address for this device-type <br>Record not added!");
        last;
     } else {
        if (!($ipno = Util->testIp($q->{ip}))) {
           $q->{ERR} = Html->header("Warning: Cannot ping this Switch: $q->{ip}");
           $active = "N";
        }
        ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
        foreach $x (@$dev) {
          if ($x->{name} eq $q->{name}) {
             $err = Html->header("Error: This Device Name is already used <br>Record not added!");
             goto out;
          } elsif ($q->{ip} && $x->{ip} eq $q->{ip}) {
             $err = Html->header("Error: This IP address is already used <br>Record not added!");
             goto out;
          } elsif ($ipno && $x->{ipno} eq $ipno) {
             $err = Html->header("Error: This IP address is already used <br>Record not added!");
             goto out;
          }
        }
        $x = $#$dev + 1;
        my($wwn) = Agent::BROCADE->getWWN($q->{ip});

        $dev->[$x]{_name}    = "device" . ($x+1);
        $dev->[$x]{type}     = "brocade";
        $dev->[$x]{class}    = "switch.brocade";
        $dev->[$x]{name}     = $q->{name};
        $dev->[$x]{active}   = $active;
        $dev->[$x]{ip}       = $q->{ip};
        $dev->[$x]{telnet}   = Util->encodeAll($q->{telnet});
        $dev->[$x]{wwn}      = $wwn;
        $dev->[$x]{key}      = $wwn;
        $dev->[$x]{ipno}     = $ipno;
        $dev->[$x]{host}     = $q->{host};

        GUIAdmin->clearSlave($q->{host}, $host);

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print "Cannot write to ConfigFile<br>";
        } else {
           $info = Html->header("Device added!", "green");
        }

        GUI::Devices::list($q);
        return;
     }
     last;
    }
  }
out:
  my($h) = Html->header("Maintain Devices : Add Silkworm Switch","","",
        "Maintenance.General#adddevice");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";

  my($phost) = "<select name=host><option value=\"\">[Select]</option>".
              "<option value=\"\" $sel>Local</option>";

  foreach $x (@$host) {
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::BROCADE::addDevice">
<center>
$h
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;Enter Device Information</td>

<tr><td bgcolor=$main'LIGHT width=30% align=right>Device Name :</td>
    <td><input type=text name=name size=15 maxlength=15 value="$q->{name}">

<tr><td bgcolor=$main'LIGHT width=30% align=right>Telnet Password :</td>
    <td><input type=password name=telnet size=20 maxlength=30 >

<tr><td bgcolor=$main'LIGHT align=right>Primary Host :</td>
    <td>$phost</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right> IP Name/Address :</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">

</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION value=\" Add \">";
  }
  print "<input type=submit name=ACTION value=\"Back\"></form>";

}

sub updDevice {
  my($q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print "\n";
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION} eq "Back") {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION} eq "Update") {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{telnet} = Util->encodeAll($q->{telnet});
    $dev->[$x]{class}= "switch.brocade";
    $dev->[$x]{hba}  = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->header("Device $name updated!", "green");

  } elsif ($q->{ACTION} eq "Delete") {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->header("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

 $h1 = Html->header("Maintain Devices : Update Silkworm Switch","","",
          "Maintenance.General#updatedevice");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";
  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";
  my $telnet = Util->decode($h->{telnet});

  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form method=get>
 <input type=hidden name=GO value=GUIAdmin::BROCADE::updDevice>
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;Device Information</td>

<tr><td bgcolor=$main'LIGHT align=right>Device Type :</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type}</td>
        <td bgcolor=$main'LIGHT align=right>Monitoring:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$main'LIGHT width=30% align=right>Device Name :</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>IP Name/Address :</td>
    <td>&nbsp;$ip</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>IP Number :</td>
    <td>&nbsp;$ipno</td>

<tr><td bgcolor=$main'LIGHT width=30% align=right>Telnet Password :</td>
    <td><input type=password name=telnet size=20 maxlength=30 value="$telnet">

<tr><td bgcolor=$main'LIGHT align=right>WWN :</td>
    <td><b>$h->{wwn}</td>
<tr><td bgcolor=$main'LIGHT align=right>Primary Host :</td>
    <td><b>$ho</td>

</table>
</table>
<b>

EOF

  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION value=\"Update\">
             <input type=submit name=ACTION value=\"Delete\">";
  }
  print " <input type=submit name=ACTION value=\"Back\">
  </form>";

}


1;

1;
