package GUI::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# SCCS Info:      pragma ident   "@(#)SE.pm 1.14     02/05/14 10:49:24 SMI"
# ----------------------------------------------------------
#</copyright>


use lib qw ( /opt/SUNWstade/lib );
use strict;
use Html;
use Util;
use System;
use SE::WebUtil;

#my $webproc = "rascgi";
my $webproc = "rashttp.2";

my @T3 = (
  ["Display Config", 
   "Display Sun StorEdge T3+ Array Configuration", 
   "SE::T3UI::dispConfig"  , 0 ],
  ["Save Config",    
   "Save Sun StorEdge T3+ Array Configuration",    
   "SE::T3UI::saveConfig"  , 0 ],
  ["Configure",      
   "Configure Sun StorEdge T3+ Array(s)",          
   "SE::T3UI::startConfig" , 0 ],
  ["Modify Parameters", 
   "Modify Sun StorEdge T3+ Array System Parameters",  
   "SE::T3UI::modifySys" , 0 ],
  ["Restore", 
   "Restore Sun StorEdge T3+ Array Configuration",   
   "SE::T3UI::restoreConfig" , 0 ],
  ["Verify",  
   "Verify Sun StorEdge T3+ Array Configuration",      
   "SE::T3UI::verifyConfig" , 0 ],
  ["Configuration Status",  
   "Display Sun StorEdge T3+ Array Configuration Status", 
   "SE::T3UI::busyUnits" , 0 ],
  ["Manage LUN Slicing",  
   "Create/Remove/List/Enable Sun StorEdge T3+ Slice (only on 3900 series)", 
   "SE::T3UI::manageLunSlicing" , 0 ],
  ["Manage LUN Masking",  
   "Sun StorEdge T3+ Lun Masking (only on 3900 series)", 
   "SE::T3UI::manageLunMasking" , 0 ],
  ["Manage Password",  
   "Store/Clear Persisted Sun StorEdge T3+ Array Password", 
   "SE::T3UI::validate" , 0 ],
   );


my @SW = (
  ["Display Config",  
   "Display Switch Configuration",  
   "SE::SWUI::dispConfig" , 0 ],
  ["Verify",          
   "Verify Switch Configuration",   
   "SE::SWUI::verifyConfig" , 0 ],
  ["Set Config",      
   "Set Switch Configuration",      
   "SE::SWUI::setConfig" , 0 ],
  ["Save Config",
   "Save Sun StorEdge network FC switch Configuration",
   "SE::SWUI::saveConfig" , 0 ],
  ["Restore Config",
   "Restore Sun StorEdge network FC switch Configuration",
   "SE::SWUI::restoreConfig" , 0 ],
  ["Set Switch Port SL Mode",  
   "Set Switch Port SL Mode Per Sun StorEdge T3+ Array<br>(StorEdge 3900 Series Only)",
   "SE::T3UI::portSLMode" , 0 ],
  ["Set Switch Port TL Mode",
   "Set Switch Port TL Mode<br>(StorEdge 3900 Series Only)",
   "SE::SWUI::portTLMode" , 0 ],
  ["Set Switch Port F Mode",
   "Set Switch Port F Mode<br>(StorEdge 3900 Series Only)",
   "SE::SWUI::setSwitchF" , 0 ],
  ["Modify Switch Zones",
   "Modify Switch Zones<br>(StorEdge 3900 Series Only) ",
   "SE::SWUI::modifySwitchZones" , 0 ],
  ["Download Firmware",  
   "Download Switch Firmware",  
   "SE::SWUI::downloadFirmware" , 0 ],
    );


my @VE = (
  ["Manage Disk Pools",    
   "Manage Disk Pools",        
   "SE::T3UI::manageDiskPools" , 0 ],
  ["Manage VLUNs",       
   "Manage Virtual LUNs",        
   "SE::VEUI::manageVLUNs" , 0 ],
  ["Manage Zones",       
   "Manage Virtualization Engine Zones",      
   "SE::VEUI::manageZones" , 0 ],
  ["Manage ConfigFiles", 
   "Manage Configuration Files",   
   "SE::VEUI::manageFiles" , 0 ],
  ["Manage Hosts",       
   "Manage Virtualization Engine Hosts",  
   "SE::VEUI::manageHosts" , 0 ],
  ["Manage MP Drive Failback",       
   "MP Drive Failback Support",  
   "SE::T3UI::mpFailback" , 0 ],
  ["View Map",           
   "View Virtualization Engine Map",    
   "SE::VEUI::viewMap" , 0 ],
  ["Manage slicd Daemon",
   "Manage Virtualization Engine Daemon", 
   "SE::VEUI::manageSlicd" , 0 ],
  ["Manage Password", 
   "Store/Clear Persisted Virtualization Engine Password", 
   "SE::VEUI::validate" , 0 ],
   );


my @LOG = (
  ["View Log",     
   "View Sun StorEdge Series Log File", 
   "SE::LogUI::logs" , 0 ],
  ["View Errors",  
   "View Sun StorEdge Series Errors",
   "SE::LogUI::errors" , 0 ],
  ["Remove Locks", 
   "Remove Lock Files",
   "SE::LogUI::removeLock" , 0 ],
   );


sub index {
  my ($q) = @_;

  my $hostname = System->hostname();

  $q->{host} = "Local" if (!$q->{host});

  my $model = SE::WebUtil->getHostIndyModelViaStorAde ( $q->{host} );
  #my $is6900 = SE::WebUtil->checkHostForIndyViaStorAde ( $q->{host}, 0, "69" );
  my $is3900 = SE::WebUtil->checkHostForIndyViaStorAde ( $q->{host}, 0, "39" );
  my $isAnyIndy = SE::WebUtil->isIndyModel ( $model, "39|69" );

  if (my $deny = Roles->verifyRole($q, "script")) {
     print "<body bgcolor=white>";
     print $deny;
     return;
  }

  my $secfg_version = System->getPackageInfo("SUNWsecfg", "VERSION");

  my $h = Html->header("Sun StorEdge Series 3900/6900 Configuration<br><h5> SUNWsecfg $secfg_version</h5>", "90%");

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  my $l = "Local=$renv->{hostname} (Local)|";
  foreach my $h0 (@$hosts) {
     $l .= "$h0->{hostname}=$h0->{hostname} (Slave)|";
  }

  my $select = Util->makeSelect("host", $l, $q->{host});
  $select    = substr($select,0,7) . " onchange=form.submit() " . substr($select, 7);

  #my $x = Util->readHtdocs("se_info");
  print "HTTP/1.0 200 OK\nContent-type: text/html\nSet-Cookie: REDIRECT=; path=/;\n\n<body bgcolor=#F0F0F0><center>$h";

  if ( ! $isAnyIndy )
  {
    print "<table border=1 cellspacing=0 cellpadding=4 width=80% bgcolor=white>
	     <tr><td>
                <center><font color=red><b>
    Warning: This machine does not appear to be a Sun StorEdge 3900/6900 Series .
           </table>";
    $model = "(Unknown Model)";
  }

  print "
  <script>
  function openw(a) {
   var O = window.open(a, 'se_1','menubar=yes,resizable=yes,scrollbars=yes,width=600,height=600');
   O.focus();
  }
  </script>
  ";

  my @LIST;

  print "<table border=1 cellspacing=0 cellpadding=0 width=90% bgcolor=white>
         <tr><td align=right bgcolor=#CCCCFF>
         <form><input type=hidden name=GO value=GUI::SE::index>
         <b>Select Host: </td>
         <td><b>$select  <input type=submit name=ACTION value=Change></table>";
  print "<table border=1 cellspacing=0 width=90%><tr><td>";
  print "<table border=0 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
         <tr><td colspan=3 bgcolor=#666699> 
	 <font color=white>&nbsp;<b>Sun StorEdge $model System</td>";


  #if ( ! $isAnyIndy )
  #{
    #return;
  #}

  print "<tr><td></td>";
  print &head(-1, "Sun StorEdge T3+ Array View/Configure", \@T3, $q);

  print "<tr><td></td>";
  print &head(-1, "Switch View/Configure", \@SW, $q);

  #if it s 3900 don't show the VE menu.
  #for better or worse this logic means
  #that all menus get shown even if it
  #is not a real solution
  if ( ! $is3900 )
  {
      print "<tr><td></td>";
      print &head(-1, "Virtualization Engines", \@VE, $q);
  }

  print "<tr><td></td>";
  print &head(-1, "Log Functions and Sun StorEdge Series Maintenance", \@LOG, $q);

  print "</table></table></form>";
}

sub head {
  my ($mode, $v, $M, $q) = @_;
  my $out;
  my $cnt = 0;

  if ($mode == -1) {
    $out .= "<tr><td bgcolor=#CCCCFF colspan=3>&nbsp;<b>$v</td>";

  } elsif ($mode) {
    $out .= "<tr><td bgcolor=#CCCCFF colspan=3>&nbsp;<b>$v</b> &nbsp;
               <b>[ Open | <a href=/?GO=GUI::SE::index&ve=0><font color=navy>Close</font></a> ] </td>";
  } else {
    $out .= "<tr><td bgcolor=#CCCCFF colspan=3>&nbsp;<b>$v</b> &nbsp;
               <b>[ <a href=/?GO=GUI::SE::index&ve=1><font color=navy>Open</font></a> | Close ]</td>";
  }
  my $PORT     = System->get_rasport();

  if ($mode) {
    foreach my $v (@$M) {
       my $bg = ($cnt++ %2 == 0)? "bgcolor=#F0F0F0":"";
       my ($url);
       my $w;

       if ($q->{host} eq "Local") {
         $url = "<a href=/?GO=$v->[2]>$v->[0]</a>";
       } elsif ($q->{host}) {
         $url = "<a href=/?REDIRECT=$q->{host}:$PORT/$webproc?GO=$v->[2]>$v->[0]</a>";
         #$url = "<a href=/?REDIRECT=$q->{host}:$PORT/?GO=$v->[2]>$v->[0]</a>";
       }
       $out .= "<tr $bg><td>&nbsp;</td><td width=20%>$url</td>".
               "<td>$v->[1]&nbsp;$w</td>\n";
    }
  } else {
    $out .= "<tr><td colspan=3>&nbsp;</td>";
  }
  return $out;
}



#       if ($v->[3]) {
#          $url = "<a href=javascript:openw('$v->[2]')>$v->[0]</a>";
#          $w = "(new window)";
#       } else {

1;
