package GUI::Revision;

use strict;
use Modules;
use Html;
use Util;
use Data::Dumper;
use Matrix;
use Revision;
use Html::Tabs;

sub run {
  my($q) = @_;
  print "\n<body bgcolor=#E0E0E0>";

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  my $F = System->get_home() . "/DATA/tmp/last_rev_check";
  my $PIDF = System->get_home() . "/DATA/tmp/last_rev_check_pid";
  my $LOG = System->get_home() . "/DATA/tmp/last_rev_check_log";
  my $mods = Modules->load("Revision");

  if ($q->{ACTION} =~ /Run/) {
    while (1) {
      if (&process_status($q->{host}) =~ /Running/) {
         print "<font color=red><b>Error:Revision checking is already running</b>";
         return;
      }
      my ($some , $args);
      foreach my $m (sort @$mods) {
         if ($q->{"check_$m"} || $q->{"check_ALL"}) {
            $some = 1;
            $args .= "$m|";
         }
      }
      if (!$some) {
         print "<font color=red><b>Error:Select at least one Module</b></font>";
         last;
      }
      my (@REPORTS);

      # $q->{matrix} may have the message like:
      #  config-matrix ---- Revirsion 3.10, created time : 10/01/2001
      #  we only need "config-matrix", this is the real matrix name

      my ($matrix_name, $restpart) = split(/\s+/,$q->{matrix});

      my $command = "rasrevcheck -h \"$q->{host}\" -m \"$matrix_name\" -M \"$args\" -e \"$q->{email}\"";

      if (!$q->{host}) {
         my $cpid;
         if (($cpid = fork()) == 0) { 
           close STDIN; close STDOUT; close STDERR;
           exec(System->get_home() . "/bin/$command");
         }
      } else {
         Util::Http->remoteCommand($q->{host}, $command);
      }
      sleep(1);
      my $hh = $q->{host} ? $q->{host} : "LocalHost";
      print "Running '$command' on $hh<br>";
      last;
    }
  }
  if ($q->{option} == 2) {
    print "<meta http-equiv=Refresh content=\"30;URL=/?GO=GUI::Revision::run&option=2\">";
  }
  print "<center>";
  $q->{option} = 1 if (!$q->{option});
  my @tabs = ("1=Start Revision Checking", "2=Display Report List" , "3=-Current Report");


  print Html->header("Revision Checking", "95%", "", "Diagnose.Tools#revisioncheck", "revision");

  my $table = Html::Tabs->create(list  =>  \@tabs,
                       url  => "/?GO=GUI::Revision::run",
                     width  => "95%",
             selectedColor  => "white",
         selectedTextColor  => "blue",
           backgroundColor  => $main'LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
         );
  print $table;
 
  if ($q->{option} == 2) {
     &monitor($q);
     return;
  } elsif ($q->{option} == 3) {
     &readLastReport($q);
     return;
  }

  my $hostname = System->hostname();
  my $info     =  Util->readHtdocs("revision");
  my $select_host = "<select name=host><option value=\"\">Local</option>";
  foreach my $h (@$hosts) {
     $select_host .= "<option>$h->{hostname}</option>";
  }
  $select_host .= "</select>";

  my $modlist = "<table border=1 cellspacing=0 width=100% bgcolor=white><tr><td>".  "<b><input type=checkbox name=check_ALL> &nbsp;&nbsp;All Components";
  my $cnt = 0;

  foreach my $m (sort @$mods) {
     my $func = "Revision::$m";           
     $modlist .= "<tr><td><b><input type=checkbox name=check_$m> &nbsp;&nbsp;". $func->description() . "</td>";
  }
  $modlist .= "</td></table>\n";

  my($D) =  System->get_home() . "/System/Matrix";
  opendir(O, $D);
  my @mats = readdir(O); closedir(O);

  my $matrix = "<select name=matrix>";
  my $tem1;
  my $tem2;
  my $revi;
  my $date;
  my @rev_mats = reverse @mats;
  foreach my $m (@rev_mats) {
     next if (substr($m,0,1) eq ".");
     next if (-d "$D/$m");
     open(OO2,System->get_home() . "/System/Matrix/" . $m);
     my $l;
     while ($l = <OO2>) {
          if ($l =~ /REV/ ){
             ($tem1, $tem2, $revi, $date) = split (/\s+/, $l); 
              $matrix .= "<option>$m  --  Revision: $revi , created time: $date";
             $matrix .= "</option>";
          }
     }
     close(OO2); 
  }
  $matrix .= "</select>";
  my $lastrun;
  if (-f $F) {
    my $fn = Util->get_file_created($F);
    $lastrun = "<a href=/?GO=GUI::Revision::readLastReport>$fn</a>";
  } else {
    $lastrun = "N/A";
  }

  my $pid;

 my $email = Util->readf(System->get_home() . "/DATA/revision_email");
  print "
  <table border=0><tr><td></table>

 <table border=1 cellpadding=0 cellspacing=0 bgcolor=white width=95%>
  <tr><td colspan=2 bgcolor=#666699><b>
      <form><input type=hidden name=GO value=GUI::Revision::run>
      <font color=white>Select options to run Revision Checking</td>
  <tr>
     <td width=30% bgcolor=#CCCCFF align=right>Select Host:&nbsp;</td>
     <td><table border=0><tr><td>&nbsp;$select_host</table>
  <tr>
     <td width=30% bgcolor=#CCCCFF align=right>Select Matrix:&nbsp;</td>
     <td>$matrix
  <tr><td width=30% bgcolor=#CCCCFF align=right>Select Components:&nbsp;</td>
      <td >$modlist
  <tr><td width=30% bgcolor=#CCCCFF align=right>Email:&nbsp;</td>
      <td> <input type=text name=email size=30 value=\"$email\">

  </table>
  &nbsp;<br>
  <b><input type=submit name=ACTION value=\"Run Revision Checking\">
  </form>
  ";
}

sub monitor {
  my($q) = @_;

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  my $out = "<table border=0><tr><td></table>";
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
  <tr><td colspan=3 bgcolor=#666699><font color=white><b>Monitor Revision Checking</td>
  <tr bgcolor=#CCCCFF>
          <th>Host
          <th>Last Report</th>
          <th>Report Status
  ";
  my $st = &process_status("");
  my $url;
  if ($st =~ /Done/) {
     $url = "<a href=/?GO=GUI::Revision::run&option=3&host=>Display Report</a>";
  } else {
     $url = "No Report";
  }
  my $run =1 if ($st =~ /Running/);
  $out .= "<tr><td>&nbsp;Local<td><center>&nbsp;$url<td><center>&nbsp;$st</td>";

  foreach my $h (@$hosts) {
     $st = &process_status($h->{ipno} || $h->{hostname});
     if ($st =~ /Done/) {
        my $ip = $h->{ipno} || $h->{hostname};
        $url = "<a href=/?GO=GUI::Revision::run&option=3&host=$ip&hostname=$h->{hostname}>Display Report</a>";
     } else {
        $url = "No Report";
     }
     $run =1 if ($st =~ /Running/);
     $out .= "<tr><td>&nbsp;$h->{hostname}<td><center>&nbsp;$url<td><center>&nbsp;$st</td>";
  }
  $out .= "</table>";
  print $out;

}

sub readLastReport {
  my($q) = @_;
  my ($rep, $VAR1);
  my $host = $q->{host};
  my $renv = System->get_renv();
  my $hostname = $q->{hostname} || System->hostname();
  if (!$host) {
    $rep = Util->deserialize("tmp/last_rev_check");
  } else {
    my $rc = Util::Http->readFile($q->{host}, "tmp/last_rev_check");
    eval $rc;
    $rep = $VAR1;
  }
  my $data = $rep->{data};
  my $matrix = $rep->{matrix};
  my $include = $rep->{include};
  my $mat = Matrix->read($matrix , {});
  my $map = $mat->{map};

  my $date = Util->get_file_created(System->get_home() . "/DATA/tmp/last_rev_check");
  
  my $MAP = {NI => "Not Installed" };

  my %X;
  foreach my $line (@$data) {
      $X{$line->[2]}++;
  }
  my $categories = "[ ";
  my($first_cnt, $first);
  foreach my $t (keys %X) {
     my $cnt = $X{$t};
     if ($cnt) { 
        $categories .= " <a href=/?GO=GUI::Revision::run&option=3&debug=$t&host=$q->{host}&hostname=$q->{hostname}>".
             ($MAP->{$t}||$t) . "=$cnt</a> |";
        $first = $t if (!$first); 
        
     }
  }
  chop($categories);
  $categories .= " | <a href=/?GO=GUI::Revision::run&option=3&host=$q->{host}&hostname=$q->{hostname}&debug=*ALL>ALL</a> ]";
  $q->{debug} = "DOWNREV:ERR:NI" if(!$q->{debug});
  my $hh = $q->{hostname} || $renv->{hostname};
  print "<table border=0><tr><td></table>";
  print "<table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=#666699><td colspan=7>
    <table border=0 cellspacing=0 width=100%><tr>
        <td><font color=white><b>Revision Checking report</td>
        <td align=right><font color=white>Date: $date</table>
   <tr><td colspan=7><form>
    <input type=hidden name=GO value=GUI::Revision::readLastReport>
    <table border=0 cellpadding=0 cellspacing=0 width=100%><tr>
       <tr><td>&nbsp;<b>Host:</b> $hh<td><td><b>Matrix-File:</b> $matrix &nbsp;</td>
           <td align=right><b>Report Section:</b> $categories</td>
       <tr><td colspan=3>&nbsp;<b>Components:</b> $include</td>
    </table>
   <tr bgcolor=#DDDDFF>
      <th>Name<th>Status
      <th>Current Version<th>Expected Version
      <th>Current Patch<th>Expected Patch 
      <th>Comments";
  my $last;
  my $cnt;
  foreach my $line (@$data) {
      my $d = $line->[2];
      my $ok = 0;
      if (($q->{debug} =~ /$d/) || ($q->{debug} eq "*ALL" ) ){
         $ok= 1;
      }
      next if (!$ok);
      $cnt++;
      if ($last ne $line->[0]) {
         print "<tr><td colspan=7><b>$line->[0] $map->{$line->[0]}</td>";
         $last = $line->[0];
      }
      my $col = ($line->[2] eq "PASS") ? "green":"red";
      if ($line->[2] eq "ERR") {
         print "<tr><td>&nbsp;$line->[1]<td> <font color=$col><center>$line->[2]".
               "<td colspan=5>$line->[7]";
      } else {
         print "<tr>
   <td>&nbsp;$line->[1]<td> <font color=$col><b><center>$line->[2]
   <td>&nbsp;$line->[3]<td>&nbsp;$line->[4]<td>&nbsp;$line->[5]
   <td>&nbsp;$line->[6]<td><small>&nbsp;$line->[7]";
      }
  }
  if (!$cnt) {
    print "<tr><td colspan=7><br><center>Nothing to report in '$q->{debug}' categories<br>&nbsp;";
  }
  print "</table>&nbsp;<br></form>";

}

# ($status, $date) = 

sub process_status {
  my($host) = @_;
  my ($st, $pid);
  my $PIDF = System->get_home() . "/DATA/tmp/last_rev_check_pid";

  if (!$host) {  # local
    if (open(O, $PIDF)) {
      $pid = <O>; close(O);
    }
  } else {
    $pid = Util::Http->readFile($host, "tmp/last_rev_check_pid");
  }
  if ($pid =~ /^pid=\d+/) {
     my($a,$s) = Util->processTime(substr($pid,4), $host);
     if (!$a) {
       my $pid2 = Util::Http->readFile($host, "tmp/last_rev_check_pid");
       if ($pid2 =~ /^pid=\d+/) {
         $st = "Died";
       } else {
         $st = "Done / $pid";
       }
       
     } else {
       $st = "Running";
     }
  } elsif ($pid)  {
     $st = "Done / $pid";

  } else {
      $st = "Not running";
  }
    
  return $st;
}

1;
