/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class VCanvas
extends Canvas
implements FocusListener,
ActionListener,
KeyListener,
MouseListener,
MouseMotionListener,
ComponentListener {
    static int deltaX;
    static int deltaY;
    public Graph graph;
    private int mode;
    protected static final int EDIT = 1;
    public Image img;
    public VertexApplet applet;
    public static Vertex saveVertex;
    private Dimension imageSize;
    Point labelOffset;

    public VCanvas(VertexApplet app0) {
        this.graph = new Graph(app0);
        this.mode = 1;
        this.applet = app0;
        this.img = null;
        this.imageSize = new Dimension(0, 0);
        this.labelOffset = null;
        try {
            this.initListen();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void actionPerformed(ActionEvent actionevent) {
    }

    public void adjustFont(int i) {
    }

    public void adjustFonts(int i) {
    }

    public void deleteAll() {
        this.graph.vertices.removeAllElements();
        this.graph.edges.removeAllElements();
        this.repaint(0L);
    }

    public void componentHidden(ComponentEvent componentevent) {
    }

    public void componentMoved(ComponentEvent componentevent) {
    }

    public void componentResized(ComponentEvent componentevent) {
        this.img = null;
    }

    public void componentShown(ComponentEvent componentevent) {
    }

    public void deleteChar() {
    }

    public void deleteObject() {
    }

    public void focusGained(FocusEvent focusevent) {
        this.repaint(0L);
    }

    public void focusLost(FocusEvent focusevent) {
    }

    public final Edge hitEdgeLabel(int i, int j) {
        int k = this.graph.edges.size();
        int l = 0;
        while (l < k) {
            Edge directededge = (Edge)this.graph.edges.elementAt(l);
            if (directededge.hitLabel(i, j)) {
                return directededge;
            }
            ++l;
        }
        return null;
    }

    public final Vertex hitVertex(int i, int j) {
        int k = this.graph.vertices.size();
        int l = 0;
        while (l < k) {
            Vertex directedvertex = (Vertex)this.graph.vertices.elementAt(l);
            String component = null;
            component = directedvertex.inside(i, j);
            if (component != null) {
                directedvertex.clickedComponent = component;
                return directedvertex;
            }
            ++l;
        }
        return null;
    }

    public final Edge hitErrorEdge(int i, int j) {
        int k = this.graph.edges.size();
        int l = 0;
        while (l < k) {
            Edge edge = (Edge)this.graph.edges.elementAt(l);
            Object component = null;
            if (edge.inside(i, j) != null) {
                return edge;
            }
            ++l;
        }
        return null;
    }

    private final void initListen() {
        this.addFocusListener((FocusListener)this);
        this.addKeyListener((KeyListener)this);
        this.addMouseListener((MouseListener)this);
        this.addMouseMotionListener((MouseMotionListener)this);
        this.addComponentListener((ComponentListener)this);
    }

    public void keyPressed(KeyEvent keyevent) {
        switch (keyevent.getKeyCode()) {
            case 127: {
                if (keyevent.getModifiers() == 0) {
                    this.deleteChar();
                    break;
                }
                this.deleteObject();
                break;
            }
            case 38: {
                if (keyevent.getModifiers() == 0) {
                    this.adjustFont(1);
                    break;
                }
                this.adjustFonts(1);
                break;
            }
            case 40: {
                if (keyevent.getModifiers() == 0) {
                    this.adjustFont(-1);
                    break;
                }
                this.adjustFonts(-1);
            }
        }
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseDragged(MouseEvent mouseevent) {
        int j;
        int i = mouseevent.getX();
        if (this.mouseDraggedVertex(i, j = mouseevent.getY(), mouseevent)) {
            return;
        }
        if (this.graph.lasso.x != 0) {
            this.graph.lasso.width = i - this.graph.lasso.x;
            this.graph.lasso.height = j - this.graph.lasso.y;
            this.repaint(0L);
        }
    }

    public final boolean mouseDraggedEdge(int i, int j, MouseEvent mouseevent) {
        return false;
    }

    public final boolean mouseDraggedVertex(int i, int j, MouseEvent mouseevent) {
        if (saveVertex == null) {
            return false;
        }
        Graphics g1 = this.img.getGraphics();
        int dx = i - deltaX - (int)(this.applet.scale * (float)VCanvas.saveVertex.position.x);
        int dy = j - deltaY - (int)(this.applet.scale * (float)VCanvas.saveVertex.position.y);
        int k = 0;
        while (k < this.graph.vertices.size()) {
            Vertex v = (Vertex)this.graph.vertices.elementAt(k);
            if (v.selected) {
                if (v == saveVertex) {
                    v.paintXOR(g1, i - deltaX, j - deltaY);
                } else {
                    v.paintXOR(g1, (int)((float)v.position.x * this.applet.scale) + dx, (int)((float)v.position.y * this.applet.scale) + dy);
                }
            }
            ++k;
        }
        this.repaint(0L);
        return true;
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
        this.labelOffset = null;
    }

    public void mouseMoved(MouseEvent mouseevent) {
    }

    public void clearAllSelected() {
        int k = 0;
        while (k < this.graph.vertices.size()) {
            Vertex v = (Vertex)this.graph.vertices.elementAt(k);
            v.selected = false;
            ++k;
        }
        int i1 = 0;
        while (i1 < this.graph.edges.size()) {
            Edge e = (Edge)this.graph.edges.elementAt(i1);
            e.selected = false;
            ++i1;
        }
        this.repaint(0L);
    }

    public void mousePressed(MouseEvent mouseevent) {
        Edge ed;
        Vertex v;
        int x = 2;
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        if ((mouseevent.getModifiers() & 1) == 0) {
            this.clearAllSelected();
        }
        if (this.pressedOnVertex(v = this.hitVertex(i, j), mouseevent)) {
            deltaX = (int)((float)i - (float)v.position.x * this.applet.scale);
            deltaY = (int)((float)j - (float)v.position.y * this.applet.scale);
            saveVertex = v;
            this.applet.saveInfo(v.info());
            return;
        }
        if (mouseevent.getModifiers() != 4) {
            this.clearAllSelected();
            saveVertex = null;
            deltaY = 0;
            deltaX = 0;
            this.graph.lasso.x = i;
            this.graph.lasso.y = j;
        }
        if (this.pressedOnErrorEdge(ed = this.hitErrorEdge(i, j), mouseevent)) {
            String s = ed.info();
            this.applet.saveInfo(s);
            return;
        }
    }

    String describe(String s) {
        String s1 = s.substring(0, 1);
        String s2 = s1.equals("p") ? "Port " + s.substring(1) : (s1.equals("d") ? "Disk " + s.substring(1) : (s1.equals("h") ? "Hba " + s.substring(1) : (s1.equals("s") ? "Ses " + s.substring(1) : s)));
        return s2;
    }

    public boolean shift(int mod) {
        return (mod & 1) != 0;
    }

    public boolean alt(int mod) {
        return (mod & 2) != 0;
    }

    public boolean buttonLeft(int mod) {
        return (mod & 0x10) != 0;
    }

    public boolean buttonRight(int mod) {
        return (mod & 4) != 0;
    }

    public void mouseReleased(MouseEvent mouseevent) {
        Vertex directedvertex = null;
        boolean found = false;
        this.applet.selectedVertex = null;
        this.applet.selectedEdge = null;
        this.applet.selectedAlign = null;
        this.applet.selectedZoom = 0;
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        int x = 2;
        int mod = mouseevent.getModifiers();
        if (this.buttonLeft(mod)) {
            if (this.graph.lasso.x != 0) {
                Rectangle r = new Rectangle((int)((float)this.graph.lasso.x / this.applet.scale), (int)((float)this.graph.lasso.y / this.applet.scale), (int)((float)this.graph.lasso.width / this.applet.scale), (int)((float)this.graph.lasso.height / this.applet.scale));
                int k = 0;
                while (k < this.graph.vertices.size()) {
                    Vertex v = (Vertex)this.graph.vertices.elementAt(k);
                    if (v.position.x > r.x && v.position.y > r.y && v.position.x < r.x + r.width && v.position.y < r.y + r.height) {
                        v.selected = true;
                        found = true;
                    }
                    ++k;
                }
                this.graph.clearLasso();
                this.repaint(0L);
            }
            if (saveVertex != null) {
                saveVertex = null;
                this.repaint(0L);
            }
            return;
        }
        if (this.shift(mod) && this.buttonRight(mod) && saveVertex != null) {
            this.applet.selectedAlign = saveVertex;
            this.applet.alignPopup.show(mouseevent.getComponent(), i, j);
            return;
        }
        if (!this.shift(mod) && this.buttonRight(mod)) {
            directedvertex = this.hitVertex(i, j);
            if (directedvertex != null) {
                this.applet.popup.setLabel(directedvertex.label);
                int ix = directedvertex.label.indexOf(":");
                if (ix < 0) {
                    return;
                }
                char vType = directedvertex.vertexType;
                String type = directedvertex.label.substring(0, ix);
                String enc_label = String.valueOf(directedvertex.name) + " (" + type + ":" + directedvertex.clickedComponent + ")";
                this.applet.selectedVertex = directedvertex;
                int x2 = 0;
                int x1 = 1;
                while (x1 <= this.applet.dropMenusCnt) {
                    if (this.applet.dropMenus[x1][2].length() <= 0 || this.applet.dropMenus[x1][2].indexOf(vType) < 0) {
                        this.applet.popup.getItem(x2).setEnabled(true);
                        this.applet.popup.getItem(x2).setLabel(String.valueOf(this.applet.dropMenus[x1][0]) + " " + enc_label + "   ");
                        ++x2;
                    }
                    ++x1;
                }
                while (x2 < this.applet.dropMenusCnt) {
                    this.applet.popup.getItem(x2).setEnabled(false);
                    this.applet.popup.getItem(x2).setLabel("   ");
                    ++x2;
                }
                this.applet.popup.show(mouseevent.getComponent(), i, j);
            } else {
                Edge ed = this.hitErrorEdge(i, j);
                if (ed != null) {
                    this.applet.linkPopup.setLabel("Link Info");
                    String enc_label = ed.label2;
                    int x1 = 1;
                    while (x1 <= this.applet.linkMenusCnt) {
                        this.applet.linkPopup.getItem(x1 - 1).setLabel(this.applet.linkMenus[x1][0]);
                        ++x1;
                    }
                    this.applet.selectedEdge = ed;
                    this.applet.linkPopup.show(mouseevent.getComponent(), i, j);
                } else {
                    this.applet.zoomPopup.setLabel("Zoom=" + this.applet.zoom);
                    this.applet.selectedZoom = 1;
                    this.applet.zoomPosition.x = i;
                    this.applet.zoomPosition.y = j;
                    this.applet.zoomPopup.show(mouseevent.getComponent(), i, j);
                }
            }
        }
    }

    public final void paint(Graphics g) {
        if (this.img == null) {
            this.imageSize = this.getSize();
            this.img = this.createImage(this.imageSize.width, this.imageSize.height);
        }
        Graphics g1 = this.img.getGraphics();
        if (saveVertex == null) {
            if (this.graph.lasso.x > 0) {
                this.graph.paintLasso(g1);
            } else {
                this.paintParts(g1);
            }
        }
        g.drawImage(this.img, 0, 0, null);
    }

    private final void paintParts(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.imageSize.width, this.imageSize.height);
        this.graph.paint(g);
    }

    public boolean pressedOnEdge(Edge directededge, MouseEvent mouseevent) {
        if (directededge == null) {
            return false;
        }
        int i = mouseevent.getX();
        int j = mouseevent.getY();
        this.select((Selectable)directededge);
        this.repaint(0L);
        return true;
    }

    public boolean pressedOnEdgeLabel(Edge directededge, MouseEvent mouseevent) {
        if (directededge == null) {
            return false;
        }
        this.labelOffset = new Point(mouseevent.getX() - directededge.labelBase.x, mouseevent.getY() - directededge.labelBase.y);
        this.select((Selectable)directededge);
        this.repaint(0L);
        return true;
    }

    public final boolean pressedOnVertex(Vertex v, MouseEvent mouseevent) {
        if (v == null) {
            return false;
        }
        if ((mouseevent.getModifiers() & 1) != 0) {
            v.selected = true;
        } else {
            this.clearAllSelected();
            v.selected = true;
        }
        this.repaint(0L);
        return true;
    }

    public final boolean pressedOnErrorEdge(Edge ed, MouseEvent mouseevent) {
        if (ed == null) {
            return false;
        }
        this.select((Selectable)ed);
        this.repaint(0L);
        return true;
    }

    public boolean pressedOnVertexLabel(Vertex directedvertex, MouseEvent mouseevent) {
        return false;
    }

    private final void select(Selectable selectable) {
        Selectable.select((Selectable)selectable);
    }

    public void setEditMode() {
        this.mode = 1;
    }

    public void setViewMode() {
        this.mode = 0;
    }

    public void repaintGraph() {
        this.resetVertices();
        this.repaint(0L);
    }

    public final void update(Graphics g) {
        this.paint(g);
    }

    public final void resetVertices() {
        saveVertex = null;
        deltaY = 0;
        deltaX = 0;
        int k = 0;
        while (k < this.graph.vertices.size()) {
            Vertex v = (Vertex)this.graph.vertices.elementAt(k);
            v.reset();
            ++k;
        }
    }
}

