#!/bin/sh
#
# Copyright (c) 1999, 2002 Sun Microsystems Inc.,
# All rights reserved.
#
#
#ident       "@(#) Config-Reader4u1P-platform.sh        1.4     02/01/15 SMI"
#

SYMON_PATH="$PATH"

#
# You must setup the SSP environment variables
#
if [ ! -r /etc/opt/SUNWssp/ssp_env.sh ]; then
    /usr/bin/echo "--"
    exit 0;
fi
. /etc/opt/SUNWssp/ssp_env.sh

PATH="$PATH:$SYMON_PATH"

EEPROMDIR=/.ssp_private/eeprom_save/

platformId () {
    for eeprom in `find ${SSPVAR:='/var/opt/SUNWssp'}${EEPROMDIR} -name "*eeprom.image*"`; do
	id=`${SSPOPT:='/opt/SUNWssp'}/bin/sys_id -f ${eeprom} 2>/dev/null`;
	/usr/bin/echo ${id:=--};
    done;
}

SUNW_HOSTNAME=`hostname`
export SUNW_HOSTNAME

platformId | /usr/bin/egrep '^[ 	]*[0-9]+[ 	]*$' | /usr/bin/sort | /usr/bin/head -1

exit 0
