       IDENTIFICATION DIVISION.
       PROGRAM-ID. ACCT01.
       REMARKS. THIS PROGRAM IS THE FIRST INVOKED BY THE 'AC01'
                TRANSACTION.  IT ANALYZES ALL REQUESTS, AND COMPLETES
                THOSE FOR NAME INQUIRES AND RECORD DISPLAYS.  FOR
                UPDATE TRANSACTIONS, IT SENDS THE APPROPRIATE DATA ENTRY
                SCREEN AND SETS THE NEXT TRANSACTION IDENTIFIER TO
                'AC02', WHICH COMPLETE THE UPDATE OPERATION.  FOR PRINT
                REQUESTS, IT STARTS TRANSACTION 'AC03' TO DO THE ACTUAL
                PRINTING.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01  MISC.
           02  MSG-NO                  PIC S9(4) COMP VALUE +0.
           02  ACCT-LNG                PIC S9(4) COMP VALUE +383.
           02  ACIX-LNG                PIC S9(4) COMP VALUE +63.
           02  DTL-LNG                 PIC S9(4) COMP VALUE +751.
           02  STARS                   PIC X(12) VALUE '************'.
           02  USE-QID.
               04  USE-QID1            PIC X(3) VALUE 'AC0'.
               04  USE-QID2            PIC X(5).
           02  USE-REC.
               04  USE-TERM            PIC X(4) VALUE SPACES.
               04  USE-TIME            PIC S9(7) COMP-3.
               04  USE-DATE            PIC S9(7) COMP-3.
           02  USE-LIMIT               PIC S9(7) COMP-3 VALUE +1000.
           02  USE-ITEM                PIC S9(4) COMP VALUE +1.
           02  USE-LNG                 PIC S9(4) COMP VALUE +12.
           02  IN-AREA.
               04  IN-TYPE             PIC X VALUE 'R'.
               04  IN-REQ.
                   06  REQC            PIC X VALUE SPACES.
                   06  ACCTC           PIC X(5) VALUE SPACES.
                   06  PRTRC           PIC X(4) VALUE SPACES.
               04  IN-NAMES.
                   06  SNAMEC          PIC X(18) VALUE SPACES.
                   06  FNAMEC          PIC X(12) VALUE SPACES.
           02  COMMAREA-FOR-ACCT04.
               04  ERR-PGRMID          PIC X(8) VALUE 'ACCT01'.
               04  ERR-FN              PIC X.
               04  ERR-RCODE           PIC X.
               04  DATACOM-ERR.
                   06  DERR-CMD        PIC X(5) VALUE SPACES.
                   06  DERR-TABID      PIC X(3) VALUE SPACES.
                   06  DERR-KEY        PIC X(5) VALUE SPACES.
                   06  DERR-RTCODE     PIC X(2) VALUE SPACES.
                   06  DERR-IRTCODE    PIC X(1) VALUE SPACES.
           02  LINE-CNT                PIC S9(4) COMP VALUE +0.
           02  MAX-LINES               PIC S9(4) COMP VALUE +6.
           02  IX                      PIC S9(4) COMP.
           02  SRCH-CTRL.
               04  FILLER              PIC X VALUE 'S'.
               04  START-KEY.
                   06  MIN-SNAME       PIC X(18).
                   06  MIN-FNAME       PIC X(12).
               04  STOP-KEY.
                   06  MAX-SNAME       PIC X(18).
                   06  MAX-FNAME       PIC X(12).
           02  SUM-LINE.
               04  ACCTDO              PIC X(5).
               04  FILLER              PIC X(3) VALUE SPACES.
               04  SNAMEDO             PIC X(12).
               04  FILLER              PIC X(2) VALUE SPACES.
               04  FNAMEDO             PIC X(7).
               04  FILLER              PIC X(2) VALUE SPACES.
               04  MIDO                PIC X(1).
               04  FILLER              PIC X(2) VALUE SPACES.
               04  TTLDO               PIC X(4).
               04  FILLER              PIC X(2) VALUE SPACES.
               04  ADDR1DO             PIC X(24).
               04  FILLER              PIC X(2) VALUE SPACES.
               04  STATDO              PIC X(2).
               04  FILLER              PIC X(3) VALUE SPACES.
               04  LIMITDO             PIC X(8).
           02  PAY-LINE.
               04  BAL                 PIC X(8).
               04  FILLER              PIC X(6) VALUE SPACES.
               04  BMO                 PIC 9(2).
               04  FILLER              PIC X    VALUE '/'.
               04  BDAY                PIC 9(2).
               04  FILLER              PIC X    VALUE '/'.
               04  BYR                 PIC 9(2).
               04  FILLER              PIC X(4) VALUE SPACES.
               04  BAMT                PIC X(8).
               04  FILLER              PIC X(7) VALUE SPACES.
               04  PMO                 PIC 9(2).
               04  FILLER              PIC X    VALUE '/'.
               04  PDAY                PIC 9(2).
               04  FILLER              PIC X    VALUE '/'.
               04  PYR                 PIC 9(2).
               04  FILLER              PIC X(4) VALUE SPACES.
               04  PAMT                PIC X(8).
           COPY DFHBMSCA.
           COPY DFHAID.
           COPY ACCTSET.
       01  MSG-LIST.
           02  FILLER                  PIC X(60) VALUE
               'NAMES MUST BE ALPHABETIC, AND SURNAME IS REQUIRED.'.
           02  FILLER                  PIC X(60) VALUE
               'ENTER SOME INPUT AND USE ONLY "CLEAR" OR "ENTER".'.
           02  FILLER                  PIC X(60) VALUE
           'REQUEST TYPE REQUIRED; MUST BE "D", "P", "A", "M" OR "X".'.
           02  FILLER                  PIC X(60) VALUE
               'PRINTER NAME REQUIRED ON PRINT REQUESTS'.
           02  FILLER                  PIC X(60) VALUE
               'ACCOUNT NUMBER REQUIRED (BETWEEN 10000 AND 79999).'.
           02  FILLER                  PIC X(60) VALUE
               'ACCOUNT NO. MUST BE NUMERIC AND FROM 10000 AND 79999'.
           02  FILLER                  PIC X(60) VALUE
               'NO NAMES ON FILE MATCHING YOUR REQUEST'.
           02  FILLER                  PIC X(60) VALUE
               'ENTER EITHER NAME OR A REQUEST TYPE AND ACCOUNT NUMBER'.
           02  FILLER                  PIC X(60) VALUE
               'THIS ACCOUNT NUMBER ALREADY EXISTS'.
           02  FILLER                  PIC X(60) VALUE
               'NO RECORD OF THIS ACCOUNT NUMBER'.
           02  FILLER                  PIC X(47) VALUE
               'THIS ACCOUNT NUMBER ALREADY IN USE AT TERMIMAL.'.
           02  MSG-TERM                PIC X(13).
           02  FILLER                  PIC X(60) VALUE
               'PRINT REQUEST SCHEDULED.'.
           02  FILLER                  PIC X(60) VALUE
               'PRINTER NAME NOT RECOGNIZED.'.
           02  FILLER                  PIC X(60) VALUE
           'INPUT ERROR; PLEASE RETRY; USE ONLY "CLEAR OR "ENTER" KEY'.
           02  FILLER                  PIC X(60) VALUE
               'THERE ARE MORE MATCHING NAMES. PRESS PA2 TO CONTINUE.'.
       01  FILLER REDEFINES MSG-LIST.
           02  MSG-TEXT                PIC X(60) OCCURS 15.
      *
      * D A T A C O M / U N I X   W O R K    A R E A S 
      *
       01  USER-ID.
           05  PROGRAM-NAME        PIC X(8)      VALUE 'PRIMER'.
           05  FILLER              PIC X(24)     VALUE SPACES.

       01  ACCT-RQ-AREA.
           05  ACCT-RQ-CMD         PIC X(5).
           05  ACCT-RQ-FILENAME    PIC X(3)      VALUE 'ACT'.
           05  ACCT-RQ-KEYNAME     PIC X(5)      VALUE 'ACTMI'.
           05  ACCT-RQ-RTCODE      PIC X(2)      VALUE SPACES.
           05  FILLER              PIC X(1).
           05  ACCT-RQ-DBID        PIC S9999     USAGE COMP VALUE +16.
           05  FILLER              PIC X(58).
           05  ACCT-RQ-KEYVALUE1   PIC X(180).
           05  ACCT-RQ-KEYVALUE2   PIC X(180).

       01  ACCT-WORK-AREA.
           COPY DACCTREC.

       01  ACCT-ELEMENT-LIST.
           05  FILLER              PIC X(5)      VALUE 'ACTEL'.
           05  FILLER              PIC X(1)      VALUE SPACES.
           05  FILLER              PIC X(5)      VALUE SPACES.

       01  ABND-RQ-AREA.
           05  FILLER              PIC X(5)      VALUE 'ABEND'.
           05  FILLER              PIC X(71)     VALUE SPACES.

       01  ABND-WORK-AREA.
           05  FILLER              PIC X(2)      VALUE 'U0'.
           05  ABND-FILE           PIC X         VALUE '0'.
           05  ABND-CODE           PIC XX        VALUE '01'.
           05  FILLER              PIC X(6)      VALUE 'NODUMP'.

       LINKAGE SECTION.
       01  DFHCOMMAREA.
           02  SRCH-COMM               PIC X(61).
           02  IN-COMM REDEFINES SRCH-COMM PIC X(61).
           02  CTYPE REDEFINES SRCH-COMM PIC X.
      *
       PROCEDURE DIVISION.
      *
      *
      *    INITIALIZE.
           EXEC CICS HANDLE CONDITION MAPFAIL(NO-MAP)
      *        NOTFND(SRCH-ANY)
      *        ENDFILE(SRCH-DONE)
               QIDERR(RSRV-1)
               TERMIDERR(TERMID-ERR)
               ERROR(OTHER-ERRORS) END-EXEC.
           MOVE LOW-VALUES TO ACCTMNUI, ACCTDTLI.
      *
      *    CHECK BASIC  REQUEST TYPE.
           IF EIBAID = DFHCLEAR
               IF EIBCALEN = 0,
                   EXEC CICS SEND CONTROL FREEKB END-EXEC
                   EXEC CICS RETURN END-EXEC
               ELSE GO TO NEW-MENU.
           IF EIBAID = DFHPA2 AND EIBCALEN > 0 AND CTYPE = 'S',
               MOVE SRCH-COMM TO SRCH-CTRL,
               GO TO SRCH-RESUME.
           IF EIBCALEN > 0 AND CTYPE = 'R', MOVE IN-COMM TO IN-AREA.
      *
      *    GET INPUT AND CHECK REQUEST TYPE FURTHER.
           EXEC CICS RECEIVE MAP('ACCTMNU') MAPSET('ACCTSET') END-EXEC.
           IF REQML > 0 MOVE REQMI TO REQC.
           IF REQMF NOT = LOW-VALUES, MOVE SPACE TO REQC.
           IF ACCTML > 0 MOVE ACCTMI TO ACCTC.
           IF ACCTMF NOT = LOW-VALUE, MOVE SPACES TO ACCTC.
           IF PRTRML > 0 MOVE PRTRMI TO PRTRC.
           IF PRTRMF NOT = LOW-VALUE, MOVE SPACES TO PRTRC.
           IF SNAMEML > 0 MOVE SNAMEMI TO SNAMEC.
           IF SNAMEMF NOT = LOW-VALUE, MOVE SPACES TO SNAMEC.
           IF FNAMEML > 0 MOVE FNAMEMI TO FNAMEC.
           IF FNAMEMF NOT = LOW-VALUE, MOVE SPACES TO FNAMEC.
           MOVE LOW-VALUES TO ACCTMNUI.
           IF IN-NAMES = SPACES GO TO CK-ANY.
      *
      *    NAME INQUIRY PROCESSING.
      *    VALIDATE NAME INPUT.
           IF FNAMEC NOT ALPHABETIC, MOVE 1 TO MSG-NO,
               MOVE -1 TO FNAMEML, MOVE DFHBMBRY TO FNAMEMA.
           IF SNAMEC = SPACES, MOVE STARS TO SNAMEMO,
           ELSE IF SNAMEC ALPHABETIC, GO TO CK-NAME.
           MOVE 1 TO MSG-NO.
           MOVE -1 TO SNAMEML, MOVE DFHBMBRY TO SNAMEMA.
       CK-NAME.
           IF MSG-NO > 0 GO TO MENU-RESEND.
      *
      *    BUILD KEY AND LIMITING NAME VALUES FOR SEARCH.
       SRCH-INIT.
           MOVE SNAMEC TO MIN-SNAME, MAX-SNAME.
           TRANSFORM MAX-SNAME FROM SPACES TO HIGH-VALUES.
           MOVE FNAMEC TO MIN-FNAME, MAX-FNAME.
           TRANSFORM MIN-FNAME FROM SPACES TO LOW-VALUES.
           TRANSFORM MAX-FNAME FROM SPACES TO HIGH-VALUES.
      *
      *    INITIALIZE FOR SEQUENTIAL SEARCH THRU KEY RANGE.
       SRCH-RESUME.
           MOVE 'REDKR' TO ACCT-RQ-CMD.
           MOVE 'ACTK1' TO ACCT-RQ-KEYNAME.
           MOVE 'ACT' TO ACCT-RQ-FILENAME.
           MOVE 16 TO ACCT-RQ-DBID.
           MOVE START-KEY TO ACCT-RQ-KEYVALUE1.
           MOVE STOP-KEY TO ACCT-RQ-KEYVALUE2.
      *
      *
      *    BUILD NAME DISPLAY.
       SRCH-LOOP.
           CALL 'DBNTRY' USING USER-ID,
                ACCT-RQ-AREA, ACCT-WORK-AREA, ACCT-ELEMENT-LIST.
           IF ACCT-RQ-RTCODE = '14'
               GO TO SRCH-DONE.
           IF ACCT-RQ-RTCODE NOT = SPACES
               MOVE ACCT-RQ-AREA TO DATACOM-ERR
               GO TO OTHER-ERRORS.
           MOVE 'REDNR' TO ACCT-RQ-CMD.
           MOVE MAX-FNAME TO MIN-SNAME.
           TRANSFORM MIN-SNAME FROM HIGH-VALUES TO LOW-VALUES.
           IF FNAMEDO IN ACCTREC < MIN-FNAME OR
               FNAMEDO IN ACCTREC > MAX-FNAME, GO TO SRCH-LOOP.
           ADD 1 TO LINE-CNT.
           IF LINE-CNT > MAX-LINES,
               MOVE SNAMEDO OF ACCTREC TO MIN-SNAME
               MOVE FNAMEDO OF ACCTREC TO MIN-FNAME
               MOVE MSG-TEXT (15) TO MSGMO,
               MOVE DFHBMBRY TO MSGMA, GO TO SRCH-DONE.
           MOVE CORRESPONDING ACCTREC TO SUM-LINE.
           MOVE SUM-LINE TO SUMLNMO (LINE-CNT).
           GO TO SRCH-LOOP.
       SRCH-DONE.
      *    EXEC CICS ENDBR DATASET('ACCTIX') END-EXEC.
      *SRCH-ANY.
           IF LINE-CNT = 0, MOVE 7 TO MSG-NO,
               MOVE -1 TO SNAMEML, GO TO MENU-RESEND.
      *
      *    SEND THE NAME SEARCH RESULTS TO TERMINAL.
           MOVE DFHBMUNP TO SUMLNMA (1), SUMLNMA (2), SUMLNMA (3),
               SUMLNMA (4), SUMLNMA (5), SUMLNMA (6).
           MOVE DFHBMBRY TO MSGMA, MOVE DFHBMASB TO SUMTTLMA.
           EXEC CICS SEND MAP('ACCTMNU') MAPSET('ACCTSET')
               FREEKB DATAONLY ERASEAUP END-EXEC.
           IF LINE-CNT NOT > MAX-LINES,
               EXEC CICS RETURN TRANSID('AC01') END-EXEC
           ELSE EXEC CICS RETURN TRANSID('AC01') COMMAREA(SRCH-CTRL)
                   LENGTH(61) END-EXEC.
      *
      *    DISPLAY, PRINT, ADD, MODIFY AND DELETE PROCESSING.
      *    CHECK ACCOUNT NUMBER.
       CK-ANY.
           IF IN-REQ = SPACES, MOVE -1 TO SNAMEML,
               MOVE 8 TO MSG-NO, GO TO MENU-RESEND.
       CK-ACCTNO-1.
           IF ACCTC = SPACES, MOVE STARS TO ACCTMO,
               MOVE 5 TO MSG-NO, GO TO ACCT-ERR.
           IF (ACCTC < '10000' OR ACCTC > '79999' OR ACCTC NOT NUMERIC),
               MOVE 6 TO MSG-NO, GO TO ACCT-ERR.
       CK-ACCTNO-2.
           MOVE 'REDKX' TO ACCT-RQ-CMD.
           MOVE 'ACTMI' TO ACCT-RQ-KEYNAME.
                   MOVE ACCTC TO ACCT-RQ-KEYVALUE1.
           CALL 'DBNTRY' USING USER-ID,
                ACCT-RQ-AREA, ACCT-WORK-AREA, ACCT-ELEMENT-LIST.
           IF ACCT-RQ-RTCODE = '14'
               GO TO NO-ACCT-RECORD.
           IF ACCT-RQ-RTCODE NOT = SPACES
               MOVE ACCT-RQ-AREA TO DATACOM-ERR
               GO TO OTHER-ERRORS.
           IF REQC = 'A',
               MOVE 9 TO MSG-NO, GO TO ACCT-ERR,
           ELSE GO TO CK-REQ.
       NO-ACCT-RECORD.
           IF REQC = 'A', GO TO CK-REQ.
           MOVE 10 TO MSG-NO.
       ACCT-ERR.
           MOVE -1 TO ACCTML, MOVE DFHBMBRY TO ACCTMA.
      *
      *    CHECK REQUEST TYPE.
       CK-REQ.
           IF REQC = 'D' OR 'P' OR 'A' OR 'M' OR 'X',
               IF MSG-NO = 0 GO TO CK-USE, ELSE GO TO MENU-RESEND.
           IF REQC = SPACES, MOVE STARS TO REQMO.
           MOVE -1 TO REQML, MOVE DFHBMBRY TO REQMA,
           MOVE 3 TO MSG-NO.
           GO TO MENU-RESEND.
      *
      *    TEST IF ACCOUNT NUMBER IN USE, ON UPDATES ONLY.
       CK-USE.
           IF REQC = 'P' OR 'D' GO TO BUILD-MAP.
           MOVE ACCTC TO USE-QID2.
           EXEC CICS READQ TS QUEUE(USE-QID) INTO(USE-REC)
               ITEM(USE-ITEM) LENGTH(USE-LNG) END-EXEC.
           ADD USE-LIMIT TO USE-TIME.
           IF USE-TIME > 236000, ADD 1 TO USE-DATE,
               SUBTRACT 236000 FROM USE-TIME.
           IF USE-DATE > EIBDATE OR
               (USE-DATE = EIBDATE AND USE-TIME NOT < EIBTIME)
               MOVE USE-TERM TO MSG-TERM, MOVE 11 TO MSG-NO,
               MOVE -1 TO ACCTML, MOVE DFHBMBRY TO ACCTMA,
               GO TO MENU-RESEND.
      *
      *    RESERV ACCOUNT NUMBER.
       RSRV.
           MOVE EIBTRMID TO USE-TERM, MOVE EIBTIME TO USE-TIME.
           MOVE EIBDATE TO USE-DATE.
           EXEC CICS WRITEQ TS QUEUE(USE-QID) FROM(USE-REC)
               LENGTH(12) ITEM(USE-ITEM) REWRITE END-EXEC.
           GO TO BUILD-MAP.
       RSRV-1.
           MOVE EIBTRMID TO USE-TERM, MOVE EIBTIME TO USE-TIME.
           MOVE EIBDATE TO USE-DATE.
           EXEC CICS WRITEQ TS QUEUE(USE-QID) FROM(USE-REC)
               LENGTH(12) END-EXEC.
      *
      *    BUILD THE RECORD DISPLAY.
       BUILD-MAP.
           IF REQC = 'X' MOVE 'DELETION' TO TITLEDO,
               MOVE -1 TO VFYDL, MOVE DFHBMUNP TO VFYDA,
               MOVE 'ENTER "Y" TO CONFIRM OR "CLEAR" TO CANCEL'
                   TO MSGDO,
           ELSE MOVE -1 TO SNAMEDL.
           IF REQC = 'A' MOVE 'NEW RECORD' TO TITLEDO,
               MOVE DFHPROTN TO STATTLDA, LIMTTLDA, HISTTLDA,
               MOVE ACCTC TO ACCTDI,
               MOVE 'FILL IN AND PRESS "ENTER," OR "CLEAR" TO CANCEL'
                   TO MSGDO,
               GO TO SEND-DETAIL.
           IF REQC = 'M' MOVE 'RECORD CHANGE' TO TITLEDO,
               MOVE 'MAKE CHANGES AND "ENTER" OR "CLEAR" TO CANCEL'
                   TO MSGDO,
           ELSE IF REQC = 'D',
                   MOVE 'PRESS "CLEAR" OR "ENTER" WHEN FINISHED'
                       TO MSGDO.
           MOVE CORRESPONDING ACCTREC TO ACCTDTLO.
           MOVE CORRESPONDING PAY-HIST-R (1) TO PAY-LINE.
           MOVE PAY-LINE TO HIST1DO.
           MOVE CORRESPONDING PAY-HIST-R (2) TO PAY-LINE.
           MOVE PAY-LINE TO HIST2DO.
           MOVE CORRESPONDING PAY-HIST-R (3) TO PAY-LINE.
           MOVE PAY-LINE TO HIST3DO.
           IF REQC = 'M' GO TO SEND-DETAIL,
           ELSE IF REQC = 'P' GO TO PRINT-PROC.
           MOVE DFHBMASK TO
               SNAMEDA, FNAMEDA, MIDA, TTLDA, TELDA, ADDR1DA,
               ADDR2DA, ADDR3DA, AUTH1DA, AUTH2DA, AUTH3DA,
               AUTH4DA, CARDSDA, IMODA, IDAYDA, IYRDA, RSNDA,
               CCODEDA, APPRDA, SCODE1DA, SCODE2DA, SCODE3DA.
      *
      *    SEND THE RECORD DETAIL MAP TO THE TERMINAL.
       SEND-DETAIL.
           EXEC CICS SEND MAP('ACCTDTL') MAPSET('ACCTSET') ERASE FREEKB
               CURSOR END-EXEC.
           IF REQC = 'D', EXEC CICS RETURN TRANSID('ACCT') END-EXEC,
           ELSE EXEC CICS RETURN TRANSID('AC02')
                   COMMAREA(IN-REQ) LENGTH(6) END-EXEC.
      *
      *    START UP A TASK TO PRINT THE RECORD.
       PRINT-PROC.
           IF PRTRC = SPACES, MOVE STARS TO PRTRMO
               MOVE 4 TO MSG-NO, GO TO TERMID-ERR1.
           EXEC CICS START INTERVAL(12) TRANSID('AC03') FROM(ACCTDTLO)
               LENGTH(DTL-LNG) TERMID(PRTRC) END-EXEC.
           MOVE MSG-TEXT (12) TO MSGMO.
           EXEC CICS SEND MAP('ACCTMNU') MAPSET ('ACCTSET') DATAONLY
               ERASEAUP FREEKB END-EXEC.
           EXEC CICS RETURN TRANSID('AC01') END-EXEC.
       TERMID-ERR.
           MOVE 13 TO MSG-NO.
       TERMID-ERR1.
           MOVE -1 TO PRTRML, MOVE DFHBMBRY TO PRTRMA.
      *
      *    ERROR PROCESSING, FOR ALL REQUESTS.
      *    RESEND MENU SCREEN.
       MENU-RESEND.
           MOVE MSG-TEXT (MSG-NO) TO MSGMO.
           EXEC CICS SEND MAP('ACCTMNU') MAPSET('ACCTSET')
               CURSOR DATAONLY FRSET FREEKB END-EXEC.
           EXEC CICS RETURN TRANSID('AC01') COMMAREA(IN-AREA)
               LENGTH(41) END-EXEC.
      *
      *    PROCESSING FOR MAP FAILURES, CLEARS.
       NO-MAP.
           IF (EIBAID = DFHPA1 OR DFHPA2 OR DFHPA3 OR DFHENTER)
               MOVE 2 TO MSG-NO, MOVE -1 TO SNAMEML, GO TO MENU-RESEND.
           MOVE MSG-TEXT (14) TO MSGMO.
       NEW-MENU.
           EXEC CICS SEND MAP('ACCTMNU') MAPSET('ACCTSET')
               FREEKB ERASE END-EXEC.
           EXEC CICS RETURN TRANSID ('AC01') END-EXEC.
      *
      *    PROCESSING FOR UNEXPECTED ERRORS.
       OTHER-ERRORS.
           MOVE EIBFN TO ERR-FN, MOVE EIBRCODE TO ERR-RCODE.
           EXEC CICS HANDLE CONDITION ERROR END-EXEC.
           EXEC CICS LINK PROGRAM('ACCT04') COMMAREA
              (COMMAREA-FOR-ACCT04) LENGTH(26) END-EXEC.
           GOBACK.
