/*
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2001 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#
*/

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include <cmqc.h>		/* MQSeries Header file			*/

extern MQHCONN kixhConn;

int KXMQSUNDO()
{

MQLONG lCompCode, lReasonCode;
#ifdef MQ_SYNC_ENABLED

lReasonCode = lCompCode = 0; 
if (kixhConn)
   {
   MQBACK(kixhConn, &lCompCode, &lReasonCode);

   if (lReasonCode)
      {
      kxprtf("MQBACK failed with CompCode [%d], ReasonCode [%d]\n",lCompCode,lReasonCode);
      return(lReasonCode);
      }
   }
return(0);
#else
return(0);
#endif
}


int KXMQSSAVE()
{
MQLONG lCompCode, lReasonCode;

lReasonCode = lCompCode = 0; 

#ifdef MQ_SYNC_ENABLED
if (kixhConn)
   {
   MQCMIT(kixhConn, &lCompCode, &lReasonCode);

   if (lReasonCode)
      {
      kxprtf("MQCMIT failed with CompCode [%d], ReasonCode [%d]\n",lCompCode,lReasonCode);
      return(lReasonCode);
      }
   }
return(0);
#else
return(0);
#endif
}


int KXMQSETRN()
{
MQLONG lCompCode, lReasonCode;

#ifdef MQ_SYNC_ENABLED

lReasonCode = lCompCode = 0; 
if (kixhConn)
   {
   MQDISC(&kixhConn, &lCompCode, &lReasonCode);

   kixhConn=NULL;

   if (lReasonCode)
      {
      kxprtf("MQDISC failed with CompCode [%d], ReasonCode [%d]\n",lCompCode,lReasonCode);
      return(lReasonCode);
      }
   }
return(0);
#else
return(0);
#endif
}
