#Copyright 10/01/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)dr-serengeti-d.x	1.16 01/10/01          Sun Microsystems"


[ use MANAGED-MODULE ]
[ requires template dr-serengeti-models-d ]
[ requires package dr ]
[ requires template dr-serengeti-family-j ]

# Overwrite the Default ACLs specified.
# Allow DR operations only for adminUsers,adminGroups and adminCommunites

userAccess(%operatorUsers,write)       = none
userAccess(%operatorCommunities,write) = none
groupAccess(%operatorGroups,write)     = none
userAccess(%generalUsers,write)       = none
userAccess(%generalCommunities,write) = none
groupAccess(%generalGroups,write)     = none

[ load dr-serengeti-v2-m.x ]

_filters = { [ use PROC ]
        [ source dr-serengeti-d.flt ]
}


#
# Define services required by this module
#
_services = { [ use SERVICE ]
 
        #
        # Standard Bourne Shell
        #

        sh = {
                command = ::shell:pipe:/bin/sh
                max = 1
        }

        dr-shell = {
                command = "pipe://localhost/oa-shell.sh;transport=shell;args=dr-shell.tcl"
                max     = 1
        }
 
}


############
# DR Availability
############
availability = { [ use _filters ]
        mediumDesc                 =
        type                       = active
        refreshMode                = sync
        refreshService             = _services.sh
        refreshCommand             = dr-serengeti-availability.sh
        refreshFilter              = availabilityFilter
        refreshInterval            = 86400
        initInterval               = 0
        initHoldoff                = 2

        alarmChecks                = "disabled-eq error-ne";

        alarmlimit:disabled-eq     = "UNAVAILABLE";
        statusActions(disabled-eq) = forcedown
        disabledMessage            = "Module is not supported on this platform."

        alarmlimit:error-ne        = "AVAILABLE";
        statusActions(error-ne)    = forcedown
        errorMessage               = "Module em is required, but not present"

        statusService(forcedown)   = _superior
        statusCommand(forcedown)   = forceModuleState down %[ toe_self ]
}

##
## Check the platform name and hide the Dual CPU Table
## if the platform is not a Sun Fire 15000.
##
platformCheck = { [ use templates.dr-serengeti-models-d.platformCheck _filters ]
   type	           = active
   refreshService  = _services.sh
   refreshCommand  = /usr/bin/uname -i
   refreshFilter   = checkPlatform
   initInterval    = 0
   initHoldoff     = 2
   refreshInterval = 0
}

emDependency = {  [ use templates.dr-serengeti-models-d.dr-object.emDependency ]
		  [ use _filters ]

	type		= derived
	refreshMode	= async
	initInterval	= 0
	refreshService	= _services.dr-shell
	refreshCommand	= drdaq
	refreshFilter	= drdaqFilter
	refreshTrigger	= .iso*em.dr-class.statechange.apid:set
	refreshInterval	= 1800
	timeoutInterval	= 600
}

#Serengeti stuff
slots = { [ use templates.dr-serengeti-models-d.dr-object.slots ]
		[ use templates.dr-serengeti-family-j.slots ]

  cpu-mem = { 	[ use templates.dr-serengeti-models-d.dr-object.slots.cpu-mem ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.cpumem ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 0 CPU
	refreshFilter   = drsetop 
	timeoutInterval = 600

    cpu-mem-table = { 



	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-sbdcmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

  io-wib = {	[ use templates.dr-serengeti-models-d.dr-object.slots.io-wib ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.iowib ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 0 I/O
	refreshFilter   = drsetop
	timeoutInterval = 600

    io-wib-table = { 

	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-sbdcmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

  pci  = {	[ use templates.dr-serengeti-models-d.dr-object.slots.pci ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.pci ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 0 pci
	refreshFilter   = drsetop
	timeoutInterval = 600

    pci-table = { 

	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-sbdcmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

  scsi = {	[ use templates.dr-serengeti-models-d.dr-object.slots.scsi ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.scsi ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 0 scsi
	refreshFilter   = drsetop
	timeoutInterval = 600

    scsi-table = { 

	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-sbdcmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

  empty-slots = { [ use templates.dr-serengeti-models-d.dr-object.slots.empty-slots ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.emptyslots ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 0 unknown
	refreshFilter   = drsetop
	timeoutInterval = 600

    empty-slots-table = { 

	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-sbdcmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

   dcpu = { [ use templates.dr-serengeti-models-d.dr-object.slots.dcpu ]
            [ use _filters ]
            [ use templates.dr-serengeti-family-j.dcpu ]

      type            = derived
      refreshMode     = async
      initInterval    = 2
      refreshTrigger  = .iso*dr-serengeti.emDependency:refresh
      refreshService  = _services.dr-shell
      refreshCommand  = drinfo 0 MCPU
      refreshFilter   = drsetop 
      timeoutInterval = 600

      dcpu-table = { 

         entry = {
            cmdStateNode = { [ use _filters ]
               type            = derived
               refreshMode     = sync
               refreshService  = _internal
               refreshTrigger  = Receptacle:refresh
               refreshCommand  = cmdStateTableRefresh "0"
               refreshInterval = 0
            }
            cmdStatusNode = { [ use _filters ]
               type            = derived
               refreshMode     = sync
               refreshService  = _internal
               refreshTrigger  = Receptacle:refresh
               refreshCommand  = get-msg-from-file 0
               refreshInterval = 0
            }
            plfmCmdNode = { [ use _filters ]
               setActions             = run_script 
               setService(run_script) = _internal
               setCommand(run_script) = execute-sbdcmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
            }
         }
      }
   }
}

daps = { [ use templates.dr-serengeti-models-d.dr-object.daps ]
		[ use templates.dr-serengeti-family-j.daps ]

  cpu = { [ use templates.dr-serengeti-models-d.dr-object.daps.cpu ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.cpu ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger  = .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 1 cpu
	refreshFilter   = drsetop
	timeoutInterval = 600

    cpu-table = {
 
	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-dapscmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

  mem = { [ use templates.dr-serengeti-models-d.dr-object.daps.mem ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.mem ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 1 memory
	refreshFilter   = drsetop
	timeoutInterval = 600

    mem-table = { 

	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 1
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-dapscmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

  io = { [ use templates.dr-serengeti-models-d.dr-object.daps.io ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.io ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 1 io
	refreshFilter   = drsetop
	timeoutInterval = 600

    io-table = { 

	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-dapscmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

  disk = { [ use templates.dr-serengeti-models-d.dr-object.daps.disk ]
		[ use _filters ]
		[ use templates.dr-serengeti-family-j.disk ]
		

	type            = derived
	refreshMode     = async
	initInterval    = 2
	refreshTrigger	= .iso*dr-serengeti.emDependency:refresh
	refreshService  = _services.dr-shell
	refreshCommand  = drinfo 1 scsi-comp
	refreshFilter   = drsetop
	timeoutInterval = 600

    disk-table = { 

	entry = {
		cmdStateNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = cmdStateTableRefresh "0"
                        refreshInterval = 0
		}
		cmdStatusNode = { [ use _filters ]
                        type = derived
                        refreshMode     = sync
                        refreshService     = _internal
                        refreshTrigger  = Receptacle:refresh
                        refreshCommand   = get-msg-from-file 0
                        refreshInterval = 0
		}
		plfmCmdNode = { [ use _filters ]
			setActions = run_script 
                        setService(run_script) = _internal
                        setCommand(run_script) = execute-dapscmd %value %[ valueOf Ap_Id.${index} ] %[ valueOf Type.${index} ] %[ valueOf Receptacle.${index} ] %[ list ${index} ]
		}
	}
    }
  }

}
