package NWS::D2Schema;
#  $Name:  $ 
#  $Id: D2Schema.pm,v 1.6 2001/02/16 19:32:48 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.6 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j);
  my($CTRL);

Debug->print1("newSystem:");

  # From "./NWS/SCH_Storage.pm"
  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		  => $rep->get('id.wwn')],
                    [SystemName           => $rep->get('id.name')],
		    [OtherIdentifyingInfo => $rep->get('inq_info.LogicalPath')],
  		    # FIXME - really slot count.
                    [FruDiskDriveCount    => $rep->get('RdEncCfg.Number_of_Device_Slots')],
                    [FruPowerCount        => $rep->get('RdEncCfg.Number_of_Power_Supplies')],
                    [Fan0Status           => $rep->get('RdEncSts.Fan_0_Status')],
                    [Fan1Status           => $rep->get('RdEncSts.Fan_1_Status')],
                    [Caption              => "D2"],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 					=> $rep->get('id.wwn')],
                  [Manufacturer 		=> 'SUN'],
                  [Model 				=> 'D2'],
                  [Name  				=> $rep->get('id.wwn')],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 				=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  for ($j = 0; $j <= 2 ; $j++) {
      $dd = $class->newPowerUnit($rep,"power.$j");
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "pcu$j"],
                   ]);

      push (@pil, @$dd);
      push (@pil, $a);
  }

  
# FIXME - add newDiskDrive

  return Ilist->new(\@pil);

}

# FIXME - also add newFanUnit!

# FIXME - also add newPowerUnit!
sub newPowerUnit {
  my($class, $rep, $cd) = @_;
  my(@il, $p1 ,$c1, $a1);

Debug->print1("newPowerUnit:");

  my($serial_no) = $rep->get('id.wwn') . ".$cd";

  my($map) = PDM->getDeviceStateMap("d2.availability");
  my($state) = $map->get("status." . $rep->get('id.wwn'));

  $p1 = CIM::Instance->new('NWS_PowerUnit', [
               [SystemName   => $cd],
               [DeviceID     => $serial_no],
               [StatusInfo   => $rep->get('id.wwn')],
               [Status       => $state ],
                    ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
               [Removable       => "Yes"],
               [Tag             => $serial_no],
               [SerialNumber    => $serial_no],
               [Manufacturer    => ""],
               [Model           => ""],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
               [Antecedent      => $c1],
               [Dependent       => $p1],
                    ]);

  push(@il,$a1);

Debug->print1("newPowerUnit: return");

  return Ilist->new(\@il);
}

# create instances of NWS_DiskDrive, CIM_Realizes, CIM_PhysicalPackage, 
# CIM_MediaPresent and CIM_StorageExtent, CIM_SoftwareElement, CIM_DeviceSoftware
#  $disk = NWS::D2Schema->newDiskDrive($rep, "u1d1");

1;
