package D2Health;

#       "@(#)D2Health.pm 1.4     01/09/18 SMI"


use base 'Health';
use NWS::D2Schema;
use Ilist;
use Message;
use Report;
use Events;
use strict;
use Debug;
sub revision {'$Revision: 1.4 $'}


sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'D2Health');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_D2});
  return $self;
}

#####################################################


sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $comp);
  $DB::single = 1;
  my($rep)     = $report->content;
  my($oreport) = $pdm->getLastReport($report->fileKey);
#  my($name)    =  $report->accessName;  # name of the D2, by luxadm
  my($name)    =  $report->deviceName;  # name of the D2, by luxadm
#  $name = "D2.$name";
  Debug->print2("D2Health: all_logic: name = $name");
  my $wwn = Catalog->deviceRead('d2', Catalog::Name, $name, Catalog::Key);
  Debug->print2("D2Health: all_logic: wwn = $wwn");

  my($log)     = $report->log();
#  my($id)      = "$name with wwn:$wwn";
  CIM->version("1.1");
  if (!$wwn) {
     Debug->err(ERROR => "This D2 ($name) cannot be identified");
     return;
  }
#  my($SysName) = $report->name; 
  my($SysName) = System->hostname();
  my($LogicalPath) = $rep->get("inq_info.LogicalPath"); 
  my($id)      = "@ host: $SysName, $name, dev: $LogicalPath";
  my($esmid) = $id;
  $esmid =~ s/D2./D2 ESM SN: /;
  Debug->print2("D2Health: id=$id");

  $hm->logEvent($log, $report, $wwn, 1) if ($log);
  my($slot_max) = $rep->get("RdEncCfg.Number_of_Device_Slots");
  if (($slot_max !~ /6/) && ($slot_max !~ /12/)) {
	Debug->print2("D2Health: slot_max = $slot_max!!!!!!!!!!!!!!!!!");
        my($desc0) = "Cannot connect to $id";
	Debug->print2("desc0=$desc0, wwn=$wwn");
        $hm->alarmEvent( "", $report, $wwn,  $desc0);
	return;
  }
  return if ( $hm->connectionEvent($wwn, $report, {method => 1} )); # return if cannot_connect

  my($audit); 
  my($freq) = System->get_renv()->{audit_freq} || 7;
  if (!$oreport || ($audit = $pdm->isXdays("Audit$wwn", $freq)) eq "YES" ) {  # new D2 or audit time.
      Debug->print2("D2Health: (1st report) name = $name, wwn = $wwn");
#     D2Agent->disks_display("*", $rep);  # add the disk details.

     my($etype) = $audit ? "d2.AuditEvent" : "d2.DiscoveryEvent";
     my($title) = $audit ? "Auditing":"Discovered";
     my($dt)    = "A" if (!$audit);
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "$title a new D2 $esmid"],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::D2Schema->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);

     #
     # Establish a baseline.
     #
     my($j, $s1);

     for ($j=0; $j < 2; $j++) {
	$s1 = $rep->get("RdEncSts.Fan_${j}_Status");
	Debug->print2("D2Health: (1st pass) Fan: $s1");
	if ($s1 !~ /(0x00)/) {
	 my($desc0) = "Fan $j status: $s1 $esmid";
	 $hm->alarmEvent( "", $report, $wwn,  $desc0);
	 State->saveState("D2", $wwn, "fan.$j", $name, 
	       Message::SEVERITY_WARNING, $desc0);
	}
	$s1 = $rep->get("RdEncSts.Power_Supply_${j}_Status");
	Debug->print2("D2Health: (1st pass) Power Supply: $s1");
	if ($s1 !~ /(0x00)/) {
	 my($desc0) = "Power Supply $j status: $s1 $esmid";
	 $hm->alarmEvent( "", $report, $wwn,  $desc0);
	 State->saveState("D2", $wwn, "pwrsupply.$j", $name, 
	       Message::SEVERITY_WARNING, $desc0);
	}
     }
     $s1 = $rep->get("RdDevSlotSts.Vendor_Unique");
     Debug->print2("D2Health: (1st pass) Vendor Unique: $s1");
     if ($s1 !~ /Normal/) {
      my($desc0) = "Vendor Unique byte: $s1 $esmid";
      $hm->alarmEvent( "", $report, $wwn,  $desc0);
      State->saveState("D2", $wwn, "vendor_unique", $name, 
            Message::SEVERITY_WARNING, $desc0);
     }
     $s1 = $rep->get("RdEncSts.Temp._Out_of_Range_Flags_1");
     Debug->print2("D2Health: (1st pass) Temp Out of Range Flags 1: $s1");
     if ($s1 !~ /0x00/) {
      my($desc0) = "Temp Out of Range Flags 1: $s1 $esmid";
      $hm->alarmEvent( "", $report, $wwn,  $desc0);
      State->saveState("D2", $wwn, "temp_oor", $name, 
            Message::SEVERITY_WARNING, $desc0);
     }
     my($slot_max) = $rep->get("RdEncCfg.Number_of_Device_Slots");
     Debug->print2("D2Health: (1st pass) Disks: max slots = $slot_max");
     for ($j=0; $j < $slot_max; $j++) {
	$s1 = $rep->get("RdDevSlotSts.${j}");
	Debug->print2("D2Health: (1st pass) Disks: NEW $s1");
	if ($s1 !~ /Drive inserted./) {
		$s1 =~ s/	/ /g;
		$s1 =~ s/-- None.//;
		my($desc0) = "Disk $j status: $s1 $esmid";
		$hm->alarmEvent( "", $report, $wwn,  $desc0);
		State->saveState("D2", $wwn, "disk.$j", $name, 
		    Message::SEVERITY_WARNING, $desc0);
	}
     }
  }
  return if (!$oreport);
  $orep = $oreport->content;
  $hm->locationChangeEvent($report, $rep, $orep, $wwn);
  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame', # frame key 
                       Tag               => $wwn,
                       CreationClassName => 'CIM_PhysicalFrame' ]);

# FIXME - add newDiskDrive

  my($j, $s1, $s2);

  for ($j=0; $j < 2; $j++) {
      $comp = "fan.$j";
      $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', "$wwn.$comp");
      $s2 = $orep->get("RdEncSts.Fan_${j}_Status");
      $s1 = $rep->get("RdEncSts.Fan_${j}_Status");
#$s1 = "(0x01) Fan is bad";
      Debug->print2("D2Health: checking Fan: OLD: $s2, NEW $s1");
      if ($s1 ne $s2) {
         Debug->print2("D2Health: calling Fan saveState: OLD: $s2, NEW $s1");
         my($desc0) = "Fan $j status changed from $s2 to $s1 $esmid";
         $hm->alarmEvent( "", $report, $wwn,  $desc0);
	 if ($s1 !~ /(0x00)/) {
             State->saveState("D2", $wwn, "fan.$j", $name, 
               Message::SEVERITY_WARNING, $desc0);
         } else {
             State->saveState("D2", $wwn, "fan.$j", $name, 
               Message::SEVERITY_GREEN, $desc0);
         }
      }
      $comp = "pwrsupply.$j";
      $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', "$wwn.$comp");
      $s2 = $orep->get("RdEncSts.Power_Supply_${j}_Status");
      $s1 = $rep->get("RdEncSts.Power_Supply_${j}_Status");
      Debug->print2("D2Health: checking Power Supply: OLD: $s2, NEW $s1");
      if ($s1 ne $s2) {
         Debug->print2("D2Health: calling Power Supply saveState: OLD: $s2, NEW $s1");
         my($desc0) = "Power Supply $j status changed from $s2 to $s1 $esmid";
         $hm->alarmEvent( "", $report, $wwn,  $desc0);
	 if ($s1 !~ /(0x00)/) {
             State->saveState("D2", $wwn, "pwrsupply.$j", $name, 
               Message::SEVERITY_WARNING, $desc0);
         } else {
             State->saveState("D2", $wwn, "pwrsupply.$j", $name, 
               Message::SEVERITY_GREEN, $desc0);
         }
      }
  }
  my($slot_max) = $rep->get("RdEncCfg.Number_of_Device_Slots");
  Debug->print2("D2Health: checking Disks: max slots = $slot_max");
  for ($j=0; $j < $slot_max; $j++) {
      $comp = "disk.$j";
      $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', "$wwn.$comp");
      $s2 = $orep->get("RdDevSlotSts.${j}");
      $s1 = $rep->get("RdDevSlotSts.${j}");
      Debug->print2("D2Health: checking Disks: OLD: $s2, NEW $s1");
      if ($s1 ne $s2) {
         Debug->print2("D2Health: calling Disk saveState: OLD: $s2, NEW $s1");
         my($desc0) = "Disk $j status changed from $s2 to $s1 $esmid";
	 $desc0 =~ s/	/ /g;
	 $desc0 =~ s/-- None.//;
         $hm->alarmEvent( "", $report, $wwn,  $desc0);
         State->saveState("D2", $wwn, "disk.$j", $name, 
               Message::SEVERITY_WARNING, $desc0);
      }
  }


	$comp = "vendor_unique";
	$hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', "$wwn.$comp");
	$s2 = $orep->get("RdDevSlotSts.Vendor_Unique");
	$s1 = $rep->get("RdDevSlotSts.Vendor_Unique");
	Debug->print2("D2Health: checking Vendor Unique: OLD: $s2, NEW $s1");
	if ($s1 ne $s2) {
	Debug->print2("D2Health: calling Vendor Unique saveState: OLD: $s2, NEW $s1");
	 my($desc0) = "Vendor Unique byte changed from $s2 to $s1 $esmid";
	 $hm->alarmEvent( "", $report, $wwn,  $desc0);
         State->saveState("D2", $wwn, "vendor_unique", $name, 
	       Message::SEVERITY_WARNING, $desc0);
	}


	$comp = "temp_oor";
	$hm->stateEvent($comp, $report, $rep, $orep, 'CIM_PhysicalPackage', "$wwn.$comp");
	$s2 = $orep->get("RdEncSts.Temp._Out_of_Range_Flags_1");
	$s1 = $rep->get("RdEncSts.Temp._Out_of_Range_Flags_1");
	Debug->print2("D2Health: checking Temp Out of Range Flags 1: OLD: $s2, NEW $s1");
	if ($s1 ne $s2) {
	Debug->print2("D2Health: calling Temp Out of Range saveState: OLD: $s2, NEW $s1");
	 my($desc0) = "Temp Out of Range Flags 1 changed from $s2 to $s1 $esmid";
	 $hm->alarmEvent( "", $report, $wwn,  $desc0);
         State->saveState("D2", $wwn, "temp_oor", $name, 
	       Message::SEVERITY_WARNING, $desc0);
	}

}


sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my($pdm) = $hm->{pdm};
   my($map) = $pdm->getDeviceStateMap("d2.availability");
   my($state, $ostate, $status, $ostatus, $old, $new);

   Debug->print3("D2Health: calling status, comp = $comp");

	$state = $rep->get("RdEncSts.Fan_0_Status");
	$ostate = $orep->get("RdEncSts.Fan_0_Status");

	$old = 0;
	$new = 0;

	return ($ostatus, $status, $old, $new);
}


sub compStatus {
   my($hm, $rep, $orep, $comp) = @_;

   Debug->print2("D2Health: calling compStatus");

   my($map) = PDM->getDeviceStateMap("d2.availability");
   my($state, $status, $new);

   if ($comp =~ /disk/) { # disk have state and status
     $state   = $rep->get("$comp.state");
     $status  = $rep->get("$comp.status");

     $new = $map->get("disk.status.$status") . $map->get("disk.state.$state");

     $new = ($new eq "11")? 1:0;
     return ("$status-$state", $new);

   } else {
     $status  = $rep->get("$comp.status");
     $new = $map->get("status.$status");

     return ($status, $new);
   }
}
   


1;
