package GUIAdmin::D2;

#       "@(#)D2.pm 1.10     01/10/22 SMI"

use PDM;
use Util;
use Agent;
use Agent::D2Agent;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use base 'GUIAdmin';

sub isDevice {1}
sub description {'D2'};

sub ipRequired {1}

sub discover {
  my( $q, $post, $util) = @_;
  my($o);
  print "\n";
  if ($q->{ACTION} =~ /Confirm/) {
     &discoverd2($q, $post, $util);
     return 'DONE';
  }

  my($h) = GUIAdmin->header("Discover D2s");

  $o =<<EOF;
 <body bgcolor=$main'BGCOLOR>
 <center>
 $h
<table border=0 cellpadding=4 width=80% bgcolor=white><tr><td>
This program will request a list of D2's from each registered Slave host.  This list will be compared with the configured D2's and any new ones will be added. This may take a few seconds per Slave.<p><center>
</table>
<table border=1 cellspacing=0 cellpadding=4 width=80% bgcolor=$main'LIGHT>
  <form method=get>
  <input type=hidden name=GO value=discover>
  <input type=hidden name=PKG value=GUIAdmin::D2::discover>
  <tr><td><center><b>
     <input type=submit name=ACTION value="Confirm D2 Discovery">
 </table>
 </form>
EOF
  print $o;
  return 0;

}

sub discoverd2 {
  my( $q, $post, $util) = @_;

  my(%T, @a, $loc, $ip);
  my(%F);
  my(@NEW);

  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
 
  my($cnt) = 0;
  foreach my $d (@$dev) {
     if ($d->{type} eq "d2") {
        $cnt++;
        if ($d->{ipno}) {
           $F{$d->{ipno}} = 1;
        } elsif ($d->{ip}) {
           my($ipno) = Util->name2ip($d->{ip});
           $F{$ipno} = 1 if ($ipno);
        }
     }
  }
  print "<pre>1 - Found $cnt D2 already registered ...\n";

	my $local = &getDevices($q,$post, $util);
	if (substr($local,0,3) eq "ERR") {
		print "LOCAL:   $local<br>";
	}
	@a = split(/\n/, substr($local,3) );
	my($skipit, $j, $addit) = 0;
	my($new_dev) = $#$dev;
	foreach my $l (@a) {
		$skipit = 0;
		foreach my $d (@$dev) {
			if ($d->{type} eq "d2" && $d->{name} eq $l &&
					$d->{host} eq "") {
				print "  *** Device $l already discovered! ***\n";
				$skipit = 1;
				last;
			}
		}
		if ($skipit == 1) {
			next;
		}
		$cnt++;
		$addit++;
		print "    Adding /dev/es/$l\n";
		$new_dev++;
		$dev->[$new_dev]{_name}    = "device" . $l;
		$dev->[$new_dev]{type}     = 'd2';
		$dev->[$new_dev]{name}     = $l;
		$dev->[$new_dev]{wwn}      = "/dev/es/$l";
		$dev->[$new_dev]{active}   = 'Y';
		$dev->[$new_dev]{host}     = "";
	}
  my($data, $d2, $file, $h, $url, $hbano);
  my($TO) = 20;
  print "2 - Finding D2 on Slave Agents ...\n";
  foreach $h (@$host) {
      print "  - Querying host $h->{hostname} / $h->{ip} ...\n";
      $url = Util->makeUrl($h->{ip}, "?GET=device&type=d2");
#     print "url = $url<br>";
      if ( ($data = Util::Http->get($url, $TO)) ) {
        if (substr($data,0,3) eq "ERR") {
           print "  $data<br>";
           next;
        } else {
           $data = substr($data,3);
        }
	my($a);
        @a = split(/\n/, $data);
        foreach my $d2 (@a) {
		$skipit = 0;
		foreach my $d (@$dev) {
			if ($d->{type} eq "d2" && $d->{name} eq $d2 &&
					$d->{host} eq $h->{hostname} ) {
				print "  *** Device $d2 already discovered! ***\n";
				$skipit = 1;
				last;
			}
		}
		if ($skipit == 1) {
			next;
		}
		$cnt++;
		$addit++;
		print "    Adding /dev/es/$d2\n";
		$new_dev++;
		$dev->[$new_dev]{_name}    = "device" . $d2;
		$dev->[$new_dev]{type}     = 'd2';
		$dev->[$new_dev]{name}     = $d2;
		$dev->[$new_dev]{wwn}      = "/dev/es/$d2";
		$dev->[$new_dev]{active}   = 'Y';
		$dev->[$new_dev]{host}     = $h->{hostname};
		$h->{last_push} = "";
	}
      }
  }
	print "Found $cnt D2 devices\n";
	if ($addit) {
		PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
	} else {
		$cnt = 0;
	}
  if ($cnt == 0) {
    print "  *** No new devices were added ***\n";
  }
  print "</pre>";
}

#
# returns the D2 that a slave has.
# response to a http request made by a master rasagent.

sub getDevices {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn);

#print "GET = $q->{GET}, type = $q->{type}<br>";
#print "GET = $q->{GET}, type = $q->{type}, name = $q->{name}, ACTION = $q->{ACTION}<br>";
#print "GET = $q->{GET}, name = $q->{name}, ACTION = $q->{ACTION}<br>";
  if ($q->{ACTION} =~ /identify/) {
     &identify($q);
     return ;
  }
        my($cnt) = 0;
        my($sesdev, $i, $found);
        my($error,$out) = Util->run_command("/bin/ls -C1 /dev/es", "",20);
        my($TO) = 20;
        foreach $sesdev (@$out) {
		my($dir) = System->get_home() . "/bin";
		my($err,$com) = Util->run_command("$dir/vpd /dev/es/$sesdev -i -l 2>&1", "vpd_luxadm.txt", $TO);
                if ($err) {
                        print("ERR: D2: $dir/vpd /dev/es/$sesdev -i -l    error = $err");
                        next;
                }
                $found = 0;
                foreach my $l (@$com) {
                        if (($l =~ /Vendor:/) && ($l =~ /SUN/)) {
                                $found++;
                        } elsif (($l =~ /Product:/) && ($l =~ /D2/)) {
                                $found++;
                        } elsif (($l =~ /Serial Number/) && ($l =~ /SAF-TE/)) {
                                $found++;
                        } elsif (($l =~ /Device type:/) && ($l =~ /Processor device/)) {
                                $found++;
                                last;
                        } else {
                                next;
                        }
                }
                if ($found eq 4) {
#                       print "    /dev/es/$sesdev is a D2 SAF-TE device<br>";
                        $f .= "$sesdev\n";
                        $i++;
                }
        }
        $cnt = $i;

#       print "Found $cnt D2 devices.<br>";
#print "OK $f<br>";
  return "OK $f";
}


sub addDevice {
  my( $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);

  print "\n";
  require "GUI/Devices.pm";
  if ($q->{ACTION} eq "Back") {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION} eq " Add ") {
    my($active) = "Y";
    while (1) {
     if ($q->{name} eq "") {
        $err = &main::info("Device name is mandatory <br>Record not added!");
        last;
     } elsif (!$q->{ip}) {
        $err = &main::info("You must enter an IP address for this device-type <br>Record not added!");
        last;
     } else {
        if (!($ipno = Util->testIp($q->{ip}))) {
           $q->{ERR} = &main::info("Warning: Cannot ping this D2: $q->{ip}");
           $active = "N";
        }
        ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
        foreach $x (@$dev) {
          if ($x->{name} eq $q->{name}) {
             $err = &main::info("Error: This Device Name is already used <br>Record not added!");
             goto out;
          } elsif ($q->{ip} && $x->{ip} eq $q->{ip}) {
             $err = &main::info("Error: This IP address is already used <br>Record not added!");
             goto out;
          } elsif ($ipno && $x->{ipno} eq $ipno) {
             $err = &main::info("Error: This IP address is already used <br>Record not added!");
             goto out;
          }
        }
         my($wwn) = Util->snmpWWN($q->{ip});
        $x = $#$dev + 1;
        $dev->[$x]{_name}    = "device" . ($x+1);
        $dev->[$x]{type}     = "d2";
        $dev->[$x]{wwn}      = "-" . $wwn;
        $dev->[$x]{name}     = $q->{name};
        $dev->[$x]{active}   = $active;
        $dev->[$x]{ip}       = $q->{ip};
        $dev->[$x]{telnet}   = $q->{telnet};
        $dev->[$x]{ipno}     = $ipno;
        $dev->[$x]{host}     = $q->{host};
        $dev->[$x]{datahost}   = $q->{datahost};
        GUIAdmin->clearSlave($q->{host}, $host);

        if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
           print "Cannot write to ConfigFile<br>";
        } else {
           $info = &main::info("Device added!", "green");
        }

        GUI::Devices::list($q);
        return;
     }
     last;
    }
  }
out:
  my($h) = &main::header("Maintain Devices : Add D2");

  ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
  $sel = ($q->{host} eq "")? "selected":"";


  my($phost) = "<select name=host><option value=\"\">[Select]</option>".
              "<option value=\"\" $sel>Local</option>";
  foreach $x (@$host) {
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";

  my($phostD) = "<select name=datahost>".  "<option value=\"\" $sel>Local</option>";
  foreach $x (@$host) {
    $sel = ($q->{datahost} eq $x->{ip})? "selected":"";
    $phostD .= "<option value=\"" . $x->{ip} . "\" $sel>" . $x->{hostname} ."</option>";
  }
  $phostD .= "</select>";

  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::D2::addDevice">
<center>
$h
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;Enter Device Information</td>

<tr><td bgcolor=$main'LIGHT width=30% align=right>Device Name :</td>
    <td><input type=text name=name size=15 maxlength=35 value="$q->{name}">

<tr><td bgcolor=$main'LIGHT width=30% align=right>Telnet Password (optional):</td>
    <td><input type=password name=telnet size=20 maxlength=30 value="$q->{telnet}">

<tr><td bgcolor=$main'LIGHT align=right>Primary Host :</td>
    <td>$phost</td>
<tr><td bgcolor=$main'LIGHT align=right>Data-Path Host :</td>
    <td>$phostD</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right> IP Name/Address :</td>
    <td><input type=text name=ip size=40 maxlength=40 value="$q->{ip}">

</table>
</table>
<b>
<input type=submit name=ACTION value=" Add ">
<input type=submit name=ACTION value="Back">
</form>
EOF

  print $o;

}

sub updDevice {
  my($q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print "\n";
  require "GUI/Devices.pm";

# print "updDevice: ACTION = $q->{ACTION}<br>";

  if ($q->{ACTION} =~ /Back/) {
	my($hostname) = System->hostname();
	my($master) = Util->findMaster;
#       print "Remote Got Back! hostname = $hostname, master = $master<br>";
	GUI::Devices::list($q);
	return;

  } elsif ($q->{ACTION} eq "Update") {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{host} = $q->{host};
    $dev->[$x]{datahost} = $q->{datahost};
    $dev->[$x]{name} = $q->{name};
    $dev->[$x]{telnet} = $q->{telnet};
    $dev->[$x]{hba}  = $q->{hba};
    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = &main::info("Device $name updated!", "green");

  } elsif ($q->{ACTION} eq "Delete") {
    ($renv, $dev, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    &main::save_event("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = &main::info("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  } elsif ($q->{ACTION} eq "Identify") {
#print "Got to drive IDENTIFY in updDevice! <br>";
#print "name: $q->{name}, host: $q->{host}, datahost: $q->{datahost} <br>";
    &identify($q);
    return;
  }
out:

 $h1 = &main::header("Maintain Devices : Update D2");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $sel = ($h->{datahost})? "":"selected";
  my($dataho) = "<select name=datahost><option value=\"\" $sel>Local</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{ip} eq $h->{datahost}) ? "selected":"";
       $dataho .= "<option value=\"$h1->{ip}\" $sel>$h1->{hostname}</option>";
  }
  $dataho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";


  $o =<<EOF;
<body bgcolor=$main'BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUIAdmin::D2::updDevice>
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=#666699><b><font color=white>&nbsp;Device Information</td>

<tr><td bgcolor=$main'LIGHT align=right>Device Type :</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type}</td>
        <td bgcolor=$main'LIGHT align=right>Monitoring:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$main'LIGHT width=30% align=right>Device Name :</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$main'LIGHT width=30% align=right>Telnet Password (optional):</td>
    <td><input type=password name=telnet size=20 maxlength=40 value="$h->{telnet}">

<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>IP Name/Address :</td>
    <td>&nbsp;$ip</td>
<tr><td bgcolor=$main'LIGHT width=30% nowrap align=right>IP Number :</td>
    <td>&nbsp;$ipno</td>

<tr><td bgcolor=$main'LIGHT align=right>WWN :</td>
    <td><b>$h->{wwn}</td>
<tr><td bgcolor=$main'LIGHT align=right>Primary Host :</td>
    <td><b>$ho</td>

<tr><td bgcolor=$main'LIGHT align=right>Data-Path Host :</td>
    <td><b>$dataho</td>

</table>
</table>
<b>

<input type=submit name=ACTION value="Update">
<input type=submit name=ACTION value="Delete">
<input type=submit name=ACTION value="Identify">
<input type=submit name=ACTION value="Back">
</form>
EOF

  print $o;
}

sub slave_identify {
  my($q) = @_;

  my($sesdev) = $q->{name};

#  print "got to slave_identify: sesdev = $sesdev<br>";

  $q->{GET} = "device";

  &identify($q);
}


sub identify {
  my($q) = @_;

  my($sesdev) = $q->{name};

#	print "Local: GET=$q->{GET}, host = $q->{host} <br>";

	# Check if remote request via getDevices.
	if ($q->{host} ne "") {
		my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

		my($data, $d2, $file, $h, $url, $hbano);
		my($TO) = 20;
		foreach $h (@$host) {
#		    print "hostname = $h->{hostname}<br>";
		    if ($h->{hostname} eq $q->{host}) {
			print "  - Identify querying host $h->{hostname} ...<br>";
			$url = Util->makeUrl($h->{ip}, "?GET=device&type=d2&ACTION=identify&name=$sesdev");
#			print "url = $url<br>";
			if ( ($data = Util::Http->get($url, $TO)) ) {
				if (substr($data,0,3) eq "ERR") {
				   print "  $data<br>";
				   next;
				} else {
				   $data = substr($data,3);
				}
				print "  $data<br>";
			}
			return;
		    }
		}
		return;
	}

	#
	# http being set indicates this is a remote host
	#
	my($hostname) = System->hostname();
	my($http) = "";
	if ($q->{GET} =~ /device/) { 
		$http = "http://$hostname:7654";
#		print "REMOTE SETUP: http = $http<br>";
	}

	my($input) = "";
	my($esm) = "";
	my($boxid) = "";
	my $command = System->get_home() . "/bin/identify -d -f /dev/es/$sesdev 2>&1";
#print "identify: command = $command <br>";
	my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
	if ($err) {
		print "identify: err = $err <br>";
		return;
	}
	my($cnt) = 0;
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		my($devname) = "";
		my($showname) = "None";
#print "$l <br>";
		if ($l =~ /ESM:/) {
			$esm = $l;
			$esm =~ s/^.*ESM: //;
			$esm = substr($esm, 0, 1);
			$boxid = $l;
			$boxid =~ s/^.*Unit ID: //;
			$boxid = substr($boxid, 0, 1);
		}
		if ($l !~ /rive/) {
			next;
		}
		$cnt++;
		if ($l =~ /after/) {
			$l =~ s/ after.*/./;
		}
		if ($l =~ /Drive Ready for Removal./) {
			$l =~ s/Ready for Removal.*/inserted./;
		}
		if ($l =~ /c/) {
			$devname = $l;
			$devname =~ s/^.*c/c/;
			$devname =~ s/s2.*$/s2/;
			$showname = $devname;
			$showname =~ s/s2.*$//;
		}
		my($slot, $rest) = split(/	/, $l, 2); # separate TAB
		my($id, $rest) = split(/	/, $rest, 2); # separate TAB

		my($status) = $l;
		$status =~ s/.*0x..........//;
#print "$status <br>";

		my($href_pre) = "<center><td nowrap>&nbsp;<a href=$http/?GO=GUIAdmin::D2::drive_identify&sesdev=$sesdev&slot=$slot&devname=$devname&http=$http>";
		my($no_href_pre) = "<center><td nowrap>&nbsp;";
		my($href_post) = "</a></center>";
		my($no_href_post) = "</center>";
		if ($l =~ /Drive inserted./) {
			$input .= "<tr>$href_pre<b>$slot</b>$href_post $href_pre<b>$id</b>$href_post $href_pre<b>$showname</b>$href_post <center><td nowrap>&nbsp;<b>$status</b>";
		} else {
			$input .= "<tr>$no_href_pre<b>$slot</b>$no_href_post $no_href_pre<b>$id</b>$no_href_post $no_href_pre<b>$showname</b>$no_href_post <center><td nowrap>&nbsp;<b>$status</b>";
		}
	}
	$input .= "<tr><td colspan=4 ><bgcolor=red><b>&nbsp;<a href=$http/?GO=GUIAdmin::D2::drive_leds_off&sesdev=$sesdev&cnt=$cnt&http=$http><b>Turn off all Drive Identify LEDs @ /dev/es/$sesdev (ESM: $esm, Unit: $boxid)</b> </td>";
	if ($esm !~ 0 && $esm !~ 1) {
		print "<font size=+2 color=navy><center><b>D2 Identify<br>";
		print "<font size=+2 color=red><center><b>Cannot connect to: /dev/es/$sesdev<br>";
		return;
	}


  print "\n\n";

  my($sespath) = "/dev/es/$sesdev";
  my($sn) = D2Agent::get_esm_sn($sespath);
  if ($sn eq "") {
	$sn = 0;
  }
#print "SN: $sn for /dev/es/$sesdev<br>";

  my($o) =<<EOF;

<body bgcolor=#E0E0E0>
<form method=get>
 <input type=hidden name=GO value=GUI::Devices::list>
<center>

<table border=0 cellspacing=0 cellpadding=2 width=90%>
  
 <tr>
	<td>
	<font size=+2 color=navy><b>Identify<br><br>
	<font color=navy>Host: <font color=red>$hostname &nbsp;&nbsp;&nbsp;&nbsp<font color=navy>D2 ESM Device: <font color=red>/dev/es/$sesdev<br>
	<font color=navy>D2 ESM SN: <font color=red>$sn &nbsp;&nbsp;&nbsp;&nbsp
	<font color=navy>ESM: <font color=red>$esm &nbsp;&nbsp;&nbsp;&nbsp<font color=navy>Unit ID: <font color=red>$boxid</b>

<hr noshade size="1">
	<font color=navy><br><br>Drive Identify<br>
	</td>

   
   <td align=right>
   
</table>
<table border=1 width=90% cellpadding=4 cellspacing=0 bgcolor=white>
 <tr><td>
To blink the amber
Identify LED on a drive slot, click on the <b>Slot, ID,</b> or <b>Device Name</b> link below.
 <p>
 <li>The 'Slot' column represents the D2 Slot #.
 <li>The 'ID' column represents the SCSI Target ID for that slot.
 <li>The 'Device Name' column represents the drive's Solaris device name.
 <li>The 'Status' column represents the drive insertion status.<br><br>
 <li><b>NOTE: </b>It is a good idea to turn off all identify LEDs before leaving this window.
 </table>


<table border=1 cellspacing=1 width=90% bgcolor=white><tr><td>
<tr><td colspan=4 bgcolor=#666699>
<tr>
    <td bgcolor=#CCCCFF><center><b>Slot</td>
    <td bgcolor=#CCCCFF><center><b>ID</td>
    <td bgcolor=#CCCCFF><center><b>Device Name</td>
    <td bgcolor=#CCCCFF><center><b>Status</td>

EOF

print $o;


  $o =<<EOF;


     <tr><td><bgcolor=white><b>$input</b></table></table></table>

   </td></b>

</table>

</form>
<br>
<br>
EOF

  print $o;

##################################################################################
my($o) =<<EOF;


<table border=0 cellspacing=0 cellpadding=2 width=90%>
  
 <tr>
	<td>
<hr noshade size="1"><br><br>
	<font size=+2 color=navy>D2 Identify
	</td>

   
   <td align=right>
   
</table>

<table border=1 width=90% cellpadding=1 cellspacing=0 bgcolor=white>
 <tr><td>
To blink the amber
Subsystem LED on a D2, click on the <b>Identify D2</b> link below.
 <p>
 <li><b>NOTE: </b>If the D2 Subsystem LED is set solid amber, this is an indication of a fault
in the D2 and clicking the <b>Identify D2</b> link below will not override it.
The <b>Monitor -> Instrumentation</b> page should be checked to determine the cause of the fault.<br><br>
 <li><b>NOTE: </b>In split-bus mode (6 slots per ESM), both ESMs in the D2 can blink the same D2 Subsystem LED,
but only the ESM that turned on the D2 Subsystem LED can turn it off.<br><br>
 <li><b>NOTE: </b>It is a good idea to turn off all identify LEDs before leaving this window.
 </table>


<table border=1 cellspacing=1 width=90% bgcolor=white>

EOF

print $o;

	$input = "<tr><td colspan=4 ><bgcolor=red><br><center><b>&nbsp;<a href=$http/?GO=GUIAdmin::D2::global_warning_led_on&sesdev=$sesdev&cnt=$cnt&http=$http><b>Identify D2 @ /dev/es/$sesdev (ESM: $esm, Unit: $boxid) via Subsystem LED</b></center><br> </td>";
	$input .= "<tr><td colspan=4 ><bgcolor=red><b>&nbsp;<a href=$http/?GO=GUIAdmin::D2::global_warning_led_off&sesdev=$sesdev&cnt=$cnt&http=$http><center><b>Turn off Subsystem LED @ /dev/es/$sesdev (ESM: $esm, Unit: $boxid)</b></center> <br></td>";
	$input .= "<tr><td colspan=4 ><bgcolor=red><b>&nbsp;<a href=$http/?GO=GUIAdmin::D2::turn_off_all_leds&sesdev=$sesdev&cnt=$cnt&http=$http><center><b>Turn off all Identify LEDs (Subsystem and Drive) @ /dev/es/$sesdev</b></center> <br></td>";

  $o =<<EOF;


     <tr><bgcolor=white><b>$input</b></table></table></table>

   </b>

</table>

</form>
<br>
<br>
EOF

  print $o;

##################################################################################

  my($action) = "";
  if ($http ne "") {
	my($master) = Util->findMaster;
#	$action = "ACTION=http://$master:7654/";
#       print "action = $action<br>";
# FIXME - for now just return to avoid re-login to master
	if ($master) {
		print "<hr noshade size=1>";
		return;
	}
  }

  my($o) =<<EOF;
<body bgcolor=#E0E0E0>
<form $action  method=get>
<form  method=get>
 <input type=hidden name=GO value=GUIAdmin::D2::updDevice>
 <input type=hidden name=no value=1>
<center>



<input type=submit name=ACTION value="Back">
</form>
</form>
</form>

EOF

print $o;

  print "<hr noshade size=1>";

}

sub drive_identify {
  my($q) =  @_;

  print "<body bgcolor=#E0E0E0><font size=+2 color=navy><b>Turn on D2 Drive Identify LED: Slot $q->{slot}, /dev/es/$q->{sesdev}</font><br><br>";

  if (Util->findMaster) {
	print "http = $q->{http}<br><br>";
  }

#  print "got to drive_identify <br>";

  if ($q->{sesdev} eq "") {
	print "drive_identify: no device name <br>";
	return;
  }

#  my $command = System->get_home() . "/bin/identify -i -f /dev/rdsk/$q->{devname} 2>&1";
  my $command = System->get_home() . "/bin/identify -i -s $q->{slot} -f /dev/es/$q->{sesdev} 2>&1";
#print "drive_identify: command = $command <br>";
  my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
  if ($err) {
  	print "drive_identify: err = $err <br>";
  	return;
  }
  print "&nbsp;&nbsp;&nbsp;&nbsp;Slot $q->{slot}: Drive Identify LED on. <br>";

  my($dest) = "identify";
  if ($q->{http} ne "") {
        $dest = "slave_identify";
  }

  my($o) =<<EOF;
<body bgcolor=#E0E0E0>
<form  method=get>
<form  method=get>
 <input type=hidden name=GO value=GUIAdmin::D2::$dest>
 <input type=hidden name=name value=$q->{sesdev}>
<center>



<input type=submit name=ACTION value="Back">
</form>

EOF

print $o;

}

sub drive_leds_off {
  my($q) =  @_;

  print "<body bgcolor=#E0E0E0><font size=+2 color=navy><b>Turn off D2 Drive Identify LEDs: /dev/es/$q->{sesdev}</font><br><br>";

  if (Util->findMaster) {
	print "http = $q->{http}<br><br>";
  }


#  print "got to drive_leds_off <br>";

  if ($q->{sesdev} eq "") {
	print "drive_leds_off: no device name <br>";
	return;
  }

  for (my($i) = 0; $i < $q->{cnt}; $i++) {
	my $command = System->get_home() . "/bin/identify -l 4 -s $i -f /dev/es/$q->{sesdev} 2>&1";
#print "drive_leds_off: command = $command <br>";
	my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
	if ($err) {
		print "drive_leds_off: err = $err <br>";
		return;
	}
	print "&nbsp;&nbsp;&nbsp;&nbsp;Slot $i: Drive Identify LED off. <br>";
  }

  my($dest) = "identify";
  if ($q->{http} ne "") {
        $dest = "slave_identify";
  }

  my($o) =<<EOF;
<body bgcolor=#E0E0E0>
<form  method=get>
<form  method=get>
 <input type=hidden name=GO value=GUIAdmin::D2::$dest>
 <input type=hidden name=name value=$q->{sesdev}>
<center>



<input type=submit name=ACTION value="Back">
</form>

EOF

print $o;
}

sub global_warning_led_on {
  my($q) =  @_;

  print "<body bgcolor=#E0E0E0><font size=+2 color=navy><b>Turn on D2 Subsystem LED: /dev/es/$q->{sesdev}</font><br><br>";

  if (Util->findMaster) {
	print "http = $q->{http}<br>";
	print "sesdev = $q->{sesdev}<br><br>";
  }

#  print "got to global_warning_led_on <br>";

  if ($q->{sesdev} eq "") {
	print "global_warning_led_on: no device name <br>";
	return;
  }

  my $command = System->get_home() . "/bin/identify -l 3 -s 0 -f /dev/es/$q->{sesdev} 2>&1";
# print "global_warning_led_on: command = $command <br>";
  my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
  if ($err) {
  	print "global_warning_led_on: err = $err <br>";
  	return;
  }
  print "&nbsp;&nbsp;&nbsp;&nbsp; D2 Subsystem LED on. <br>";

  my($dest) = "identify";
  if ($q->{http} ne "") {
        $dest = "slave_identify";
  }

  my($o) =<<EOF;
<body bgcolor=#E0E0E0>
<form  method=get>
<form  method=get>
 <input type=hidden name=GO value=GUIAdmin::D2::$dest>
 <input type=hidden name=name value=$q->{sesdev}>
<center>



<input type=submit name=ACTION value="Back">
</form>

EOF

print $o;

}

sub global_warning_led_off {
  my($q) =  @_;

  print "<body bgcolor=#E0E0E0><font size=+2 color=navy><b>Turn off D2 Subsystem LED: /dev/es/$q->{sesdev}</font><br><br>";

  if (Util->findMaster) {
	print "http = $q->{http}<br><br>";
  }

#  print "got to global_warning_led_off <br>";

  if ($q->{sesdev} eq "") {
	print "global_warning_led_off: no device name <br>";
	return;
  }

  my $command = System->get_home() . "/bin/identify -l 5 -s 0 -f /dev/es/$q->{sesdev} 2>&1";
# print "global_warning_led_off: command = $command <br>";
  my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
  if ($err) {
  	print "global_warning_led_off: err = $err <br>";
  	return;
  }
  print "&nbsp;&nbsp;&nbsp;&nbsp; D2 Subsystem LED off. <br>";

  if ($q->{cnt} eq "0") {
	return;
  }

  my($dest) = "identify";
  if ($q->{http} ne "") {
        $dest = "slave_identify";
  }

  my($o) =<<EOF;
<body bgcolor=#E0E0E0>
<form  method=get>
<form  method=get>
 <input type=hidden name=GO value=GUIAdmin::D2::$dest>
 <input type=hidden name=name value=$q->{sesdev}>
<center>



<input type=submit name=ACTION value="Back">
</form>

EOF

print $o;

}

sub turn_off_all_leds {
  my($q) =  @_;

  print "<hr noshade size=1>";
  &drive_leds_off($q);
  print "<hr noshade size=1>";
  $q->{cnt} = 0;
  &global_warning_led_off($q);
  print "<hr noshade size=1>";
}



1;
