package D2Agent;

#       "@(#)D2Agent.pm 1.10     01/10/22 SMI"

use Agent;
use Debug;
use Carp;
use Util;
use vars qw($AUTOLOAD);
use Debug;
use Report;
use Util::Http;
use Cwd;
use strict;
use base 'Agent';

sub isSelectable {"D2"} # displayed by the GUI in front of a checkbox that allows

# admin to turn this Agent off.
sub revision {'$Revision: 1.1 $'}

sub new { # standard to all Agent packages.
	my($self) = Agent->new();
	bless ($self, 'D2Agent');
	return $self;
}
sub RUN {
    my($agent) = @_;

    if (!$agent->category_selected) {
	Debug->print2("Skipping " . ref($agent) . ".");
	return;
    }

Debug->print1("D2Agent::RUN");
    my($dc, $device, $key);
# 2.0    foreach $device ( @{$agent->get_config_devices}) {
    foreach $device ( $agent->deviceList()) {
	$dc++;
	Debug->print1(" ");
	Debug->print1("D2Agent: Reading name: $device->{name}");
	Debug->print1("D2Agent: Reading type: $device->{type}");
	Debug->print1("D2Agent: Reading wwn:  $device->{wwn}");

	my($pdm) = $agent->{pdm}; # get handle to the PDM
	my($renv) = System->get_renv(); # get environment data-struct
	# Debug->print1("-> D2Agent: Reading host configuration");
	$key = get_esm_sn($device->{wwn});
	if ($key eq "") {
		$key = $device->{name};
	}
	# Debug->print2("key = $key");
	my $name = System->hostname(); # name of report

	my($dir) = System->get_home() . "/bin";
	my($err,$com) = Util->run_command("$dir/vpd $device->{wwn} -i -l 2>&1", "vpd_luxadm.txt", 20);
	if ($err) {
		Debug->print2("D2Agent: vpd $device->{wwn} -i -l    error = $err");
	}

	if ($key) {
		Debug->print2("D2Agent: key = $key");	
		Debug->print2("D2Agent: name = $name");	
	} else {
		Debug->err(TEXT => "Cannot identify this host, Skipping report"); # report an error when hostid fails.
		return; # get-out
	}
	# parse $com and generate data structure.
	my %Report;
	my($addlogical) = 0;
	my($connect_check) = 0;
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		my($name, $val) = split(/: /, $l); # separate
		$name = Util->ltrim($name); # remove leading spaces
		$name =~ s/ /_/g; # join
		# Debug->print2("name: $name, val: $val");
		if ($name eq "Vendor" || $name eq "Product" || $name eq "Revision") { 
			$Report{"inq_info.$name"} = $val;
		} elsif (substr($name, 0, 8) eq "/devices") {
		# Debug->print2("Found: $name");
			$val = $name;
			$name = "inq_info.PhysicalPath";
			$Report{$name} = $val;
		} elsif ($addlogical == 0) {
			$val = $device->{wwn};
			$name = "inq_info.LogicalPath";
			$Report{$name} = $val;
			$addlogical++;
		} else {
			if ($l =~ /SAF-TE/) {
				$val = "SAF-TE";
				$name = "inq_info.EnclosureType";
				$Report{$name} = $val;
				$connect_check++;
			}
		}
	}
	my $report = \%Report; # $report must be a hash pointer.
	$agent->addIdentification($report); # add device location to the report

	if (!$connect_check) {
		Debug->err(TEXT => "D2Agent: Cannot connect!"); 
		$err = 1;
		goto EXIT; # get-out
	}
	#
	# Append the SAF-TE config and status info to the report.
	#
	&read_enclosure_config($report, $device->{wwn});
	&read_enclosure_status($report, $device->{wwn});
	&read_device_slot_status($report, $device->{wwn});

	&dump_midplane_vpd($report, $device->{wwn});
	&dump_esm_vpd($report, $device->{wwn});
EXIT:
	my($xname) = "D2.$key";
	Debug->print2("D2Agent: deviceAccess: $xname");
# 2.0	$pdm->deviceAccess("n2k","D2.$key", 'd2', $key);
	my($wwn) = $device->{name};
	Debug->print2("D2Agent: PRE: wwn = $wwn, xname = $xname");
	Catalog->deviceWrite("$xname", ['d2', "$xname", "D2.$wwn",undef,undef,undef, undef,undef ]);
	$wwn = Catalog->deviceRead('d2', Catalog::Name, "$xname", Catalog::Key);
	my $key2name = Catalog->deviceRead("", Catalog::Key, "$xname", Catalog::Name);
	Debug->print2("D2Agent: POST: wwn = $wwn, key2name = $key2name");
	if (!$wwn) {
		Debug->err(TEXT => "Cannot identify this d2, no wwn available for $device->{name} ");
	}
	my $id = { accessName => $xname,
		deviceName => $xname,
		active => "Y",
		logFile => "",
		name => $xname,
		category => Report::CAT_D2, # valid category
		ip => "",
	};
	$report->{"id.name"} = $name;
	$report->{"id.wwn"} = $device->{wwn};
	if ($err) {
		$pdm->saveReport(
#		Report->new($id, $report , undef, Report::STATUS_CANNOT_CONNECT));
		Report->new($id, $report , undef, Report::STATUS_OK));
	} else {
		$pdm->saveReport(Report->new($id, $report , undef)); # normal status.
	}
    }
}

sub read_enclosure_config {
	my($report, $path) = @_;

	my $command = System->get_home() . "/bin/rdbuf $path";
	Debug->print3("read_enclosure_config: command = $command");
	my($err,$com) = Util->run_command( $command, "readenc.txt",20); # run the command, timeout after 20 secs.
	if ($err) {
		Debug->print2("read_enclosure_config: err = $err");
		return;
	}
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		my($name, $val) = split(/: /, $l); # separate
		$name = Util->ltrim($name); # remove leading spaces
		$name =~ s/ /_/g; # join
	# Debug->print2("name: $name, val: $val");
		if ($val ne "") {
			if ($l =~ /Vendor/) {
				next;
			}
			if ($l =~ /Temp/) {
				next;
			}
			if ($l =~ /\?/) {
				next;
			}
			if ($l =~ /:/) {
				$report->{"RdEncCfg.$name"} = $val;
			}
		}
	}
}

sub read_enclosure_status {
	my($report, $path) = @_;

	my $command = System->get_home() . "/bin/rdbuf $path 1";
	Debug->print3("read_enclosure_status: command = $command");
	my($err,$com) = Util->run_command( $command, "readenc.txt",20); # run the command, timeout after 20 secs.
	if ($err) {
		Debug->print2("read_enclosure_status: err = $err");
		return;
	}
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		my($name, $val) = split(/: /, $l); # separate
		$name = Util->ltrim($name); # remove leading spaces
		$name =~ s/ /_/g; # join
		# Debug->print2("name: $name, val: $val");
		if ($val ne "") {
			if ($l =~ /:/) {
				$report->{"RdEncSts.$name"} = $val;
			}
		}
	}
}

sub read_device_slot_status {
	my($report, $path) = @_;

	my $command = System->get_home() . "/bin/identify -d -f $path";
	Debug->print3("read_device_slot_status: command = $command");
	my($err,$com) = Util->run_command( $command, "rddevslot.txt",20); # run the command, timeout after 20 secs.
	if ($err) {
		Debug->print2("read_device_slot_status: err = $err");
		return;
	}
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		if ($l =~ /ESM: /) {
			my($vu) = $l;
			$vu =~ s/^.*ESM:/ESM:/;
			my($name) = "Vendor_Unique"; 
			$report->{"RdDevSlotSts.$name"} = $vu;
			# Debug->print2("RdDevSlotSts.$name: vu = $vu\n");
			next;
		}
		if ($l !~ /rive/) {
			next;
                }
		my($name, $val) = split(/	/, $l, 2); # separate
		$name = Util->ltrim($name); # remove leading spaces
		$name =~ s/ /_/g; # join
		$name =~ s/Slot__/Slot_0/g; # join
		if ($val ne "") {
			if ($l =~ /rive/) {
				Debug->print3("D2Agent: (PRE) name=$name, val=$val");
				if ($val =~ /after/) {
					$val =~ s/ after.*/./;
				}
				if ($val =~ /Drive Ready for Removal./) {
					$val =~ s/Ready for Removal.*/inserted./;
				}
				$val =~ s/\(0x........\)//;
				Debug->print3("D2Agent: (POST) name=$name, val=$val");
				$report->{"RdDevSlotSts.$name"} = $val;
			}
		}
	}
}

sub dump_midplane_vpd {
	my($report, $path) = @_;

	my($dir) = cwd();
	chdir System->get_home() . "/bin";
	my $command = "./vpd $path 1";  # need to run the command from "bin"
	Debug->print3("read_device_slot_status: command = $command");
	my($err,$com) = Util->run_command( $command, "dump_midplane_vpd.txt",20); # run the command, timeout after 20 secs.
	chdir $dir;
	$dir = cwd();
	if ($err) {
		Debug->print2("dump_midplane_vpd: err = $err");
		return;
	}
	my($full) = "";
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		my($val) = substr($l, 58, 16);
		$full = $full . $val;
		# Debug->print2("val = $val");
		# Debug->print2("full = $full");
	}
	if ($full !~ /PN/) {
		Debug->print2("dump_midplane_vpd: No Midplane VPD info.");
		$report->{"midplane_vpd.PN"} = "............";
		$report->{"midplane_vpd.SN"} = "............";
		$report->{"midplane_vpd.VN"} = "........";
		$report->{"midplane_vpd.DT"} = "........";
		$report->{"midplane_vpd.FT"} = "........";
		return;
	}
	$report->{"midplane_vpd.PN"} = substr($full, 8, 12);
	$report->{"midplane_vpd.SN"} = substr($full, 24, 12);
	$report->{"midplane_vpd.VN"} = substr($full, 40, 8);
	$report->{"midplane_vpd.DT"} = substr($full, 52, 8);
	$report->{"midplane_vpd.FT"} = substr($full, 64, 8);
}

sub dump_esm_vpd {
	my($report, $path) = @_;

	my($dir) = cwd();
	chdir System->get_home() . "/bin";
	my $command = "./vpd $path 2";  # need to run the command from "bin"
	Debug->print3("read_device_slot_status: command = $command");
	my($err,$com) = Util->run_command( $command, "dump_esm_vpd.txt",20); # run the command, timeout after 20 secs.
	chdir $dir;
	$dir = cwd();
	if ($err) {
		Debug->print2("D2Agent: dump_esm_vpd: err = $err");
		return;
	}
	my($full) = "";
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		my($val) = substr($l, 58, 16);
		$full = $full . $val;
		# Debug->print2("val = $val");
		# Debug->print2("full = $full");
	}
	if ($full !~ /PN/) {
		Debug->print2("D2Agent: dump_esm_vpd: No Midplane VPD info.");
		$report->{"esm_vpd.PN"} = "............";
		$report->{"esm_vpd.SN"} = "............";
		$report->{"esm_vpd.VN"} = "........";
		$report->{"esm_vpd.DT"} = "........";
		$report->{"esm_vpd.FT"} = "........";
		return;
	}
	$report->{"esm_vpd.PN"} = substr($full, 8, 12);
	$report->{"esm_vpd.SN"} = substr($full, 24, 12);
	$report->{"esm_vpd.VN"} = substr($full, 40, 8);
	$report->{"esm_vpd.DT"} = substr($full, 52, 8);
	$report->{"esm_vpd.FT"} = substr($full, 64, 8);
}

sub get_esm_sn {
	my($path) = @_;

	my($dir) = cwd();
	chdir System->get_home() . "/bin";
	my $command = "./vpd $path 2";  # need to run the command from "bin"
	Debug->print3("read_device_slot_status: command = $command");
	my($err,$com) = Util->run_command( $command, "dump_esm_vpd.txt",20); # run the command, timeout after 20 secs.
	chdir $dir;
	$dir = cwd();
	if ($err) {
		Debug->print2("D2Agent: get_esm_vpd: err = $err");
		return;
	}
	my($full) = "";
	foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
		my($val) = substr($l, 58, 16);
		$full = $full . $val;
		# Debug->print2("val = $val");
		# Debug->print2("full = $full");
	}
	my($sn) = "";
	if ($full !~ /SN/) {
		Debug->print2("D2Agent: get_esm_vpd: No ESM VPD SN.");
	} else {
		$sn = substr($full, 24, 12);
		$sn =~ s/ //g;
	}
	return $sn;
}

sub REPORT {
	my($class, $host, $r, $arg) = @_;

	my($out) = "";
	my($name) = $r->{_id}{name};

	my($report) = $r->{_value};# $rep->value is the actual hash created previously.
	
	my($pathkey) = "inq_info.LogicalPath";

	my($vustr) = "";
	foreach my $k (sort keys %$report) {
		if ($k =~ /RdDevSlotSts/) {
			if ($k =~ /RdDevSlotSts.Vendor_Unique/) {
				$vustr = $report->{$k};
			}
		}
	}
	my($esm, $rest) = split(/,/, $vustr, 2); # separate
	my($unit, $rest) = split(/,/, $rest, 2); # separate

	$out .= "
	<body bgcolor=#E0E0E0><center>
	<table border=0 cellspacing=0 cellpadding=2 width=90%>
	<tr> <td><font size=+2 color=navy>
	<b>D2 Report<br>
	<center><br>Name: $name, Device: $report->{$pathkey}</b><br>
	";
	if ($esm !~ 0 && $esm !~ 1) {
		$out .= "
		<font size=+2 color=red><center><b>Cannot connect!<br>
		</td><td align=right></table>
		";
		return $out;
	}
	$out .= "
	<b>$esm, $unit</b><br><br>
	</td><td align=right></table>

	<table border=1 cellspacing=0 width=90% bgcolor=white>
	<tr bgcolor=\"#666699\"> <td colspan=\"2\"><a name=\"INQUIRY\">
	</a><font color=\"#FFFFFF\"><b>Inquiry Info:</b></font></td> </tr>
	<tr><th>Name<th>Value</tr>
	";

	foreach my $k (keys %$report) {
		if ($k =~ /inq_info/) {
			my($x, $val) = split(/inq_info./, $k);
			$out .= "<tr><td>$val <td> $report->{$k}</td>";
		}
	}
	$out .= "</table>";

	$out .= "
	<table border=1 cellspacing=0 width=90% bgcolor=white>
	<tr bgcolor=\"#666699\"> <td colspan=\"2\"><a name=\"RDENCCFG\">
	</a><font color=\"#FFFFFF\"><b>Read Enclosure Configuration:</b></font></td> </tr>
	<tr><th>Name<th>Value</tr>
	";

	foreach my $k (keys %$report) {
		if ($k =~ /RdEncCfg.Number_of_Device_Slots/) {
			my($x, $val) = split(/RdEncCfg./, $k);
			$out .= "<tr><td>$val <td> $report->{$k}</td>";
		}
	}
	$out .= "</table>";

	$out .= "
	<table border=1 cellspacing=0 width=90% bgcolor=white>
	<tr bgcolor=\"#666699\"> <td colspan=\"2\"><a name=\"RDENCSTS\">
	</a><font color=\"#FFFFFF\"><b>Read Enclosure Status:</b></font></td> </tr>
	<tr><th>Name<th>Value</tr>
	";

	foreach my $k (keys %$report) {
		if ($k =~ /RdEncSts.Power/) {
			my($x, $val) = split(/RdEncSts./, $k);
			if ($report->{$k} =~ /(0x00)/) {
				$out .= "<tr><td>$val <td> $report->{$k}</td>";
			} else {
				$out .= "<tr><td>$val <td><font color=red> $report->{$k}</td>";
			}
		}
	}

	foreach my $k (keys %$report) {
		if ($k =~ /RdEncSts.Fan/) {
			my($x, $val) = split(/RdEncSts./, $k);
			if ($report->{$k} =~ /(0x00)/) {
				$out .= "<tr><td>$val <td> $report->{$k}</td>";
			} else {
				$out .= "<tr><td>$val <td><font color=red> $report->{$k}</td>";
			}
		}
	}

	foreach my $k (keys %$report) {
		if ($k =~ /RdEncSts.Temp/) {
			my($x, $val) = split(/RdEncSts./, $k);
			if ($report->{$k} =~ /ETA/) {
				if ($report->{$k} =~ /(ETA=0)/) {
					$out .= "<tr><td>$val <td> $report->{$k}</td>";
				} else {
					$out .= "<tr><td>$val <td><font color=red> $report->{$k}</td>";
				}
			} else {
				$out .= "<tr><td>$val <td> $report->{$k}</td>";
			}
		}
	}

	my($vendor_unique) = 0;
	foreach my $k (keys %$report) {
		if ($k =~ /RdEncSts.Vendor/) {
			$vendor_unique = $report->{$k};
		}
	}
	$out .= "</table>";

	$out .= "
	<table border=1 cellspacing=0 width=90% bgcolor=white>
	<tr bgcolor=\"#666699\"> <td colspan=\"4\"><a name=\"RDDEVSLOTSTS\">
	</a><font color=\"#FFFFFF\"><b>Read Device Slot Status:</b></font></td> </tr>
	<tr><th>Slot<th>SCSI ID<th>Device Name<th>Status</tr>
	";

	foreach my $k (keys %$report) {
		if ($k =~ /RdDevSlotSts/) {
			if ($k !~ /RdDevSlotSts.Vendor_Unique/) {
				my($sts) = $report->{$k};
				my($id, $rest) = split(/	/, $sts, 2); # separate
				my($devname, $devsts) = split(/	/, $rest, 2); # separate
				$devname =~ s/s2//;

				my($trailer) = "";
				if ($devsts =~ /Drive inserted/) {
					$trailer = "$devsts";
				} else {
					$trailer = "<font color=red>$devsts";
				}
				if ($devname =~ /None/) {
					$devname = "<font color=red>$devname";
				}
				my($x, $val) = split(/RdDevSlotSts./, $k);
				$out .= "<tr><td>$val<td>$id<td>$devname<td>$trailer</td>";
			}
		}
	}
	$out .= "</table>";

	$out .= "
	<table border=1 cellspacing=0 width=90% bgcolor=white>
	<tr bgcolor=\"#666699\"> <td colspan=\"2\"><a name=\"RDDEVSLOTSTSVU\">
	</a><font color=\"#FFFFFF\"><b>Read Device Slot Status: Vendor Unique</b></font></td></tr>
	<tr><th>Value<th>Meaning</tr>
	";

	foreach my $k (sort keys %$report) {
		if ($k =~ /RdDevSlotSts/) {
			if ($k =~ /RdDevSlotSts.Vendor_Unique/) {
				if ($report->{$k} =~ /Normal/) {
					$out .= "<tr><td>$vendor_unique<td> $report->{$k} </td>";
				} else {
					$out .= "<tr><td>$vendor_unique<td><font color=red> $report->{$k} </td>";
				}
			}
		}
	}
	$out .= "</table>";

	$out .= "
	<table border=1 cellspacing=0 width=90% bgcolor=white>
	<tr bgcolor=\"#666699\"> <td colspan=\"2\"><a name=\"MIDPLANE\">
	</a><font color=\"#FFFFFF\"><b>Midplane VPD:</b></font></td> </tr>
	<tr><th>Name<th>Value</tr>
	";


	foreach my $k (keys %$report) {
		if ($k =~ /midplane_vpd/) {
			my($x, $val) = split(/midplane_vpd./, $k);
			$out .= "<tr><td>$val <td> $report->{$k}</td>";
		}
	}
	$out .= "</table>";

	$out .= "
	<table border=1 cellspacing=0 width=90% bgcolor=white>
	<tr bgcolor=\"#666699\"> <td colspan=\"2\"><a name=\"ESM\">
	</a><font color=\"#FFFFFF\"><b>ESM VPD:</b></font></td> </tr>
	<tr><th>Name<th>Value</tr>
	";

	foreach my $k (keys %$report) {
		if ($k =~ /esm_vpd/) {
			my($x, $val) = split(/esm_vpd./, $k);
			$out .= "<tr><td>$val <td> $report->{$k}</td>";
		}
	}
	$out .= "</table>\n";

	return $out
}

1;
