#pragma ident "@(#)xmp.h	1.21 03/10/06 SMI"
/*
 * Copyright 03/10/06 Sun Microsystems, Inc. All Rights Reserved
 */

#ifndef _XMP_H
#define _XMP_H

#ifdef  __cplusplus
extern "C" {
#endif

/*-----------------------------------------------------------------**
**               Common Package Definition                         **
**-----------------------------------------------------------------*/

/*
** Octal definition of the package
** -------------------------------
**/
#define OMP_O_MP_COMMON_PKG "\x2a\x86\x3a\x00\x88\x1a\x06\x01"

/*
** Definitions of the Feature Object Identifiers
**/
#define OMP_O_MP_AUTOMATIC_CONNECTION_MANAGEMENT	"\x2a\x86\x3a\x00\x88\x1a\x06\x01\x01"
#define OMP_O_MP_AUTOMATIC_DECODING			"\x2a\x86\x3a\x00\x88\x1a\x06\x01\x02"

/*
** Object Identifiers for features specific to the Sun XMP implementation.
**/
#define OMP_O_MP_ONE_FD_PER_SESSION			"\x2a\x86\x3a\x00\x88\x1a\x06\x01\x03"
#define OMP_O_MP_ANY_APP_CONTEXT			"\x2a\x86\x3a\x00\x88\x1a\x06\x01\x04"

/*-----------------------------------------------------------------**
**                      Symbolic Constants                         **
**-----------------------------------------------------------------*/
#define mpP_comn(X)	(OMP_O_MP_COMMON_PKG#X)

/*
** OM Object Class Oid Definitions for the Common Management Service package
** -------------------------------------------------------------------------
**/
#define OMP_O_MP_C_ABORT_ARGUMENT		mpP_comn(\x87\x69)
#define OMP_O_MP_C_ACCESS_CONTROL		mpP_comn(\x87\x6A)
#define OMP_O_MP_C_ACSE_ARGS			mpP_comn(\x87\x6B)
#define OMP_O_MP_C_ADDRESS			mpP_comn(\x87\x6C)
#define OMP_O_MP_C_AE_TITLE			mpP_comn(\x87\x6D)
#define OMP_O_MP_C_ASSOC_ARGUMENT		mpP_comn(\x87\x6E)
#define OMP_O_MP_C_ASSOC_DIAGNOSTIC		mpP_comn(\x87\x6F)
#define OMP_O_MP_C_ASSOCIATION_INFORMATION	mpP_comn(\x87\x70)
#define OMP_O_MP_C_ASSOC_RESULT			mpP_comn(\x87\x71)
#define OMP_O_MP_C_AUTHENTICATION_INFORMATION	mpP_comn(\x87\x72)
#define OMP_O_MP_C_AUTHENTICATION_OTHER		mpP_comn(\x87\x73)
#define OMP_O_MP_C_AVA				mpP_comn(\x87\x74)
#define OMP_O_MP_C_BAD_ARGUMENT			mpP_comn(\x87\x75)
#define OMP_O_MP_C_CMIP_ASSOC_ARGS		mpP_comn(\x87\x76)
#define OMP_O_MP_C_COMMUNITY_NAME		mpP_comn(\x87\x77)
#define OMP_O_MP_C_CONTEXT			mpP_comn(\x87\x78)
#define OMP_O_MP_C_DS_DN			mpP_comn(\x87\x79)
#define OMP_O_MP_C_DS_RDN			mpP_comn(\x87\x7A)
#define OMP_O_MP_C_ENTITY_NAME			mpP_comn(\x87\x7B)
#define OMP_O_MP_C_ERROR			mpP_comn(\x87\x7C)
#define OMP_O_MP_C_EXTENSION			mpP_comn(\x87\x7D)
#define OMP_O_MP_C_EXTERNAL_AC			mpP_comn(\x87\x7E)
#define OMP_O_MP_C_FORM1			mpP_comn(\x87\x7F)
#define OMP_O_MP_C_FORM2			mpP_comn(\x88\x00)
#define OMP_O_MP_C_FUNCTIONAL_UNIT_PACKAGE	mpP_comn(\x88\x01)
#define OMP_O_MP_C_NAME				mpP_comn(\x88\x02)
#define OMP_O_MP_C_NAME_STRING			mpP_comn(\x88\x03)
#define OMP_O_MP_C_NETWORK_ADDRESS		mpP_comn(\x88\x04)
#define OMP_O_MP_C_PRESENTATION_ADDRESS		mpP_comn(\x88\x05)
#define OMP_O_MP_C_PRESENTATION_CONTEXT		mpP_comn(\x88\x06)
#define OMP_O_MP_C_PRESENTATION_LAYER_ARGS	mpP_comn(\x88\x07)
#define OMP_O_MP_C_RELATIVE_NAME		mpP_comn(\x88\x08)
#define OMP_O_MP_C_RELEASE_ARGUMENT		mpP_comn(\x88\x09)
#define OMP_O_MP_C_RELEASE_RESULT		mpP_comn(\x88\x0A)
#define OMP_O_MP_C_SESSION			mpP_comn(\x88\x0B)
#define OMP_O_MP_C_SMASE_USER_DATA		mpP_comn(\x88\x0C)
#define OMP_O_MP_C_SNMP_OBJECT_NAME		mpP_comn(\x88\x0D)
#define OMP_O_MP_C_STANDARD_EXTERNALS		mpP_comn(\x88\x0E)
#define OMP_O_MP_C_TITLE			mpP_comn(\x88\x0F)

/*
** OM attribute names for the Common Management Service package
** -------------------------------------------------------------
**/
#define MP_ABORT_DIAGNOSTIC			(OM_type)11001
#define MP_ABORT_SOURCE				(OM_type)11002
#define MP_ACCESS_CONTROL			(OM_type)11003
#define MP_ACSE_ARGS				(OM_type)11004
#define MP_ACSE_ASSOC_ARGS			(OM_type)11005
#define MP_ACSE_SERVICE_PROVIDER		(OM_type)11006
#define MP_ACSE_SERVICE_USER			(OM_type)11007
#define MP_AE_INVOCATION			(OM_type)11008
#define MP_AE_QUALIFIER_FORM1			(OM_type)11009
#define MP_AE_QUALIFIER_FORM2			(OM_type)11010
#define MP_AE_TITLE_FORM1			(OM_type)11011
#define MP_AE_TITLE_FORM2			(OM_type)11012
#define MP_AGENT_ROLE_FUNCTIONAL_UNIT		(OM_type)11013
#define MP_APPLICATION_CONTEXT			(OM_type)11014
#define MP_AP_INVOCATION			(OM_type)11015
#define MP_AP_TITLE_FORM1			(OM_type)11016
#define MP_AP_TITLE_FORM2			(OM_type)11017
#define MP_ASSOC_EXTERN				(OM_type)11018
#define MP_ASYNCHRONOUS				(OM_type)11019
#define MP_AUTHENTICATION_INFORMATION		(OM_type)11020
#define MP_AVAS					(OM_type)11021
#define MP_BITSTRING				(OM_type)11022
#define MP_CHARSTRING				(OM_type)11023
#define MP_CMIP_ABORT_SOURCE			(OM_type)11024
#define MP_CMIP_ASSOC_ARGS			(OM_type)11025
#define MP_CMIP_USER_INFORMATION		(OM_type)11026
#define MP_CMIS_FUNCTIONAL_UNITS		(OM_type)11027
#define MP_COMMUNITY				(OM_type)11028
#define MP_ENTITY				(OM_type)11029
#define MP_EXTENSIONS				(OM_type)11030
#define MP_EXTERNAL				(OM_type)11031
#define MP_EXTERNAL_AC				(OM_type)11032
#define MP_FILE_DESCRIPTOR			(OM_type)11033
#define MP_FUNCTIONAL_UNIT_PACKAGE_ID		(OM_type)11034
#define MP_IDENTIFIER				(OM_type)11035
#define MP_INFORMATION				(OM_type)11036
#define MP_IP_ADDRESS				(OM_type)11037
#define MP_MANAGER_ROLE_FUNCTIONAL_UNIT		(OM_type)11038
#define MP_MODE					(OM_type)11039
#define MP_NAME_STRING				(OM_type)11040
#define MP_NAMING_ATTRIBUTE_ID			(OM_type)11041
#define MP_NAMING_ATTRIBUTE_VALUE		(OM_type)11042
#define MP_N_ADDRESSES				(OM_type)11043
#define MP_OBJECT_NAME				(OM_type)11044
#define MP_OTHER				(OM_type)11045
#define MP_OTHER_MECHANISM_NAME			(OM_type)11046
#define MP_OTHER_MECHANISM_VALUE		(OM_type)11047
#define MP_PRESENTATION_ABSTRACT		(OM_type)11048
#define MP_PRESENTATION_CONTEXT_LIST		(OM_type)11049
#define MP_PRESENTATION_ID			(OM_type)11050
#define MP_PRESENTATION_LAYER_ARGS		(OM_type)11051
#define MP_PRIORITY				(OM_type)11052
#define MP_P_SELECTOR				(OM_type)11053
#define MP_RDNS					(OM_type)11054
#define MP_REASON				(OM_type)11055
#define MP_REPLY_LIMIT				(OM_type)11056
#define MP_REQUESTOR_ADDRESS			(OM_type)11057
#define MP_REQUESTOR_TITLE			(OM_type)11058
#define MP_RESPONDER_ADDRESS			(OM_type)11059
#define MP_RESPONDER_TITLE			(OM_type)11060
#define MP_ROLE					(OM_type)11061
#define MP_SIGNIFICANCE				(OM_type)11062
#define MP_SMASE_USER_DATA			(OM_type)11063
#define MP_SMFU_PACKAGES			(OM_type)11064
#define MP_STANDARD_EXTERNALS			(OM_type)11065
#define MP_SYSTEMS_MANAGEMENT_USER_INFORMATION	(OM_type)11066
#define MP_S_SELECTOR				(OM_type)11067
#define MP_TIME_LIMIT				(OM_type)11068
#define MP_T_SELECTOR				(OM_type)11069
#define MP_USER_INFO				(OM_type)11070
#define MP_USER_INFORMATION			(OM_type)11071

/*
** Error parameters and attribute names missing from CAE doc
** ---------------------------------------------------------
**/
#define MP_PROBLEM				(OM_type)18000
#define MP_PARAMETER				(OM_type)18001
#define MP_OM_SUBOBJECT				(OM_type)18002
#define MP_OM_CLASS				(OM_type)18003
#define MP_OM_ATTRIBUTE				(OM_type)18004
#define MP_OM_INDEX				(OM_type)18005
#define MP_OM_BAD_ARGUMENT			(OM_type)18006
#define MP_SESSION				(OM_type)18007
#define MP_ASSOC_DIAGNOSTIC			(OM_type)18008
#define MP_ASSOC_RESULT				(OM_type)18009

/*
** Specific port attribute definition
** ----------------------------------
**/
#define OMP_O_MP_C_PROPRIETARY_ARGS		mpP_comn(\x88\x34)
#define MP_PROPRIETARY_ARGS			(OM_type)19000
#define MP_INACTIVITY_TIMER			(OM_type)19001
#define MP_BIND_STATE				(OM_type)19002
#define MP_CONNECT_STATE			(OM_type)19003
#define MP_CONNECTION_ID			(OM_type)19004

/*
** Functional Units definition
** ----------------------------
**/
#define MP_T_FU_CANCEL_GET			1
#define MP_T_FU_FILTER				2
#define MP_T_FU_MULTIPLE_OBJECT_SELECTION	4
#define MP_T_FU_EXTENDED_SERVICE		8
#define MP_T_FU_MULTIPLE_REPLY			16

/*
** MP_T_Request-Mask:
** -------------------
**/
#define MP_T_PRESENTATION_CONTEXT_LIST	1
#define MP_T_RESPONDER_ADDRESS		2
#define MP_T_RESPONDER_TITLE		4
#define MP_T_APPLICATION_CONTEXT	8
#define MP_T_AUTHENTICATION_INFORMATION	16
#define MP_T_ACSE_USER_INFO		32
#define MP_T_CMIS_FUNCTIONAL_UNITS	64
#define MP_T_ACCESS_CONTROL		128
#define MP_T_USER_INFO			256
#define MP_T_SMASE_USER_DATA		512

/*
** MP_T_Abort_Source
** ------------------
**/
#define MP_T_ABORT_SOURCE_ACSE_SERVICE_USER	1
#define MP_T_ABORT_SOURCE_ACSE_SERVICE_PROVIDER	2

/*
** MP_T_Abort_DIagnostic
** ----------------------
**/
#define MP_T_ABORT_DIAGNOSTIC_NO_REASON_GIVEN					1
#define MP_T_ABORT_DIAGNOSTIC_PROTOCOL_ERROR					2
#define MP_T_ABORT_DIAGNOSTIC_AUTHENTICATION_MECHANISM_NAME_NOT_RECOGNIZED	3
#define MP_T_ABORT_DIAGNOSTIC_AUTHENTICATION_MECHANISM_NAME_REQUIRED		4
#define MP_T_ABORT_DIAGNOSTIC_AUTHENTICATION_FAILURE				5
#define MP_T_ABORT_DIAGNOSTIC_AUTHENTICATION_REQUIRED				6

/*
** MP_T_CMIP_Abort_Source
** -----------------------
**/
#define MP_T_CMIP_ABORT_SOURCE_CMISE_SERVICE_USER	1
#define MP_T_CMIP_ABORT_SOURCE_CMISE_SERVICE_PROVIDER	2

/*
** MP_T_ACSE_Service_User
** -----------------------
**/
#define MP_T_ACSE_SERVICE_USER_NULL						1
#define MP_T_ACSE_SERVICE_USER_NO_REASON_GIVEN					2
#define MP_T_ACSE_SERVICE_USER_APPLICATION_CONTEXT_NAME_NOT_SUPPORTED		3
#define MP_T_ACSE_SERVICE_USER_CALLING_AP_TITLE_NOT_RECOGNIZED			4
#define MP_T_ACSE_SERVICE_USER_CALLING_AP_INVOCATION_IDENTIFIER_NOT_RECOGNIZED	5
#define MP_T_ACSE_SERVICE_USER_CALLING_AE_QUALIFIER_NOT_RECOGNIZED		6
#define MP_T_ACSE_SERVICE_USER_CALLING_AE_INVOCATION_IDENTIFIER_NOT_RECOGNIZED	7
#define MP_T_ACSE_SERVICE_USER_CALLED_AP_TITLE_NOT_RECOGNIZED			8
#define MP_T_ACSE_SERVICE_USER_CALLED_AP_INVOCATION_IDENTIFIER_NOT_RECOGNIZED	9
#define MP_T_ACSE_SERVICE_USER_CALLED_AE_QUALIFIER_NOT_RECOGNIZED		10
#define MP_T_ACSE_SERVICE_USER_CALLED_AE_INVOCATION_IDENTIFIER_NOT_RECOGNIZED	11
#define MP_T_ACSE_SERVICE_USER_AUTHENTICATION_MECHANISM_NAME_NOT_RECOGNIZED	12
#define MP_T_ACSE_SERVICE_USER_AUTHENTICATION_MECHANISM_NAME_REQUIRED		13
#define MP_T_ACSE_SERVICE_USER_AUTHENTICATION_FAILURE				14
#define MP_T_ACSE_SERVICE_USER_AUTHENTICATION_REQUIRED				15

/*
** MP_T_ACSE_Service_P rovider
** ----------------------------
**/
#define MP_T_ACSE_SERVICE_PROVIDER_NULL				1
#define MP_T_ACSE_SERVICE_PROVIDER_NO_REASON_GIVEN		2
#define MP_T_ACSE_SERVICE_PROVIDER_NO_COMMON_ACSE_VERSION	3

/*
** MP_T_Assoc_Result
** ------------------
**/
#define MP_T_ACCEPT		1
#define MP_T_REJECT_PERMANENT	2
#define MP_T_REJECT_TRANSIENT	3

/*
** Request Mode definition
** ------------------------
**/
#define MP_T_CONFIRMED		1
#define MP_T_NON_CONFIRMED	2

/*
**   Priority definition
** ---------------------
**/
#define MP_T_HIGH	1
#define MP_T_LOW	2
#define MP_T_MEDIUM	3

/*
** MP_T_Asynchronous
** ------------------
**/
#define MP_T_FALSE	1
#define MP_T_TRUE	2

/*
** MP_T_Reason
** ------------
**/
#define MP_T_NORMAL		1
#define MP_T_URGENT		2
#define MP_T_USER_DEFINED	3
#define MP_T_NOT_FINISHED	4

/*
** MP_T_BoundState
** ----------------
**/
#define MP_T_UNBOUND		1
#define MP_T_BOUND		2
/*
** MP_T_XXXState Flags
** -------------------
**/
#define MP_T_SINGLE_ASSOC	0x40

/*
** MP_T_ConnectState
** ------------------
**/
#define MP_T_UNCONNECTED	1
#define MP_T_PARTLY_CONNECTED	2
#define MP_T_CONNECTED		4

/*
**    Error Problem definition
** ---------------------------
**/
#define MP_E_BAD_ADDRESS		1001
#define MP_E_BAD_ARGUMENT		1002
#define MP_E_BAD_CLASS			1003
#define MP_E_BAD_CONTEXT		1004
#define MP_E_BAD_ERROR			1005
#define MP_E_BAD_LINKED_REPLY		1006
#define MP_E_BAD_PROCEDURAL_USE		1007
#define MP_E_BAD_RESULT			1008
#define MP_E_BAD_SESSION		1009
#define MP_E_BAD_SYNTAX			1010
#define MP_E_BAD_TITLE			1011
#define MP_E_BAD_VALUE			1012
#define MP_E_BAD_WORKSPACE		1013
#define MP_E_BROKEN_SESSION		1014
#define MP_E_COMMUNICATIONS_PROBLEM	1015
#define MP_E_EXCLUSIVE_ATTRIBUTE	1016
#define MP_E_INVALID_CONNECTION_ID	1017
#define MP_E_INVALID_ATTRIBUTE_ID	1018
#define MP_E_MISCELLANEOUS		1019
#define MP_E_MISSING_ATTRIBUTE		1020
#define MP_E_NOT_MULTI_VALUED		1021
#define MP_E_NOT_SUPPORTED		1022
#define MP_E_NO_SUCH_OPERATION		1023
#define MP_E_REPLY_LIMIT_EXCEEDED	1024
#define MP_E_SESSION_TERMINATED		1025
#define MP_E_SYSTEM_ERROR		1026
#define MP_E_TIME_LIMIT_EXCEEDED	1027
#define MP_E_TOO_MANY_OPERATIONS	1028
#define MP_E_TOO_MANY_SESSIONS		1029

/*
**    Specific port Error Problem definition
**    -----------------------------------------
**/
#define MP_E_BAD_ACCESS_CTRL		MP_E_NOT_SUPPORTED
#define MP_E_NO_TITLE_NOR_ADDRESS	MP_E_BAD_ADDRESS

/*
**    Additional Error retrieved by mp_get_last_error()
**    -------------------------------------------------
**/
#define MP_E_ADD_MCS_SEND_OM_FUNCTION_INTERRUPTED	2001
#define MP_E_ADD_MCS_SEND_OM_MEMORY_INSUFFICIENT	2002
#define MP_E_ADD_MCS_SEND_OM_NETWORK_ERROR		2003
#define MP_E_ADD_MCS_WAIT_READY_IND_KO			2004
#define MP_E_ADD_MCS_WAIT_SYNC_CONF_KO			2005
#define MP_E_ADD_MCS_RECEIVE_CANCEL_REGISTER_IND	2006
#define MP_E_ADD_MCS_RECEIVE_USER_ABORT_IND		2007
#define MP_E_ADD_MCS_RECEIVE_PROVIDER_ABORT_IND		2008
#define MP_E_ADD_MCS_SEND_USER_CREDIT			2009

/*
** Role Definition
** ---------------
**/
#define MP_T_MANAGING	1
#define MP_T_MONITORING	2
#define MP_T_PERFORMING	4
#define MP_T_REPORTING	8

/*
** Feature Definition
** ------------------
**/
#define MP_ACTIVATE		0
#define MP_DEACTIVATE		1
#define MP_QUERY_STATE		2
#define MP_QUERY_SUPPORTED	3

/*-----------------------------------------------------------------**
**                      Type Definition                            **
**-----------------------------------------------------------------*/

/*
** Status returned by XMP functions
** --------------------------------
**/
typedef long MP_status;

/*
** Feature definition
** ------------------
**/
typedef struct {
	OM_object_identifier	feature;
	OM_sint			request;
	OM_boolean		response;
} MP_feature;

typedef struct {
	OM_private_object	bound_session;
	OM_boolean		activated;
} MP_waiting_sessions;

/*
** Usefull to return an empty result in an XMP function
** ----------------------------------------------------
**/

#define MP_ABSENT_OBJECT	((OM_object)0)

/*
** Two default objects used by XMP.
** --------------------------------
**/
#define MP_DEFAULT_CONTEXT	((OM_object)0)
#define MP_DEFAULT_SESSION	((OM_object)0)

/*
**  Success code returned by XMP functions
**  --------------------------------------
**/
#define MP_SUCCESS			((MP_status)0)
#define MP_NO_WORKSPACE			((MP_status)1)
#define MP_INVALID_SESSION		((MP_status)2)
#define MP_INSUFFICIENT_RESOURCES	((MP_status)3)

/*
**   CMISE Primitive Definitions
** -----------------------------
**/
#define MP_ACTION_CNF		1
#define MP_ACTION_IND		2
#define MP_CANCEL_GET_CNF	3
#define MP_CANCEL_GET_IND	4
#define MP_CREATE_CNF		5
#define MP_CREATE_IND		6
#define MP_DELETE_CNF		7
#define MP_DELETE_IND		8
#define MP_EVENT_REPORT_CNF	9
#define MP_EVENT_REPORT_IND	10
#define MP_GET_CNF		11
#define MP_GET_IND		12
#define MP_GET_NEXT_IND		13
#define MP_SET_CNF		14
#define MP_SET_IND		15
#define MP_ABORT_IND		16
#define MP_ASSOC_CNF		17
#define MP_ASSOC_IND		18
#define MP_RELEASE_CNF		19
#define MP_RELEASE_IND		20

/*
** Receive status definition
** -------------------------
**/
#define MP_COMPLETED	1
#define MP_INCOMING	2
#define MP_NOTHING	3
#define MP_OUTSTANDING	4
#define MP_PARTIAL	5

/*
** Usefull to specify no file descriptor
** -------------------------------------
**/
#define MP_NO_VALID_FILE_DESCRIPTOR	-1

/*
** Size of the window for asynchronous calls
** -----------------------------------------
** This constant shall be defined in accordance with the MCS window size
** so that the data flow control will be supervised by XMP.
** In this case the MCS entity shall be configured with a window size
** of 11 items.
**/
#define MP_MAX_OUTSTANDING_OPERATIONS	20

/*-----------------------------------------------------------------**
**                      XMP library functions                      **
**-----------------------------------------------------------------*/

#if defined(__STDC__) || defined(__cplusplus)

extern MP_status mp_abandon (
					OM_private_object	/* session */,
					OM_sint32		/* invoke_id  */
);

extern MP_status mp_abort_req(
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */
);

extern MP_status mp_action_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_action_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern MP_status mp_assoc_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_assoc_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_private_object	/* response */,
					OM_sint32			/* invoke_id */
);

extern MP_status mp_bind (
					OM_object		/* session */,
					OM_workspace		/* workspace */,
					OM_private_object *	/* bound_session_return */
);

extern MP_status mp_cancel_get_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_cancel_get_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern MP_status mp_create_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_create_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern MP_status mp_delete_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_delete_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern OM_sint mp_error_message (
					MP_status		/* error */,
					OM_sint			/* length */,
					unsigned char	  *	/* error_text_return */
);

extern MP_status mp_event_report_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_event_report_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern MP_status mp_get_assoc_info(
					OM_private_object	/* receive_result_or_argument */,
					OM_uint			/* request_mask */,
					OM_uint		  *	/* result_mask */,
					OM_public_object  *	/* pres_layer_args */,
					OM_public_object  *	/* acse_args */,
					OM_public_object  *	/* cmip_assoc_args */,
					OM_public_object  *	/* standard_externals */
);

extern MP_status mp_get_last_error(
					OM_workspace		/* workspace */,
					OM_uint32	  *	/* additional_error_return */
);

extern MP_status mp_get_next_req(
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_get_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_get_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern OM_workspace  mp_initialize (  void  );

extern MP_status mp_negotiate (
					MP_feature	  *	/* feature_list[] */,
					OM_workspace		/* workspace  */
);

extern MP_status mp_receive (
					OM_private_object	/* session */,
					OM_sint		  *	/* mode_return */,
					OM_sint		  *	/* primitive_return */,
					OM_sint		  *	/* completion_flag_return */,
					MP_status	  *	/* operation_notification_status_return */,
					OM_private_object *	/* result_or_argument_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_release_req(
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_release_rsp(
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern MP_status mp_set_req (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* argument */,
					OM_private_object *	/* result_return */,
					OM_sint32	  *	/* invoke_id_return */
);

extern MP_status mp_set_rsp (
					OM_private_object	/* session */,
					OM_private_object	/* context */,
					OM_object		/* response */,
					OM_sint32		/* invoke_id */
);

extern MP_status mp_shutdown (
					OM_workspace		/* workspace */
                                ) ;

extern MP_status mp_unbind (
					OM_private_object	/* session */
);

extern MP_status mp_validate_object(
					OM_workspace		/* workspace */,
					OM_object		/* test_object */,
					OM_private_object *	/* bad_argument_return */
);

extern MP_status mp_wait (
					MP_waiting_sessions *	/* bound_session_list[] */,
					OM_workspace		/* workspace */,
					OM_uint32		/* timeout */
);

#else

extern MP_status mp_abandon (/*
					OM_private_object	session,
					OM_sint32        	invoke_id
*/);

extern MP_status mp_abort_req(/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument
*/);

extern MP_status mp_action_req (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_action_rsp (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern MP_status mp_assoc_req(/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_assoc_rsp(/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern MP_status mp_bind (/*
					OM_object		session,
					OM_workspace		workspace,
					OM_private_object	*bound_session_return
*/);

extern MP_status mp_cancel_get_req (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_cancel_get_rsp (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern MP_status mp_create_req (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_create_rsp (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern MP_status mp_delete_req (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_delete_rsp (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern OM_sint mp_error_message (/*
					MP_status		error,
					OM_sint			length,
					unsigned char		*error_text_return
*/);

extern MP_status mp_event_report_req (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_event_report_rsp (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern MP_status mp_get_assoc_info(/*
					private_object		receive_result_or_argument,
					OM_uint			request_mask,
					OM_uint			result_mask,
					OM_public_object	*pres_layer_args,
					OM_public_object	*acse_args,
					OM_public_object	*cmip_assoc_args,
					OM_public_object	*standard_externals
*/);

extern MP_status mp_get_last_error(/*
					OM_workspace		workspace,
					OM_uint32		*additional_error_return
*/);

extern MP_status mp_get_next_req(/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_get_req (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_get_rsp (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern OM_workspace  mp_initialize ( /* void */ );

extern MP_status mp_negotiate (/*
					MP_feature		feature_list[],
					OM_workspace		workspace
*/);

extern MP_status mp_receive (/*
					OM_private_object	session,
					OM_sint			*mode_return,
					OM_sint			*primitive_return,
					OM_sint			*completion_flag_return,
					MP_status		*operation_notification_status_return,
					OM_private_object	*result_or_argument_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_release_req(/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_release_rsp(/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern MP_status mp_set_req (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		argument,
					OM_private_object	*result_return,
					OM_sint32		*invoke_id_return
*/);

extern MP_status mp_set_rsp (/*
					OM_private_object	session,
					OM_private_object	context,
					OM_object		response,
					OM_sint32		invoke_id
*/);

extern MP_status mp_shutdown (/*
					OM_workspace		workspace
*/);

extern MP_status mp_unbind (/*
					OM_private_object	session
*/);

extern MP_status mp_validate_object(/*
					OM_workspace		workspace,
					OM_object		test_object,
					OM_private_object	*bad_argument_return
*/);

extern MP_status mp_wait (/*
					MP_waiting_sessions	bound_session_list[],
					OM_workspace		workspace,
					OM_uint32		timeout
*/);

#endif /* __STDC__ */

#ifdef  __cplusplus
}
#endif

#endif	/* _XMP_H */
