# Copyright 02/06/02 Sun Microsystems, Inc. All Rights Reserved.
# pragma ident "@(#)t300-d.x	1.10 02/02/06 Sun Microsystems"
#
#   File: t300-d.x
#   Version: 1.0
#
#   Storage T300 Module
#

[ use MANAGED-MODULE ]

[ load t300-m.x ]
[ requires template t300-models-d ]
[ requires package t300 ]

_procedures = {
	[ use PROC ]
	[ source t300-d.prc ]
}

#Define services required by this module
_services = { [use SERVICE ]
	T300Shell = {
		command = "pipe://localhost/oa-shell.sh;transport=shell;args=t300-shell.tcl"
		max = 1
	}
}

[ use _procedures ]

adhocCommand(tree) = probeserver -u root -c /usr/bin/cat /var/opt/SUNWsymon/cfg/t300.tree
adhocCommand(schema) = probeserver -c t300-schema.sh

# This module will be displayed in the PV/LV. 
# A new module called hdreg has been added in the SunMC 3.0
# The PV/LV will read the hdreg module and get all rows in it, 
# then display them. 
# The hdreg module requires the hardware module to registry it when loaded, 
# and unregistry it when unloaded.
# We should make sure that even the hdreg module doesn't be loaded,
# this module still can be loaded. At this time, it cannot be displayed 
# in the PV/LV, but it can be displayed in the browser.

# registry to hdreg module
activateActions(post) = load
activateService(load) = _self
activateCommand(load) = regHdreg

# unregistry from hdreg module
deactivateActions(pre) = unload
deactivateService(unload) = _self
deactivateCommand(unload) = unregHdreg

system = {
	[ use templates.t300-models-d.system ]

	basic-table	=  { 
		[ use templates.t300-models-d.system.basic-table ]
		type		= active
		refreshMode	= async
		refreshService	= _services.T300Shell
		refreshCommand	= t300 system t300name sminfo sysId sysVendor sysModel sysRevision sysIpAddr sysSubNet sysGateway sysBootMode sysBootDelay sysMpSupport sysHasVolumes sysStatus
		initInterval	= 2
		refreshInterval	= 600
		refreshFilter	= join
		timeoutInterval	= 400

		basic-entry = { [ use _procedures ]
			consoleHint:tableCommands = editrow
			consoleHint:commandLabel(editrow) = base.console.ConsoleGeneric:tableRow.editPopup
			consoleHint:commandSpec(editrow) = launchUniqueDialog %windowID .templates.tools.roweditor objectUrl=snmp://%targetHost:%targetPort/mod/t300/system/basic-table/basic-entry#%targetFragment

			globActions		= refresh
			globService(refresh)	= basic-table
			globCommand(refresh)	= refreshValueAndTrap

			sysId = {
				access = rw
	
				setActions = *define decrglob
				setService(define) = basic-entry
				setCommand(define) = setEntry system sysId %index %value
			}

			sysSubNet = {
				access = rw
	
				setActions = *define decrglob
				setService(define) = basic-entry
				setCommand(define) = setEntry system sysSubNet %index %value
			}

			sysGateway = {
				access = rw
	
				setActions = *define decrglob
				setService(define) = basic-entry
				setCommand(define) = setEntry system sysGateway %index %value
			}

			sysMpSupport = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = none readWrite

				setActions = *define decrglob
				setService(define) = basic-entry
				setCommand(define) = setEntry system sysMpSupport %index %value
			}

			sysBootMode = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = none auto tftp

				setActions = *define decrglob
				setService(define) = basic-entry
				setCommand(define) = setEntry system sysBootMode %index %value
			}

			sysBootDelay = {
				access = rw

				setActions = *define decrglob
				setService(define) = basic-entry
				setCommand(define) = setEntry system sysBootDelay %index %value
			}
		}
	}

	advanced-table	= { 
		[ use templates.t300-models-d.system.advanced-table ]
		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 system t300name sysStripeUnitSize sysCacheMode sysCacheMirror sysReadAhead sysReconRate sysOndgMode sysOndgTimeslice sysTftpHost sysTftpFile sysLastRestart sysDate sysTime sysTimezone
		refreshFilter	= join

		advanced-entry = { [ use _procedures ]
			consoleHint:tableCommands = editrow
			consoleHint:commandLabel(editrow) = base.console.ConsoleGeneric:tableRow.editPopup
			consoleHint:commandSpec(editrow) = launchUniqueDialog %windowID .templates.tools.roweditor objectUrl=snmp://%targetHost:%targetPort/mod/t300/system/advanced-table/advanced-entry#%targetFragment

			globActions		= refresh
			globService(refresh)	= advanced-table
			globCommand(refresh)	= refreshValueAndTrap

			sysStripeUnitSize = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = 16384 32768 65536

				setActions = *define
				setService(define) = advanced-entry
				setCommand(define) = setEntry system sysStripeUnitSize %index %value
			}

			sysCacheMode = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = disabled writeThrough writeBehind auto

				setActions = *define
				setService(define) = advanced-entry
				setCommand(define) = setEntry system sysCacheMode %index %value
			}

			sysCacheMirror = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = off auto

				setActions = *define
				setService(define) = advanced-entry
				setCommand(define) = setEntry system sysCacheMirror %index %value
			}

			sysReadAhead = {
				access = rw

				setActions = *define
				setService(define) = advanced-entry
				setCommand(define) = setEntry system sysReadAhead %index %value
			}

			sysReconRate = {
				access = rw

				setActions = *define
				setService(define) = advanced-entry
				setCommand(define) = setEntry system sysReconRate %index %value
			}

			sysOndgMode = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = off passive active

				setActions = *define
				setService(define) = advanced-entry
				setCommand(define) = setEntry system sysOndgMode %index %value
			}

			sysOndgTimeslice = {
				access = rw

				setActions = *define
				setService(define) = advanced-entry
				setCommand(define) = setEntry system sysOndgTimeslice %index %value
			}

#
# sysIdleDiskTimeout will not available
#
#			sysIdleDiskTimeout = {
#				access = rw
#
#				setActions = *define
#				setService(define) = advanced-entry
#				setCommand(define) = setEntry system sysIdleDiskTimeout %index %value
#			}
		}
	}
		
	statistical-table = {
		[ use templates.t300-models-d.system.statistical-table ]
		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 system t300name sysTotalRequests sysWriteRequests sysReadRequests sysTotalBlocks sysBlocksWritten sysBlocksRead sysCacheWriteHits sysCacheWriteMisses sysCacheReadHits sysCacheReadMisses sysCacheRmwFlushes sysCacheReconFlushes sysCacheStripeFlushes
		refreshFilter	= join

		statistical-entry = { [ use _procedures ]
			consoleHint:tableMenuGenerator = com.sun.symon.apps.storage.t300.ClearMenuItem

# clear-flag is just a flag, it is used by CLEAR operation
			clear-flag = {
				type	= derived

				access	= rw

				refreshTrigger	= t300name:update
				refreshService	= statistical-entry
				refreshCommand	= addClearFlag
				refreshInterval	= 0

				setActions = *define
				setService(define) = statistical-entry
				setCommand(define) = clearEntry system %index %value
			}
		}
	}
}

unit = {
	[ use templates.t300-models-d.unit ]
	
	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 unit t300name unitId sminfo unitType unitStandby unitIsControllerUnit machine platform
	refreshFilter	= join
}

disks = {
	[ use templates.t300-models-d.disks ]
	
	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 disks rowno sminfo
	refreshFilter	= join
}

disk = {
	[ use templates.t300-models-d.disk ]
	
	basic-table = { [ use templates.t300-models-d.disk.basic-table ]
		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 disk t300name unitId fruId sminfo fruStatus fruState fruVendor fruModel fruRevision fruSerialNo fruErrors fruDiskRole fruDiskCapacity fruDiskTemp
		refreshFilter	= join
	}

	advanced-table = { [ use templates.t300-models-d.disk.advanced-table ]
		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 disk t300name unitId fruId fruDiskPort1State fruDiskPort2State fruDiskStatusCode fruDiskVolId fruDiskVolIndex fruDiskVolName fruDiskIsRoleData fruDiskIsRoleStandby fruDiskIsRoleUndefined fruDiskIsExpendable fruDiskIsRebuildable
		refreshFilter	= join
	}
}

controllers = {
	[ use templates.t300-models-d.controllers]
	
	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 controllers rowno sminfo
	refreshFilter	= join
}

controller = {
	[ use templates.t300-models-d.controller ]
	
	type		= derived
	refreshMode	= async
	refreshService	= _services.T300Shell
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshCommand	= t300 controller t300name unitId fruId sminfo fruStatus fruState fruVendor fruModel fruRevision fruSerialNo fruErrors fruCtlrCpuDesc fruCtlrRole fruCtlrPartnerId fruCtlrCtState fruCtlrCacheSize fruCtlrTemp fruCtlrIsExpendable
	refreshFilter	= join
}

loopcards = {
	[ use templates.t300-models-d.loopcards ]

	type		= derived
	refreshMode	= async
	refreshService	= _services.T300Shell
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshCommand	= t300 loopcards rowno sminfo
	refreshFilter	= join
}

loop_card = {
	[ use templates.t300-models-d.loop_card ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 loop_card t300name unitId fruId sminfo fruStatus fruState fruVendor fruModel fruRevision fruSerialNo fruErrors fruLoopMode fruLoopCable1State fruLoopCable2State fruLoopTemp
	refreshFilter	= join
}

powerunits = {
	[ use templates.t300-models-d.powerunits ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 powerunits rowno sminfo
	refreshFilter	= join
}

power_cooling_unit = {
	[ use templates.t300-models-d.power_cooling_unit ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 power_cooling_unit t300name unitId fruId sminfo fruStatus fruState fruVendor fruModel fruRevision fruSerialNo fruErrors fruPowerPowOutput fruPowerPowSource fruPowerPowTemp fruPowerFan1State fruPowerFan2State fruPowerBatState fruPowerBatLife fruPowerBatUsed
	refreshFilter	= join
}

midplanes = {
	[ use templates.t300-models-d.midplanes ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 midplanes rowno sminfo
	refreshFilter	= join
}

midplane = {
	[ use templates.t300-models-d.midplane ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 midplane t300name unitId fruId sminfo fruStatus fruState fruVendor fruModel fruRevision fruSerialNo fruErrors
	refreshFilter	= join
}

volumes = {
	[ use templates.t300-models-d.volumes ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 volumes rowno sminfo
	refreshFilter	= join
}

volume = {
	[ use templates.t300-models-d.volume ]

	basic-table = { [ use templates.t300-models-d.volume.basic-table ]
		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 volume t300name unitId volId sminfo volName volWWN volStatus volCacheMode volCacheMirror volCapacity volArrayWidth volRaidLevel volDisabledDisk volSubstitutedDisk volInitRate volVerifyRate
		refreshFilter	= join
	}

	statistical-table = { 
		[ use templates.t300-models-d.volume.statistical-table ]

		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 volume t300name unitId volId volTotalRequests volWriteRequests volReadRequests volTotalBlocks volBlocksWritten volBlocksRead volSoftErrors volFirmErrors volHardErrors volCacheWriteHits volCacheWriteMisses volCacheReadHits volCacheReadMisses volCacheRmwFlushes volCacheReconFlushes volCacheStripeFlushes
		refreshFilter	= join

		statistical-entry = { [ use _procedures ]
			consoleHint:tableMenuGenerator = com.sun.symon.apps.storage.t300.ClearMenuItem
			
# clear-flag is just a flag, it is used by CLEAR operation
			clear-flag = {
				type	= derived

				access	= rw

				refreshTrigger	= t300name:update
				refreshService	= statistical-entry
				refreshCommand	= addClearFlag
				refreshInterval	= 0

				setActions = *define
				setService(define) = statistical-entry
				setCommand(define) = clearEntry volume %index %value
			}
		}
	}
}

ports = {
	[ use templates.t300-models-d.ports ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 ports rowno sminfo
	refreshFilter	= join
}

port = {
	[ use templates.t300-models-d.port ]

	basic-table = {
		[ use templates.t300-models-d.port.basic-table ]

		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 port t300name unitId portId sminfo portWWN portStatus portType portFruId portSunHost portFibreCount portFibreAlpaMode portFibreAlpa
		refreshFilter	= join
	}

	statistical-table = {
		[ use templates.t300-models-d.port.statistical-table ]

		type		= derived
		refreshMode	= async
		refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
		refreshService	= _services.T300Shell
		refreshCommand	= t300 port t300name unitId portId portTotalRequests portWriteRequests portReadRequests portTotalBlocks portBlocksWritten portBlocksRead
		refreshFilter	= join
	}
}

attachments = {
	[ use templates.t300-models-d.attachments ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 attachments rowno sminfo
	refreshFilter	= join
}

attachment = {
	[ use templates.t300-models-d.attachment ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 attachment t300name unitId portId attachIndex sminfo attachLun attachMode attachVolId attachVolName
	refreshFilter	= join
}


loops = {
	[ use templates.t300-models-d.loops ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 loops rowno sminfo
	refreshFilter	= join
}

loop = {
	[ use templates.t300-models-d.loop ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 loop t300name unitId loopId sminfo loopStatus loopMux loopIsAvailable loopIsReserved loopIsIsolated loopIsTop loopIsBottom loopIsMiddle
	refreshFilter	= join
}

logging = {
	[ use templates.t300-models-d.logging ]

	type		= derived
	refreshMode	= async
	refreshTrigger	= system.basic-table.basic-entry.sysId:refresh
	refreshService	= _services.T300Shell
	refreshCommand	= t300 logging t300name sminfo logStatus logPort logTo logLevel
	refreshFilter	= join

	logging-table = {
		logging-entry = { [ use _procedures ]
			consoleHint:tableCommands = editrow
			consoleHint:commandLabel(editrow) = base.console.ConsoleGeneric:tableRow.editPopup
			consoleHint:commandSpec(editrow) = launchUniqueDialog %windowID .templates.tools.roweditor objectUrl=snmp://%targetHost:%targetPort/mod/t300/logging/logging-table/logging-entry#%targetFragment

			globActions		= refresh
			globService(refresh)	= logging-table
			globCommand(refresh)	= refreshValueAndTrap

			logPort = {
				access = rw
	
				setActions = *define decrglob
				setService(define) = logging-entry
				setCommand(define) = setEntry logging logPort %index %value
			}

			logTo = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = 1 *

				setActions = *define decrglob
				setService(define) = logging-entry
				setCommand(define) = setEntry logging logTo %index %value
			}

			logLevel = {
				access = rw
				consoleHint:editAccess = rw
				consoleHint:customCellEditor = com.sun.symon.base.console.views.table.CvTblComboBoxEditor
				consoleHint:optionList = \"0 - None\" \"1 - Error\" \"2 - Warning\" \"3 - Notice\" \"4 - All\"

				setActions = *define decrglob
				setService(define) = logging-entry
				setCommand(define) = setEntry logging logLevel %index %value
			}

#
# logMask will not support by tokenizer interface
#
#			logMask = {
#				access = rw
#	
#				setActions = *define decrglob
#				setService(define) = logging-entry
#				setCommand(define) = setEntry logging logMask %index %value
#			}
		}
	}
}

t300-rules = {
	[ use templates.t300-models-d.t300-rules ]
}
