#!/bin/sh
# Copyright 10/31/01 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)sm_setup_metadata.sh	1.12 01/10/31 Sun Microsystems"

# Note:  This script is used internally by Sun Enterprise SyMON,
# and is not intended to be called directly by users.
# It should not be modified.
#
#

write_domain_values() {
#
#  $1 = name to use for server
#
    local_host=`/usr/bin/uname -n`
    $XPUT ${VARDIR}/domain-config.x metadata.metadataServer "$local_host"
}

set_server_name() {
#
    get_input_from_user "Please enter the Sun Management Center Server Hostname: "
    server_host="$answer"
    [ "$server_host" != "_none_" ] && write_domain_values $server_host
}

configure_server() {

    metadata_port=""
    agent_port=""
    traphost=""
    server_host=""
    platform_port=""

    if [ -f "${VARDIR}/domain-config.x" ] ; then
	metadata_port=`$XGET ${VARDIR}/domain-config.x metadata.snmpPort`
	agent_port=`$XGET ${VARDIR}/domain-config.x agent.snmpPort`
	traphost=`$XGET ${VARDIR}/domain-config.x trap.trapServer`
	platform_port=`$XGET ${VARDIR}/domain-config.x platform.snmpPort`
    fi


    [ "$server_host" = "_none_" ] && return 0

    if [ -z "$metadata_port" ] ; then
	local_host=`/usr/bin/uname -n`
	$XPUT ${VARDIR}/domain-config.x metadata.metadataServer  "$local_host"   metadata.snmpPort  168 


	if [ $? -ne 0 ] ; then
	    echolog ""
	    echolog 'Error - Unable to set $2 values.' "$VARDIR/domain-config.x"
	    echolog ""
	    exit 1
	fi
    else
	echologverbose ""
	echologverbose 'agent.snmpPort already configured in $2' "$VARDIR/domain-config.x"
	echologverbose ""
    fi


}

fix_ent_vers() {
#
#  Fixes the enterprise and version fields
#
#    echo "\nBefore:\n$LINE"

    LINE=`echo $LINE | /usr/bin/sed s/halcyon/sun/g`
    LINE=`echo $LINE | /usr/bin/sed s/1.0/2.0/`

}

fix_base_modules() {

    [ -f $VARDIR/metadata-modules-d.dat.old ] && /usr/bin/rm $VARDIR/metadata-modules-d.dat.old
    /usr/bin/mv $VARDIR/metadata-modules-d.dat $VARDIR/metadata-modules-d.dat.old
    SED=/usr/bin/sed

    while read LINE
    do
	module=`echo $LINE | /usr/bin/awk '{print $1}'`
	case $module in
	    datalog-registry)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.localApplication.datalog.registry/prod.sunsymon.agent.modules.datalogRegistry/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.datalogRegistry\"'/`
		;;
	    dirmon*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.dirmon\"'/`
		LINE=`echo $LINE | $SED s/'location = ""'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.dirmon\"'/`
	        ;;
	    filemon*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.operatingSystem.filemon/prod.sunsymon.agent.modules.filemon/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.filemon\"'/`
	        ;;
	    fscan*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.localApplication.fscan/prod.sunsymon.agent.modules.fscan/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.fscan\"'/`
	        ;;
	    hp-jetdirect*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.remoteSystem.hp.jetdirect/prod.sunsymon.agent.modules.hpJetdirect/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.hpJetdirect\"'/`
	        ;;
	    nfsmon*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.operatingSystem.nfsmon/prod.sunsymon.agent.modules.nfsmon/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.nfsmon\"'/`
		;;
	    nfsstat)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.operatingSystem.nfsstat/prod.sunsymon.agent.modules.nfsstat/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.\"'/`
	        ;;
	    print-spool*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.localApplication.print.spool/prod.sunsymon.agent.modules.printSpool/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.printSpool\"'/`
	        ;;
	    process-table*)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/primealert.modules.localApplication.process.table/prod.sunsymon.agent.modules.processTable/`
		LINE=`echo $LINE | $SED s/'location = \"\"'/'location = \".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.processTable\"'/`
		;;
	    kernel-reader)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/operatingSystem.kernel.reader/kernelReader/`
		;;
	    process-details)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/operatingSystem.process.details/processDetails/`
		;;
	    health-monitor)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/localApplication.health.monitor/healthMonitor/`
		;;
	    dr)
		fix_ent_vers
		LINE=`echo $LINE | $SED s/localApplication.dr/dr/`
		;;
	    *)
		;;
	esac
	LINE=`echo $LINE | /usr/bin/sed s/'"\; '/'\\\"\; '/g`
	LINE=`echo $LINE | /usr/bin/sed s/'= "'/'= \\\"'/g`
	#  Remove the first \
	LINE=`echo $LINE | /usr/bin/sed s:'\\\'::`
#    echo "\nAfter:\n$LINE"
	echo "$LINE" >> $VARDIR/metadata-modules-d.dat

    done < "$VARDIR/metadata-modules-d.dat.old"
   
}


######################################################
#
#  Main entry point
#

prog_base=`/usr/bin/basename $0`
common_cmd=`echo $0 | /usr/bin/sed s/$prog_base/es-common.sh/`
. $common_cmd
gen_cmd=`echo $0 | /usr/bin/sed s/$prog_base/es-keys.sh/`
. $gen_cmd

VERBOSE=OFF
do_default=0
while getopts dvs: OPT
do
    case $OPT in
	d)
	    do_default=1
	    ;;
	v)
	    VERBOSE=ON
	    ;;
        s)
            security_seed="$OPTARG"
            #echologverbose 'Using security seed $2 for Sun Management Center metadata' "$security_seed"
            ;;

	*)
	    exit 1
	    ;;
    esac
done
set_basedir
PROGNAME="$0"; export PROGNAME
check_root
check_logfile setup
check_osver
set_xput
set_inst_flags


echologverbose ""
echologverbose "This part of the setup process does the Sun Management Center Metadata Component setup."

#
#  Make sure LS directory exists
#
LSDIR=$VAROPTDIR/LS
if [ ! -d "$LSDIR" ] ; then
    /usr/bin/mkdir -p "$LSDIR"
    /usr/bin/chown nobody:nobody "$LSDIR"
    /usr/bin/chmod 755 "$LSDIR"
fi

#
#  Add in mail script
#

#if [ ! -f $VAROPTDIR/bin/email.sh ] ; then
# Do Not check for the presence of file. Copy it from /opt/SUNWsymon/base/sbin.
# This is needed Since we want to replace the 2.0.1 version of this file.4234218
    /usr/bin/mkdir -p $VAROPTDIR/bin
    /usr/bin/cp $BASEDIR/base/sbin/email.sh $VAROPTDIR/bin
#fi

#
#  Copy snmpd.conf if needed
#
if [ -f "$VARDIR/snmpd.conf" ] ; then
    echologverbose 'snmpd.conf already exists in $2.  Leaving it in place' $VARDIR
else
    echologverbose 'Copying snmpd.conf file into $2' $VARDIR
    /usr/bin/cp "$BASEDIR"/base/cfg/snmpd.conf "$VARDIR"
fi

#
#  Setup the domain-config.x file
#
if [ -f "${VARDIR}/domain-config.x" ] ; then
#    if [ $no_server -eq 1 ] ; then
#	configure_server
#    else
#	echologverbose ""
#	echologverbose "Server component also installed locally."
#	echologverbose "Using this machine as the Sun Management Center server."
#	server_host=`/usr/bin/uname -n`
#	write_domain_values $server_host
#    fi
#else
  server_host=`/usr/bin/uname -n`
  write_domain_values $server_host
  configure_server
fi
#
#  Check the relevant port numbers
#
check_port metadata.snmpPort metadata

#
#  See if Config Reader will work on this platform.
#
if [ -f "$VARDIR/metadata-modules-d.dat" ] ; then
    #
    #  Update for new oids
    #
    fix_base_modules

fi

if [ -f "$VARDIR/user-oids-d.dat" ] ; then
    /usr/bin/rm "$VARDIR/user-oids-d.dat"
fi

if [ -f "$VARDIR/platform-oids-d.dat" ] ; then
    /usr/bin/rm "$VARDIR/platform-oids-d.dat"
fi

# give a message to the user to use the 2.x seed for metadata
# while doing an upgrade from 2.x to 3.0

if [ "$UPGRADE_DONE" = "YES" ]
then
    echolog ""
    echolog "Note : You should specify below the same 2.x security seed that is currently" 
    echolog "being used by this SunMC server." 
    echolog ""
fi

if [ "$GENERATE_SECURITY_KEY" = "1" ] ; then
    generate_keys metadata $do_default  "$security_seed"
fi

echologverbose ""
echologverbose "Completing Sun Management Center Agent Component setup."
echologverbose ""

exit 0
