#!/bin/sh
#
# @(#)mcp_propagate.sh	1.11 02/12/18
# Copyright (c) 12/18/02 Sun Microsystems, Inc. All Rights Reserved.
#

setup_safe_tmp_dir() {
	# determine architecture

	MACH=`uname -m`
	SYS=`uname -s`
	REL=`uname -r`
	VER=`uname -v`
	case "$MACH:$SYS:$REL:$VER" in
    	i86pc*:SunOS:5.*:*)
        	REL="`echo ${REL} | sed 's/^5/2/' | cut -d\. -f1,2`"
			ARCH="i386-sun-solaris${REL}" ;;
		sun4*:SunOS:5.*:*)
			REL="`echo ${REL} | sed 's/^5/2/' | cut -d\. -f1,2`"
			ARCH="sparc-sun-solaris${REL}" ;;
		sun4*:SunOS:*:*)
			REL="`echo ${REL} | cut -d\. -f1,2`"
			ARCH="sparc-sun-sunos${REL}" ;;
	esac

	if [ ! -x  $ESROOT/util/bin/$ARCH/uclock ]
	then
		/usr/bin/gettext "ERROR: Could not find uclock in $ESROOT/util/bin/$ARCH"
		exit 1
	fi

    timestamp=`$ESROOT/util/bin/$ARCH/uclock`
    safedir="${TMPDIR:-/tmp}/sunmclog-${timestamp}-$$"

    if [ ! -d "$safedir" ]; then
	/usr/bin/mkdir -m 700 $safedir
	if [ $? != 0 ]; then
	    /usr/bin/gettext "ERROR: Unable to make temporary directory $safedir\n"
	    exit 1
	fi
	TMP_LOG_DIR="$safedir"
    else
	/usr/bin/gettext "ERROR: Unable to use $safedir due to possible security issues.\n"
	exit 2
    fi
}

LOCAL_BASE=`expr "$INTERFACE_PATH" : '\([^:]*\)'`
LOCAL_BASE=`dirname $LOCAL_BASE`

#
# remove MCP module file
#
if [ -f "$LOCAL_BASE/cfg/base-modules-d.dat.MCP" ] ; then
    rm -f "$LOCAL_BASE/cfg/base-modules-d.dat.MCP"
fi

setup_safe_tmp_dir

LOGFILE="$TMP_LOG_DIR/"`basename $0`.$$.log

#
# initialize the log file
#
echo $0 called at `date` with args: $* >$LOGFILE

#
# check expanded argument list
#
if [ $# -ne 1 ]
then
    echo "Usage: $0 id,url,parcel,propagate,load,parameters,security,schedule" >&2
    exit 1
fi

#
# expand first argument into its three components
#
OLDIFS=$IFS
IFS=,
set $1
IFS=$OLDIFS

#
# check expanded argument list
#
if [ $# -ne 8 ]
then
    echo "Usage: $0 id,url,parcel,propagate,load,parameters,security,schedule" >&2
    exit 1
fi

echo "$0 $1 $2 $3 $4 $5 $6 $7 $8" >> $LOGFILE

ID=$1
URL=$2
PARCEL=$3
PARAM_PROPAGATE=$4  # 0 = always, 1 = if not loaded
PARAM_LOAD=$5	    # 0 = always, 1 = as is
PARAM_PARAMETERS=$6 # 0 = reference, 1 = target
PARAM_SECURITY=$7   # 0 = reference, 1 = target
PARAM_SCHEDULE=$8   # 0 = reference, 1 = target

#
# perform the get
#
RESULT=`es-mcp-get $ID $URL $LOCAL_BASE $PARCEL $PARAM_PROPAGATE 2>>$LOGFILE`

#
# check status
#
STATUS=$?
if [ $STATUS -ne 0 ]
then
    if [ $STATUS -ne 255 ]
    then
	#
	# failure - log error and exit, leaving log file for perusal
	#
	echo $RESULT >>$LOGFILE
	echo "error: es-mcp-get failed - see $LOGFILE for details" >&2
	echo "error: es-mcp-get failed - see $LOGFILE for details" >> $LOGFILE
	echo "failure"
	exit 2
    else
	echo "success"
	exit 0
    fi
fi

#
# success - merge any MCP DAT files with the originals
#
for module in `/usr/bin/nawk '{ print $1 }' $LOCAL_BASE/cfg/base-modules-d.dat.MCP`
do
    DATFILE="$LOCAL_BASE/cfg/"$module".dat"
    MCPFILE=$DATFILE".MCP"
    TMPFILE=$DATFILE".TMP"

    #
    # ensure DAT file exists
    #
    touch $DATFILE

    echo "merging $MCPFILE into $DATFILE" >> $LOGFILE

    #
    # remove everything but security info from the dat file
    #
    if [ "$PARAM_SECURITY" = "1" ] ; then # Use the target security info
	/usr/bin/egrep '(^value:.*=)|(value:ackName *=)|(= *{[ 	]*$)|(^[ 	]*}[ 	]*$)' $DATFILE > $TMPFILE
    else
	/usr/bin/egrep '(^value:.*=)' $MCPFILE > $TMPFILE
	/usr/bin/egrep '(value:ackName *=)|(= *{[ 	]*$)|(^[ 	]*}[ 	]*$)' $DATFILE >> $TMPFILE
    fi

    #
    # append the MCP dat file content
    #
    cat $MCPFILE | /usr/bin/grep -v "^value:" >> $TMPFILE

    #
    # overwrite original
    #
    mv $TMPFILE $DATFILE
done

#
# clean up log file and exit
#
rm -rf $TMP_LOG_DIR
echo "success"
exit 0
