#! /usr/bin/sh
#
# ident "@(#)base-setup.sh 1.40     03/01/14 SMI"
#
# Copyright 2000-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#
#   File:    base-setup.sh
#   Author:  Halcyon Inc.
#   Version: 1.40 03/01/14 10:42:38
#
#   Copyright (c) 1993-1997 Halcyon Inc.
#

usage()
{
    basename=`basename $0`
    eval echo `gettext 'usage: $basename "[-sh|-csh] [-internal|-external]"'` >&2
    exit 1
}

envusage()
{
    gettext "ERROR: the ESROOT environment variable has not been set" >&2
    exit 2
}

#
# ensure ESROOT is set
#
if [ -z "$ESROOT" ]
then
    envusage
fi

#
# default to csh external mode
#
MODE=external
SHELL=csh

#
# parse command line
#
for arg
do
    case $arg in
	-int*)		MODE=internal ;;
	-ext*)		MODE=external ;;
	-csh)		SHELL=csh ;;
	-sh)		SHELL=sh ;;
	*)		usage ;;
    esac
done

#
# shell-independent env var output
#
putenv()
{
    if [ $SHELL = "sh" ]
    then
        echo "$1=$2; export $1;"
    else
        echo "setenv $1 $2;"
    fi
}

#
# path appending function
#
append()
{
    value=`eval echo \\$$1`
    if [ -z "$value" ]
    then
        eval $1=$2
    else
        eval $1=$value:$2
    fi
}

#
# put config information in environment
#
putenvconfig()
{
    envValue=`eval echo \\$$1`
    envVar=$1
    objName=.config.$2 

    if [ -z "$envValue" ]
    then
        val=`${ESROOT}/base/sbin/${ARCH}/xget ${ESROOT}/base/cfg/super-config.x ${objName}`
        putenv $envVar $val
    fi
}

#
# set the ARCH environment variable
#
putenvARCH()
{
    #
    # determine architecture
    #
    MACH=`uname -m`
    SYS=`uname -s`
    REL=`uname -r`
    VER=`uname -v`
    case "$MACH:$SYS:$REL:$VER" in
	i86pc*:SunOS:5.*:*)
	    REL="`echo ${REL} | sed 's/^5/2/' | cut -d\. -f1,2`"
            ARCH="i386-sun-solaris${REL}" ;;
	sun4*:SunOS:5.*:*)
	    REL="`echo ${REL} | sed 's/^5/2/' | cut -d\. -f1,2`"
            ARCH="sparc-sun-solaris${REL}" ;;
	sun4*:SunOS:*:*)
	    REL="`echo ${REL} | cut -d\. -f1,2`"
            ARCH="sparc-sun-sunos${REL}" ;;
    esac

    putenv ARCH $ARCH
}

#
# set the USER environment variable
#
putenvUSER()
{
    if [ -z "$USER" ]
    then
	if [ -z "$LOGNAME" ]
	then
	    USER=`id | awk '{ split ($1,a,"("); split (a[2],b,")"); print b[1]; }'`
	else
	    USER=$LOGNAME
	fi
	putenv USER $USER
    fi
}

#
# set the HOST environment variable
#
putenvHOST()
{
    if [ -z "$HOST" ]
    then
	HOST=`uname -n`
	putenv HOST $HOST
    fi
}

#
# if this is the first time running setup
#
if [ -z "$ESENV" ]
then
    #
    # output commands to set ARCH, USER, and HOST
    #
    putenvARCH
    putenvUSER
    putenvHOST

    #
    # set ESDIR 
    #
    USER=`id | sed 's/^[^\(]*(\([^\)]*\)).*$/\1/'`
    if [ -n "$ESPRIVATE" ]
    then
        ESDIR=`echo $ESPRIVATE | sed 's/:.*$//'`
    else
	ESDIR=${ESDIR-/var/opt/SUNWsymon} 
    fi

    putenv ESDIR $ESDIR

    #
    # set ESLOCAL
    #
    if [ "$ESDEBUG" = "true" ]
    then
	ESLOCAL=${ESLOCAL-local}:debug
    else
	ESLOCAL=${ESLOCAL-local}
    fi

    putenv ESLOCAL $ESLOCAL 

    #
    # set module loading location
    #
    ESMODULES=${ESMODULES-modules} 

    #
    # set ESPATH
    #
    ESPATH=${ESPRIVATE-${ESDIR}:/etc/oa}:${ESLOCAL}:${ESMODULES}:util:base:contrib

    putenv ESPATH $ESPATH

elif [ "$MODE" = "$ESENV" -o "$ESENV" = "internal" ]
then
    #
    # exit since setup has already been run in this mode or 
    # the internal setup has already been run
    #
    exit 0
fi

#
# generate the PATH, INTERFACE_PATH, and LD_LIBRARY_PATH additions 
#
PATH_INT=""
PATH_EXT=""
INTERFACE_PATH=""
LD_LIBRARY_PATH_ADD=""
for COMP in `echo $ESPATH | sed 's/:/ /g'`
do
    if [ `expr "$COMP" : '\/'` -eq 0 ]
    then
        COMP=${ESROOT}/${COMP}
    fi

    if [ -d ${COMP}/bin ]; then 
	append PATH_INT ${COMP}/bin
	append PATH_EXT ${COMP}/bin

	if [ -d ${COMP}/bin/${ARCH} ]; then
	    append PATH_INT ${COMP}/bin/${ARCH}
	    append PATH_EXT ${COMP}/bin/${ARCH}
	    #
	    # If installing 2.9 AddOn then add 2.8 to path too.
	    #
            if [ "${ARCH}" = "sparc-sun-solaris2.9" ]
            then
                append PATH_INT ${COMP}/bin/sparc-sun-solaris2.8
                append PATH_EXT ${COMP}/bin/sparc-sun-solaris2.8
            fi
	fi
    fi

    if [ -d ${COMP}/sbin ]; then 
	append PATH_INT ${COMP}/sbin

	if [ -d ${COMP}/sbin/${ARCH} ]; then 
	    append PATH_INT ${COMP}/sbin/${ARCH}
	fi
    fi

    test -d ${COMP}/cfg -o -z "$INTERFACE_PATH" \
		&& append INTERFACE_PATH ${COMP}/cfg
    #
    # Add the OS Independent location to the LD_LIBRARY_PATH
    #
    test -d ${COMP}/lib \
		&& append LD_LIBRARY_PATH_ADD ${COMP}/lib

    test -d ${COMP}/lib/${ARCH} \
		&& append LD_LIBRARY_PATH_ADD ${COMP}/lib/${ARCH}

    #
    # If installing 2.9 AddOn then also add 2.8 to the path.
    #
    if [ "${ARCH}" = "sparc-sun-solaris2.9" ]
    then
        append LD_LIBRARY_PATH_ADD ${COMP}/lib/sparc-sun-solaris2.8
    fi

done

#
# if this is the first time running setup
#
if [ -z "$ESENV" ]
then
    #
    # prepend the ld library path addition to the LD_LIBRARY_PATH
    #
    LD_LIBRARY_PATH=${LD_LIBRARY_PATH_ADD}:${LD_LIBRARY_PATH}

    putenv LD_LIBRARY_PATH $LD_LIBRARY_PATH

    #
    # export interface path for use by xget in putenvconfig
    #
    export INTERFACE_PATH

    #
    # set the ESTRAPPORT, ESSNMPPORT, OAPROBEPORT, ESTRAPHOST, ESCONHOST
    #
    # plus new Event Management ones: ESEVENTPORT and ESEVENTHOST
    # plus new Topology ones: ESTOPOLOGYPORT and ESTOPOLOGYHOST
    #
    putenvconfig ESTRAPPORT trap.snmpPort
    putenvconfig ESSNMPPORT agent.snmpPort
    putenvconfig ESEVENTPORT event.snmpPort
    putenvconfig ESCSTSERVICEPORT cstservice.snmpPort
    putenvconfig ESTOPOLOGYPORT topology.snmpPort
    putenvconfig OAPROBEPORT probe.tcpPort
    putenvconfig ESTRAPHOST trap.trapServer
    putenvconfig ESCONHOST concentrator.consoleServer
    putenvconfig ESEVENTHOST event.eventServer
    putenvconfig ESCSTSERVICEHOST cstservice.cstserviceServer
    
    putenvconfig ESTOPOLOGYHOST topology.topologyServer

    #
    # define the RAIMA database storage and definition directories:
    #
    # DBFPATH   - Raima default directory (for output) 
    # EVDBFPATH - Event Management Raima default directory (for output)
    # DBTMP     - location of Event Management Raima Lock Manager file
    # LOCKMGR   - name of Event Management Raima Lock Manager
    # DBDPATH   - location of Raima .dbd files
    # QDBPATH   - location of Raima query .dbd files
    # LOCKMAX   - max. no. of lock manager connections
    #
    putenv DBFPATH   $ESDIR/SunMCDB02
    putenv EVDBFPATH $ESDIR/SunMCDB02
    putenv DBTMP     $ESDIR/SunMCDB02/eventmgr/log/
    putenv LOCKMGR   evLckMgr
    putenv DBDPATH   $ESROOT/base/cfg
    putenv QDBPATH   $ESROOT/base/cfg
    putenv LOCKMAX   200

#
# otherwise, if mode is internal and external setup was run previously
#
elif [ "$MODE" = internal -a "$ESENV" = "external" ]
then
    #
    # remove the external path addition in the PATH
    
    PATH=`echo $PATH | sed "s,${PATH_EXT}:,,g"` 
else
    exit 0
fi

#
# generate output based on mode
#
if [ $MODE = "external" ]
then
    #
    # prepend the PATH with the external path addition
    #
    PATH=${PATH_EXT}:${PATH}
    putenv PATH $PATH

    putenv ESENV external
else 
    #
    # prepend the PATH with the internal path addition 
    #
    PATH_REQ="/usr/sbin:/usr/bin"
    if [ "$PATH" = "$PATH_REQ" ]
    then
        PATH=${PATH_INT}:${PATH}
    else
        PATH=${PATH_INT}:${PATH_REQ}:${PATH}
    fi

    putenv PATH $PATH
    putenv INTERFACE_PATH $INTERFACE_PATH
    putenv TCL_LIBRARY ${ESROOT}/base/cfg
    putenv ESENV internal
fi

exit 0
