#
#   File:    base-topology-action-d.x
#   Author:  Ian Neal
#   Version: 1.14 99/10/18 21:55:16
#   Created: November 1996
#
#   Copyright (c) 1993-1997 Halcyon Inc.
#
#   OpenAgent General Trap Action Specification
#

    [ requires class trapaction ]
    [ inherit classes.trapaction ]
 
    status = {
	[ inherit classes.trapaction ]

	criteria		= trapOID
	trapOID			= [ lookup trap statusChange ]

	#
	# perform trap correlation in job module
	#
	trapActions		= jobfire
	trapService(jobfire)	= .services.snmp
	trapMethod(jobfire)	= jobFireByTagPattern %trapAddress/%context/%value2
    }

    refresh = {
	[ inherit classes.trapaction ]

	criteria		= trapOID
	trapOID			= [ lookup trap valueRefresh ]

	#
	# perform trap correlation in job module
	#
	trapActions		= jobfire 
	trapService(jobfire)	= .services.snmp
	trapMethod(jobfire)	= jobFireByTagPattern %trapAddress/%context/%value2
    }

    warmStart = {
        [ inherit classes.trapaction ]
 
        criteria                    = trapOID
        trapOID                     = [ lookup trap warmStart ]
 
        #
        # perform trap correlation in job module
        #
        trapActions                 = flush jobfire 
        trapService(flush)          = .services.io.snmp
        trapMethod(flush)           = clearCacheByTarget %trapAddress
        trapService(jobfire)        = .services.snmp
        trapMethod(jobfire)         = jobRebootByTag %trapAddress
    }

    trapClient = {
        [ inherit classes.trapaction ]
 
        criteria                    = trapOID
        trapOID                     = [ lookup trap trapClient ]

        #
        # add sender to trap recipient list
        # 
        trapActions                 = addclient
        trapService(addclient)      = .services.trap
        trapMethod(addclient)       = addTrapClientByTrap %pdu
    }

    topoLicRefresh = {
        [ inherit classes.trapaction ]

        criteria                    = trapOID
        trapOID                     = [ lookup trap topoLicRefresh ]

        #
        # add sender to trap recipient list
        #
        trapActions                 = updateDB
        trapService(updateDB)      = .services.modquery
        trapMethod(updateDB)       = handleLicenseTrap %trapAddress
    }

