
# Copyright 09/29/98 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)Config-Reader4udt-d.x	1.24 00/08/03 16:27:36, Sun Microsystems, Inc."


[ use MANAGED-MODULE ]
[ requires package configddt ]
[ requires package pfa ]
[ requires template Config-Reader4udt-models-d ]
[ requires template sena-models-d ]

[ load Config-Reader4udt-m.x ]

# Define services required by this module

#_services = { [ use SERVICE ]
#	Config-Reader4uShell = {
#		command	= "pipe://localhost/oa-shell.sh;transport=shell;args=Config-Reader4u-shell.tcl"
#		max	= 1
#	}
#}

_filters = { [use PROC]
        [ source Config-Reader4udt-d.flt ]
}

#
# configd Availability
#
availability = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.timestamp:update
	refreshCommand  = get_availabilty_status

# change the default error message. Change the default alarm.
 
	errorMessage       = "Is not supported on this platform."
	alarmChecks         = "error-ne";
	alarmlimit:error-ne  = AVAILABLE
	mediumDesc          = 
	statusActions(error-ne)      = forcedown
	statusService(forcedown)    = _superior
	statusCommand(forcedown)    = forceModuleState down %[ toe_self ]

}


system = { [ use templates.Config-Reader4udt-models-d.system ]
	type		= active
	refreshMode	= sync
        refreshCommand  = configddt system 0 OS OS_version System_clock_frequency architecture hostname machine platform sample serial_number timestamp timestamp_raw total_disks total_memory total_processors total_tape_devices 
        initInterval    = 2
	refreshInterval	= 300
	total_model_changes = { [ use _filters ]
		type		= derived
		refreshMode	= sync
		refreshCommand  = get_prom_changed_status 0
		refreshFilter   = modelChange
        	refreshTrigger  = system.timestamp:refresh
		initInterval    = 2
	}
	total_config_changes = { [ use _filters ]
		type		= derived
		refreshMode	= sync
		refreshCommand  = get_prom_changed_status 1
		refreshFilter   = configChange
		initInterval    = 2
        	refreshTrigger  = system.timestamp:refresh
	}
}


system-board = { [ use templates.Config-Reader4udt-models-d.system-board ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt system-board 0
        initInterval    = 5
	refreshInterval	= 6000
}

SUNWUltra-1  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-1  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-1 0
        initInterval    = 5
	refreshInterval	= 86400
}
SUNWUltra-2  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-2  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-2 0
        initInterval    = 5
	refreshInterval	= 86400
}
SUNWUltra-4  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-4  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-4 0
        initInterval    = 5
	refreshInterval	= 6000
}
SUNWUltra-30  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-30  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-30 0
        initInterval    = 5
	refreshInterval	= 86400
}
SUNWUltra-60  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-60  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-60 0
        initInterval    = 5
	refreshInterval	= 86400
}
SUNWUltra-80  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-80  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-80 0
        initInterval    = 5
	refreshInterval	= 86400
}
# SUNWUltra-100  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-100  ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt SUNW,Ultra-100 0
#        initInterval    = 5
#	refreshInterval	= 86400
#}
SUNWUltra-5  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-5  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-5 0
        initInterval    = 5
	refreshInterval	= 86400
}
SUNWUltra-10  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-10  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-10 0
        initInterval    = 5
	refreshInterval	= 86400
}
SUNWUltra-5_10  = { [ use templates.Config-Reader4udt-models-d.SUNWUltra-5_10  ]
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,Ultra-5_10 0
        initInterval    = 5
	refreshInterval	= 86400
}
slot = { [ use templates.Config-Reader4udt-models-d.slot ]
slotTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt slot 1 slot-num
        initInterval    = 5
	refreshInterval	= 86400
}
}

cpu-unit = { [ use templates.Config-Reader4udt-models-d.cpu-unit ]
cpu-unitTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt cpu-unit 1 board# board# clock-frequency cpu-type dcache-size device_type ecache-size fru icache-size model pathname_element processor-id reg status unit upa-mid upa-portid
        initInterval    = 5
	refreshInterval	= 6000
}
}
mc   = { [ use templates.Config-Reader4udt-models-d.mc ]
mcTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt mc 1 device_type fru_device
        initInterval    = 5
        refreshInterval = 86400
}
}
bank  = { [ use templates.Config-Reader4udt-models-d.bank ]
bankTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt bank 1 bank-size device_type fru_device status
        initInterval    = 5
        refreshInterval = 86400
}
}
dimm = { [ use templates.Config-Reader4udt-models-d.dimm ]
dimmTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt dimm 1 device_type fru fru_device module-size socket-name status
        initInterval    = 5
        refreshInterval = 86400
}
}
power-supply = { [ use templates.Config-Reader4udt-models-d.power-supply ]
power-supplyTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt power-supply 1 fru state
        initInterval    = 5
        refreshInterval = 86400
}
}
cpu-fans = { [ use templates.Config-Reader4udt-models-d.cpu-fans ]
cpu-fansTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt cpu-fans 1 status
        initInterval    = 5
        refreshInterval = 86400
}
}
power-supply-fans = { [ use templates.Config-Reader4udt-models-d.power-supply-fans ]
power-supply-fansTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt power-supply-fans 1 status
        initInterval    = 5
        refreshInterval = 86400
}
}
#sd = { [ use templates.Config-Reader4udt-models-d.sd ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt sd 1 device_type fru mounted_partitions disk_name
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#zs = { [ use templates.Config-Reader4udt-models-d.zs ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt zs 1 device_type device_usage instance pathname_element
#        initInterval    = 5
#	refreshInterval	= 6000
#}
simm = { [ use templates.Config-Reader4udt-models-d.simm ]
simmTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt simm 1 board_reference_number fru size slot type
        initInterval    = 5
	refreshInterval	= 86400
}
}
#AC_PS = { [ use templates.Config-Reader4udt-models-d.AC_PS ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt AC_PS 0 status 
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#hot_plug_charges = { [ use templates.Config-Reader4udt-models-d.hot_plug_charges ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt hot_plug_charges 0 fru
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#auxiliary_5v = { [ use templates.Config-Reader4udt-models-d.auxiliary_5v ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt auxiliary_5v 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#peripheral_5v = { [ use templates.Config-Reader4udt-models-d.peripheral_5v ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt peripheral_5v 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#peripheral_5v_precharge = { [ use templates.Config-Reader4udt-models-d.peripheral_5v_precharge ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt peripheral_5v_precharge 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#peripheral_12v = { [ use templates.Config-Reader4udt-models-d.peripheral_12v ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt peripheral_12v 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#peripheral_12v_precharge = { [ use templates.Config-Reader4udt-models-d.peripheral_12v_precharge ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt peripheral_12v_precharge 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#system_3v = { [ use templates.Config-Reader4udt-models-d.system_3v ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt system_3v 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#system_3v_precharge = { [ use templates.Config-Reader4udt-models-d.system_3v_precharge ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt system_3v_precharge 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#system_5v = { [ use templates.Config-Reader4udt-models-d.system_5v ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt system_5v 0 fru status
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#system_5v_precharge = { [ use templates.Config-Reader4udt-models-d.system_5v_precharge ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt system_5v_precharge 0 fru status
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#keyswitch = { [ use templates.Config-Reader4udt-models-d.keyswitch ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt keyswitch 0 position
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#peripheral_PS = { [ use templates.Config-Reader4udt-models-d.peripheral_PS ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt peripheral_PS 1 fru hpu status unit_no
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#rack_fan = { [ use templates.Config-Reader4udt-models-d.rack_fan ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt rack_fan 0 status
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#remote_console = { [ use templates.Config-Reader4udt-models-d.remote_console ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt remote_console 0 status
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#fhc = { [ use templates.Config-Reader4udt-models-d.fhc ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt fhc 1 board_num model reg upa-mid version_no
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#ac = { [ use templates.Config-Reader4udt-models-d.ac ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt ac 1 bank-0-status bank-1-status device_type model pv_ancestor_alarm reg version#
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#environment = { [ use templates.Config-Reader4udt-models-d.environment ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt environment 1 reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#environ = { [ use templates.Config-Reader4udt-models-d.environ ]
#        type            = derived
#        refreshMode     = sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt environ 1 reg
#        initInterval    = 5
#        refreshInterval = 6000
#}
#
flashprom = { [ use templates.Config-Reader4udt-models-d.flashprom ]
flashpromTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        initInterval    = 5
        refreshCommand  = configddt flashprom 1 model reg 
	refreshInterval	= 86400
}
}
#simmstat = { [ use templates.Config-Reader4udt-models-d.simmstat ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt simmstat 1 instance reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#simm-status = { [ use templates.Config-Reader4udt-models-d.simm-status ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt simm-status 1 reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sram = { [ use templates.Config-Reader4udt-models-d.sram ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt sram 1 reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
##sbus = { [ use templates.Config-Reader4udt-models-d.sbus ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt sbus 1 clock-frequency board_num device_type model network_count reg upa-mid upa-portid version#
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sbus-speed = { [ use templates.Config-Reader4udt-models-d.sbus-speed ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt sbus-speed 1 reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#ba = { [ use templates.Config-Reader4udt-models-d.ba ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt ba 1 instance model reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#soc = { [ use templates.Config-Reader4udt-models-d.soc ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt soc 1 device_type instance model port-wwns reg soc-fcode soc-wwn
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWsoc = { [ use templates.Config-Reader4udt-models-d.SUNWsoc ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt SUNW,soc 1 device_type model port-wwns reg soc-fcode soc-wwN
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWsocmod = { [ use templates.Config-Reader4udt-models-d.SUNWsocmod ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt SUNW,socmod 1 
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWhme = { [ use templates.Config-Reader4udt-models-d.SUNWhme ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt SUNW,hme 1 device_type ether inet dt_name  reg pathname_element symbol
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWfas = { [ use templates.Config-Reader4udt-models-d.SUNWfas ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt SUNW,fas 1 device_type disk_count reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#SUNWpln = { [ use templates.Config-Reader4udt-models-d.SUNWpln ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt SUNW,pln 1 device_type disk_count instance status unit_no
#        initInterval    = 5
#	refreshInterval	= 6000
#}

# This is commented since we can use the ssd model from the sena-models-d.x
#
#ssd = { [ use templates.Config-Reader4udt-models-d.ssd ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt ssd 1 device_type fru instance mounted_partitions disk_name
#        initInterval    = 5
#	refreshInterval	= 6000
#}

#fas = { [ use templates.Config-Reader4udt-models-d.fas ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt fas 1 device_type disk_count instance reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#cdrom0 = { [ use templates.Config-Reader4udt-models-d.cdrom0 ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt cdrom0 1 device_type fru  instance mounted_partitions name 
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#hme = { [ use templates.Config-Reader4udt-models-d.hme ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt hme 1 device_type ether inet instance pathname_element symbol
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#QLGCisp = { [ use templates.Config-Reader4udt-models-d.QLGCisp ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt QLGC,isp 1 device_type disk_count model reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#isp = { [ use templates.Config-Reader4udt-models-d.isp ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt isp 1 device_type disk_count instance model reg tape_count
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#st = { [ use templates.Config-Reader4udt-models-d.st ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt st 1 device_type fru model tape_name status
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#led = { [ use templates.Config-Reader4udt-models-d.led ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt led 1 led-num state
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#central = { [ use templates.Config-Reader4udt-models-d.central ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt central 1 reg upa-mid
#        initInterval    = 5
#	refreshInterval	= 6000
#}
eeprom = { [ use templates.Config-Reader4udt-models-d.eeprom ]
eepromTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt eeprom 1 model reg
        initInterval    = 5
	refreshInterval	= 86400
}
}
sysctrl = { [ use templates.Config-Reader4udt-models-d.sysctrl ]
sysctrlTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt sysctrl 1 instance reg
        initInterval    = 5
	refreshInterval	= 86400
}
}
#cgsix = { [ use templates.Config-Reader4udt-models-d.cgsix ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt cgsix 1 device_type height model reg width
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#socal = { [ use templates.Config-Reader4udt-models-d.socal ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt socal 1 device_type instance model reg
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sf = { [ use templates.Config-Reader4udt-models-d.sf ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt sf 1 device_type disk_count instance port-wwn reg slot-num 
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#
fan = { [ use templates.Config-Reader4udt-models-d.fan ]
fanTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt fan 1 status
        initInterval    = 5
	refreshInterval	= 86400
}
}
#disk = { [ use templates.Config-Reader4udt-models-d.disk ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt disk 1  scsi-target-id
#        initInterval    = 5
#	refreshInterval	= 6000
#}
memory = { [ use templates.Config-Reader4udt-models-d.memory ]
memoryTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt memory 1 pathname_element
        initInterval    = 5
	refreshInterval	= 86400
}
}
# memory-controller = { [ use templates.Config-Reader4udt-models-d.memory-controller ]
# memory-controllerTbl = {
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt memory-controller 1 pathname_element
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#}
#counter-timer = { [ use templates.Config-Reader4udt-models-d.counter-timer ]
#counter-timerTbl = {
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt counter-timer 1 pathname_element
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#}
#
#generic-device = { [ use templates.Config-Reader4udt-models-d.generic-device ]
#generic-deviceTbl = {
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt generic-device 1 pathname_element
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#}

#pci108e5043 = { [ use templates.Config-Reader4udt-models-d.pci108e5043 ]
#pci108e5043Tbl = {
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt pci108e5043 1 pathname_element
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#}

#audiocs = { [ use templates.Config-Reader4udt-models-d.audiocs ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt audiocs 1 device_type instance pathname_element
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#bpp = { [ use templates.Config-Reader4udt-models-d.bpp ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt bpp 1 instance pathname_element
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#fd = { [ use templates.Config-Reader4udt-models-d.fd ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt fd 1 device_type fru instance pathname_element status
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sbus-slot = { [ use templates.Config-Reader4udt-models-d.sbus-slot ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt sbus-slot 1 slot-num
#        initInterval    = 5
#	refreshInterval	= 6000
#}
#sbus-board = { [ use templates.Config-Reader4udt-models-d.sbus-board ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt sbus-board 1 board-num fru model state type
#        initInterval    = 5
#	refreshInterval	= 6000
#}
ffb = { [ use templates.Config-Reader4udt-models-d.ffb ]
ffbTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt ffb 1 buffer device_type model pathname_element 
        initInterval    = 5
	refreshInterval	= 86400
}
}
afb = { [ use templates.Config-Reader4udt-models-d.afb ]
afbTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt afb 1 buffer device_type model pathname_element 
        initInterval    = 5
	refreshInterval	= 86400
}
}
SUNWffb = { [ use templates.Config-Reader4udt-models-d.SUNWffb ]
SUNWffbTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,ffb 1 3DRAM DAC FBC_version board_type buffer device_type height model revision upa-portid width
        initInterval    = 5
	refreshInterval	= 86400
}
}
SUNWafb = { [ use templates.Config-Reader4udt-models-d.SUNWafb ]
SUNWafbTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt SUNW,afb 1 3DRAM DAC FBC_version board_type buffer device_type height model revision upa-portid width
        initInterval    = 5
	refreshInterval	= 86400
}
}
#pci = { [ use templates.Config-Reader4udt-models-d.pci ]
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt pci 1 compatible0 device_type model reg upa-mid upa-portid version#
#        initInterval    = 5
#	refreshInterval	= 6000
#}
hardware-rules = { [ use templates.Config-Reader4udt-models-d.hardware-rules ]
#	        type            = active
}

pfa-rules = { [ use templates.Config-Reader4udt-models-d.pfa-rules ]
#	        type            = active
}

# sena information

sena = { [ use templates.sena-models-d.sena ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt sena 1  box_rev device_count instance loop_configuration_status machine name node-wwn platform  slot_count type virtual_node
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

led = { [ use templates.sena-models-d.led ]
ledTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt led 1  led-num state
        initInterval    = 5
	refreshInterval	= 6000
}
}

front = { [ use templates.sena-models-d.front ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt front 1  instance
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
rear = { [ use templates.sena-models-d.rear ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt rear 1  instance
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

disk_backplane = { [ use templates.sena-models-d.disk_backplane ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt disk_backplane 1  byp_a_enabled byp_b_enabled status
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

fan_tray = { [ use templates.sena-models-d.fan_tray ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt fan_tray 1  fan_fail speed status type
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

front_slot = { [ use templates.sena-models-d.front_slot ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt front_slot 1  id loop_status slot-num status temperature temperature_status
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
rear_slot = { [ use templates.sena-models-d.rear_slot ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt rear_slot 1  id loop_status slot-num status temperature temperature_status
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

ssd = { [ use templates.sena-models-d.ssd ]
ssdTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt ssd 1  device_type fru hard_address instance mounted_partitions name node-wwn parent port-wwn status alternate_instances alternate_names alternate_parents
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
}

sena_power_supply = { [ use templates.sena-models-d.sena_power_supply ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt sena_power_supply 1  AC_status  DC-current DC-voltage ps-instance status temperature_status type
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}

interconnect = { [ use templates.sena-models-d.interconnect ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt interconnect 1  eprom_failure status
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
ib = { [ use templates.sena-models-d.ib ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt ib 1  ib-instance loop loop0_fault loop1_fault status temperature_status 
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
gbic = { [ use templates.sena-models-d.gbic ]
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt gbic 1  gbic-instance status xmit_fail
        initInterval    = 5
	timeoutInterval = 600
	refreshInterval	= 6000
}
io_controller = { [ use templates.Config-Reader4udt-models-d.io_controller ]
io_controllerTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt io_controller 1 board# clock-frequency device_type instance model reg  upa-mid upa-portid version#
        initInterval    = 5
        refreshInterval = 86400

 }
}
io_device = { [ use templates.Config-Reader4udt-models-d.io_device ]
io_deviceTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt io_device 1 device_type disk_count instance model node_hierarchy network_count reg tape_count
        initInterval    = 5
        refreshInterval = 86400
}
}
disk = { [ use templates.Config-Reader4udt-models-d.disk ]
diskTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt disk 1 device_type name fru instance node_hierarchy target
        initInterval    = 5
        refreshInterval = 86400
}
}
tape = { [ use templates.Config-Reader4udt-models-d.tape ]
tapeTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt tape 1 device_type fru instance model node_hierarchy tape_name status target
        initInterval    = 5
        refreshInterval = 86400
}
}
network = { [ use templates.Config-Reader4udt-models-d.network ]
networkTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt network 1 device_type ether inet name node_hierarchy symbol reg
        initInterval    = 5
        refreshInterval = 86400
}
}
io-unit = { [ use templates.Config-Reader4udt-models-d.io-unit ]
io-unitTbl = { 
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configddt io-unit 1 board# device-id instance reg
        initInterval    = 5
        refreshInterval = 86400
}
}


#ppm = { [ use templates.Config-Reader4udt-models-d.ppm ]
#ppmTbl = {
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt ppm 1 pathname_element
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#}
#
#upa64s = { [ use templates.Config-Reader4udt-models-d.upa64s ]
#upa64sTbl = {
#	type		= derived
#	refreshMode	= sync
#        refreshTrigger  = system.total_model_changes:update
#        refreshCommand  = configddt upa64s 1 pathname_element
#        initInterval    = 5
#	refreshInterval	= 86400
#}
#}
