
# Needed utilities
UNAME=/bin/uname

OS=`${UNAME} -s | tr -- '-.' '__'`

EXEEXT_CYGWIN_NT_4_0=.exe
eval EXEEXT=\${EXEEXT_$OS-}

COMPRESS_CYGWIN_NT_4_0=gzip
COMPRESS_Linux=gzip
eval COMPRESS=\${COMPRESS_$OS-/usr/bin/compress}${EXEEXT}
COMPRESS_SUFFIX_CYGWIN_NT_4_0=gz
COMPRESS_SUFFIX_Linux=gz
eval COMPRESS_SUFFIX=\${COMPRESS_SUFFIX_$OS-Z}

DF_Linux=df_gnu_func
DF_CYGWIN_NT_4_0=df_gnu_func
eval DF=\${DF_$OS-/bin/df}

AWK=/usr/bin/awk
NAWK_CYGWIN_NT_4_0=/bin/awk
eval NAWK=\${NAWK_$OS-/usr/bin/nawk}${EXEEXT}

FIND_Linux=/usr/bin/find
eval FIND=\${FIND_$OS-/bin/find}${EXEEXT}

CPIO_CYGWIN_NT_4_0=/bin/cpio
eval CPIO=\${CPIO_$OS-/usr/bin/cpio}${EXEEXT}

TAR=/bin/tar${EXEEXT}
TARFILELISTOPT_SunOS=-I
TARFILELISTOPT_Linux=-T
TARFILELISTOPT_CYGWIN_NT_4_0=-T
eval TARFILELISTOPT=\${TARFILELISTOPT_$OS}

ZCAT=/bin/zcat
UNZIP=/usr/bin/unzip

TOUCH_Linux=/usr/bin/touch
eval TOUCH=\${TOUCH_$OS-/bin/touch}${EXEEXT}

TAIL_Linux=/usr/bin/tail
eval TAIL=\${TAIL_$OS-/bin/tail}${EXEEXT}

MOUNT_SunOS=/sbin/mount
eval MOUNT=\${MOUNT_$OS-/bin/mount}${EXEEXT}
UMOUNT_SunOS=/sbin/umount
eval UMOUNT=\${UMOUNT_$OS-/bin/umount}${EXEEXT}

VALPATH=valpath_func

SUM_Linux=/usr/bin/sum
eval SUM=\${SUM_$OS-/bin/sum}${EXEEXT}

GETTEXT_SunOS=/usr/bin/gettext
eval GETTEXT=\${GETTEXT_$OS-printf}${EXEEXT}

LCHOWN_SunOS="chown -h"
LCHOWN_Linux=chown
LCHOWN_CYGWIN_NT_4_0=chown
eval LCHOWN=\${LCHOWN_$OS}${EXEEXT}
LCHGRP_SunOS="chgrp -h"
LCHGRP_Linux=chgrp
LCHGRP_CYGWIN_NT_4_0=chgrp
eval LCHGRP=\${LCHGRP_$OS}${EXEEXT}

WC_CYGWIN_NT_4_0=/bin/wc
eval WC=\${WC_$OS-/usr/bin/wc}${EXEEXT}

DIFF=/usr/bin/diff${EXEEXT}
MD=/bin/mkdir${EXEEXT}
EXPR=/bin/expr${EXEEXT}
CAT=/bin/cat${EXEEXT}
PKGPROTO=/usr/bin/pkgproto${EXEEXT}
ECHO=/bin/echo${EXEEXT}
MV=/bin/mv${EXEEXT}
LN=/bin/ln${EXEEXT}
RM=/bin/rm${EXEEXT}
SED=/bin/sed${EXEEXT}
GREP=/bin/grep${EXEEXT}
EGREP=/bin/egrep${EXEEXT}
FGREP=/bin/fgrep${EXEEXT}
LS=/bin/ls${EXEEXT}
CP=/bin/cp${EXEEXT}


# Description:
#   Limitedly simulates Solaris' `valpath':
# -a check that arg is a valid absolute path
# -l check that arg is a valid relative path
#
# Parameters:
#	$1 - -a | -l
#	$2 - path to be checked
#
valpath_func ()
{
	case "$1" in
	-a)
		case "$2" in
		/*)
			return 0 ;;
		*)
			return 1 ;;
		esac
		;;
	-l)
		case "$2" in
		/*)
			return 1 ;;
		*)
			return 0 ;;
		esac
		;;
	*)
		echo >&2 "ERROR: valpath not called with '-a' or '-l': \`$*'"
		exit 1
		;;
	esac
}


df_gnu_func ()
{
	if [ "$1" != "-b" ]
	then
		df -P "$*"
	fi

	shift
	echo "Filesystem              avail"
	df -P "$*" | tail -1 | sed 's/  */ /g' | cut -d' ' -f1,4
}


sane_rootdir ()
{
	case $1 in
	*/)
		echo $1
		;;
	*)
		echo $1/
		;;
	esac
}
