#   File:    cfgserver-d.x
#   File:    cfgserver-d.x
#   Version: 1.22 01/05/01 12:30:59
#
#   Copyright (c) 1993-1998 Halcyon Inc.
#
#   PrimeAlert Config/Security Module
#
    [ use MODULE ]
    [ load cfgserver-m.x ]
    [ requires template cfgserver-models-d ]
    [ requires package auth ]
#    [ requires package snmpv2 ]

    type = passive

    _services = { [ use SERVICE ]
	#
	# Standard Bourne Shell
	#
	sh = {
	    command	= "pipe://localhost//bin/sh;transport=shell"
	    max		= 2
	}
    }

#   Config server procedures.
#   -------------------------
 
    _engineprocs = {
	[ use PROC ]
	[ source cfgserver-engine-d.prc ]
    }
    _userprocs = {
	[ use PROC ]
	[ source cfgserver-user-d.prc ]
    }
    _genprocs = {
	[ use PROC ]
	[ source cfgserver-gen-d.prc ]
    }

    persistentSlices		= value

#   Activation actions.
#   -------------------
    activateActions(post)		= loadtraps firsttrapclient schedtrapclient

#   --- load cfgserver trapactions --- #
    activateService(loadtraps)		= .services.trap
    activateCommand(loadtraps)		= loadActions cfgserver-traps


#   Deactivation actions.
#   ---------------------
    deactivateActions(pre) 		= unloadtraps
    deactivateService(unloadtraps)	= .services.trap
    deactivateCommand(unloadtraps)	= unloadActions cfgserver-traps


#   --- send a trapclient trap right away --- #
    activateService(firsttrapclient)	= .services.snmp
    activateMethod(firsttrapclient)	= jobNotify "" "" ""

#   --- schedule periodic trapclient traps --- #
    activateService(schedtrapclient)	= .services.snmp
    activateMethod(schedtrapclient)	= registerNotifyTimer "" 300 0 {jobNotify "" "" ""}

#   --- define access control for the module --- #
    userAccess(%operatorUsers,write)       = none
    userAccess(%operatorCommunities,write) = none
    groupAccess(%operatorGroups,write)     = none

#   User authentication service.
#   ----------------------------

    authenticator = { [ use templates.cfgserver-models-d.authenticator ]
	access			= wo
	setActions		= *auth
	setService(auth)	= users
	setMethod(auth)		= authUser %value %pdu
        userAccess(%generalUsers,write)       = auth
        groupAccess(%generalGroups,write)     = auth
    }

#   Getter/setter node.
#   -------------------

    getset = { [ use templates.cfgserver-models-d.getset ]
	access			= rw
	setActions		= *set
	setService(set)		= users
	setMethod(set)		= getSetUserKeyVal %value

        userAccess(%generalUsers,write)       = auth
        groupAccess(%generalGroups,write)     = auth
    }

    engines = { [ use templates.cfgserver-models-d.engines ]

	persistentSlices	= data:cfgserver-engines.dat \
				  oldauthkey:cfgserver-oldauthkey.dat \
				  newauthkey:cfgserver-newauthkey.dat \
				  authkeychange:cfgserver-authkeychange.dat

	activateActions(post)		= updateinsts
	activateService(updateinsts)	= engineTable.engineEntry
	activateCommand(updateinsts)	= updateInstances

	engineTable = { 

	    engineEntry = { [ use _engineprocs _userprocs _genprocs ]
		[ requires class trapaction ]
		[ inherit classes.trapaction ]

		activateActions(post)		= registerme
	
#   		--- register myself in trap service --- #
    		activateService(registerme)	= .services.trap
    		activateCommand(registerme)	= define peer cfgserver %[ toe_name -full ]

    	        globService(syncdata)	= engines
		globCommand(syncdata)	= syncSlice data

		userService		= users

		snmpService		= [ locate .services.io.snmp ]
		snmpCommand		= runCommand %ecm %command

		engineid = { 
		}

		netloc = { 

		    setActions		= sync
		    setService(sync)	= engines
		    setCommand(sync)	= syncSlice data
		}

		authkey = {
                    access = none
		    setActions		= syncOld syncNew syncChg
		    setService(syncOld)	= engines
		    setCommand(syncOld)	= syncSlice oldauthkey
		    setService(syncNew)	= engines
		    setCommand(syncNew)	= syncSlice newauthkey
		    setService(syncChg)	= engines
		    setCommand(syncChg)	= syncSlice authkeychange
		}

		getcfgidretries	= { 
		    defaultvalue	= 0

		    #setActions		= sync
		    setService(sync)	= engines
		    setCommand(sync)	= syncSlice data
		}

		getcfgidack	= { 
		    defaultvalue	= 1

		    #setActions		= sync
		    setService(sync)	= engines
		    setCommand(sync)	= syncSlice data
		}

		setcfgid = { 
		    defaultvalue	= 0

		    #setActions		= sync
		    setService(sync)	= engines
		    setCommand(sync)	= syncSlice data
		}

		setcfgidtime = { 
		    defaultvalue	= 0

		    #setActions		= sync
		    setService(sync)	= engines
		    setCommand(sync)	= syncSlice data
		}

		setcfgidack = { 
		    defaultvalue	= 1

		    setActions		= sync
		    setService(sync)	= engines
		    setCommand(sync)	= syncSlice data
		}
	    }
	}
    }

    users = { [ use templates.cfgserver-models-d.users _userprocs _genprocs ]

	type			= active
        checkService            = _internal
        checkCommand            = checkuserfile
        checkInterval           = 30

	refreshMode		= sync
	refreshService	        = _services.sh
	refreshCommand		= cfgserver-grplist-d.sh %[ lookup value userfile ]
#	refreshService		= _internal
#	refreshCommand		= getauthusers %[ lookup value globalContext ]
	refreshFilter		= fleshOutUserList
	initInterval		= 0
	refreshInterval		= 60

	refreshActions		= update
	refreshService(update)	= _internal
	refreshMethod(update)	= updateTblImage authkey grouplist -compare

	tblchActions		= sync
	tblchService(sync)	= _internal
	tblchCommand(sync)	= syncSlice data

	subtblchActions			= incrid updagents sync
	subtblchService(incrid)		= _internal
	subtblchCommand(incrid)		= incrConfigID %diffs
	subtblchService(updagents)	= engines.engineTable.engineEntry
	subtblchCommand(updagents)	= updateAgents 1
	subtblchService(sync)		= _internal
	subtblchCommand(sync)		= syncSlice userauthsuppl

	forwardStatus		= false
	persistentSlices	= data:cfgserver-users.dat \
				  userdata:auth-userdata.dat \
				  userauthsuppl:auth-suppl.dat \
				  configid:config-id.dat \
				  cfgdiffs:config-diffs.dat

#   	Activation actions.
#   	-------------------
	activateActions(pre)		= initid
	activateService(initid)		= _internal
	activateCommand(initid)		= define configid configid 0

	activateActions(post)		= cachetbl updinsts tblimage refresh updateagents

#   	--- register my user table here, for future convenience --- #
	activateService(cachetbl)	= _internal
	activateCommand(cachetbl)	= define value usertable \
							"userTable.userEntry"

#	--- initialize instance names (for read-in sync data) --- #
	activateService(updinsts)	= userTable.userEntry
	activateCommand(updinsts)	= updateInstances

#	--- get starting table data image --- #
	activateService(tblimage)	= _internal
	activateCommand(tblimage)	= updateTblImage authkey grouplist

#	--- initially populate the table --- #
	activateService(refresh)	= _internal
	activateCommand(refresh)	= refreshValue

#	--- update agents that need updating --- #
	activateService(updateagents)	= engines.engineTable.engineEntry
	activateCommand(updateagents)	= updateAgents 0

	engineService = engines.engineTable.engineEntry
    
	userTable = { 

	    userEntry = { 

     	        globActions		= update
    	        globService(update)	= users
		globCommand(update)	= updateTblImage authkey grouplist -compare
		username = { 
		}

		grouplist = { 
		}

		authprotocol = { 
		}

		privprotocol = {
		}

		defaultcomm = {
		    access		= rw
		    setActions		= suppl decrglob
		    setService(suppl)	= users
		    setCommand(suppl)	= updateAuthSuppl %[ toe_name ] %rowname %value

                    userAccess(%generalUsers,write)       = auth
                    groupAccess(%generalGroups,write)     = auth
		}

		defaultdomain = { 
		    access		= rw
		    setActions		= suppl decrglob
		    setService(suppl)	= users
		    setCommand(suppl)	= updateAuthSuppl %[ toe_name ] %rowname %value

                    userAccess(%generalUsers,write)       = auth
                    groupAccess(%generalGroups,write)     = auth
		}

		authkey = { 
                    access = none
		    setActions		= suppl decrglob
		    setService(suppl)	= users
		    setCommand(suppl)	= updateAuthSuppl %[ toe_name ] %rowname %value
		}

		localize = {
		}
	    }
	}
    }

    userGraphs = { [ use templates.cfgserver-models-d.userGraphs ]
	persistentSlices	= data:cfgserver-usergraphs.dat

	activateActions(post)           = updateinsts
        activateService(updateinsts)    = userGraphTable.userGraphEntry
        activateCommand(updateinsts)    = updateInstances

        userAccess(%generalUsers,write)      = auth
        groupAccess(%generalGroups,write)     = auth

        userGraphTable = {
            userGraphEntry = {

	        globActions		= sync
	        globService(sync)	= _internal
	        globCommand(sync)	= syncSlice data

                username = { 
                    access = rw
                }
                graphname = { 
                    access = rw
                }
                graphinfo = { 
                    access = rw
                }
            }
        }
    }

    userGraphTemplates = { [ use templates.cfgserver-models-d.userGraphTemplates ]
	persistentSlices	= data:cfgserver-usertemplates.dat

        activateActions(post)           = updateinsts
        activateService(updateinsts)    = userTemplateTable.userTemplateEntry
        activateCommand(updateinsts)    = updateInstances

        userAccess(%generalUsers,write)       = auth
        groupAccess(%generalGroups,write)     = auth

        userTemplateTable = {
            userTemplateEntry = {

	        globActions		= sync
	        globService(sync)	= _internal
	        globCommand(sync)	= syncSlice data

                username = { 
                    access = rw
                }
                templatename = { 
                    access = rw
                }
                templateinfo = { 
                    access = rw
                }
            }
        }
    }
