/*
 * This example is from the Tools.h++ manual, version 7
 *
 * Copyright (c) 1989-1999 Rogue Wave Software, Inc.  All Rights Reserved.
 *
 * This computer software is owned by Rogue Wave Software, Inc. and is
 * protected by U.S. copyright laws and other laws and by international
 * treaties.  This computer software is furnished by Rogue Wave Software,
 * Inc. pursuant to a written license agreement and may be used, copied,
 * transmitted, and stored only in accordance with the terms of such
 * license and with the inclusion of the above copyright notice.  This
 * computer software or any other copies thereof may not be provided or
 * otherwise made available to any other person.
 *
 * U.S. Government Restricted Rights.  This computer software is provided
 * with Restricted Rights.  Use, duplication, or disclosure by the
 * Government is subject to restrictions as set forth in subparagraph (c)
 * (1) (ii) of The Rights in Technical Data and Computer Software clause
 * at DFARS 252.227-7013 or subparagraphs (c) (1) and (2) of the
 * Commercial Computer Software  Restricted Rights at 48 CFR 52.227-19,
 * as applicable.  Manufacturer is Rogue Wave Software, Inc., 5500
 * Flatiron Parkway, Boulder, Colorado 80301 USA.
 */

#include <assert.h>
#include <rw/cstring.h>
#include <rw/rwfile.h>

class Developer {
  public:
    Developer(const char* name, const Developer* anAlias = 0L)
      : name_(name), alias_(anAlias) {}

  RWCString         name_;
  const Developer*  alias_;
};

RWFile& operator<<(RWFile& file, const Developer& developer)
{/*... */ return file;}

RWFile& operator>>(RWFile& file, Developer& developer)
{/*...*/ return file;}

class Team {
  public:
    Developer*  member_[3];
};

RWFile& operator<<(RWFile& file, const Team& team)
{/*...*/ return file;}

RWFile& operator>>(RWFile& file, Team& team)
{/*...*/ return file;}

main (){
  Developer*  kevin   = new Developer("Kevin");
  Developer*  rudi    = new Developer("Rudi", kevin);
  Team        team1;

  team1.member_[0] = rudi;
  team1.member_[1] = rudi;
  team1.member_[2] = kevin;

  {
    RWFile    f("team.dat");
    f << team1;  // Simple persistence of team.
  }

  Team        team2;
  {
    RWFile            f("team.dat");
    f >> team2;
  }
  return 0;
}
