/*
 * This software and its associated documentation are protected by
 *   Copyright 1998 Geodesic Systems Inc. All Rights Reserved.
 * Portions of the software include modification to code which was
 * released publicly by Xerox Corporation, subject to the requirement that
 * the following notice be retained and included with the modified code:
 *  "Copyright 1988, 1989 Hans-J. Boehm, Alan J. Demers.
 *   Copyright (c) 1991-1995 by Xerox Corporation.
 *   All rights reserved. THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY
 *   NO WARRANTY EXPRESS OR IMPLIED. ANY USE IS AT YOUR OWN RISK."
 */

#if !defined(_GCT_H)
#  define _GCT_H

#  if defined(__cplusplus)
extern "C" {
#  endif

/*
 * gcFixPrematureFrees() disables the operation of free() and delete,
 * and delegates all the task of memory deallocation to the garbage
 * collector. Fixing premature frees may increase memory usage. 
 * gcStopFixingPrematureFrees() has the opposite
 * effect. Both functions return nonzero if premature frees
 * were previously being fixed. 
 */
extern void gcFixPrematureFrees();
extern void gcStopFixingPrematureFrees();

/*
 * gcInitialize() is a function that the user can define, and 
 * that is called during the initialization of the garbage
 * collector. It is used to set some parameters of
 * the garbage collector, like calling gcFixPrematureFrees(). 
 */
extern void gcInitialize();

#ifdef  __cplusplus
}
#  endif /* __cplusplus */

#endif /* _GCT_H */

