/*****************************************************************************
 *
 * %Z%Digi International Inc. $Id: stsaip.h,v 1.1 1999/12/20 14:53:37 root Exp $
 *
 *****************************************************************************
 *
 * Copyright (c) 1988-00 Digi International Inc., All Rights Reserved
 * 
 * This  software  contains  proprietary  and  confidential   information   of
 * Digi International  Inc.   By  accepting  transfer  of this copy, Recipient
 * agrees to retain this software in  confidence,  to  prevent  disclosure  to
 * others,  and  to make no  use of this software other than that for which it
 * was delivered.  This is an unpublished copyright work  Digi   International
 * Inc.    Except   as   permitted   by  federal  law,  17 USC 117, copying is
 * strictly prohibited.
 * 
 * Digi  International  Inc.  CONFIDENTIAL  -   (Digi    International    Inc.
 * Confidential  when   combined   with   the   aggregated  modules  for  this
 * product) OBJECT CODE ONLY SOURCE MATERIALS
 * 
 * (C) COPYRIGHT Digi International Inc. 1999
 * 
 * All Rights Reserved
 * 
 * US   Government   Users   Restricted   Rights   -   Use,   duplication   or
 * disclosure  restricted by GSA ADP Schedule Contract with Digi International
 * Inc.
 * 
 *****************************************************************************/
 
#ifndef _SYS_SAIP_H
#define _SYS_SAIP_H
 
#ifdef  __cplusplus
extern "C" {
#endif
 
/*************************************************************************
 * Legal flag values for saip_t.saip_flags defined
 * in the structure below.
 */
#define SAIP_IXON	0x0001		/* Handle IXON in the FEP	*/
#define SAIP_FAST	0x0002		/* Fast baud rates		*/
#define SAIP_RTSFLOW	0x0004		/* RTS input flow control	*/
#define SAIP_CTSFLOW	0x0008		/* CTS output flow control	*/
#define SAIP_DSRFLOW	0x0010		/* DSR output flow control	*/
#define SAIP_DCDFLOW	0x0020		/* DCD output flow control	*/
#define SAIP_DTRFLOW	0x0040		/* DTR input flow control	*/
#define SAIP_COOK	0x0080		/* Cooked processing done in FEP */
#define SAIP_FORCEDCD	0x0100		/* Force carrier		*/
#define	SAIP_ALTPIN	0x0200		/* Alternate RJ-45 pin config	*/
#define	SAIP_AIXON	0x0400		/* Aux flow control in fep	*/
#define	SAIP_PRINTER	0x0800		/* Hold port open for flow cntrl*/
#define	SAIP_PP_INPUT	0x1000		/* Change parallel port to input*/
#define SAIP_RIFLOW	0x2000
#define	SAIP_422	0x4000		/* for 422/232 selectable panel */
#define SAIP_BZNOHUP	0x8000		/* No soft hangup on baud 0	*/

#define SAIP_PLEN	8		/* String length		*/
#define SAIP_TSIZ	10		/* String length		*/

/*************************************************************************
 * I_CTL values to pass when setting SAIP parameters.
 */
#define SAIP_GETA	(('d' << 8) | 128)	/* Read params		*/
#define SAIP_SETA	(('d' << 8) | 129)	/* Set params		*/
#define SAIP_SETAW	(('d' << 8) | 130)	/* Drain & set params	*/
#define SAIP_SETAF	(('d' << 8) | 131)	/* Drain, flush & set params*/

/*************************************************************************
 * Some of the following are not defined in various versions of
 * the operating system.
 */
#if !defined(TIOCSSOFTCAR)
#define	TIOCSSOFTCAR	(('d' << 8) | 146)	/* set CD state flag	*/
#endif

#if !defined(TIOCGSOFTCAR)
#define	TIOCGSOFTCAR	(('d' << 8) | 148)	/* get state of CD flag	*/
#endif

/************************************************************************
 * Ioctl command arguments for SAIP parameters.
 */
#define SAIP_KME	0x6562	/*(('d'<<8) | 98)  Read/Write Host	*/
						/* Adapter Memory	*/

#define SAIP_GETFLOW	(('d' << 8) | 150)	/* Get startc/stopc flow */
						/* control characters 	 */
#define SAIP_SETFLOW	(('d' << 8) | 151)	/* Set startc/stopc flow */
						/* control characters	 */
#define SAIP_GETAFLOW	(('d' << 8) | 152)	/* Get Aux. startc/stopc */
						/* flow control chars 	 */
#define SAIP_SETAFLOW	(('d' << 8) | 153)	/* Set Aux. startc/stopc */
						/* flow control chars	 */
#define SAIP_GCLOSE	(('d' << 8) | 154)	/* get close time to	 */
						/* wait for data to drain */
#define SAIP_SCLOSE	(('d' << 8) | 155)	/* set close time to	 */
						/* wait for data to drain */
#define SAIP_PSETA	(('d' << 8) | 161)
#define SAIP_PGETA	(('d' << 8) | 164)
#define SAIP_PRESET	(('d' << 8) | 165)
#define SAIP_BRESET	(('d' << 8) | 166)
#define SAIP_TCXONC (('d' << 8) | 167)  /* ldterm intercepts TCXONC */

#define SAIP_TCXONC (('d' << 8) | 167)  /* ldterm intercepts TCXONC */
#define SAIP_TCXONC (('d' << 8) | 167)  /* ldterm intercepts TCXONC */

typedef struct fw_tunable fw_t;

struct fw_tunable {
	short	carr_wink;
	short	brk_cnt;
	short	brk_det;
};

typedef struct saipflow_struct {
	u_char	startc;			/* flow cntl start char		*/
	u_char	stopc;			/* flow cntl stop char		*/
} saipflow_t;

/*************************************************************************
 * Structure used with I_CTL to read/set SAIP special
 * tty parameters.
 */
typedef struct {
	u_short	saip_flags ;		/* Flags (see above)		*/
	u_short	saip_maxcps ;		/* Max printer CPS		*/
	u_short	saip_maxchar ;		/* Max chars in print queue	*/
	u_short	saip_bufsize ;		/* Buffer size			*/
	u_char	saip_onlen ;		/* Length of ON string		*/
	u_char	saip_offlen ;		/* Length of OFF string		*/
	char	saip_onstr[SAIP_PLEN] ;	/* Printer on string		*/
	char	saip_offstr[SAIP_PLEN] ;/* Printer off string		*/
	char	saip_term[SAIP_TSIZ] ;	/* Terminal string		*/
} saip_t ;

/************************************************************************
 * KME definitions and structures.
 */
#define RW_IDLE		0	/* Operation complete			*/
#define RW_READ		1	/* Read Concentrator Memory		*/
#define RW_WRITE	2	/* Write Concentrator Memory		*/
#define RW_PAUSE	3
#define RW_RESET	4	/* Reset the indicated concentrator	*/

typedef struct {
	u_char	rw_req;		/* Request type				*/
	u_char	rw_board;	/* Host Adapter board number		*/
	u_char	rw_conc;	/* Concentrator number			*/
	u_int   rw_addr;	/* Address in concentrator		*/
	u_short	rw_size;	/* Read/write request length		*/
	u_char	rw_data[128];	/* Data to read/write			*/
	u_char	rw_reserved;	/* Reserved for expansion		*/
} rw_t;

/************************************************************************
 * Structure to get driver status information.
 */
struct saip_dinfo {
	u_long	dinfo_nboards;		/* # of boards configured	*/
	char	dinfo_reserved[12];	/* for future expansion		*/
	char	dinfo_version[16];	/* driver version		*/
};

#define SAIP_GETDD	(('d' << 8) | 248)	/* get driver info	*/

/************************************************************************
 * Structure used with ioctl commands for per-board info
 */
struct saip_info {
	u_long	info_bdnum;		/* board number (0 based)	*/
	u_long	info_ioport;		/* I/O port address		*/
	u_long	info_physaddr;		/* memory address		*/
	u_long	info_physsize;		/* Size of host window		*/
	u_long	info_memsize;		/* Amount of installed memory	*/
	u_short	info_bdtype;		/* board type			*/
	u_short	info_nports;		/* number of ports on board	*/
	char	info_bdstate;		/* board health			*/
	char	info_reserved[7];	/* future expansion		*/
};

#define SAIP_GETBD	(('d' << 8) | 249)	/* get board info	*/

#define SAIP_GEDELAY	(('d' << 8) | 246)
#define SAIP_SEDELAY	(('d' << 8) | 247)

/* Board type definitions */
#define	SUBTYPE		0007
#define T_PCXR		0003
#define FAMILY		0070
#define	T_PCLITE	0040
#define BUSTYPE		0700
#define T_SBUS		0300
#define T_PCIBUS	0400  

/* Board State Definitions */
#define	BD_RUNNING	0x0
#define	BD_REASON	0x7f
#define	BD_NOTFOUND	0x1
#define	BD_NOIOPORT	0x2
#define	BD_NOMEM	0x3
#define	BD_NOBIOS	0x4
#define	BD_NOFEP	0x5
#define	BD_FAILED	0x6
#define	BD_BADKME	0x80

/* Serial Asynchronous Device Testing Ioctls */ 
#ifndef SAIP_ENLOOP
#define SAIP_ENLOOP  (('d' << 8) | 240)	/* Enable loopbacks on board */
#define SAIP_DISLOOP (('d' << 8) | 241)	/* Disable loopbacks on board */
#define SAIP_ALIVE   (('d' << 8) | 242)	/* Check if board is alive */
#endif

#ifdef  __cplusplus
}
#endif
 
#endif /* _SYS_SAIP_H */
