#!/bin/sh
#
# Script to ftp/upload patch system files to a target T300 system
#
# @(#)t3.sh 1.10 00/05/22
# 
#
# Algorithm:
#
#  o Prompt User for required information
#    - Prompt for $TARGET_SYSTEM (hostname or IP Address)
#      Ping $TARGET_SYSTEM user entered
#      -> Exit if ping fails (system unreachable)
#    - Prompt For $HOME_DIRECTORY Location 
#      -> Exit if can't write a file in home directory
#    - Prompt for top level directory of patch image ($PATCH_DIR)
#      -> Need to locate files.tar within that directory tree
#	 set $PATCH_DIR
#      -> copy files.tar image to /tmp/$PID
#	 set $PATCH_DIR /tmp/$PID
#      -> Exit if can't find patch location or reprompt
#    - Warn User they must set root password on target T300
#
#  o Set interrupts so cleanup routine is used
#   Cleanup Routine:
#      -> rm  ~/.netrc 
#      -> rm -r /tmp/$PID 
#
#  o Create ~/.netrc
#    Check for existing ~/.netrc and preserve if one exists
#    Dump the following into ~/.netrc:
#      machine $TARGET_SYSTEM
#      macdef init
#      bin
#      prompt
#      lcd /etc
#      cd $PATCHDIR
#      cd etc
#      mput *
#      lcd /web
#      cd ../web
#      mput *
#      mkdir snmp
#      lcd snmp
#      cd snmp
#      mput *
#      quit
#
#    Remove read permissions from ~/.netrc
#
#  o Start ftp process
#    exec 'ftp TARGET_T300'
#
#  o Perform File Validation ?
#    -> Perhaps snapshot a long filelisting and cmp with
#       local image?
#
#  o Cleanup Local Files
# 
#  o Restore preserved ~/.netrc if applicable 
#
#  o Exit

# Script Variables
TOC=patchtoc		  # Patch Table Of Contents File
TARGET=                   # T300 To Be Upgraded 
TRUE=1                    # Boolean true
FALSE=0                   # Boolean false
PATCHDIR=.		  # Patch Directory Location
RESP=' '
ERR=0			  # Error Counter
TMPDIR=/tmp/upload.$$     # Temporary Directory
TMPNETRC=/tmp/netrc.$$    # Backup copy of existing .netrc
HOMEDIR=$HOME		  # User's default home directory.

netrc_gen() {
  #  Routine to Create ~/.netrc
  echo "Enter Your Home Directory Path [$HOMEDIR]: \c"
  read HOME
  if [ "X$HOME" != 'X' ];then
     HOMEDIR=$HOME    # User must have entered new homedir
  fi
  if [ -f $HOMEDIR/.netrc ]; then
    mv $HOMEDIR/.netrc $TMPNETRC    # Preserve existing .netrc
  fi
  echo "Creating Auto ftp File In [$HOMEDIR/.netrc]..."
  echo "machine $TARGET" > $HOMEDIR/.netrc
  echo "macdef init" >> $HOMEDIR/.netrc
  echo "bin"  >> $HOMEDIR/.netrc
  echo "prompt"  >> $HOMEDIR/.netrc

  # Controller/lpc/ep firmware
  # echo "cd /tmp/incoming"  >> $HOMEDIR/.netrc  # Testing Only
  echo "cd /"  >> $HOMEDIR/.netrc  
  echo "lcd $TMPDIR"  >> $HOMEDIR/.netrc
  echo "mkdir etc"  >> $HOMEDIR/.netrc
  echo "mkdir web"  >> $HOMEDIR/.netrc
  echo "mkdir web/snmp"  >> $HOMEDIR/.netrc

  # Load Controller firmware
  echo "mput ep*.bin"  >> $HOMEDIR/.netrc
  echo "mput v118*.bin"  >> $HOMEDIR/.netrc
  echo "mput lpc*.*"  >> $HOMEDIR/.netrc

  # Load /etc files     # Only copy over schd.conf
  echo "cd etc"  >> $HOMEDIR/.netrc
  echo "lcd files/etc"  >> $HOMEDIR/.netrc
  echo "rename schd.conf sch_old.conf"  >> $HOMEDIR/.netrc # Save old
  echo "put schd.conf"  >> $HOMEDIR/.netrc      

  # Load Web files
  echo "cd ../web"  >> $HOMEDIR/.netrc
  echo "lcd ../web"  >> $HOMEDIR/.netrc
  echo "mput *"  >> $HOMEDIR/.netrc
  echo "cd snmp"  >> $HOMEDIR/.netrc
  echo "lcd snmp"  >> $HOMEDIR/.netrc
  echo "mput *"  >> $HOMEDIR/.netrc

  echo "quit\n\n"  >> $HOMEDIR/.netrc
}

cleanup() {
  echo "\nCleaning Up Temporary Files..."
  rm -rf $TMPDIR 		# Cleanup Archive File
  rm -f $HOMEDIR/.netrc		# Remove .netrc file
  if [ -f $TMPNETRC ]; then
    mv $TMPNETRC $HOMEDIR/.netrc  # Restore previous .netrc
  fi
}

error_exit_code() {
  cleanup
  echo "Exiting $0...."
  exit 1
}

trap "error_exit_code" 1 2 3

# Mainline code starts here
echo  'Please Enter Hostname or IP Address Of T300 To Be Ugpraded: \c'
read TARGET    
ping $TARGET
ERRCODE=$?      
if [ $ERRCODE -ne $FALSE ]; then
  echo 'Target System Unreachable.'
  error_exit_code;
fi

# Get Location of T300 System Files To Upload
echo  "Please Enter Patch Location Pathname [$PATCHDIR]: \c"
read TMP    

if [ "999$TMP" != "999" ]; then
  PATCHDIR=$TMP
fi

# Verify Patch Contents
echo "Looking For Patch Contents In [$PATCHDIR]..."
# 
mkdir $TMPDIR   # Create /tmp directory With File Contents To Upload
ERR=0
if [ -f $PATCHDIR/$TOC ]; then
  for file in `cat $PATCHDIR/$TOC`
  do
   if [ -s $PATCHDIR/$file ]; then
    echo "$file image located"
    cp $PATCHDIR/$file $TMPDIR
   else
    echo "$file image missing"
    ERR=`expr $ERR + 1`
   fi
  done
else
  echo "Patch TOC Not Found..."
  ERR=`expr $ERR + 1`
fi

if [ $ERR -gt 0 ]; then
  error_exit_code
fi

PWD=`pwd`
mkdir $TMPDIR/files
cd $TMPDIR/files
tar xfp $TMPDIR/files.tar       # Extract System Files Tar Image
cd $PWD

netrc_gen			# Generate netrc file

# Start ftp process
ftp $TARGET 

cleanup				# Remove temp directories
